/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.workflow.engine.impl.cmd.history;

import java.util.ArrayList;
import java.util.List;
import java.util.Set;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.db.tx.TX;
import kd.bos.db.tx.TXHandle;
import kd.bos.entity.EntityMetadataCache;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.operation.DeleteServiceHelper;
import kd.bos.servicehelper.operation.SaveServiceHelper;
import kd.bos.workflow.engine.WfUtils;
import kd.bos.workflow.engine.history.serialization.CollectionBinder;
import kd.bos.workflow.engine.history.serialization.CollectionSerialize;
import kd.bos.workflow.engine.impl.clean.model.EntityCompactConfigFactory;
import kd.bos.workflow.engine.impl.clean.model.EntityCompactConfigParam;
import kd.bos.workflow.engine.impl.interceptor.Command;
import kd.bos.workflow.engine.impl.interceptor.CommandContext;
import kd.bos.workflow.engine.impl.persistence.entity.history.HistoricProcCompactEntity;

public class RecoverProcDataFromCompactCmd
implements Command<Void> {
    private List<Long> compactIds;

    public RecoverProcDataFromCompactCmd(List<Long> compactIds) {
        this.compactIds = compactIds;
    }

    @Override
    public Void execute(CommandContext commandContext) {
        if (WfUtils.isEmptyForCollection(this.compactIds)) {
            return null;
        }
        Set<String> zipEntityPropertys = EntityMetadataCache.getDataEntityType((String)"wf_historicproccompact").getFields().keySet();
        if (WfUtils.isEmptyForCollection(zipEntityPropertys)) {
            return null;
        }
        List<HistoricProcCompactEntity> compactEntitys = commandContext.getHistoricProcCompactEntityManager().findByQueryFilters(new QFilter[]{new QFilter("id", "in", this.compactIds)});
        if (WfUtils.isEmptyForCollection(compactEntitys)) {
            return null;
        }
        ArrayList<Long> procInstIds = new ArrayList<Long>(compactEntitys.size());
        for (HistoricProcCompactEntity wideEntity : compactEntitys) {
            procInstIds.add(wideEntity.getProcessInstanceId());
        }
        try (TXHandle h = TX.requiresNew();){
            this.reduceProcDatas(compactEntitys, zipEntityPropertys);
            this.deleteCompactData(procInstIds);
        }
        return null;
    }

    private void deleteCompactData(List<Long> procInstIds) {
        DeleteServiceHelper.delete((String)"wf_historicproccompact", (QFilter[])new QFilter[]{new QFilter("processInstanceId", "in", procInstIds)});
        DeleteServiceHelper.delete((String)"wf_historiccompactrela", (QFilter[])new QFilter[]{new QFilter("processInstanceId", "in", procInstIds)});
    }

    private void reduceProcDatas(List<HistoricProcCompactEntity> compactEntitys, Set<String> zipEntityPropertys) {
        CollectionBinder binder = new CollectionBinder();
        for (EntityCompactConfigParam compactConf : EntityCompactConfigFactory.getCompactEntitys().values()) {
            String compactPropName = compactConf.getCompactPropertyName();
            if (!zipEntityPropertys.contains(compactPropName)) continue;
            for (HistoricProcCompactEntity wideEntity : compactEntitys) {
                String zipJsonStr = wideEntity.getDynamicObject().getString(compactPropName);
                if (WfUtils.isEmpty(zipJsonStr)) continue;
                CollectionSerialize collectionSerialize = (CollectionSerialize)binder.getDcJsonSerializer().deserializeFromString(zipJsonStr, null);
                List<DynamicObject> hiDynObjects = collectionSerialize.getDynamicObjects();
                DynamicObject[] dyns = new DynamicObject[hiDynObjects.size()];
                for (int i = 0; i < hiDynObjects.size(); ++i) {
                    DynamicObject dyn = hiDynObjects.get(i);
                    dyn.getDataEntityState().setDirty(true);
                    DynamicObjectCollection multilangCols = dyn.getDynamicObjectCollection("multilanguagetext");
                    if (multilangCols != null) {
                        for (DynamicObject multilang : multilangCols) {
                            multilang.getDataEntityState().setDirty(true);
                        }
                    }
                    dyns[i] = dyn;
                }
                SaveServiceHelper.save((DynamicObject[])dyns);
            }
        }
    }
}

