/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.workflow.engine.impl.cmd.job;

import java.util.ArrayList;
import java.util.List;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.db.DBRoute;
import kd.bos.dlock.DLock;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.workflow.engine.impl.asyncexecutor.AsyncExecutor;
import kd.bos.workflow.engine.impl.cache.WfCacheHelper;
import kd.bos.workflow.engine.impl.cmd.job.JobHandleStrategy;
import kd.bos.workflow.engine.impl.cmd.job.JobHandleStrategyFactory;
import kd.bos.workflow.engine.impl.interceptor.Command;
import kd.bos.workflow.engine.impl.interceptor.CommandContext;
import kd.bos.workflow.engine.impl.persistence.entity.job.JobEntity;
import kd.bos.workflow.engine.runtime.ExecuteJob;

public class AcquireJobsCmd
implements Command<List<JobEntity>> {
    protected static Log logger = LogFactory.getLog(AcquireJobsCmd.class);
    private final AsyncExecutor asyncExecutor;

    public AcquireJobsCmd(AsyncExecutor asyncExecutor) {
        this.asyncExecutor = asyncExecutor;
    }

    @Override
    public List<JobEntity> execute(CommandContext commandContext) {
        ArrayList<JobEntity> jobs = new ArrayList<JobEntity>();
        String[] dbKeys = WfCacheHelper.getJobSourceOfDBRouteKey();
        if (dbKeys != null && dbKeys.length > 0) {
            for (String dbKey : dbKeys) {
                if ("wf".equalsIgnoreCase(dbKey) || "wfs".equalsIgnoreCase(dbKey)) continue;
                this.searchExpiredJobs(commandContext, dbKey, jobs, "");
            }
        }
        this.searchExpiredJobs(commandContext, DBRoute.workflow.getRouteKey(), jobs, "");
        return jobs;
    }

    private void searchExpiredJobs(CommandContext commandContext, String dbKey, List<JobEntity> jobs, String jobType) {
        try (DLock lock = DLock.create((String)String.format("wf/acquireJob/%s", dbKey), (String)String.format(ResManager.loadKDString((String)"\u9501\u5b9aJOB[%s]", (String)"JobEntityManagerImpl_3", (String)"bos-wf-engine", (Object[])new Object[0]), dbKey)).fastMode();){
            boolean lockNotNeededOrSuccess = lock.tryLock(60000L);
            if (lockNotNeededOrSuccess) {
                JobHandleStrategy strategy = JobHandleStrategyFactory.getJobHandleStrategy(JobHandleStrategyFactory.genenateSource(dbKey), jobType);
                strategy.setProcessEngineConfiguration(commandContext.getProcessEngineConfiguration());
                strategy.setSource(JobHandleStrategyFactory.genenateSource(dbKey));
                List<? extends ExecuteJob> ret = strategy.findExpiredJobs(dbKey);
                if (ret == null || ret.size() == 0) {
                    logger.debug(String.format("no job from db[%s]", dbKey));
                    return;
                }
                jobs.addAll(ret);
                logger.debug(String.format("acquire job from db[%s],size:[%s]", dbKey, jobs == null ? 0 : jobs.size()));
            }
        }
    }
}

