/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.workflow.engine.impl.cmd.job;

import java.io.Serializable;
import kd.bos.bec.engine.consumer.DistributeEvtJobHandleStrategy;
import kd.bos.context.RequestContext;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.bos.workflow.devopos.WorkflowDevopsService;
import kd.bos.workflow.devopos.info.IndicatorInfo;
import kd.bos.workflow.engine.WfConfigurationUtil;
import kd.bos.workflow.engine.WfUtils;
import kd.bos.workflow.engine.delegate.event.ActivitiEventType;
import kd.bos.workflow.engine.delegate.event.impl.ActivitiEventBuilder;
import kd.bos.workflow.engine.impl.cache.WfCacheHelper;
import kd.bos.workflow.engine.impl.cmd.job.DistributeJobHandleStrategy;
import kd.bos.workflow.engine.impl.cmd.job.ILocalJobHandleStrategy;
import kd.bos.workflow.engine.impl.cmd.job.JobHandleStrategy;
import kd.bos.workflow.engine.impl.cmd.job.JobHandleStrategyFactory;
import kd.bos.workflow.engine.impl.context.Context;
import kd.bos.workflow.engine.impl.interceptor.Command;
import kd.bos.workflow.engine.impl.interceptor.CommandContext;
import kd.bos.workflow.engine.impl.jobexecutor.JobFinishNotification;
import kd.bos.workflow.engine.impl.persistence.entity.design.ModelType;
import kd.bos.workflow.engine.impl.persistence.entity.job.AbstractJobEntity;
import kd.bos.workflow.engine.impl.persistence.entity.job.JobStateEnum;
import kd.bos.workflow.engine.impl.util.RuntimeUtil;
import kd.bos.workflow.engine.runtime.ExecuteJob;
import kd.bos.workflow.exception.WFErrorCode;
import kd.bos.workflow.exception.WfJobException;
import kd.bos.workflow.service.WfTraceType;

public class ExecuteAsyncJobCmd
implements Command<Object>,
Serializable {
    private static final long serialVersionUID = 1L;
    private static Log log = LogFactory.getLog(ExecuteAsyncJobCmd.class);
    protected Long jobId;
    protected ExecuteJob job;
    protected boolean saveByVerifySql;

    public ExecuteAsyncJobCmd(Long jobId) {
        this.jobId = jobId;
    }

    public ExecuteAsyncJobCmd(ExecuteJob job) {
        this.job = job;
        this.jobId = job.getId();
        this.saveByVerifySql = !WfConfigurationUtil.notSaveByVerifySql();
    }

    @Override
    public Object execute(CommandContext commandContext) {
        if (this.job != null) {
            MsgStatus info = this.canExecute(this.job, commandContext);
            if (!info.canExecute()) {
                log.info(String.format("job[%s] is not sutiable for executing because of [%s]", this.job.getId(), info.getMsg()));
                if (info.isFinished()) {
                    String state;
                    commandContext.addCloseListener(new JobFinishNotification(this.job));
                    ILocalJobHandleStrategy localJobHandleStrategy = JobHandleStrategyFactory.getLocalJobHandleStrategy(this.job.getJobType());
                    ExecuteJob localJob = localJobHandleStrategy.findJob(this.job.getId(), false);
                    String string = state = localJob == null ? "" : localJob.getState();
                    if (localJob != null && (JobStateEnum.CREATED.getNumber().equals(state) || JobStateEnum.PREEXECUTING.getNumber().equals(state))) {
                        localJob.setState(info.getResult());
                        commandContext.getExecuteJobManager().saveOrUpdate(localJob);
                    }
                    log.info(String.format("\u6d88\u606f[%s]\u5df2\u7ecf\u88ab\u5904\u7406,\u539f\u56e0[%s]\uff01", this.job.getId(), info.getMsg()));
                    this.removeBusinesskeyAndEntityCache(commandContext);
                } else if (info.isExecuting()) {
                    log.info(String.format("\u6d88\u606f[%s]\u6b63\u5728\u88ab\u6267\u884c\uff0c\u6b63\u5e38\u60c5\u51b5\u4e0b\u4e0d\u4f1a\u8d70\u5230\u8fd9\u91cc.", this.job.getId()));
                }
                if (Context.getProcessEngineConfiguration().getEventDispatcher().isEnabled()) {
                    Context.getProcessEngineConfiguration().getEventDispatcher().dispatchEvent(ActivitiEventBuilder.createAsyncMessageEvent(ActivitiEventType.JOB_EXECUTION_SUCCESS, this.job.getJobHandlerType(), String.format(ResManager.loadKDString((String)"job[%1$s]\u76ee\u524d\u65e0\u6cd5\u5904\u7406\uff0c\u539f\u56e0[%2$s]", (String)"ExecuteAsyncJobCmd_1", (String)"bos-wf-engine", (Object[])new Object[0]), this.job.getId(), info.getMsg()), this.job));
                }
            } else {
                log.info(String.format("job[%s] is sutiable for executing because of [%s]", this.job.getId(), info.getMsg()));
                WfTraceType.WfTraceJobInfo jobInfo = WfTraceType.getOrCreate().getJobInfo();
                if (jobInfo != null) {
                    jobInfo.setIsUpdate(!info.isWillInsert());
                }
                this.executeJob(commandContext, info.isWillInsert());
            }
        } else {
            log.warn("ExecuteAsyncJobCmd Job is null!");
        }
        return null;
    }

    private void executeJob(CommandContext commandContext, boolean ifWillInsert) {
        JobHandleStrategy strategy = JobHandleStrategyFactory.getJobHandleStrategy(this.job.getSource(), this.job.getJobType());
        ILocalJobHandleStrategy localJobHandleStrategy = JobHandleStrategyFactory.getLocalJobHandleStrategy(this.job.getJobType());
        if (strategy != null) {
            ExecuteJob reQueryJob = strategy.findJob(this.job.getId(), false);
            if (reQueryJob == null || "address-process-event".equals(reQueryJob.getJobHandlerType()) && WfCacheHelper.existWithdrawDeleteBizJobs(this.job.getEntityNumber(), this.job.getId())) {
                if ("address-process-event".equals(this.job.getJobHandlerType()) || "async-event-dispatch".equals(this.job.getJobHandlerType())) {
                    localJobHandleStrategy.deleteJob(this.job);
                }
                if ("address-process-event".equals(this.job.getJobHandlerType()) && !WfCacheHelper.existCurrentStartProcessBusinessKey(this.job.getEntityNumber(), this.job.getBusinessKey())) {
                    WfCacheHelper.removeExecutingJobGYEntityOfCurrentBusiness(this.job.getEntityNumber(), this.job.getBusinessKey());
                }
                log.info(String.format("job[%s]\u5df2\u7ecf\u88ab\u5220\u9664,\u53ef\u80fd\u5df2\u7ecf\u79fb\u52a8\u5230\u91cd\u8bd5\u6216\u8005\u6302\u8d77\u8868\u4e2d.", this.job.getId()));
                if (commandContext.getEventDispatcher().isEnabled()) {
                    commandContext.getEventDispatcher().dispatchEvent(ActivitiEventBuilder.createAsyncMessageEvent(ActivitiEventType.JOB_EXECUTION_SUCCESS, this.job.getJobHandlerType(), String.format(ResManager.loadKDString((String)"job[%s]\u5df2\u7ecf\u88ab\u5220\u9664,\u53ef\u80fd\u5df2\u7ecf\u79fb\u52a8\u5230\u91cd\u8bd5\u8868\u6216\u8005\u6302\u8d77\u8868\u4e2d.", (String)"ExecuteAsyncJobCmd_2", (String)"bos-wf-engine", (Object[])new Object[0]), this.job.getId()), this.job));
                }
                return;
            }
            this.job.setState(JobStateEnum.EXECUTING.getNumber());
            this.job.setRootTraceNo(RequestContext.get().getTraceId());
            strategy.updateJobState(this.job, false);
        }
        log.debug("start Executing async job [" + this.job.getId() + "] really!");
        long start = Context.getProcessEngineConfiguration().getClock().getCurrentTime().getTime();
        commandContext.getJobManager().execute(this.job);
        if (this.saveByVerifySql) {
            if (ifWillInsert) {
                JobFinishNotification deleteOtherDBJob = new JobFinishNotification(this.job);
                commandContext.addCloseListener(deleteOtherDBJob);
            }
            this.job.setDuration(Context.getProcessEngineConfiguration().getClock().getCurrentTime().getTime() - start);
            this.job.setState(JobStateEnum.COMPLETED.getNumber());
            this.job.setSuccess(true);
            commandContext.getExecuteJobManager().saveOrUpdateByVerifySql(ifWillInsert, this.job);
            this.collectMessageData(this.job);
            this.dispatch(commandContext, this.job);
            return;
        }
        String jobEntityNumber = null;
        jobEntityNumber = this.job.getJobType().equals("taskMessage") || this.job.getJobType().equals("taskTimer") ? "wf_taskjobrecord" : "wf_job";
        boolean sameDB = QueryServiceHelper.exists((String)jobEntityNumber, (Object)this.job.getId());
        if (!sameDB) {
            JobFinishNotification deleteOtherDBJob = new JobFinishNotification(this.job);
            commandContext.addCloseListener(deleteOtherDBJob);
        }
        boolean cache = !sameDB || !(strategy instanceof DistributeJobHandleStrategy) && !(strategy instanceof DistributeEvtJobHandleStrategy);
        ExecuteJob tmp = localJobHandleStrategy.findJob(this.job.getId(), cache);
        if (tmp != null) {
            tmp.setState(JobStateEnum.COMPLETED.getNumber());
            this.job.setState(JobStateEnum.COMPLETED.getNumber());
            tmp.setExceptionMessage(this.job.getExceptionMessage());
            tmp.setEndTime(Context.getProcessEngineConfiguration().getClock().getCurrentTime());
            tmp.setDuration(tmp.getEndTime().getTime() - start);
            tmp.setSuccess(true);
            commandContext.getExecuteJobManager().saveOrUpdate(tmp);
            this.collectMessageData(tmp);
            this.dispatch(commandContext, tmp);
        }
    }

    private void dispatch(CommandContext commandContext, ExecuteJob job) {
        log.debug("Executing async job successful [" + job.getId() + "]");
        if (commandContext.getEventDispatcher().isEnabled()) {
            commandContext.getEventDispatcher().dispatchEvent(ActivitiEventBuilder.createAsyncMessageEvent(ActivitiEventType.JOB_EXECUTION_SUCCESS, job.getJobHandlerType(), job.getJobHandlerConfiguration(), job));
        }
    }

    private void collectMessageData(AbstractJobEntity job) {
        String number = "address-process-event".equals(job.getJobHandlerType()) ? "addressMessage" : "asyncMessage";
        IndicatorInfo info = new IndicatorInfo(number, (Object)"success");
        info.addToSpecialProperty("procDefId", (Object)job.getProcessDefinitionId());
        info.addToSpecialProperty("createDate", (Object)job.getCreateDate());
        WorkflowDevopsService.create().exceutionDataCollection(info);
    }

    private MsgStatus canExecute(ExecuteJob wfJob, CommandContext commandContext) {
        try {
            MsgStatus status = this.getRetState(wfJob);
            if (!status.canExecute()) {
                return status;
            }
            ILocalJobHandleStrategy localJobHandleStrategy = JobHandleStrategyFactory.getLocalJobHandleStrategy(wfJob.getJobType());
            localJobHandleStrategy.setProcessEngineConfiguration(commandContext.getProcessEngineConfiguration());
            ExecuteJob localJob = localJobHandleStrategy.findJob(wfJob.getId(), false);
            if (localJob == null) {
                if (localJobHandleStrategy.isLocalJob(JobHandleStrategyFactory.getDBRouteKey(wfJob.getSource()))) {
                    return new MsgStatus(JobStateEnum.UNKNOWN.getNumber(), String.format(ResManager.loadKDString((String)"\u672a\u77e5\u539f\u56e0\uff0c\u65e0\u6cd5\u4ecedbRouteKey[%1$s]\u4e2d\u67e5\u8be2\u5230Job[%2$s],\u53ef\u80fd\u5df2\u7ecf\u88ab\u5220\u9664", (String)"ExecuteAsyncJobCmd_8", (String)"bos-wf-engine", (Object[])new Object[0]), wfJob.getSource(), wfJob.getId()));
                }
                localJobHandleStrategy.insertJobToLocal(wfJob);
                return new MsgStatus(wfJob.getState(), ResManager.loadKDString((String)"\u7b2c\u4e00\u6b21\u6267\u884c", (String)"ExecuteAsyncJobCmd_3", (String)"bos-wf-engine", (Object[])new Object[0]), true);
            }
            return this.getRetState(localJob);
        }
        catch (Exception e) {
            throw new WfJobException(e, WFErrorCode.jobHandledError(), wfJob.getId(), e);
        }
    }

    private MsgStatus getRetState(ExecuteJob wfJob) {
        String code;
        JobStateEnum state = wfJob.getState() == null ? JobStateEnum.UNKNOWN : JobStateEnum.of(wfJob.getState());
        log.info(String.format("the current state of job[%s] is [%s].", wfJob.getId(), state.getNumber()));
        switch (code = state.getNumber()) {
            case "created": 
            case "received": {
                return new MsgStatus(state.getNumber(), ResManager.loadKDString((String)"\u72b6\u6001OK,\u53ef\u4ee5\u6267\u884c", (String)"ExecuteAsyncJobCmd_4", (String)"bos-wf-engine", (Object[])new Object[0]));
            }
            case "executing": {
                return new MsgStatus(state.getNumber(), String.format(ResManager.loadKDString((String)"\u6b63\u5728\u88ab\u6267\u884c,\u72b6\u6001\u662f[%s]", (String)"ExecuteAsyncJobCmd_5", (String)"bos-wf-engine", (Object[])new Object[0]), state.getName()));
            }
            case "completed": 
            case "errored": {
                return new MsgStatus(state.getNumber(), String.format(ResManager.loadKDString((String)"\u5df2\u7ecf\u6267\u884c,\u72b6\u6001\u662f[%s]", (String)"ExecuteAsyncJobCmd_6", (String)"bos-wf-engine", (Object[])new Object[0]), state.getName()));
            }
        }
        return new MsgStatus(JobStateEnum.UNKNOWN.getNumber(), String.format(ResManager.loadKDString((String)"\u672a\u77e5\u539f\u56e0\uff0c\u65e0\u6cd5\u4ecedbRouteKey[%1$s]\u4e2d\u67e5\u8be2\u5230Job[%2$s]\u6216\u8005state\u4e0d\u6b63\u786e", (String)"ExecuteAsyncJobCmd_7", (String)"bos-wf-engine", (Object[])new Object[0]), wfJob.getSource(), wfJob.getId()));
    }

    private void removeBusinesskeyAndEntityCache(CommandContext commandContext) {
        if (RuntimeUtil.isRunningJob(this.job.getJobHandlerType()) && WfUtils.isNotEmpty(this.job.getProcessInstanceId())) {
            String businesskey = this.job.getBusinessKey();
            String entitynumber = this.job.getEntityNumber();
            QFilter q1 = new QFilter("businessKey", "=", (Object)businesskey);
            QFilter q2 = new QFilter("processtype", "=", (Object)ModelType.AuditFlow.name());
            QFilter q3 = new QFilter("endTime", "is null", null);
            QFilter[] filters = new QFilter[]{q1, q2, q3};
            boolean exist = commandContext.getHistoricProcessInstanceEntityManager().exist(filters);
            if (!exist) {
                WfCacheHelper.removeExecutingJobGYEntityOfCurrentBusiness(businesskey, entitynumber);
                log.info(String.format("remove the cache for special scene:businesskey-[%s],entitynumber-[%s]", businesskey, entitynumber));
            }
        }
    }

    private static class MsgStatus {
        public static final String UNKOWN = "UNKNOW";
        private String result;
        private String msg;
        private boolean willInsert;

        public boolean isWillInsert() {
            return this.willInsert;
        }

        public MsgStatus(String ret, String msg) {
            this.result = ret;
            this.msg = msg;
        }

        public MsgStatus(String ret, String msg, boolean willInsert) {
            this.result = ret;
            this.msg = msg;
            this.willInsert = willInsert;
        }

        public boolean isExecuting() {
            return JobStateEnum.EXECUTING.getNumber().equals(this.result);
        }

        public boolean isFinished() {
            return JobStateEnum.COMPLETED.getNumber().equals(this.result) || JobStateEnum.ERRORED.getNumber().equals(this.result);
        }

        public boolean canExecute() {
            return JobStateEnum.CREATED.getNumber().equals(this.result) || JobStateEnum.PREEXECUTING.getNumber().equals(this.result);
        }

        public String getResult() {
            return this.result;
        }

        public void setResult(String result) {
            this.result = result;
        }

        public String getMsg() {
            return this.msg;
        }

        public void setMsg(String msg) {
            this.msg = msg;
        }
    }
}

