/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.workflow.engine.impl.cmd.job;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import kd.bos.algo.Row;
import kd.bos.workflow.engine.impl.cache.WfCacheHelper;
import kd.bos.workflow.engine.impl.cmd.execution.AbstractBatchQueryCmd;

public class GetEndRunningJobCacheCmd
extends AbstractBatchQueryCmd<List<String>> {
    private Collection<String> bizs;
    private String entityNumber;

    public GetEndRunningJobCacheCmd(String entityNumber) {
        this.entityNumber = entityNumber;
        this.count = 50;
    }

    @Override
    protected void handleResult(List<String> ret, Row r) {
        String bk = r.getString("FBUSINESSKEY");
        if (bk != null) {
            ret.add(bk);
        }
    }

    @Override
    protected Object[] createParameter(List<String> subList) {
        Object[] params = new Object[subList.size()];
        int i = 0;
        for (String t : subList) {
            params[i] = t;
            ++i;
        }
        return params;
    }

    @Override
    protected String createSQL(List<String> subList) {
        StringBuilder sb = new StringBuilder();
        sb.append(" SELECT a.FBUSINESSKEY FROM t_wf_hiprocinst a").append(" WHERE  a.FBUSINESSKEY IN (");
        int length = subList.size();
        for (int i = 0; i < length; ++i) {
            sb.append(" ?");
            if (i == length - 1) continue;
            sb.append(',');
        }
        sb.append(')');
        sb.append(" AND NOT EXISTS (SELECT 1 FROM t_wf_hiprocinst b WHERE b.fbusinesskey = a.fbusinesskey AND b.fendtime IS NULL)");
        return sb.toString();
    }

    @Override
    protected Collection<String> getTotal() {
        return this.getAllCacheBizKeys();
    }

    private Collection<String> getAllCacheBizKeys() {
        if (this.bizs == null || this.bizs.isEmpty()) {
            this.bizs = Arrays.asList(WfCacheHelper.getExecutingBusinesskeysByEntityNumber(this.entityNumber));
        }
        return this.bizs;
    }

    @Override
    protected List<String> createRet() {
        return new ArrayList<String>();
    }
}

