/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.workflow.engine.impl.cmd.job;

import java.io.Serializable;
import java.util.HashMap;
import java.util.Map;
import kd.bos.algo.DataSet;
import kd.bos.algo.Row;
import kd.bos.bec.engine.asyncexecutor.EvtJobManager;
import kd.bos.bec.engine.cache.EvtCacheHelper;
import kd.bos.bec.engine.persistence.job.EvtJobEntity;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.db.DB;
import kd.bos.db.DBRoute;
import kd.bos.workflow.engine.WfUtils;
import kd.bos.workflow.engine.impl.interceptor.Command;
import kd.bos.workflow.engine.impl.interceptor.CommandContext;

public class GetEventTriggerCmd
implements Command<EvtJobEntity>,
Serializable {
    protected String json;
    protected String eventNumber;

    public GetEventTriggerCmd() {
    }

    public GetEventTriggerCmd(String eventNumber, String json) {
        this.json = json;
        this.eventNumber = eventNumber;
    }

    @Override
    public EvtJobEntity execute(CommandContext commandContext) {
        Map<String, String> eventParams = this.existEvent(this.eventNumber);
        if (eventParams == null || WfUtils.isEmpty(this.json)) {
            return null;
        }
        EvtJobManager jobManager = commandContext.getEvtJobManager();
        HashMap<String, Object> params = new HashMap<String, Object>();
        params.put("eventParamsId", eventParams.get("id"));
        params.put("eventType", "jsonEvent");
        params.put("eventNumber", this.eventNumber);
        params.put("json", this.json);
        return jobManager.createEventDispatchJob(params, null);
    }

    protected Map<String, String> existEvent(String evtNumber) {
        Map<String, String> eventParams = null;
        if (StringUtils.isNotEmpty((CharSequence)evtNumber) && (eventParams = EvtCacheHelper.getCacheEventMap(evtNumber)) != null && eventParams.size() > 0) {
            return eventParams;
        }
        String sql = "select top 1 b.ftype ftype, b.fid fid from t_evt_subscription a INNER JOIN t_evt_event b on a.FEVENT = b.fid where a.FSTATUS = '1' and a.feventnumber = ? AND b.FSTATUS = '1'";
        try (DataSet ds = DB.queryDataSet((String)"be.event", (DBRoute)DBRoute.workflow, (String)sql, (Object[])new Object[]{evtNumber});){
            for (Row row : ds) {
                eventParams = new HashMap<String, String>();
                eventParams.put("id", row.getString("fid"));
                eventParams.put("type", row.getString("ftype"));
            }
        }
        if (eventParams != null && eventParams.size() > 0) {
            EvtCacheHelper.addCacheEventMap(evtNumber, eventParams);
            return eventParams;
        }
        return null;
    }
}

