/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.workflow.engine.impl.cmd.job;

import java.util.Calendar;
import java.util.Date;
import java.util.GregorianCalendar;
import java.util.Map;
import kd.bos.bec.engine.impl.jobexecutor.EvtJobUtil;
import kd.bos.bec.engine.persistence.job.EvtJobEntity;
import kd.bos.dataentity.serialization.SerializationUtils;
import kd.bos.workflow.engine.impl.cache.WfCacheHelper;
import kd.bos.workflow.engine.impl.cfg.ProcessEngineConfigurationImpl;
import kd.bos.workflow.engine.impl.cmd.job.ILocalJobHandleStrategy;
import kd.bos.workflow.engine.impl.cmd.job.JobErrorHandleCmd;
import kd.bos.workflow.engine.impl.cmd.job.JobHandleStrategy;
import kd.bos.workflow.engine.impl.cmd.job.JobHandleStrategyFactory;
import kd.bos.workflow.engine.impl.interceptor.CommandContext;
import kd.bos.workflow.engine.impl.interceptor.DefaultCommandContextCloseListener;
import kd.bos.workflow.engine.impl.jobexecutor.ErrorHandlerStrategy;
import kd.bos.workflow.engine.impl.persistence.entity.job.AbstractJobEntity;
import kd.bos.workflow.engine.impl.persistence.entity.job.DeadLetterJobEntity;
import kd.bos.workflow.engine.impl.persistence.entity.job.JobEntity;
import kd.bos.workflow.engine.impl.persistence.entity.job.TimerJobEntity;
import kd.bos.workflow.engine.msg.MessageServiceUtil;
import kd.bos.workflow.engine.runtime.ExecuteJob;
import kd.bos.workflow.exception.ExceptionUtil;

public class JobRetryCmd
extends JobErrorHandleCmd {
    public JobRetryCmd(ExecuteJob job, Throwable exception, ErrorHandlerStrategy strategy) {
        super(job, exception, strategy);
    }

    @Override
    public AbstractJobEntity innerExecute(CommandContext commandContext, ILocalJobHandleStrategy strategy) {
        AbstractJobEntity newJobEntity = null;
        ProcessEngineConfigurationImpl processEngineConfig = commandContext.getProcessEngineConfiguration();
        if (this.job instanceof EvtJobEntity) {
            Map cfg = (Map)SerializationUtils.fromJsonString((String)this.job.getJobHandlerConfiguration(), Map.class);
            String errorStrategy = (String)cfg.get("errorStrategy");
            if (EvtJobUtil.isNotRetryByRule(commandContext, ((EvtJobEntity)this.job).getSubscriptionId())) {
                errorStrategy = "ignore";
            }
            newJobEntity = ExceptionUtil.handleEventJobStrategy(commandContext, (EvtJobEntity)this.job, this.exception, errorStrategy);
        } else {
            newJobEntity = ExceptionUtil.handleJobStrategy(commandContext, (JobEntity)this.job, this.exception);
        }
        if (newJobEntity != null) {
            newJobEntity.setRetries(this.job.getRetries() - 1);
            int cusWaitTime = -1;
            if (this.errorStrategy != null && this.errorStrategy.getIntervalVal() > -1) {
                cusWaitTime = this.errorStrategy.getIntervalVal();
            }
            int calType = 12;
            if (this.errorStrategy != null && this.errorStrategy.getCalType() > -1) {
                calType = this.errorStrategy.getCalType();
            }
            if (this.job.getDuedate() == null || "message".equals(this.job.getJobType())) {
                newJobEntity.setDuedate(this.calculateDueDate(commandContext, MessageServiceUtil.getJobWaitTime(this.job, cusWaitTime > -1 ? cusWaitTime : processEngineConfig.getAsyncFailedJobWaitTime()), null, calType));
            } else {
                newJobEntity.setDuedate(this.calculateDueDate(commandContext, MessageServiceUtil.getJobWaitTime(this.job, cusWaitTime > -1 ? cusWaitTime : processEngineConfig.getDefaultFailedJobWaitTime()), this.job.getDuedate(), calType));
            }
        }
        this.log.debug(String.format("--------------------------job %s and job type:%s", this.job.getId(), this.job.getJobHandlerType()));
        this.updateJobStatus(commandContext, strategy);
        this.checkJobUnsubmit(commandContext, newJobEntity);
        return newJobEntity;
    }

    private void checkJobUnsubmit(CommandContext commandContext, final AbstractJobEntity newJobEntity) {
        if ("address-process-event".equals(this.job.getJobHandlerType())) {
            commandContext.addCloseListenerFirst(new DefaultCommandContextCloseListener("jobRetry-check-unsubmit"){

                @Override
                public void closing(CommandContext commandContext) {
                    super.closing(commandContext);
                    String source = JobRetryCmd.this.job.getSource();
                    JobHandleStrategy strategy = JobHandleStrategyFactory.getJobHandleStrategy(source, "");
                    JobEntity checkJob = (JobEntity)strategy.findJob(JobRetryCmd.this.job.getId(), false);
                    if (checkJob == null || WfCacheHelper.existWithdrawDeleteBizJobs(checkJob.getEntityNumber(), checkJob.getId()) || !checkJob.getId().equals(checkJob.getRootJobId()) && WfCacheHelper.existWithdrawTimerOrDeadJobRootId(checkJob.getEntityNumber(), checkJob.getRootJobId())) {
                        if (newJobEntity instanceof TimerJobEntity) {
                            commandContext.getTimerJobEntityManager().delete(newJobEntity.getId());
                        } else if (newJobEntity instanceof DeadLetterJobEntity) {
                            commandContext.getDeadLetterJobEntityManager().delete(newJobEntity.getId());
                        }
                        JobEntity inWfJob = (JobEntity)commandContext.getJobEntityManager().findById(JobRetryCmd.this.job.getId());
                        if (inWfJob != null) {
                            inWfJob.setExceptionMessage(String.format("%s;%s", inWfJob.getExceptionMessage(), "current bill is unsubmit."));
                            commandContext.getJobEntityManager().update(inWfJob);
                            WfCacheHelper.removeExecutingJobGYEntityOfCurrentBusiness(JobRetryCmd.this.job.getBusinessKey(), JobRetryCmd.this.job.getEntityNumber());
                        }
                    }
                }
            });
        }
    }

    protected Date calculateDueDate(CommandContext commandContext, int waitTimeInMinutes, Date oldDate, int calType) {
        GregorianCalendar newDateCal = new GregorianCalendar();
        if (oldDate != null) {
            newDateCal.setTime(oldDate);
        } else {
            newDateCal.setTime(commandContext.getProcessEngineConfiguration().getClock().getCurrentTime());
        }
        ((Calendar)newDateCal).add(calType, waitTimeInMinutes);
        return newDateCal.getTime();
    }
}

