/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.workflow.engine.impl.cmd.job;

import java.io.Serializable;
import java.util.Date;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.workflow.devopos.WFDevopsUtils;
import kd.bos.workflow.devopos.WorkflowDevopsService;
import kd.bos.workflow.devopos.info.IndicatorInfo;
import kd.bos.workflow.engine.JobNotFoundException;
import kd.bos.workflow.engine.impl.interceptor.Command;
import kd.bos.workflow.engine.impl.interceptor.CommandContext;
import kd.bos.workflow.engine.impl.persistence.entity.job.DeadLetterJobEntity;
import kd.bos.workflow.engine.impl.persistence.entity.job.JobEntity;
import kd.bos.workflow.exception.WFIllegalArgumentException;

public class MoveDeadLetterJobToExecutableJobCmd
implements Command<JobEntity>,
Serializable {
    private static final long serialVersionUID = 1L;
    protected static Log log = LogFactory.getLog(MoveDeadLetterJobToExecutableJobCmd.class);
    protected Long jobId;
    protected int retries;

    public MoveDeadLetterJobToExecutableJobCmd(Long jobId, int retries) {
        this.jobId = jobId;
        this.retries = retries;
    }

    @Override
    public JobEntity execute(CommandContext commandContext) {
        if (this.jobId == null) {
            throw new WFIllegalArgumentException("jobId and job is null");
        }
        DeadLetterJobEntity job = (DeadLetterJobEntity)commandContext.getDeadLetterJobEntityManager().findById(this.jobId);
        if (job == null) {
            throw new JobNotFoundException(this.jobId);
        }
        log.debug(String.format("Moving deadletter job to executable job table %s", job.getId()));
        JobEntity jobEntity = commandContext.getJobManager().moveDeadLetterJobToExecutableJob(job, this.retries);
        this.collectDevopsFailJob(job);
        return jobEntity;
    }

    private void collectDevopsFailJob(DeadLetterJobEntity jobEntity) {
        Date asyncMessageStartTime = WFDevopsUtils.getAsyncMessageStartTime();
        if (jobEntity.getCreateDate().before(asyncMessageStartTime)) {
            return;
        }
        if ("address-process-event".equalsIgnoreCase(jobEntity.getJobHandlerType())) {
            IndicatorInfo indicatorInfo = new IndicatorInfo("addressMessage", (Object)"fail", -1);
            WorkflowDevopsService.create().exceutionDataCollection(indicatorInfo);
        } else {
            IndicatorInfo indicatorInfo = new IndicatorInfo("asyncMessage", (Object)"fail", -1);
            indicatorInfo.addToSpecialProperty("processType", (Object)jobEntity.getProcessType());
            WorkflowDevopsService.create().exceutionDataCollection(indicatorInfo);
        }
    }

    public Long getJobId() {
        return this.jobId;
    }
}

