/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.workflow.engine.impl.cmd.job;

import java.io.Serializable;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.workflow.engine.JobNotFoundException;
import kd.bos.workflow.engine.WfUtils;
import kd.bos.workflow.engine.impl.interceptor.Command;
import kd.bos.workflow.engine.impl.interceptor.CommandContext;
import kd.bos.workflow.engine.impl.persistence.entity.job.AbstractJobEntity;
import kd.bos.workflow.engine.impl.persistence.entity.job.DeadLetterJobEntity;
import kd.bos.workflow.engine.impl.persistence.entity.job.JobEntity;

public class MoveJobToDeadLetterJobCmd
implements Command<DeadLetterJobEntity>,
Serializable {
    private static final long serialVersionUID = 1L;
    protected static Log log = LogFactory.getLog(MoveJobToDeadLetterJobCmd.class);
    protected Long jobId;
    protected Throwable e;
    protected JobEntity job;

    public MoveJobToDeadLetterJobCmd(Long jobId) {
        this.jobId = jobId;
    }

    public MoveJobToDeadLetterJobCmd(Long jobId, Throwable e) {
        this.e = e;
        this.jobId = jobId;
    }

    public MoveJobToDeadLetterJobCmd(JobEntity job, Throwable e) {
        this.e = e;
        this.job = job;
    }

    @Override
    public DeadLetterJobEntity execute(CommandContext commandContext) {
        AbstractJobEntity job;
        if (this.job == null && WfUtils.isNotEmpty(this.jobId) && (job = (AbstractJobEntity)commandContext.getTimerJobEntityManager().findById(this.jobId)) == null) {
            job = (AbstractJobEntity)commandContext.getJobEntityManager().findById(this.jobId);
        }
        if (this.job == null) {
            throw new JobNotFoundException(this.jobId);
        }
        log.debug(String.format("Moving job to deadletter job table %s", this.job.getId()));
        DeadLetterJobEntity deadLetterJob = commandContext.getJobManager().moveJobToDeadLetterJob(this.job, this.e);
        return deadLetterJob;
    }

    public Long getJobId() {
        return this.jobId;
    }
}

