/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.workflow.engine.impl.cmd.job;

import java.io.Serializable;
import java.util.ArrayList;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.workflow.engine.JobNotFoundException;
import kd.bos.workflow.engine.impl.interceptor.Command;
import kd.bos.workflow.engine.impl.interceptor.CommandContext;
import kd.bos.workflow.engine.impl.persistence.entity.job.JobEntity;
import kd.bos.workflow.engine.impl.persistence.entity.job.TimerJobEntity;
import kd.bos.workflow.exception.WFIllegalArgumentException;

public class MoveTimerToExecutableJobCmd
implements Command<JobEntity>,
Serializable {
    private static final long serialVersionUID = 1L;
    protected static Log log = LogFactory.getLog(MoveTimerToExecutableJobCmd.class);
    protected Long jobId;

    public MoveTimerToExecutableJobCmd(Long jobId) {
        this.jobId = jobId;
    }

    @Override
    public JobEntity execute(CommandContext commandContext) {
        if (this.jobId == null) {
            throw new WFIllegalArgumentException("jobId and job is null");
        }
        TimerJobEntity timerJob = (TimerJobEntity)commandContext.getTimerJobEntityManager().findById(this.jobId);
        if (timerJob == null) {
            throw new JobNotFoundException(this.jobId);
        }
        log.debug(String.format("Executing timer job %s", timerJob.getId()));
        JobEntity entity = commandContext.getJobManager().moveTimerJobToExecutableJob(timerJob);
        if (entity != null) {
            ArrayList<JobEntity> jobs = new ArrayList<JobEntity>();
            jobs.add(entity);
            commandContext.getJobManager().batchScheduleAsyncJob(jobs);
        }
        return entity;
    }

    public Long getJobId() {
        return this.jobId;
    }
}

