/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.workflow.engine.impl.cmd.job;

import kd.bos.workflow.engine.WfUtils;
import kd.bos.workflow.engine.impl.cmd.job.ILocalJobHandleStrategy;
import kd.bos.workflow.engine.impl.cmd.job.JobErrorHandleCmd;
import kd.bos.workflow.engine.impl.interceptor.CommandContext;
import kd.bos.workflow.engine.impl.jobexecutor.ErrorHandlerStrategy;
import kd.bos.workflow.engine.impl.persistence.entity.history.HistoricProcessInstanceEntity;
import kd.bos.workflow.engine.impl.persistence.entity.job.AbstractJobEntity;
import kd.bos.workflow.engine.impl.persistence.entity.job.JobEntity;
import kd.bos.workflow.engine.runtime.ExecuteJob;
import kd.bos.workflow.exception.WFEngineException;

public class SendTerminateProcessJobCmd
extends JobErrorHandleCmd {
    public SendTerminateProcessJobCmd(ExecuteJob job, Throwable exception, ErrorHandlerStrategy strategy) {
        super(job, exception, strategy);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected AbstractJobEntity innerExecute(CommandContext commandContext, ILocalJobHandleStrategy strategy) {
        try {
            Long procInstId = this.job.getProcessInstanceId();
            String exceptionMsg = WfUtils.getExceptionStacktrace(this.exception);
            this.log.info(String.format("Terminate the process when an exception occurs. EntityNumber: %s, BusinessKey: %s. %s", this.job.getEntityNumber(), this.job.getBusinessKey(), exceptionMsg));
            HistoricProcessInstanceEntity procInst = (HistoricProcessInstanceEntity)commandContext.getHistoricProcessInstanceEntityManager().findById(procInstId, "endTime");
            if (procInst == null || procInst.getEndTime() != null) {
                this.log.debug(String.format("The process instance %s does not exist or has already ended.", procInstId));
            } else if (this.job instanceof JobEntity) {
                String errorCode = "";
                if (this.exception instanceof WFEngineException && ((WFEngineException)((Object)this.exception)).getErrorCode() != null) {
                    errorCode = ((WFEngineException)((Object)this.exception)).getErrorCode().toString();
                }
                JobEntity terminateProcessJob = commandContext.getJobManager().createAsyncTerminateProcessJob((JobEntity)this.job, errorCode, exceptionMsg);
                commandContext.getJobManager().scheduleAsyncJob(terminateProcessJob);
            } else {
                this.log.debug(String.format("Unexpected type %s.", this.job.getClass()));
            }
        }
        finally {
            this.updateJobStatus(commandContext, strategy);
        }
        return null;
    }
}

