/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.workflow.engine.impl.cmd.job;

import kd.bos.extension.ExtensionFactory;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.workflow.engine.ProcessEngines;
import kd.bos.workflow.engine.impl.asyncexecutor.JobManager;
import kd.bos.workflow.engine.impl.cfg.ProcessEngineConfigurationImpl;
import kd.bos.workflow.engine.impl.cmd.job.JobHandleStrategy;
import kd.bos.workflow.engine.impl.util.ReflectUtil;
import kd.bos.workflow.util.WfCommonUtil;

public class TaskJobHelper {
    private static Log logger = LogFactory.getLog(TaskJobHelper.class);

    public static JobManager getTaskJobManagerProvider() {
        JobManager jobManager = TaskJobHelper.initJobManager();
        jobManager.setProcessEngineConfiguration((ProcessEngineConfigurationImpl)ProcessEngines.getDefaultProcessEngine().getProcessEngineConfiguration());
        return jobManager;
    }

    private static JobManager initJobManager() {
        try {
            return (JobManager)ExtensionFactory.getExtensionFacotry(JobManager.class).getExtension("taskJobManager");
        }
        catch (Exception e) {
            logger.error(String.format("get business object error,extName:%s,error is:%s", "taskJobManager", WfCommonUtil.getExceptionDetailStacktrace((Throwable)e)));
            return (JobManager)ReflectUtil.instantiate("kd.bos.workflow.task.job.impl.DefaultTaskModelJobManager");
        }
    }

    public static JobHandleStrategy getTaskJobStrategyProvider() {
        try {
            return (JobHandleStrategy)ExtensionFactory.getExtensionFacotry(JobHandleStrategy.class).getExtension("taskJobStrategy");
        }
        catch (Exception e) {
            logger.error(String.format("get business object error,extName:%s,error is:%s", "taskJobStrategy", WfCommonUtil.getExceptionDetailStacktrace((Throwable)e)));
            return (JobHandleStrategy)ReflectUtil.instantiate("kd.bos.workflow.task.job.asyncexecutor.strategy.LocalTaskJobHandleStrategy");
        }
    }
}

