/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.workflow.engine.impl.cmd.management;

import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import kd.bos.context.RequestContext;
import kd.bos.dataentity.entity.ILocaleString;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.serialization.SerializationUtils;
import kd.bos.log.api.AppLogInfo;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.servicehelper.TimeServiceHelper;
import kd.bos.servicehelper.log.LogServiceHelper;
import kd.bos.workflow.bpmn.model.CallActivity;
import kd.bos.workflow.bpmn.model.YunzhijiaTask;
import kd.bos.workflow.engine.TaskService;
import kd.bos.workflow.engine.WFMultiLangConstants;
import kd.bos.workflow.engine.WfUtils;
import kd.bos.workflow.engine.impl.bpmn.behavior.CallActivityUtil;
import kd.bos.workflow.engine.impl.cmd.management.BillBackOrProcessTerminateCmd;
import kd.bos.workflow.engine.impl.cmd.task.GetBillExecutionInBizFlowCmd;
import kd.bos.workflow.engine.impl.interceptor.Command;
import kd.bos.workflow.engine.impl.interceptor.CommandContext;
import kd.bos.workflow.engine.impl.jobexecutor.JobUtil;
import kd.bos.workflow.engine.impl.persistence.entity.design.ModelType;
import kd.bos.workflow.engine.impl.persistence.entity.history.HistoricActivityInstanceEntity;
import kd.bos.workflow.engine.impl.persistence.entity.job.DeadLetterJobEntity;
import kd.bos.workflow.engine.impl.persistence.entity.management.ManagementConstants;
import kd.bos.workflow.engine.impl.persistence.entity.operationlog.OperationLogEntityImpl;
import kd.bos.workflow.engine.impl.persistence.entity.runtime.ExecutionEntity;
import kd.bos.workflow.engine.impl.util.RuntimeUtil;
import kd.bos.workflow.engine.impl.util.WfOperationLogUtil;
import kd.bos.workflow.exception.WFEngineException;
import kd.bos.workflow.exception.WFIllegalArgumentException;
import kd.bos.workflow.service.WfTraceType;

public class AbandonProcessCmd
implements Command<Void> {
    protected static Log logger = LogFactory.getLog(AbandonProcessCmd.class);
    protected Long proInstanceId;
    private ILocaleString cause;
    private String dynType;
    private Map<String, Object> param = null;
    private ExecutionEntity executionEntity;
    public static final String PROCESSINSTIDDYNNAMEMAP = "processInstIdDynNameMap";

    public AbandonProcessCmd(Long proInstanceId) {
        this.proInstanceId = proInstanceId;
        this.dynType = "forceAbort";
    }

    public AbandonProcessCmd(Long proInstanceId, ILocaleString cause, String dynType) {
        this.proInstanceId = proInstanceId;
        this.cause = cause;
        this.dynType = dynType;
    }

    public AbandonProcessCmd(Long proInstanceId, ILocaleString cause, String dynType, Map<String, Object> param) {
        this.proInstanceId = proInstanceId;
        this.cause = cause;
        this.dynType = dynType;
        this.param = param;
    }

    public AbandonProcessCmd(ILocaleString cause, String dynType, Map<String, Object> param, ExecutionEntity execution) {
        this.proInstanceId = execution.getProcessInstanceId();
        this.cause = cause;
        this.dynType = dynType;
        this.param = param;
        this.executionEntity = execution;
    }

    @Override
    public Void execute(CommandContext commandContext) {
        Map<Object, Object> variables;
        if (WfUtils.isEmpty(this.proInstanceId)) {
            if (JobUtil.isInJobThread()) {
                logger.warn(String.format("processInstanceId[%s] is null", this.proInstanceId));
                return null;
            }
            throw new WFIllegalArgumentException(ResManager.loadKDString((String)"\u6d41\u7a0b\u5b9e\u4f8b\u4e0d\u80fd\u4e3a\u7a7a\u3002", (String)"AbandonProcessCmd_1", (String)"bos-wf-engine", (Object[])new Object[0]));
        }
        if ("forceAbortAll".equals(this.dynType)) {
            this.abandonFromRootProcess(commandContext);
            return null;
        }
        ExecutionEntity destExecution = this.getDestExecution(commandContext);
        if (destExecution == null) {
            if (JobUtil.isInJobThread()) {
                logger.warn(String.format("processInstanceId[%s] cannot find execution,may be it is finished!", this.proInstanceId));
                return null;
            }
            logger.debug(String.format("processInstanceId[%s] cannot find execution", this.proInstanceId));
            throw new WFEngineException(ResManager.loadKDString((String)"\u627e\u4e0d\u5230\u53ef\u7ec8\u6b62\u7684\u6267\u884c\u5b9e\u4f8b\u3002", (String)"AbandonProcessCmd_2", (String)"bos-wf-engine", (Object[])new Object[0]));
        }
        boolean isRunning = false;
        isRunning = ModelType.NoCodeFlow.name().equals(destExecution.getProcessType()) ? RuntimeUtil.isRunningByProcInst(commandContext, destExecution.getProcessInstanceId()) : RuntimeUtil.isRunning(commandContext, destExecution.getBusinessKey());
        if (isRunning) {
            throw new WFEngineException(ResManager.loadKDString((String)"\u5f53\u524d\u6267\u884c\u5b9e\u4f8b\u6b63\u5728\u6d41\u8f6c\uff0c\u65e0\u6cd5\u5f3a\u5236\u7ec8\u6b62\u3002", (String)"AbandonProcessCmd_3", (String)"bos-wf-engine", (Object[])new Object[0]));
        }
        Object isRestartProcess = this.param == null ? null : this.param.remove("isRestartProcess");
        Map<Object, Object> map = variables = this.param == null ? new HashMap() : this.param;
        if (WfUtils.isNotEmpty(this.cause)) {
            variables.put("dynName", SerializationUtils.toJsonString((Object)this.cause));
        }
        variables.put("dynType", this.dynType);
        this.correctDynVariables(variables);
        this.saveOperationLog(commandContext, destExecution);
        boolean isNeedWait = CallActivityUtil.tryAbandonAllCallActivity(commandContext, destExecution, variables, "terminate");
        if (!isNeedWait) {
            this.skipTaskAndContinue(commandContext, destExecution, variables);
        }
        return null;
    }

    private void correctDynVariables(Map<String, Object> variables) {
        Map procInstIdDynNameMap;
        ILocaleString dynName;
        String triggerKey = String.format("%s_%s", this.proInstanceId, "triggerExecutionId");
        if (variables.get(triggerKey) != null) {
            variables.remove("dynType");
            variables.remove("dynName");
            return;
        }
        if (("forceAbort".equals(this.dynType) || "abortByParentProcessAbort".equals(this.dynType) || "billExcepAbort".equals(this.dynType)) && variables.get(PROCESSINSTIDDYNNAMEMAP) instanceof Map && WfUtils.isNotEmpty(dynName = (ILocaleString)(procInstIdDynNameMap = (Map)variables.get(PROCESSINSTIDDYNNAMEMAP)).get(this.proInstanceId))) {
            variables.put("dynName", SerializationUtils.toJsonString((Object)dynName));
        }
    }

    private void abandonFromRootProcess(CommandContext commandContext) {
        this.param = this.param == null ? new HashMap() : this.param;
        HashMap<Long, ILocaleString> procInstIdDynNameMap = new HashMap<Long, ILocaleString>();
        String triggerKey = String.format("%s_%s", this.proInstanceId, "triggerExecutionId");
        if (this.param.get(triggerKey) == null) {
            procInstIdDynNameMap.put(this.proInstanceId, WFMultiLangConstants.getForceAbortText());
        }
        ExecutionEntity curProcInstance = commandContext.getExecutionEntityManager().findProcessInstanceById(this.proInstanceId);
        for (ExecutionEntity superExecution = curProcInstance.getSuperExecution(); superExecution != null; superExecution = superExecution.getSuperExecution()) {
            procInstIdDynNameMap.put(superExecution.getProcessInstanceId(), WFMultiLangConstants.getSubProcessTerminateText());
        }
        this.param.put(PROCESSINSTIDDYNNAMEMAP, procInstIdDynNameMap);
        ExecutionEntity rootProcessInstance = curProcInstance.getRootProcessInstance();
        String businessKey = curProcInstance.getBusinessKey();
        String entityNumber = curProcInstance.getEntityNumber();
        if (rootProcessInstance != null) {
            Long rootProcessInstanceId = rootProcessInstance.getId();
            if (ModelType.BizFlow.name().equals(rootProcessInstance.getProcessType())) {
                Object billExecutions = new GetBillExecutionInBizFlowCmd(rootProcessInstanceId).execute(commandContext);
                billExecutions.stream().filter(e -> e.getBusinessKey().equals(businessKey) && e.getEntityNumber().equals(entityNumber)).findFirst().ifPresent(billExecution -> new BillBackOrProcessTerminateCmd((ExecutionEntity)billExecution, entityNumber, WFMultiLangConstants.getForceAbortText(), "terminate", this.param).execute(commandContext));
            } else {
                new AbandonProcessCmd(rootProcessInstanceId, this.cause, "forceAbort", this.param).execute(commandContext);
            }
        }
    }

    protected ExecutionEntity getDestExecution(CommandContext commandContext) {
        HistoricActivityInstanceEntity historicActivityInstanceEntity;
        String triggerKey = String.format("%s_%s", this.proInstanceId, "triggerExecutionId");
        if (this.param != null && this.param.get(triggerKey) instanceof Long) {
            Long triggerExecutionId = (Long)this.param.get(triggerKey);
            return (ExecutionEntity)commandContext.getExecutionEntityManager().findById(triggerExecutionId);
        }
        List<DeadLetterJobEntity> deadLetterJobs = commandContext.getDeadLetterJobEntityManager().findJobsByProcessInstanceId(this.proInstanceId);
        ArrayList<Long> deadLetterExeIds = new ArrayList<Long>(deadLetterJobs.size());
        for (DeadLetterJobEntity dljob : deadLetterJobs) {
            if (!RuntimeUtil.isRunningJob(dljob.getJobHandlerType())) continue;
            deadLetterExeIds.add(dljob.getExecutionId());
        }
        List<ExecutionEntity> executionList = commandContext.getExecutionEntityManager().findChildExecutionsByProcessInstanceId(this.proInstanceId);
        ExecutionEntity destExecution = this.executionEntity;
        ExecutionEntity firstExecution = null;
        boolean bizFlow = false;
        if (executionList != null && destExecution == null) {
            if (executionList.size() > 0) {
                bizFlow = ModelType.BizFlow.name().equalsIgnoreCase(executionList.get(0).getProcessType());
            }
            for (ExecutionEntity executionEntity : executionList) {
                logger.debug(String.format("deadLetterExeIds is [%s],executionEntityId is[%s],processInstanceId is[%s],is equal[%s]", WfUtils.listToString(deadLetterExeIds, ","), executionEntity.getId(), executionEntity.getProcessInstanceId(), executionEntity.getId().equals(executionEntity.getProcessInstanceId())));
                if (executionEntity.getId().equals(executionEntity.getProcessInstanceId())) continue;
                if (bizFlow && !executionEntity.isBillExecution() && firstExecution == null) {
                    firstExecution = executionEntity;
                }
                if ((destExecution == null || !deadLetterExeIds.contains(destExecution.getId())) && deadLetterExeIds.contains(executionEntity.getId())) {
                    destExecution = executionEntity;
                    destExecution.getProcessInstance().setTransientVariable("processAbandon", "processAbandon");
                }
                if (!executionEntity.isActive() && executionEntity.getCurrentFlowElement() instanceof CallActivity) {
                    logger.debug(String.format("executionEntity.isActive is[%s],Instanceof is[%s]", executionEntity.isActive(), executionEntity.getCurrentFlowElement() instanceof CallActivity));
                    continue;
                }
                logger.debug(String.format("destExecution is[%s],executionEntity.getParent() is[%s], executionEntity.isActive() is[%s]", destExecution, executionEntity.getParent(), executionEntity.isActive()));
                if (destExecution == null && executionEntity.getParent() != null && executionEntity.isActive()) {
                    destExecution = executionEntity;
                }
                logger.info(String.format("destExecution is[%s]...", destExecution));
            }
            logger.info(String.format("executionList.size[%s]", executionList.size()));
        }
        if (destExecution != null && destExecution.getParent() != null && destExecution.getParent().isMultiInstanceRoot() && destExecution.getCurrentFlowElement() instanceof YunzhijiaTask && (historicActivityInstanceEntity = (HistoricActivityInstanceEntity)commandContext.getHistoricActivityInstanceEntityManager().findById(destExecution.getCurrentActInstId())).getEndTime() == null) {
            logger.debug("executionEntity.isMultiInstanceRoot()");
            destExecution = destExecution.getParent();
        }
        logger.debug(String.format("destExecution is[%s],,,", destExecution));
        if (destExecution == null && bizFlow && firstExecution != null) {
            destExecution = firstExecution;
            destExecution.setActive(true);
            commandContext.getExecutionEntityManager().update(destExecution);
        }
        return destExecution;
    }

    private void saveOperationLog(CommandContext commandContext, ExecutionEntity destExecution) {
        OperationLogEntityImpl operationLog = new OperationLogEntityImpl();
        Date date = commandContext.getProcessEngineConfiguration().getClock().getCurrentTime();
        operationLog.setCreateDate(date);
        Long currentTaskId = destExecution.getCurrentTaskId();
        operationLog.setTaskId(destExecution.getCurrentTaskId());
        if (currentTaskId == null || currentTaskId.equals(0L)) {
            operationLog.setActivityName(destExecution.getActivityName());
            operationLog.setActivityId(destExecution.getActivityId());
        }
        operationLog.setProcInstId(this.proInstanceId);
        String type = "billAbort".equals(this.dynType) ? "billWithdraw" : "terminal_f";
        operationLog.setType(type);
        Long userId = Long.parseLong(RequestContext.get().getUserId());
        operationLog.setOwnerId(userId);
        operationLog.setOwner(WfUtils.findUserName(userId));
        operationLog.setNOpinion(this.cause);
        operationLog.setTerminalWay(this.calClient());
        WfOperationLogUtil.recordOperationLog(commandContext, operationLog);
    }

    public void addWebLog(String entityNumber, String opName, String opDescription) {
        try {
            AppLogInfo info = new AppLogInfo();
            info.setUserID(Long.valueOf(RequestContext.get().getUserId()));
            info.setBizAppID("a479ec06000000ac");
            info.setBizObjID(entityNumber);
            info.setOrgID(Long.valueOf(RequestContext.get().getOrgId()));
            info.setOpTime(TimeServiceHelper.now());
            info.setClientType(this.calClient());
            String clientIP = "batch".equals(RequestContext.get().getClient()) ? "******" : (WfTraceType.get() != null && WfTraceType.get().getJobInfo() != null ? "******" : RequestContext.get().getLoginIP());
            info.setClientIP(clientIP);
            info.setOpName(opName);
            info.setOpDescription(opDescription);
            LogServiceHelper.addLog((AppLogInfo)info);
        }
        catch (Exception e) {
            logger.warn(e.getMessage());
        }
    }

    public String calClient() {
        String client = RequestContext.get().getClient();
        if ("mobile".equals(client)) {
            return "mobile";
        }
        if ("api".equals(client)) {
            return "api";
        }
        return "web";
    }

    protected void skipTaskAndContinue(CommandContext commandContext, ExecutionEntity destExecution, Map<String, Object> variables) {
        List<DeadLetterJobEntity> deadLetterJobEntities;
        TaskService taskService = commandContext.getProcessEngineConfiguration().getTaskService();
        Long curUserId = RequestContext.get().getCurrUserId();
        String suspensionState = destExecution.getProcessInstance().getSuspensionState();
        boolean isSuspend = ManagementConstants.SUSPENDED.getStateCode().equals(suspensionState);
        if (!isSuspend && ModelType.BizFlow.name().equalsIgnoreCase(destExecution.getProcessType()) && (deadLetterJobEntities = commandContext.getDeadLetterJobEntityManager().findRunningJobsByProcessInstanceId(destExecution.getProcessInstanceId())) != null && !deadLetterJobEntities.isEmpty()) {
            isSuspend = true;
        }
        taskService.skipTaskAndContinue(destExecution, curUserId, variables, isSuspend);
    }
}

