/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.workflow.engine.impl.cmd.management;

import java.util.ArrayList;
import java.util.List;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.query.QFilter;
import kd.bos.workflow.bpmn.model.CallActivity;
import kd.bos.workflow.engine.WfUtils;
import kd.bos.workflow.engine.impl.cfg.ProcessEngineConfigurationImpl;
import kd.bos.workflow.engine.impl.cmd.ActivateProcessInstanceCmd;
import kd.bos.workflow.engine.impl.cmd.SuspendOrActiveProcessCmd;
import kd.bos.workflow.engine.impl.cmd.job.EventTriggerCmd;
import kd.bos.workflow.engine.impl.cmd.job.MoveDeadLetterJobToExecutableJobCmd;
import kd.bos.workflow.engine.impl.db.EntityQueryBuilder;
import kd.bos.workflow.engine.impl.interceptor.Command;
import kd.bos.workflow.engine.impl.interceptor.CommandContext;
import kd.bos.workflow.engine.impl.interceptor.CommandExecutor;
import kd.bos.workflow.engine.impl.persistence.entity.history.HistoricProcessInstanceEntity;
import kd.bos.workflow.engine.impl.persistence.entity.history.HistoricProcessInstanceEntityManager;
import kd.bos.workflow.engine.impl.persistence.entity.job.DeadLetterJobEntity;
import kd.bos.workflow.engine.impl.persistence.entity.job.DeadLetterJobEntityManager;
import kd.bos.workflow.engine.impl.persistence.entity.operationlog.OperationLogEntityImpl;
import kd.bos.workflow.engine.impl.persistence.entity.runtime.ExecutionEntity;
import kd.bos.workflow.engine.impl.persistence.entity.runtime.ExecutionEntityManager;
import kd.bos.workflow.engine.impl.util.WfOperationLogUtil;
import kd.bos.workflow.engine.msg.MessageServiceUtil;

public abstract class AbstractActivateProcessInstanceCmd
implements Command<Void> {
    protected Long id;
    protected boolean cascade;
    protected Long processInstanceId;
    protected List<DeadLetterJobEntity> deadLetterJobs;
    protected Log log = LogFactory.getLog(this.getClass());

    public AbstractActivateProcessInstanceCmd(Long id, boolean cascade) {
        this.id = id;
        this.cascade = cascade;
    }

    @Override
    public Void execute(CommandContext commandContext) {
        ProcessEngineConfigurationImpl pf = commandContext.getProcessEngineConfiguration();
        CommandExecutor commandExecutor = pf.getCommandExecutor();
        ExecutionEntityManager executionManager = commandContext.getExecutionEntityManager();
        DeadLetterJobEntityManager deadLetterManager = commandContext.getDeadLetterJobEntityManager();
        this.initRequiredParams(commandContext);
        if (this.deadLetterJobs == null || this.deadLetterJobs.isEmpty()) {
            if (WfUtils.isNotEmpty(this.processInstanceId)) {
                commandExecutor.execute(new SuspendOrActiveProcessCmd(this.processInstanceId, false));
                this.reExecuteSubProcessDeadLetterJob(commandContext);
            }
            return null;
        }
        if (WfUtils.isNotEmpty(this.processInstanceId)) {
            commandExecutor.execute(new ActivateProcessInstanceCmd(this.processInstanceId));
        }
        for (DeadLetterJobEntity deadLetterJob : this.deadLetterJobs) {
            ExecutionEntity execution = (ExecutionEntity)executionManager.findById(deadLetterJob.getExecutionId());
            if (execution == null) {
                this.log.info(String.format("execution is null! ExecutionId: %s  DeadLetterJobId: %s", deadLetterJob.getExecutionId(), deadLetterJob.getId()));
                this.reExecuteJob(pf, commandExecutor, deadLetterJob);
                continue;
            }
            if (!this.cascade) {
                this.reExecuteJob(pf, commandExecutor, deadLetterJob);
                continue;
            }
            if (WfUtils.isNotEmpty(execution.getSuperExecutionId())) {
                this.reExecuteJob(pf, commandExecutor, deadLetterJob);
                ExecutionEntity superExecution = execution.getSuperExecution();
                if (superExecution != null) {
                    Long procInstId = superExecution.getProcessInstanceId();
                    Long executionId = superExecution.getId();
                    this.activiteProcess(commandContext, procInstId, executionId);
                }
            } else if (execution.getCurrentFlowElement() instanceof CallActivity) {
                ExecutionEntity subProcessInstance = executionManager.findSubProcessInstanceBySuperExecutionId(execution.getId());
                if (subProcessInstance == null) {
                    this.reExecuteJob(pf, commandExecutor, deadLetterJob);
                } else {
                    this.activiteProcess(commandContext, subProcessInstance.getProcessInstanceId(), null);
                }
                deadLetterManager.delete(deadLetterJob);
            } else {
                this.reExecuteJob(pf, commandExecutor, deadLetterJob);
            }
            if (!commandContext.getProcessEngineConfiguration().isEnableBecEventDispatcher()) continue;
            new EventTriggerCmd("wf.AfterProcessErrorActivateEvent", execution, null).execute(commandContext);
        }
        OperationLogEntityImpl operationLog = new OperationLogEntityImpl();
        WfOperationLogUtil.recordOperationLogByIdAndType(commandContext, operationLog, this.processInstanceId, "suspendCancel");
        return null;
    }

    private void reExecuteSubProcessDeadLetterJob(CommandContext commandContext) {
        HistoricProcessInstanceEntityManager procInstEntityManager = commandContext.getHistoricProcessInstanceEntityManager();
        EntityQueryBuilder queryBuilder = procInstEntityManager.createQueryBuilder();
        queryBuilder.setSelectFields("id");
        queryBuilder.addFilter("superProcessInstanceId", this.processInstanceId).addFilter("endTime", "is null", null);
        List subProcInsts = procInstEntityManager.findByQueryBuilder(queryBuilder);
        if (subProcInsts == null || subProcInsts.isEmpty()) {
            return;
        }
        ArrayList<Long> procInstIds = new ArrayList<Long>(subProcInsts.size());
        for (HistoricProcessInstanceEntity subProcInst : subProcInsts) {
            procInstIds.add(subProcInst.getId());
        }
        QFilter[] filters = new QFilter[]{new QFilter("processInstanceId", "in", procInstIds)};
        List subDeadLetterJobs = commandContext.getDeadLetterJobEntityManager().findByQueryFilters(filters);
        if (subDeadLetterJobs == null || subDeadLetterJobs.isEmpty()) {
            return;
        }
        ProcessEngineConfigurationImpl pf = commandContext.getProcessEngineConfiguration();
        CommandExecutor commandExecutor = pf.getCommandExecutor();
        for (DeadLetterJobEntity deadLetterJob : subDeadLetterJobs) {
            this.reExecuteJob(pf, commandExecutor, deadLetterJob);
        }
    }

    private void reExecuteJob(ProcessEngineConfigurationImpl pf, CommandExecutor commandExecutor, DeadLetterJobEntity deadLetterJob) {
        int retries = MessageServiceUtil.getJobEntityRestries(deadLetterJob, null, pf.getAsyncExecutorNumberOfRetries());
        commandExecutor.execute(new MoveDeadLetterJobToExecutableJobCmd(deadLetterJob.getId(), retries));
    }

    private void activiteProcess(CommandContext commandContext, Long procInstId, Long executionId) {
        ProcessEngineConfigurationImpl pf = commandContext.getProcessEngineConfiguration();
        CommandExecutor commandExecutor = pf.getCommandExecutor();
        List<DeadLetterJobEntity> jobs = this.getDeadLetterJobsByProcInstId(commandContext, procInstId);
        int actual = 0;
        int expected = 0;
        if (jobs != null && !jobs.isEmpty()) {
            expected = jobs.size();
            for (DeadLetterJobEntity job : jobs) {
                if (executionId != null && !executionId.equals(job.getExecutionId())) continue;
                this.reExecuteJob(pf, commandExecutor, job);
                ++actual;
            }
        }
        if (actual == expected) {
            commandExecutor.execute(new ActivateProcessInstanceCmd(procInstId));
        }
    }

    protected List<DeadLetterJobEntity> getDeadLetterJobsByProcInstId(CommandContext commandContext, Long processInstanceId) {
        return commandContext.getDeadLetterJobEntityManager().findJobsByProcessInstanceId(processInstanceId);
    }

    protected abstract void initRequiredParams(CommandContext var1);

    public void setProcessInstanceId(Long processInstanceId) {
        this.processInstanceId = processInstanceId;
    }

    public void setDeadLetterJobs(List<DeadLetterJobEntity> deadLetterJobs) {
        this.deadLetterJobs = deadLetterJobs;
    }
}

