/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.workflow.engine.impl.cmd.management;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import kd.bos.algo.DataSet;
import kd.bos.algo.Row;
import kd.bos.dataentity.entity.ILocaleString;
import kd.bos.db.DB;
import kd.bos.db.DBRoute;
import kd.bos.orm.query.QFilter;
import kd.bos.workflow.engine.WfUtils;
import kd.bos.workflow.engine.impl.interceptor.Command;
import kd.bos.workflow.engine.impl.interceptor.CommandContext;
import kd.bos.workflow.engine.impl.persistence.entity.runtime.ExecutionEntity;
import kd.bos.workflow.engine.impl.persistence.entity.task.TaskCenterRuleEntity;
import kd.bos.workflow.engine.impl.persistence.entity.task.TaskCenterRuleEntityManager;

public abstract class AbstractSetProcessInstanceAndRuleStateByUserIdCmd
implements Command<Void>,
Serializable {
    private static final long serialVersionUID = 1L;
    protected final ILocaleString suspendReason;
    protected final Long userId;

    public AbstractSetProcessInstanceAndRuleStateByUserIdCmd(Long userId, ILocaleString suspendReason) {
        this.userId = userId;
        this.suspendReason = suspendReason;
    }

    @Override
    public Void execute(CommandContext commandContext) {
        ArrayList executions = new ArrayList();
        QFilter filter1 = new QFilter("startUserId", "=", (Object)this.userId);
        QFilter filter2 = new QFilter("scope", "=", (Object)true);
        QFilter filter3 = new QFilter("parentId", "=", (Object)0L);
        QFilter[] filters = new QFilter[]{filter1, filter2, filter3};
        executions.addAll(commandContext.getExecutionEntityManager().findByQueryFilters(filters));
        StringBuilder currentnNodeSql = new StringBuilder("SELECT t.FEXECUTIONID executionid FROM t_wf_task t INNER JOIN t_wf_participant p ON t.FID = p.FTASKID WHERE t.FISDISPLAY = ? AND  p.FUSERID = ?");
        Object[] params = new Object[]{true, this.userId};
        ArrayList<Long> executionIdsList = new ArrayList<Long>();
        try (DataSet ds = DB.queryDataSet((String)"WfSetProcessInstance", (DBRoute)DBRoute.workflow, (String)currentnNodeSql.toString(), (Object[])params);){
            for (Row row : ds) {
                executionIdsList.add(row.getLong("executionid"));
            }
        }
        StringBuilder transferSql = new StringBuilder("SELECT t.FEXECUTIONID executionId FROM t_wf_taskhandlelog tl INNER JOIN t_wf_task t ON tl.FTASKID = t.FID WHERE tl.FTYPE =  'transfer' AND tl.FOWNERID = ");
        transferSql.append(this.userId);
        DataSet dSet = DB.queryDataSet((String)"wfTransfer", (DBRoute)DBRoute.workflow, (String)transferSql.toString());
        Object iter = null;
        try {
            for (Row row : dSet) {
                executionIdsList.add(row.getLong("executionId"));
            }
        }
        catch (Throwable iterator) {
            iter = iterator;
            throw iterator;
        }
        finally {
            if (dSet != null) {
                if (iter != null) {
                    try {
                        dSet.close();
                    }
                    catch (Throwable iterator) {
                        ((Throwable)iter).addSuppressed(iterator);
                    }
                } else {
                    dSet.close();
                }
            }
        }
        QFilter currentnNodeUserFilter1 = new QFilter("id", "in", executionIdsList);
        QFilter[] currentnNodeUserFilters = new QFilter[]{currentnNodeUserFilter1};
        executions.addAll(commandContext.getExecutionEntityManager().findByQueryFilters(currentnNodeUserFilters));
        TaskCenterRuleEntityManager taskCenterRuleEntityManager = commandContext.getTaskCenterRuleEntityManager();
        List<TaskCenterRuleEntity> ruleEntitys = taskCenterRuleEntityManager.getNoFolderTaskCenterRulesByUserId(this.userId);
        if (executions != null && !executions.isEmpty()) {
            HashSet<Long> procInstIds = new HashSet<Long>(executions.size());
            for (ExecutionEntity execution : executions) {
                Long procInstId = execution.getProcessInstanceId();
                if (!WfUtils.isNotEmpty(procInstId) || !procInstIds.add(procInstId)) continue;
                this.suspendOrActiveProcessInstance(procInstId, commandContext);
            }
        }
        if (ruleEntitys != null && !ruleEntitys.isEmpty()) {
            for (TaskCenterRuleEntity taskCenterRuleEntity : ruleEntitys) {
                taskCenterRuleEntity.setActivitstate(this.getState());
                taskCenterRuleEntityManager.update(taskCenterRuleEntity);
            }
        }
        return null;
    }

    public abstract String getState();

    public abstract void suspendOrActiveProcessInstance(Long var1, CommandContext var2);
}

