/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.workflow.engine.impl.cmd.management;

import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONObject;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import kd.bos.orm.query.QFilter;
import kd.bos.workflow.engine.WfUtils;
import kd.bos.workflow.engine.impl.cmd.management.scheme.LogDynamicConfigSchemeRecordCmd;
import kd.bos.workflow.engine.impl.db.BatchSQLInfo;
import kd.bos.workflow.engine.impl.interceptor.Command;
import kd.bos.workflow.engine.impl.interceptor.CommandContext;
import kd.bos.workflow.engine.impl.persistence.entity.design.ModelEntity;
import kd.bos.workflow.engine.impl.persistence.entity.design.ModelEntityManager;
import kd.bos.workflow.engine.impl.persistence.entity.design.ResourceEntity;
import kd.bos.workflow.engine.impl.persistence.entity.design.ResourceEntityManager;
import kd.bos.workflow.engine.impl.persistence.entity.management.DynamicConfigSchemeEntity;
import kd.bos.workflow.engine.impl.persistence.entity.management.DynamicConfigSchemeEntityManager;
import kd.bos.workflow.engine.impl.persistence.entity.management.ProcessDefinitionEntity;
import kd.bos.workflow.engine.impl.persistence.entity.management.ProcessDefinitionEntityManager;
import kd.bos.workflow.engine.impl.util.BpmnModelUtil;

public class BatchModifyProcDefOrgCmd
implements Command<Void> {
    private List<Long> ids;
    private Long newOrgId;
    private boolean updateModel = false;

    public BatchModifyProcDefOrgCmd(List<Long> ids, Long newOrgId, boolean updateModel) {
        this.ids = ids;
        this.newOrgId = newOrgId;
        this.updateModel = updateModel;
    }

    @Override
    public Void execute(CommandContext commandContext) {
        if (WfUtils.isEmptyForCollection(this.ids)) {
            return null;
        }
        HashSet<Long> updatedModelIds = new HashSet<Long>();
        String orgField = "properties.orgUnitId";
        ArrayList<Object[]> updateParamsListForDefin = new ArrayList<Object[]>();
        ArrayList<Object[]> updateParamsListForModel = new ArrayList<Object[]>();
        String batchSqlForDefin = "update t_wf_procdef set forgunitid = ? where fid = ? ";
        String batchSqlForModel = "update t_wf_model set forgunitid = ? where fid = ? ";
        ProcessDefinitionEntityManager procDefEntityManager = commandContext.getProcessDefinitionEntityManager();
        ResourceEntityManager resourceEntityManager = commandContext.getResourceEntityManager();
        ModelEntityManager modelEntityManger = commandContext.getModelEntityManager();
        DynamicConfigSchemeEntityManager dynConfSchemeManager = commandContext.getDynamicConfigSchemeEntityManager();
        for (Long id : this.ids) {
            ModelEntity modelEntity;
            ProcessDefinitionEntity procDefEntity = (ProcessDefinitionEntity)procDefEntityManager.findById(id);
            if (null == procDefEntity) continue;
            ResourceEntity resourceEntity = (ResourceEntity)resourceEntityManager.findById(procDefEntity.getResourceId());
            String origModelJson = resourceEntity.getData();
            JSONObject model1 = JSON.parseObject((String)origModelJson);
            BpmnModelUtil.setProperty((Map<String, Object>)model1, orgField, this.newOrgId);
            String modelJson = model1.toJSONString();
            resourceEntity.setData(modelJson);
            resourceEntityManager.update(resourceEntity);
            List schemes = dynConfSchemeManager.findByQueryFilters(new QFilter[]{new QFilter("processdefinitionid", "=", (Object)id), new QFilter("isdefault", "=", (Object)Character.valueOf('1'))});
            if (WfUtils.isNotEmptyForCollection(schemes)) {
                new LogDynamicConfigSchemeRecordCmd((DynamicConfigSchemeEntity)schemes.get(0), modelJson, origModelJson, new HashSet<String>()).execute(commandContext);
            }
            updateParamsListForDefin.add(new Object[]{this.newOrgId, id});
            if (!this.updateModel || updatedModelIds.contains(procDefEntity.getModelId()) || null == (modelEntity = (ModelEntity)modelEntityManger.findById(procDefEntity.getModelId()))) continue;
            ResourceEntity modelResource = (ResourceEntity)resourceEntityManager.findById(modelEntity.getBPMNXMLID());
            JSONObject model2 = JSON.parseObject((String)modelResource.getData());
            BpmnModelUtil.setProperty((Map<String, Object>)model2, orgField, this.newOrgId);
            modelResource.setData(model2.toJSONString());
            resourceEntityManager.update(modelResource);
            updateParamsListForModel.add(new Object[]{this.newOrgId, procDefEntity.getModelId()});
            updatedModelIds.add(procDefEntity.getModelId());
        }
        this.batchUpdateForDefin(commandContext, batchSqlForDefin, updateParamsListForDefin, 1000);
        this.batchUpdateForModel(commandContext, batchSqlForModel, updateParamsListForModel, 1000);
        return null;
    }

    private void batchUpdateForDefin(CommandContext commandContext, String batchSql, List<Object[]> paramsList, Integer batchCount) {
        if (paramsList == null || paramsList.isEmpty()) {
            return;
        }
        BatchSQLInfo batchSQLInfo = new BatchSQLInfo(batchSql, paramsList, batchCount);
        commandContext.getProcessDefinitionEntityManager().addBatchSQLInfo(batchSQLInfo);
    }

    private void batchUpdateForModel(CommandContext commandContext, String batchSql, List<Object[]> paramsList, Integer batchCount) {
        if (paramsList == null || paramsList.isEmpty()) {
            return;
        }
        BatchSQLInfo batchSQLInfo = new BatchSQLInfo(batchSql, paramsList, batchCount);
        commandContext.getModelEntityManager().addBatchSQLInfo(batchSQLInfo);
    }
}

