/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.workflow.engine.impl.cmd.management;

import java.util.ArrayList;
import java.util.Date;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import kd.bos.context.RequestContext;
import kd.bos.dataentity.entity.ILocaleString;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dlock.DLock;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.ORM;
import kd.bos.orm.query.QFilter;
import kd.bos.workflow.bizflow.util.BizFlowUtil;
import kd.bos.workflow.bpmn.model.BillTask;
import kd.bos.workflow.bpmn.model.CallActivity;
import kd.bos.workflow.bpmn.model.FlowElement;
import kd.bos.workflow.bpmn.model.Process;
import kd.bos.workflow.engine.WfUtils;
import kd.bos.workflow.engine.impl.bpmn.behavior.TaskBehaviorUtil;
import kd.bos.workflow.engine.impl.bpmn.helper.BPMNUtil;
import kd.bos.workflow.engine.impl.cache.WfCacheHelper;
import kd.bos.workflow.engine.impl.calculator.ParticipantCalculator;
import kd.bos.workflow.engine.impl.cmd.management.AbandonProcessCmd;
import kd.bos.workflow.engine.impl.context.Context;
import kd.bos.workflow.engine.impl.event.CompensationEventHandler;
import kd.bos.workflow.engine.impl.interceptor.Command;
import kd.bos.workflow.engine.impl.interceptor.CommandContext;
import kd.bos.workflow.engine.impl.interceptor.DefaultCommandContextCloseListener;
import kd.bos.workflow.engine.impl.persistence.entity.history.HistoricActivityInstanceEntity;
import kd.bos.workflow.engine.impl.persistence.entity.history.HistoricActivityInstanceEntityManager;
import kd.bos.workflow.engine.impl.persistence.entity.history.HistoricTaskInstanceEntity;
import kd.bos.workflow.engine.impl.persistence.entity.operationlog.OperationLogEntityImpl;
import kd.bos.workflow.engine.impl.persistence.entity.runtime.ExeConversionEntity;
import kd.bos.workflow.engine.impl.persistence.entity.runtime.ExeConversionEntityManager;
import kd.bos.workflow.engine.impl.persistence.entity.runtime.ExecutionEntity;
import kd.bos.workflow.engine.impl.persistence.entity.runtime.ExecutionEntityManager;
import kd.bos.workflow.engine.impl.persistence.entity.task.TaskEntity;
import kd.bos.workflow.engine.impl.persistence.entity.task.TaskEntityManager;
import kd.bos.workflow.engine.impl.util.BpmnModelUtil;
import kd.bos.workflow.engine.impl.util.ProcessDefinitionUtil;
import kd.bos.workflow.engine.impl.util.WfOperationLogUtil;
import kd.bos.workflow.exception.WFErrorCode;
import kd.bos.workflow.exception.WFException;

public class BillBackOrProcessTerminateCmd
implements Command<Void> {
    protected static Log logger = LogFactory.getLog(BillBackOrProcessTerminateCmd.class);
    public static final String SCENE_TERMINATE = "terminate";
    public static final String SCENE_BILLEXCEPTION = "billException";
    private ExecutionEntity billExecution;
    private ILocaleString cause;
    private String scene = "billException";
    private String entityNumber;
    private boolean tryRecoverTask;
    private String operation;
    private Map<String, Object> params;

    public BillBackOrProcessTerminateCmd(ExecutionEntity billExecution, String entityNumber, ILocaleString cause, boolean recoveryTask, String operation) {
        this.billExecution = billExecution;
        this.entityNumber = entityNumber;
        this.cause = cause;
        this.tryRecoverTask = recoveryTask;
        this.operation = operation;
    }

    public BillBackOrProcessTerminateCmd(ExecutionEntity billExecution, String entityNumber, ILocaleString cause, String scene) {
        this.billExecution = billExecution;
        this.entityNumber = entityNumber;
        this.cause = cause;
        this.scene = scene;
    }

    public BillBackOrProcessTerminateCmd(ExecutionEntity billExecution, String entityNumber, ILocaleString cause, String scene, Map<String, Object> params) {
        this.billExecution = billExecution;
        this.entityNumber = entityNumber;
        this.cause = cause;
        this.scene = scene;
        this.params = params;
    }

    @Override
    public Void execute(CommandContext commandContext) {
        try {
            boolean billException;
            Long procinstId = this.billExecution.getProcessInstanceId();
            Long currentBillExeId = this.billExecution.getId();
            logger.debug(String.format("\u6267\u884c\u5355\u636e\u4f8b\u5916\uff0cprocInstid[%s], billExecutionId[%s]", procinstId, currentBillExeId));
            ExeConversionEntityManager exeConversionMgr = commandContext.getExeConversionEntityManager();
            ExecutionEntityManager executionMgr = commandContext.getExecutionEntityManager();
            List<ExecutionEntity> executions = executionMgr.findChildExecutionsByProcessInstanceId(procinstId);
            ArrayList<ExecutionEntity> executeExecutions = new ArrayList<ExecutionEntity>(executions.size());
            ArrayList<ExecutionEntity> billExecutions = new ArrayList<ExecutionEntity>(16);
            for (ExecutionEntity e : executions) {
                if (e.getId().equals(procinstId)) continue;
                if (e.isBillExecution() && !billExecutions.contains(e)) {
                    billExecutions.add(e);
                }
                if (!e.getParentId().equals(currentBillExeId)) continue;
                executeExecutions.add(e);
            }
            boolean isAbandonProcess = billExecutions.size() == 1;
            List<ExeConversionEntity> conversions = exeConversionMgr.getSourceExeConversionEntities(procinstId, this.billExecution.getEntityNumber(), this.billExecution.getBusinessKey());
            boolean bl = billException = !SCENE_TERMINATE.equals(this.scene);
            if (isAbandonProcess && executeExecutions != null && !executeExecutions.isEmpty() && conversions.isEmpty()) {
                this.abandonWholeBizFlow(commandContext, executionMgr, executeExecutions);
                Void void_ = null;
                return void_;
            }
            this.endCurrentBillExecution(commandContext, procinstId, currentBillExeId, conversions);
            if (!billException) {
                this.executeBillExecutionTerminateListeners(commandContext, "billterminate");
            }
            boolean targetExist = WfUtils.exist(this.billExecution.getEntityNumber(), (Object)this.billExecution.getBusinessKey());
            if (this.tryRecoverTask && !targetExist) {
                HashSet<Long> srcExecutionIds = new HashSet<Long>(conversions.size());
                for (ExeConversionEntity c : conversions) {
                    srcExecutionIds.add(c.getSrcExecutionId());
                }
                logger.debug(String.format("\u8282\u70b9\u56de\u6eaf\uff0c\u76ee\u6807\u5b9e\u4f8b%s", WfUtils.listToString(srcExecutionIds, ",")));
                if (!srcExecutionIds.isEmpty()) {
                    this.recoverSourceTask(commandContext, procinstId, executionMgr, srcExecutionIds);
                }
            } else {
                logger.debug(String.format("\u76ee\u6807\u5355entityEntity[%s]pk[%s]\u8fd8\u5b58\u5728\uff0c\u4e0d\u751f\u6210\u4ee3\u529e\u4efb\u52a1\u3002", this.billExecution.getEntityNumber(), this.billExecution.getBusinessKey()));
            }
            if (!targetExist) {
                BizFlowUtil.deleteBizRelationData(commandContext, this.billExecution.getBusinessKey());
            }
            BPMNUtil.updateActivityName(this.billExecution);
        }
        catch (Exception e) {
            logger.warn(String.format("BillBackOrProcessTerminate error %s", WfUtils.getExceptionStacktrace(e)));
            throw e;
        }
        finally {
            WfCacheHelper.removeExecutingJobGYEntityOfCurrentBusiness(this.billExecution.getBusinessKey(), this.billExecution.getEntityNumber());
        }
        return null;
    }

    private void abandonWholeBizFlow(CommandContext commandContext, ExecutionEntityManager executionMgr, List<ExecutionEntity> executeExecutions) {
        ExecutionEntity executeExecution = executeExecutions.get(executeExecutions.size() - 1);
        Long executeExecutionId = null;
        for (ExecutionEntity e : executeExecutions) {
            if (e.isActive() || !(e.getCurrentFlowElement() instanceof CallActivity)) continue;
            executeExecutionId = executeExecution.getId();
            break;
        }
        if (WfUtils.isNotEmpty(executeExecutionId)) {
            List<ExecutionEntity> subExes = executionMgr.findChildExecutionsByParentExecutionId(executeExecutionId);
            ExecutionEntity callActivitySubExe = null;
            for (ExecutionEntity se : subExes) {
                if (!se.getBusinessKey().equals(this.billExecution.getBusinessKey())) continue;
                callActivitySubExe = se;
                break;
            }
            if (callActivitySubExe == null) {
                logger.debug(String.format("\u627e\u4e0d\u5230\u8282\u70b9%s\u6267\u884c\u5b9e\u4f8b%s\u7684\u5b50\u6d41\u7a0b\u591a\u5b9e\u4f8b", executeExecution.getActivityId(), executeExecutionId));
            } else {
                executeExecution = callActivitySubExe;
            }
        }
        logger.debug(String.format("\u7ec8\u6b62\u6574\u4e2a\u6d41\u7a0b\uff0c\u6267\u884c\u5b9e\u4f8b%s", executeExecution.getId()));
        new AbandonProcessCmd(this.cause, "billExcepAbort", this.params, executeExecution).execute(commandContext);
        boolean targetExist = WfUtils.exist(this.billExecution.getEntityNumber(), (Object)this.billExecution.getBusinessKey());
        if (!targetExist) {
            BizFlowUtil.deleteBizRelationData(commandContext, this.billExecution.getBusinessKey());
        }
    }

    private void endCurrentBillExecution(CommandContext commandContext, Long procinstId, Long currentBillExeId, List<ExeConversionEntity> conversions) {
        ExeConversionEntityManager exeConversionMgr = commandContext.getExeConversionEntityManager();
        ExecutionEntityManager executionMgr = commandContext.getExecutionEntityManager();
        String sourceBillConvertNodeId = WfUtils.isEmptyForCollection(conversions) ? "" : conversions.get(0).getActivityId();
        List<ExecutionEntity> executeExecutions = executionMgr.findExecuteExecutionByBillExecutionIdAndPk(currentBillExeId, this.billExecution.getBusinessKey());
        List tarConversions = exeConversionMgr.findByQueryFilters(new QFilter[]{new QFilter("procinstid", "=", (Object)procinstId).and("srcexecutionid", "=", (Object)this.billExecution.getId())});
        boolean billException = !SCENE_TERMINATE.equals(this.scene);
        boolean deleteExecution = false;
        if (executeExecutions != null && !executeExecutions.isEmpty()) {
            for (ExecutionEntity e : executeExecutions) {
                if (e == null || e.getCurrentFlowElement() == null) {
                    throw new WFException(WFErrorCode.billExceptionError(), String.format(ResManager.loadKDString((String)"\u6570\u636e\u9519\u8bef\uff0c\u6ca1\u6709businesskey\u4e3a%s\u7684\u6267\u884c\u5b9e\u4f8b\u3002", (String)"BillBackOrProcessTerminateCmd_1", (String)"bos-wf-engine", (Object[])new Object[0]), this.billExecution.getBusinessKey()));
                }
                if (e.isActive() || e.isMultiInstanceRoot()) {
                    this.endCurrentTask(commandContext, procinstId, e, sourceBillConvertNodeId.equals(e.getCurrentActivityId()));
                }
                String currentNodeId = e.getCurrentActivityId();
                if (tarConversions.isEmpty() && billException && !currentNodeId.equals(e.getVariableLocal("billExceptionDelayHandle")) && "delete".equals(this.operation)) {
                    deleteExecution = true;
                    executionMgr.delete(e);
                    executionMgr.delete(this.billExecution);
                    logger.debug(String.format("\u5220\u9664\u6267\u884c\u5b9e\u4f8bbillExec:[%s],exec[%s]", this.billExecution.getId(), e.getId()));
                    continue;
                }
                if (currentNodeId.equals(e.getVariableLocal("billExceptionDelayHandle"))) continue;
                e.setActive(false);
                logger.debug(String.format("\u64cd\u4f5c\u4e3a[%s]\u6216\u540e\u7eed\u5b58\u5728\u8f6c\u6362\u8bb0\u5f55\uff0c\u6267\u884c\u5b9e\u4f8bbillExec:[%s],exec[%s]\u7f6e\u4e3a\u975e\u6d3b\u52a8", this.operation, this.billExecution.getId(), e.getId()));
            }
        }
        if (deleteExecution) {
            for (ExeConversionEntity ec : conversions) {
                exeConversionMgr.delete(ec);
                logger.debug(String.format("\u5220\u9664\u8f6c\u6362\u8bb0\u5f55\u539f\u5355%s-%s,\u76ee\u6807\u5355%s-%s", ec.getSrcBusinesskey(), ec.getSrcEntityNumber(), ec.getTagBusinesskey(), ec.getTagEntityNumber()));
            }
        } else if (this.billExecution != null) {
            this.billExecution.setAbortType(1);
            executionMgr.update(this.billExecution);
        }
    }

    private void endCurrentTask(CommandContext commandContext, Long procinstId, ExecutionEntity executeExecution, boolean errorAtCovertNode) {
        ExecutionEntityManager executionMgr = commandContext.getExecutionEntityManager();
        FlowElement currentNode = executeExecution.getCurrentFlowElement();
        String currentNodeId = currentNode.getId();
        Long currentExeId = executeExecution.getId();
        logger.debug(String.format("\u7ed3\u675f\u5f53\u524d\u8282\u70b9%s\uff0cexecuteExecution=%s", currentNodeId, currentExeId));
        if (currentNode instanceof CallActivity) {
            if ("unsubmit".equals(this.operation)) {
                executeExecution.setMultiInstanceRoot(false);
                List<ExecutionEntity> mcExecutions = executionMgr.findChildExecutionsByParentExecutionId(executeExecution.getId());
                if (mcExecutions != null) {
                    for (ExecutionEntity executionEntity : mcExecutions) {
                        logger.debug(String.format("delete callactivity subExecutuion %s", executionEntity.getId()));
                        executionMgr.delete(executionEntity);
                    }
                }
            } else {
                ExecutionEntity executionEntity;
                List<ExecutionEntity> multiProcessExes = executionMgr.findChildExecutionsByParentExecutionId(currentExeId);
                Long subParentExecutionId = null;
                if (multiProcessExes.isEmpty()) {
                    logger.debug(String.format("\u627e\u4e0d\u5230\u8282\u70b9%s\u6267\u884c\u5b9e\u4f8b%s\u7684\u5b50\u6d41\u7a0b\u591a\u5b9e\u4f8b", currentNode.getId(), currentExeId));
                } else {
                    for (ExecutionEntity e : multiProcessExes) {
                        if (!e.getBusinessKey().equals(this.billExecution.getBusinessKey())) continue;
                        subParentExecutionId = e.getId();
                        break;
                    }
                }
                Object var11_13 = null;
                if (subParentExecutionId == null || (executionEntity = executionMgr.findSubProcessInstanceBySuperExecutionId(multiProcessExes.get(0).getId())) == null) {
                    throw new WFException(WFErrorCode.billExceptionError(), String.format(ResManager.loadKDString((String)"\u627e\u4e0d\u5230\u8282\u70b9%1$s\u6267\u884c\u5b9e\u4f8b%2$s\u7684\u5b50\u6d41\u7a0b\u591a\u5b9e\u4f8b\u3002", (String)"BillBackOrProcessTerminateCmd_2", (String)"bos-wf-engine", (Object[])new Object[0]), currentNode.getId(), currentExeId));
                }
                logger.debug(String.format("\u7ec8\u6b62\u5b50\u6d41\u7a0b%s", executionEntity.getProcessInstanceId()));
                new AbandonProcessCmd(executionEntity.getProcessInstanceId(), this.cause, "billExcepAbort", this.params).execute(commandContext);
                executeExecution.setVariableLocal("billExceptionDelayHandle", currentNodeId);
                executeExecution.setVariableLocal("exceptionScense", this.scene);
            }
        } else if (BpmnModelUtil.instanceofUserTask(currentNode.getType())) {
            ExecutionEntity subProcessExe = executionMgr.findSubProcessInstanceBySuperExecutionId(currentExeId);
            if (subProcessExe != null) {
                logger.debug(String.format("\u7ec8\u6b62\u5355\u636e\u5b50\u6d41\u7a0b%s", subProcessExe.getProcessInstanceId()));
                new AbandonProcessCmd(subProcessExe.getProcessInstanceId(), this.cause, "billExcepAbort", this.params).execute(commandContext);
                executeExecution.setVariableLocal("billExceptionDelayHandle", currentNodeId);
                executeExecution.setVariableLocal("exceptionScense", this.scene);
            }
            Long taskId = executeExecution.getCurrentTaskId();
            if (!errorAtCovertNode && WfUtils.isNotEmpty(taskId)) {
                logger.debug(String.format("\u5220\u9664\u4efb\u52a1%s\u548c\u4ee3\u529e", taskId));
                commandContext.getTaskHelper().deleteTask(taskId, "billExcepAbort", false);
                BizFlowUtil.deleteToDoMsg(commandContext, taskId);
            } else {
                logger.debug(String.format("\u8fd9\u79cd\u60c5\u51b5\u4e00\u5b9a\u8981\u8bb0\u5f55!exec:[%s]", executeExecution.getId()));
            }
        } else if ("CompensateTask".equals(currentNode.getType())) {
            CompensationEventHandler handler = (CompensationEventHandler)commandContext.getProcessEngineConfiguration().getEventHandler("compensate");
            HistoricActivityInstanceEntity compenstateTaskActinst = handler.recordActivity(executeExecution, currentNode, commandContext);
            HistoricActivityInstanceEntity historicActivityInstanceEntity = (HistoricActivityInstanceEntity)commandContext.getHistoricActivityInstanceEntityManager().findById(executeExecution.getCurrentActInstId());
            historicActivityInstanceEntity.setTargetElementId(compenstateTaskActinst.getId());
            commandContext.getHistoricActivityInstanceEntityManager().update(historicActivityInstanceEntity);
            executeExecution.setCurrentActInstId(compenstateTaskActinst.getId());
        }
        HistoricActivityInstanceEntity currentActInst = BizFlowUtil.makeEndActInst(commandContext, executeExecution);
        commandContext.getDeadLetterJobEntityManager().deleteByFilters(new QFilter[]{new QFilter("executionId", "=", (Object)currentExeId)});
        if (!errorAtCovertNode) {
            logger.debug("\u5220\u9664job\uff0ctimerjob\uff0c\u4e8b\u4ef6\u8ba2\u9605\uff0c\u5f02\u5e38\u4fe1\u606f\u8868");
            QFilter exeQf = new QFilter("executionId", "=", (Object)currentActInst.getExecutionId());
            QFilter qFilter = new QFilter("elementId", "=", (Object)currentActInst.getActivityId());
            commandContext.getJobEntityManager().deleteByFilters(new QFilter[]{exeQf, qFilter});
            commandContext.getTimerJobEntityManager().deleteByFilters(new QFilter[]{exeQf, qFilter});
            commandContext.getEventSubscriptionEntityManager().deleteByFilters(new QFilter[]{new QFilter("processDefinitionId", "=", (Object)procinstId).and("executionId", "=", (Object)currentExeId).and("activityId", "=", (Object)currentNodeId)});
        }
    }

    protected void executeBillExecutionTerminateListeners(CommandContext commandContext, String eventType) {
        this.saveOperationLog(commandContext);
        Process process = ProcessDefinitionUtil.getProcess(this.billExecution.getProcessDefinitionId(), this.billExecution.getProcessInstanceId());
        commandContext.getProcessEngineConfiguration().getListenerNotificationHelper().executeExecutionListeners(process, this.billExecution, eventType);
    }

    private void saveOperationLog(CommandContext commandContext) {
        OperationLogEntityImpl operationLog = new OperationLogEntityImpl();
        Date date = commandContext.getProcessEngineConfiguration().getClock().getCurrentTime();
        operationLog.setCreateDate(date);
        operationLog.setTaskId(this.billExecution.getCurrentTaskId());
        operationLog.setProcInstId(this.billExecution.getProcessInstanceId());
        operationLog.setType("terminal_f");
        Long userId = RequestContext.get().getCurrUserId();
        operationLog.setOwnerId(userId);
        operationLog.setOwner(WfUtils.findUserName(userId));
        operationLog.setNOpinion(this.cause);
        WfOperationLogUtil.recordOperationLog(commandContext, operationLog);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void recoverSourceTask(CommandContext commandContext, Long procinstId, ExecutionEntityManager executionMgr, Set<Long> srcExecutionIds) {
        HistoricActivityInstanceEntityManager actinstMgr = commandContext.getHistoricActivityInstanceEntityManager();
        TaskEntityManager taskMgr = commandContext.getTaskEntityManager();
        List<ExecutionEntity> executions = executionMgr.findChildExecutionsByProcessInstanceId(procinstId);
        Process process = ProcessDefinitionUtil.getProcessByProcInstId(procinstId);
        for (ExecutionEntity e : executions) {
            Long taskId;
            if (!srcExecutionIds.contains(e.getParentId())) continue;
            String cActivityId = e.getActivityId();
            logger.debug(String.format("exec[%s],activityid:[%s]", e.getId(), cActivityId));
            FlowElement elem = process.getFlowElement(cActivityId);
            BillTask bt = null;
            if (elem instanceof BillTask) {
                bt = (BillTask)elem;
                if (!bt.getEntityNumber().equalsIgnoreCase(this.entityNumber)) {
                    logger.debug(String.format("exec[%s],activityid:[%s] is billtask,but targetentity[%s] is not equals [%s]", e.getId(), cActivityId, bt.getEntityNumber(), this.entityNumber));
                    continue;
                }
            } else {
                logger.debug(String.format("exec[%s],activityid:[%s] is not billtask", e.getId(), cActivityId));
                continue;
            }
            if (!e.isActive()) {
                e.setActive(true);
                executionMgr.update(e);
                executionMgr.update(e.getParent());
                logger.debug(String.format("\u6fc0\u6d3b\u5355\u636e\u65f6%s,\u6267\u884c\u5b9e\u4f8b%s", e.getId(), e.getParentId()));
                HistoricActivityInstanceEntity hiActInst = (HistoricActivityInstanceEntity)actinstMgr.findById(e.getCurrentActInstId());
                if (BpmnModelUtil.instanceofSequenceFlow(hiActInst.getActivityType())) {
                    HistoricActivityInstanceEntity newActInst = commandContext.getHistoryManager().createHistoricActivityInstanceEntity(e);
                    Long newId = newActInst.getId();
                    e.setCurrentActInstId(newId);
                    e.getParent().setCurrentActInstId(newId);
                    hiActInst.setTargetElementId(newId);
                    actinstMgr.update(hiActInst);
                } else {
                    hiActInst.setEndTime(null);
                    hiActInst.setDurationInMillis(0L);
                    hiActInst.setRealDurationInMillis(0L);
                    hiActInst.setTargetElementId(null);
                    actinstMgr.update(hiActInst);
                    logger.debug(String.format("\u6062\u590d\u6d3b\u52a8\u5b9e\u4f8b%s=%s", hiActInst.getId(), hiActInst.getActivityId()));
                }
            }
            if (WfUtils.isNotEmpty(taskId = e.getCurrentTaskId())) {
                boolean noConverteTask;
                boolean bl = noConverteTask = taskMgr.findById(taskId) == null && WfUtils.isEmpty(WfCacheHelper.getBillExceptionCreateTaskCache(String.valueOf(taskId)));
                if (noConverteTask) {
                    try {
                        try (DLock lock = DLock.create((String)String.format("wf/billExceptionCreateTask/%s", taskId), (String)ResManager.loadKDString((String)"\u521b\u5efa\u8865\u507f\u4efb\u52a1", (String)"BillBackOrProcessTerminateCmd_3", (String)"bos-wf-engine", (Object[])new Object[0])).fastMode();){
                            if (lock.tryLock(60000L)) {
                                boolean bl2 = noConverteTask = taskMgr.findById(taskId) == null && WfUtils.isEmpty(WfCacheHelper.getBillExceptionCreateTaskCache(String.valueOf(taskId)));
                                if (noConverteTask) {
                                    WfCacheHelper.putBillExceptionCreateTaskCache(String.valueOf(taskId), String.valueOf(taskId));
                                    logger.debug(String.format("\u6062\u590d\u4efb\u52a1%s", taskId));
                                    HistoricTaskInstanceEntity historicTask = (HistoricTaskInstanceEntity)commandContext.getHistoricTaskInstanceEntityManager().findById(taskId);
                                    historicTask.setEndTime(null);
                                    historicTask.setDurationInMillis(0L);
                                    historicTask.setRealDurationInMillis(0L);
                                    historicTask.setHandleState("unConverted");
                                    TaskEntity task = taskMgr.recoverTask(historicTask);
                                    taskMgr.changeTaskAssignee(task, null, null);
                                    if (bt.isAllowSendTodo()) {
                                        commandContext.getMessageService().deleteDealToDoAndCreateToDo(task.getId());
                                    }
                                }
                            }
                        }
                        commandContext.addCloseListener(new DefaultCommandContextCloseListener("recoverBillExceptionTask", taskId){
                            final /* synthetic */ Long val$taskId;
                            {
                                this.val$taskId = l;
                                super(aim);
                            }

                            @Override
                            public void closed(CommandContext commandContext) {
                                super.closed(commandContext);
                                WfCacheHelper.removeBillExceptionCreateTaskCache(String.valueOf(this.val$taskId));
                            }

                            @Override
                            public void closeFailure(CommandContext commandContext) {
                                super.closeFailure(commandContext);
                                WfCacheHelper.removeBillExceptionCreateTaskCache(String.valueOf(this.val$taskId));
                            }
                        });
                        continue;
                    }
                    catch (Throwable throwable) {
                        commandContext.addCloseListener(new /* invalid duplicate definition of identical inner class */);
                        throw throwable;
                    }
                }
                logger.debug(String.format("task %s is recovered by others", taskId));
                continue;
            }
            this.createConvertTask(commandContext, e, bt);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void createConvertTask(CommandContext commandContext, ExecutionEntity e, BillTask bt) {
        String activityId;
        String businesskey;
        boolean noConverteTask;
        Long taskId = 0L;
        ParticipantCalculator participantCalculator = Context.getProcessEngineConfiguration().getParticipantCalculator();
        HistoricActivityInstanceEntityManager actinstMgr = commandContext.getHistoricActivityInstanceEntityManager();
        TaskEntityManager taskMgr = commandContext.getTaskEntityManager();
        boolean bl = noConverteTask = taskMgr.findTaskIdByBusinessKeyAndNodeId(businesskey = e.getBusinessKey(), activityId = bt.getId()).isEmpty() && WfUtils.isEmpty(WfCacheHelper.getBillExceptionCreateTaskCache(businesskey));
        if (noConverteTask) {
            try {
                try (DLock lock = DLock.create((String)String.format("wf/billExceptionCreateTask/%s", businesskey), (String)ResManager.loadKDString((String)"\u521b\u5efa\u8865\u507f\u4efb\u52a1", (String)"BillBackOrProcessTerminateCmd_3", (String)"bos-wf-engine", (Object[])new Object[0])).fastMode();){
                    if (lock.tryLock(60000L)) {
                        if (taskMgr.findTaskIdByBusinessKeyAndNodeId(businesskey, activityId).isEmpty() && WfUtils.isEmpty(WfCacheHelper.getBillExceptionCreateTaskCache(businesskey))) {
                            taskId = ORM.create().genLongId("wf_task");
                            WfCacheHelper.putBillExceptionCreateTaskCache(businesskey, String.valueOf(taskId));
                            TaskEntity task = TaskBehaviorUtil.buildTaskEntity(e, bt);
                            task.setId(taskId);
                            commandContext.getTaskEntityManager().changeTaskExecutionType(task, "manualpush");
                            String cbk = e.getBusinessKey();
                            List<Long> userIds = participantCalculator.getUserIds(e.getProcessInstanceId(), activityId, cbk, e, true);
                            task.setSubject(TaskBehaviorUtil.getTaskSubject(bt, task, cbk, e.getEntityNumber()));
                            task.setHandleState("unConverted");
                            task.setBizTraceNo(e.getBizTraceNo());
                            if (!userIds.isEmpty()) {
                                e.setCurrentTask(task);
                                taskMgr.insert(task, e);
                                e.setCurrentTaskId(taskId);
                                task.addUserIdentityLinks(userIds, "participant");
                                if (bt.isAllowSendTodo()) {
                                    commandContext.getMessageService().createToDo(taskId);
                                }
                                HistoricActivityInstanceEntity hiActInst = (HistoricActivityInstanceEntity)actinstMgr.findById(e.getCurrentActInstId());
                                hiActInst.setTaskId(e.getCurrentTaskId());
                                actinstMgr.update(hiActInst);
                                commandContext.getProcessEngineConfiguration().getListenerNotificationHelper().executeAfterTaskListeners(task, "afterCreate");
                            }
                            logger.debug(String.format("\u751f\u6210\u8282\u70b9%s\u7684\u4efb\u52a1%s\uff0c\u53c2\u4e0e\u4eba%s", task.getTaskDefinitionKey(), task.getId(), WfUtils.listToString(userIds, ",")));
                        } else {
                            logger.debug(String.format("\u8282\u70b9%s\u5355\u636e%s\u5df2\u7ecf\u88ab\u5176\u4ed6\u4f8b\u5916\u751f\u6210\u4e86\u4efb\u52a1", activityId, businesskey));
                        }
                    } else {
                        logger.debug(String.format("\u5355\u636e\u5b9e\u4f8b%s,\u76ee\u6807\u5355 %s \u4f8b\u5916\u751f\u6210\u8282\u70b9%s,\u539f\u5355%s\u4efb\u52a1\u65f6\u672a\u83b7\u53d6\u5230\u9501", this.billExecution.getId(), this.billExecution.getBusinessKey(), activityId, businesskey));
                    }
                }
                commandContext.addCloseListener(new DefaultCommandContextCloseListener("createBillExceptionTask", businesskey){
                    final /* synthetic */ String val$businesskey;
                    {
                        this.val$businesskey = string;
                        super(aim);
                    }

                    @Override
                    public void closed(CommandContext commandContext) {
                        super.closed(commandContext);
                        WfCacheHelper.removeBillExceptionCreateTaskCache(this.val$businesskey);
                    }

                    @Override
                    public void closeFailure(CommandContext commandContext) {
                        super.closeFailure(commandContext);
                        WfCacheHelper.removeBillExceptionCreateTaskCache(this.val$businesskey);
                    }
                });
            }
            catch (Throwable throwable) {
                commandContext.addCloseListener(new /* invalid duplicate definition of identical inner class */);
                throw throwable;
            }
        }
    }
}

