/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.workflow.engine.impl.cmd.management;

import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import kd.bos.context.RequestContext;
import kd.bos.dataentity.entity.ILocaleString;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.resource.promptenum.MultiLangEnumBridge;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.workflow.bpmn.model.CallActivity;
import kd.bos.workflow.bpmn.model.FlowNode;
import kd.bos.workflow.bpmn.model.Process;
import kd.bos.workflow.bpmn.model.UserTask;
import kd.bos.workflow.domain.model.NodeForkJoinModel;
import kd.bos.workflow.engine.WfUtils;
import kd.bos.workflow.engine.impl.cmd.management.GetJumpNodesCmd;
import kd.bos.workflow.engine.impl.cmd.management.JumpToNodeCmd;
import kd.bos.workflow.engine.impl.cmd.task.JudgeForkTaskCanRejectCmd;
import kd.bos.workflow.engine.impl.cmd.task.SkipTaskAndContinueCmd;
import kd.bos.workflow.engine.impl.interceptor.CommandContext;
import kd.bos.workflow.engine.impl.persistence.entity.management.ManagementConstants;
import kd.bos.workflow.engine.impl.persistence.entity.operationlog.OperationLogEntityImpl;
import kd.bos.workflow.engine.impl.persistence.entity.runtime.ExecutionEntity;
import kd.bos.workflow.engine.impl.persistence.entity.runtime.ExecutionEntityManager;
import kd.bos.workflow.engine.impl.util.BpmnModelUtil;
import kd.bos.workflow.engine.impl.util.ProcessDefinitionUtil;
import kd.bos.workflow.engine.impl.util.WfOperationLogUtil;
import kd.bos.workflow.engine.task.center.ForkNodeRejectListener;
import kd.bos.workflow.exception.WFEngineException;
import kd.bos.workflow.exception.WFIllegalArgumentException;

public class BillWithdrawJumpToUserNodeCmd
extends JumpToNodeCmd {
    private static Log log = LogFactory.getLog(BillWithdrawJumpToUserNodeCmd.class);

    public BillWithdrawJumpToUserNodeCmd(Long proInstanceId) {
        super(proInstanceId, null, null, false);
    }

    public BillWithdrawJumpToUserNodeCmd(Long proInstanceId, boolean isSuspend) {
        super(proInstanceId, null, null, isSuspend);
    }

    @Override
    public Void execute(CommandContext commandContext) {
        ExecutionEntityManager executionEntityManager = commandContext.getExecutionEntityManager();
        ExecutionEntity procInst = executionEntityManager.findProcessInstanceById(this.proinstanceId);
        if (WfUtils.isEmpty(this.proinstanceId) || procInst == null) {
            throw new WFIllegalArgumentException(String.format(ResManager.loadKDString((String)"\u201c%s\u201d\u5f53\u524d\u6d41\u7a0b\u5b9e\u4f8b\u4e0d\u5b58\u5728\u3002", (String)"BillWithdrawJumpToUserNodeCmd_1", (String)"bos-wf-engine", (Object[])new Object[0]), this.getErrorMessagePrefix()));
        }
        if (this.isSuspend || ManagementConstants.SUSPENDED.getStateCode().equals(procInst.getSuspensionState())) {
            throw new WFEngineException(String.format(ResManager.loadKDString((String)"\u201c%s\u201d\u5f53\u524d\u6d41\u7a0b\u5df2\u6302\u8d77\uff0c\u8bf7\u8054\u7cfb\u7ba1\u7406\u5458\u68c0\u67e5\u6d41\u7a0b\u3002", (String)"BillWithdrawJumpToUserNodeCmd_6", (String)"bos-wf-engine", (Object[])new Object[0]), this.getErrorMessagePrefix()));
        }
        Process process = ProcessDefinitionUtil.getProcess(procInst.getProcessDefinitionId(), this.proinstanceId);
        UserTask firstUserTask = BpmnModelUtil.getFirstUserTask(process);
        this.destNodeId = firstUserTask.getId();
        Object jumpNodes = new GetJumpNodesCmd(this.proinstanceId).execute(commandContext);
        List<String> srcNodeIds = this.getSrcNodeIds((List<Map<String, Object>>)jumpNodes);
        if (WfUtils.isEmpty(this.destNodeId) || WfUtils.isEmptyForCollection(srcNodeIds)) {
            throw new WFIllegalArgumentException(String.format(ResManager.loadKDString((String)"\u201c%s\u201d\u76ee\u6807\u8282\u70b9\u4e3a\u7a7a\u6216\u8005\u6240\u6709\u7684\u5f53\u524d\u8282\u70b9\u90fd\u65e0\u6cd5\u8df3\u8f6c\u79bb\u5f00\u3002", (String)"BillWithdrawJumpToUserNodeCmd_2", (String)"bos-wf-engine", (Object[])new Object[0]), this.getErrorMessagePrefix()));
        }
        List<ExecutionEntity> executionList = executionEntityManager.findChildExecutionsByProcessInstanceId(this.proinstanceId);
        ExecutionEntity destExecution = null;
        for (int i = 0; i < srcNodeIds.size(); ++i) {
            boolean isLastNode;
            String curNodeId = srcNodeIds.get(i);
            ExecutionEntity curExecution = this.getDestExecution(executionList, curNodeId);
            boolean bl = isLastNode = i == srcNodeIds.size() - 1;
            if (!this.canWithdrawJump(commandContext, process, curNodeId, curExecution, isLastNode)) continue;
            this.srcNodeId = curNodeId;
            destExecution = curExecution;
            break;
        }
        if (WfUtils.isEmpty(this.srcNodeId) || destExecution == null) {
            throw new WFIllegalArgumentException(String.format(ResManager.loadKDString((String)"\u201c%s\u201d\u5f53\u524d\u8282\u70b9\u6216\u8005\u5f53\u524d\u6267\u884c\u5b9e\u4f8b\u4e0d\u80fd\u4e3a\u7a7a\u3002", (String)"BillWithdrawJumpToUserNodeCmd_9", (String)"bos-wf-engine", (Object[])new Object[0]), this.getErrorMessagePrefix()));
        }
        log.debug(String.format("\u6574\u5355\u64a4\u56de\u65f6\u5f3a\u5236\u8df3\u8f6c\u81f3\u4eba\u5de5\u8282\u70b9\u3002\u6d41\u7a0b\u5b9e\u4f8bid[%s]\uff0c\u6e90\u8282\u70b9[%s]\uff0c\u76ee\u6807\u8282\u70b9[%s]", this.proinstanceId, this.srcNodeId, this.destNodeId));
        ForkNodeRejectListener.markOtherBranchsEnd(commandContext, destExecution, this.proinstanceId, this.srcNodeId, this.destNodeId, "", "jump");
        String lastUserDealNode = (String)destExecution.getVariableLocal("lastUserDealNode");
        if (WfUtils.isNotEmpty(lastUserDealNode) && "start".equals(lastUserDealNode)) {
            destExecution.setVariableLocal("lastUserDealNode", "jump");
        }
        HashMap<String, Object> variables = new HashMap<String, Object>();
        variables.put("dynType", "billWithdrawJump");
        variables.put("nextNodeId", this.destNodeId);
        variables.put("dynparticipantdynjump", this.destNodeId);
        this.saveOperationLog(commandContext, destExecution);
        new SkipTaskAndContinueCmd(destExecution, Long.valueOf(RequestContext.get().getUserId()), variables, this.isSuspend).execute(commandContext);
        WfUtils.addOpLog("wf_execution", "billWithdrawJump", new MultiLangEnumBridge("\u6574\u5355\u64a4\u56de\u5f3a\u5236\u8df3\u8f6c\u81f3\u4eba\u5de5", "BillWithdrawJumpToUserNodeCmd_3", "bos-wf-engine"), new MultiLangEnumBridge("\u6d41\u7a0b\u5b9e\u4f8bID\u201c%1$s\u201d\uff0c\u539f\u8282\u70b9ID\u201c%2$s\u201d\uff0c\u76ee\u6807\u8282\u70b9ID\u201c%3$s\u201d\u3002", "BillWithdrawJumpToUserNodeCmd_4", "bos-wf-engine"), this.proinstanceId, this.srcNodeId, this.destNodeId);
        return null;
    }

    private List<String> getSrcNodeIds(List<Map<String, Object>> jumpNodes) {
        ArrayList<String> srcNodeIds = new ArrayList<String>(jumpNodes.size());
        for (Map<String, Object> node : jumpNodes) {
            srcNodeIds.add((String)node.get("value"));
        }
        return srcNodeIds;
    }

    private ExecutionEntity getDestExecution(List<ExecutionEntity> executionList, String curNodeId) {
        ExecutionEntity destExecution = null;
        if (WfUtils.isNotEmptyForCollection(executionList) && WfUtils.isNotEmpty(curNodeId)) {
            for (ExecutionEntity executionEntity : executionList) {
                if (!executionEntity.isActive() && executionEntity.getCurrentFlowElement() instanceof CallActivity || !curNodeId.equalsIgnoreCase(executionEntity.getActivityId())) continue;
                if (destExecution == null && executionEntity.getParent() != null && executionEntity.isActive()) {
                    destExecution = executionEntity;
                }
                if (!executionEntity.isMultiInstanceRoot() || executionEntity.equals(destExecution)) continue;
                destExecution = executionEntity;
            }
        }
        return destExecution;
    }

    private boolean canWithdrawJump(CommandContext commandContext, Process process, String curNodeId, ExecutionEntity destExecution, boolean isLastNode) {
        Map<String, NodeForkJoinModel> models;
        if (destExecution == null || WfUtils.isEmpty(curNodeId)) {
            if (isLastNode) {
                throw new WFEngineException(String.format(ResManager.loadKDString((String)"\u201c%s\u201d\u5f53\u524d\u8282\u70b9ID\u6216\u5f53\u524d\u8282\u70b9\u7684\u6267\u884c\u5b9e\u4f8b\u4e0d\u80fd\u4e3a\u7a7a\u3002", (String)"BillWithdrawJumpToUserNodeCmd_5", (String)"bos-wf-engine", (Object[])new Object[0]), this.getErrorMessagePrefix()));
            }
            return false;
        }
        FlowNode flowNode = (FlowNode)process.getFlowElement(curNodeId);
        if (flowNode != null && flowNode.getJoin() != null && flowNode.getJoin().booleanValue() && "enterwhenallarrive".equals(flowNode.getInSet()) && WfUtils.isEmpty(destExecution.getCurrentTaskId())) {
            if (isLastNode) {
                throw new WFIllegalArgumentException(String.format(ResManager.loadKDString((String)"\u201c%s\u201d\u5f53\u524d\u6c47\u805a\u8282\u70b9\u6ca1\u6709\u751f\u6210\u4efb\u52a1\u3002", (String)"BillWithdrawJumpToUserNodeCmd_7", (String)"bos-wf-engine", (Object[])new Object[0]), this.getErrorMessagePrefix()));
            }
            return false;
        }
        if (new JudgeForkTaskCanRejectCmd(destExecution.getProcessInstanceId(), curNodeId).execute(commandContext).booleanValue() && ((models = process.getForkJoinModels()).get(curNodeId) == null || models.get(this.destNodeId) == null || !models.get(curNodeId).getForkStructure().equals(models.get(this.destNodeId).getForkStructure()))) {
            if (isLastNode) {
                throw new WFIllegalArgumentException(String.format(ResManager.loadKDString((String)"\u201c%s\u201d\u5f53\u524d\u5206\u652f\u8282\u70b9\u65e0\u6cd5\u8df3\u8f6c\u79bb\u5f00\uff0c\u5df2\u6709\u5176\u4ed6\u5206\u652f\u9a73\u56de\u81f3\u4e3b\u5e72\uff0c\u5176\u4ed6\u5206\u652f\u56de\u5230\u5206\u652f\u5185\u540e\u624d\u80fd\u8df3\u8f6c\u81f3\u4e3b\u5e72\u3002", (String)"BillWithdrawJumpToUserNodeCmd_8", (String)"bos-wf-engine", (Object[])new Object[0]), this.getErrorMessagePrefix()));
            }
            return false;
        }
        return true;
    }

    @Override
    protected void saveOperationLog(CommandContext commandContext, ExecutionEntity execution) {
        OperationLogEntityImpl operationLog = new OperationLogEntityImpl();
        Date date = commandContext.getProcessEngineConfiguration().getClock().getCurrentTime();
        operationLog.setCreateDate(date);
        Long taskId = execution.getCurrentTaskId();
        if (WfUtils.isNotEmpty(taskId)) {
            operationLog.setTaskId(taskId);
        } else {
            operationLog.setActivityId(execution.getActivityId());
            operationLog.setActivityName(execution.getActivityName());
        }
        operationLog.setProcInstId(this.proinstanceId);
        operationLog.setType("billWithdraw");
        Long userId = Long.parseLong(RequestContext.get().getUserId());
        operationLog.setOwnerId(userId);
        operationLog.setOwner(WfUtils.findUserName(userId));
        operationLog.setNOpinion((ILocaleString)ResManager.getLocaleString((String)"\u6574\u5355\u64a4\u56de\u5f3a\u5236\u8df3\u8f6c\u81f3\u4eba\u5de5", (String)"BillWithdrawJumpToUserNodeCmd_3", (String)"bos-wf-engine"));
        WfOperationLogUtil.recordOperationLog(commandContext, operationLog);
    }

    private String getErrorMessagePrefix() {
        return ResManager.loadKDString((String)"\u65e0\u6cd5\u5b9e\u73b0\u6574\u5355\u64a4\u56de\u65f6\u4ece\u5f53\u524d\u8282\u70b9\u5f3a\u5236\u8df3\u8f6c\u81f3\u4eba\u5de5\u8282\u70b9\u3002\u539f\u56e0\uff1a", (String)"BillWithdrawJumpToUserNodeCmd_0", (String)"bos-wf-engine", (Object[])new Object[0]);
    }
}

