/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.workflow.engine.impl.cmd.management;

import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONArray;
import com.alibaba.fastjson.JSONObject;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import kd.bos.dataentity.entity.ILocaleString;
import kd.bos.metadata.domainmodel.DomainModelType;
import kd.bos.metadata.domainmodel.ElementType;
import kd.bos.workflow.bpmn.graph.codec.GraphCodecUtils;
import kd.bos.workflow.engine.impl.interceptor.Command;
import kd.bos.workflow.engine.impl.interceptor.CommandContext;
import kd.bos.workflow.engine.impl.persistence.entity.design.ModelType;
import kd.bos.workflow.engine.impl.persistence.entity.design.ResourceEntity;
import kd.bos.workflow.engine.impl.persistence.entity.management.DynamicConfigSchemeEntity;
import kd.bos.workflow.engine.impl.persistence.entity.management.ProcessInfoDetailEntity;
import kd.bos.workflow.engine.impl.persistence.entity.management.ProcessInfoDetailEntityImpl;
import kd.bos.workflow.engine.impl.persistence.entity.management.ProcessInfoEntity;
import kd.bos.workflow.engine.impl.persistence.entity.management.ProcessInfoEntityManager;
import kd.bos.workflow.engine.impl.util.BpmnModelUtil;

public class CreateProcessInfoEntityCmd
implements Command<Void> {
    private ResourceEntity resource;
    private DynamicConfigSchemeEntity scheme;
    private Map<String, ElementType> elementTypeMap = new HashMap<String, ElementType>();

    public CreateProcessInfoEntityCmd() {
        this.initElementTypeMap();
    }

    public CreateProcessInfoEntityCmd(ResourceEntity resource, DynamicConfigSchemeEntity scheme) {
        this();
        this.resource = resource;
        this.scheme = scheme;
    }

    @Override
    public Void execute(CommandContext commandContext) {
        ProcessInfoEntityManager processInfoManager = commandContext.getProcessInfoEntityManager();
        ProcessInfoEntity processInfo = (ProcessInfoEntity)processInfoManager.create();
        processInfo.setProcdefId(this.scheme.getProcDefId());
        processInfo.setSchemeId(this.scheme.getId());
        processInfo.setIsDefaultScheme(this.scheme.isAcquiescence());
        processInfo.setResourceId(this.scheme.getJsonResourceId());
        this.createProcessInfo(commandContext, processInfo, this.resource);
        return null;
    }

    protected void createProcessInfo(CommandContext commandContext, ProcessInfoEntity processInfo, ResourceEntity resource) {
        JSONObject model = JSON.parseObject((String)resource.getData());
        JSONObject multiLangDatas = BpmnModelUtil.getMultiLangDatasFromResource(resource);
        this.initProcessInfo(processInfo, model, multiLangDatas);
        commandContext.getProcessInfoEntityManager().insert(processInfo);
    }

    private void initElementTypeMap() {
        String extModel;
        DomainModelType domainModelType = GraphCodecUtils.getDomainType("WorkflowModel");
        if (domainModelType != null) {
            this.elementTypeMap.putAll(domainModelType.getElementTypes());
        }
        if ((domainModelType = GraphCodecUtils.getDomainType("BizFlowModel")) != null) {
            this.elementTypeMap.putAll(domainModelType.getElementTypes());
        }
        if ((extModel = GraphCodecUtils.getExtendedModel("WorkflowModel")) != null) {
            String[] modelIds;
            for (String modelId : modelIds = extModel.split(";")) {
                domainModelType = GraphCodecUtils.getDomainType(modelId);
                if (domainModelType == null) continue;
                this.elementTypeMap.putAll(domainModelType.getElementTypes());
            }
        }
    }

    private ProcessInfoEntity initProcessInfo(ProcessInfoEntity processInfo, JSONObject model, JSONObject multiLangDatas) {
        JSONObject properties = model.getJSONObject("properties");
        String processType = properties.getString("processType");
        if (processType == null) {
            processType = ModelType.AuditFlow.name();
        }
        processInfo.setProcessType(processType);
        processInfo.setOrgId(properties.getLong("orgUnitId"));
        processInfo.setEntityId(properties.getString("entraBillId"));
        List<ProcessInfoDetailEntity> details = this.initProcessInfoDetails(model, multiLangDatas);
        processInfo.setDetails(details);
        return processInfo;
    }

    private List<ProcessInfoDetailEntity> initProcessInfoDetails(JSONObject model, JSONObject multiLangDatas) {
        JSONArray children = model.getJSONArray("childShapes");
        int size = children.size();
        ArrayList<ProcessInfoDetailEntity> details = new ArrayList<ProcessInfoDetailEntity>(size);
        for (int i = 0; i < size; ++i) {
            JSONObject child = children.getJSONObject(i);
            details.add(this.initElementInfo(child, multiLangDatas));
        }
        return details;
    }

    private ProcessInfoDetailEntity initElementInfo(JSONObject child, JSONObject multiLangDatas) {
        ProcessInfoDetailEntityImpl entity = new ProcessInfoDetailEntityImpl();
        JSONObject properties = child.getJSONObject("properties");
        String activityId = properties.getString("itemId");
        entity.setActivityId(activityId);
        entity.setActivityNumber(properties.getString("number"));
        String multiKey = BpmnModelUtil.getActivityNameMultiKey(activityId);
        ILocaleString activityName = BpmnModelUtil.getMultiLangFieldValue(multiLangDatas, multiKey, properties.getString("name"));
        entity.setActivityName(activityName);
        JSONObject stencil = child.getJSONObject("stencil");
        String type = stencil.getString("id");
        entity.setActivityType(type);
        entity.setActivityTypeName(this.getElementTypeName(type));
        String entityId = properties.getString("entityId");
        entity.setActivityEntityId(entityId);
        Long templateId = properties.getLong("templateId");
        entity.setActivityTemplateId(templateId);
        return entity;
    }

    private ILocaleString getElementTypeName(String type) {
        ElementType elementType = this.elementTypeMap.get(type);
        return elementType.getName();
    }
}

