/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.workflow.engine.impl.cmd.management;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import kd.bos.context.RequestContext;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.resource.promptenum.MultiLangEnumBridge;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.workflow.engine.WfAdminUtil;
import kd.bos.workflow.engine.WfConfigurationUtil;
import kd.bos.workflow.engine.WfUtils;
import kd.bos.workflow.engine.impl.interceptor.Command;
import kd.bos.workflow.engine.impl.interceptor.CommandContext;
import kd.bos.workflow.engine.impl.interceptor.CommandContextCloseListener;
import kd.bos.workflow.engine.impl.persistence.entity.management.ProcessDefinitionEntity;

public class DisableOtherProcessCmd
implements Command<Void>,
Serializable {
    private static final long serialVersionUID = 1L;
    private Log log = LogFactory.getLog(this.getClass());
    private ProcessDefinitionEntity processDefinition;

    public DisableOtherProcessCmd(ProcessDefinitionEntity processDefinition) {
        this.processDefinition = processDefinition;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Void execute(CommandContext commandContext) {
        try {
            Object orgs;
            commandContext.addAttribute("env", "publish");
            List<Object> otherProcessId = new ArrayList();
            if (WfConfigurationUtil.isFilterDataByOrg()) {
                Map<String, Object> orgMap = WfAdminUtil.getWfAdminCache(RequestContext.get().getUserId());
                orgs = null;
                if (orgMap != null) {
                    orgs = (String)orgMap.get("withSubordinateByConf");
                }
                otherProcessId = commandContext.getProcessDefinitionEntityManager().findOtherProcessEnableByEntrabillidAndOrg(this.processDefinition.getEntraBillId(), (String)orgs);
            } else {
                otherProcessId = commandContext.getProcessDefinitionEntityManager().findOtherProcessEnableByEntrabillid(this.processDefinition.getEntraBillId());
            }
            if (otherProcessId != null && !otherProcessId.isEmpty()) {
                Long alreadyDisabledProcDefId = (Long)commandContext.getAttribute("alreadyDisabledId");
                if (alreadyDisabledProcDefId != null) {
                    otherProcessId.remove(String.valueOf(alreadyDisabledProcDefId));
                    this.log.debug(String.format("%s already disabed, remove.", alreadyDisabledProcDefId));
                }
                if (otherProcessId.isEmpty()) {
                    this.log.debug("otherProcessIds is empty!");
                    orgs = null;
                    return orgs;
                }
                for (String string : otherProcessId) {
                    commandContext.getProcessEngineConfiguration().getRepositoryService().suspendProcessDefinitionById(WfUtils.normalizeId(string));
                }
                final String otherProcessIdStr = otherProcessId.toString();
                commandContext.addCloseListener(new CommandContextCloseListener(){

                    @Override
                    public void closing(CommandContext commandContext) {
                    }

                    @Override
                    public void closed(CommandContext commandContext) {
                        String str = WfUtils.isEmpty(DisableOtherProcessCmd.this.processDefinition.getId()) ? "" : String.format(ResManager.loadKDString((String)"\u6d41\u7a0b\u5b9a\u4e49ID: %s ", (String)"DisableOtherProcessCmd_1", (String)"bos-wf-engine", (Object[])new Object[0]), DisableOtherProcessCmd.this.processDefinition.getId());
                        String appType = "wf";
                        if ("BizFlow".equals(DisableOtherProcessCmd.this.processDefinition.getType())) {
                            appType = "bpm";
                        }
                        WfUtils.addOpLogByAppType(appType, "wf_processdefinition", "bardisable", new MultiLangEnumBridge("\u7981\u7528\u6d41\u7a0b", "WFMultiLangConstants_24", "bos-wf-engine"), new MultiLangEnumBridge("%1$s\u7f16\u7801\uff1a%2$s\uff0c\u7248\u672c\uff1a%3$s\uff0c\u7981\u7528\u5176\u4ed6\u6d41\u7a0b\uff1a%4$s\u3002", "DisableOtherProcessCmd_2", "bos-wf-engine"), str, DisableOtherProcessCmd.this.processDefinition.getKey(), DisableOtherProcessCmd.this.processDefinition.getVersion(), otherProcessIdStr);
                    }

                    @Override
                    public void closeFailure(CommandContext commandContext) {
                    }

                    @Override
                    public void afterSessionsFlush(CommandContext commandContext) {
                    }
                });
            }
        }
        finally {
            commandContext.removeAttribute("env");
        }
        return null;
    }
}

