/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.workflow.engine.impl.cmd.management;

import java.util.HashMap;
import java.util.List;
import kd.bos.context.RequestContext;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.workflow.engine.TaskService;
import kd.bos.workflow.engine.WfUtils;
import kd.bos.workflow.engine.impl.interceptor.Command;
import kd.bos.workflow.engine.impl.interceptor.CommandContext;
import kd.bos.workflow.engine.impl.jobexecutor.JobUtil;
import kd.bos.workflow.engine.impl.persistence.entity.management.ManagementConstants;
import kd.bos.workflow.engine.impl.persistence.entity.runtime.ExecutionEntity;
import kd.bos.workflow.engine.impl.util.RuntimeUtil;
import kd.bos.workflow.exception.WFEngineException;
import kd.bos.workflow.exception.WFIllegalArgumentException;

public class ExpireSkipCmd
implements Command<Void> {
    protected static Log logger = LogFactory.getLog(ExpireSkipCmd.class);
    private Long proInstanceId;

    public ExpireSkipCmd(Long proInstanceId) {
        this.proInstanceId = proInstanceId;
    }

    @Override
    public Void execute(CommandContext commandContext) {
        if (WfUtils.isEmpty(this.proInstanceId)) {
            if (JobUtil.isInJobThread()) {
                logger.warn(String.format("processInstanceId[%s] is null", this.proInstanceId));
                return null;
            }
            throw new WFIllegalArgumentException(ResManager.loadKDString((String)"\u6d41\u7a0b\u5b9e\u4f8b\u4e3a\u7a7a\uff0c\u65e0\u6cd5\u5904\u7406\u3002", (String)"ExpireSkipCmd_1", (String)"bos-wf-engine", (Object[])new Object[0]));
        }
        ExecutionEntity destExecution = this.getDestExecution(commandContext);
        if (destExecution == null) {
            if (JobUtil.isInJobThread()) {
                logger.warn(String.format("processInstanceId[%s] cannot find execution,may be it is finished!", this.proInstanceId));
                return null;
            }
            throw new WFEngineException(ResManager.loadKDString((String)"\u65e0\u6cd5\u627e\u5230\u53ef\u5904\u7406\u7684\u6267\u884c\u5b9e\u4f8b\u3002", (String)"ExpireSkipCmd_2", (String)"bos-wf-engine", (Object[])new Object[0]));
        }
        if (RuntimeUtil.isRunning(commandContext, destExecution.getBusinessKey())) {
            throw new WFEngineException(ResManager.loadKDString((String)"\u5f53\u524d\u6267\u884c\u5b9e\u4f8b\u6b63\u5728\u6d41\u8f6c\uff0c\u65e0\u6cd5\u8df3\u8fc7\u3002", (String)"ExpireSkipCmd_3", (String)"bos-wf-engine", (Object[])new Object[0]));
        }
        this.skipTaskAndContinue(commandContext, destExecution);
        return null;
    }

    private ExecutionEntity getDestExecution(CommandContext commandContext) {
        List<ExecutionEntity> executionList = commandContext.getExecutionEntityManager().findChildExecutionsByProcessInstanceId(this.proInstanceId);
        ExecutionEntity destExecution = null;
        if (executionList != null) {
            for (ExecutionEntity executionEntity : executionList) {
                if (destExecution == null && executionEntity.getParent() != null) {
                    destExecution = executionEntity;
                }
                if (!executionEntity.isMultiInstanceRoot() || executionEntity.equals(destExecution)) continue;
                destExecution = executionEntity;
            }
        }
        return destExecution;
    }

    private void skipTaskAndContinue(CommandContext commandContext, ExecutionEntity destExecution) {
        HashMap<String, Object> variables = new HashMap<String, Object>();
        variables.put("dynType", "expireSkip");
        TaskService taskService = commandContext.getProcessEngineConfiguration().getTaskService();
        Long curUserId = Long.valueOf(RequestContext.get().getUserId());
        String suspensionState = destExecution.getProcessInstance().getSuspensionState();
        taskService.skipTaskAndContinue(destExecution, curUserId, variables, ManagementConstants.SUSPENDED.getStateCode().equals(suspensionState));
    }
}

