/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.workflow.engine.impl.cmd.management;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import kd.bos.algo.DataSet;
import kd.bos.algo.Row;
import kd.bos.db.DB;
import kd.bos.db.DBRoute;
import kd.bos.orm.query.QFilter;
import kd.bos.workflow.engine.WfUtils;
import kd.bos.workflow.engine.impl.db.EntityQueryBuilder;
import kd.bos.workflow.engine.impl.interceptor.Command;
import kd.bos.workflow.engine.impl.interceptor.CommandContext;
import kd.bos.workflow.engine.impl.persistence.entity.design.ModelType;
import kd.bos.workflow.engine.impl.persistence.entity.design.ProcessCategoryEntity;
import kd.bos.workflow.engine.impl.persistence.entity.design.ProcessCategoryEntityManager;

public class FindChildrenProcessCategoriesCmd
implements Command<List<ProcessCategoryEntity>> {
    private Long parentId;
    private String formId;

    public FindChildrenProcessCategoriesCmd(Long parentId, String formId) {
        this.parentId = parentId;
        this.formId = formId;
    }

    @Override
    public List<ProcessCategoryEntity> execute(CommandContext commandContext) {
        Object row22;
        ArrayList<ProcessCategoryEntity> result = new ArrayList<ProcessCategoryEntity>();
        ProcessCategoryEntityManager categoryManager = commandContext.getProcessCategoryEntityManager();
        if (WfUtils.isEmpty(this.formId) || "wf_model".equals(this.formId) || "bpm_model".equals(this.formId)) {
            EntityQueryBuilder eb = categoryManager.createQueryBuilder();
            eb.addFilter("parentid", this.parentId);
            eb.addFilter("processtype", "!=", ModelType.NoCodeFlow.name());
            return categoryManager.findByQueryBuilder(eb);
        }
        Set<Object> categoryIds = new HashSet(16);
        String sql = "SELECT FID FROM T_WF_PROCCATE WHERE FPARENTID = ?;";
        HashMap<Long, List<Long>> map = new HashMap<Long, List<Long>>(16);
        try (DataSet ds = DB.queryDataSet((String)"wf.engine.findChildrenProcessCategory", (DBRoute)DBRoute.workflow, (String)sql, (Object[])new Object[]{this.parentId});){
            for (Object row22 : ds) {
                map.put(row22.getLong("FID"), new ArrayList());
            }
        }
        String condition = "";
        if ("wf_processdefinition".equals(this.formId)) {
            condition = String.format(" WHERE FTYPE = '%s'", ModelType.AuditFlow.name());
        }
        sql = String.format("SELECT FID FROM T_WF_PROCCATE WHERE FPROCESSTYPE != '%s' AND FID IN (SELECT DISTINCT FCATEGORYID FROM T_WF_PROCDEF %s);", ModelType.NoCodeFlow.name(), condition);
        HashSet<Long> ids = new HashSet<Long>(16);
        DataSet ds = DB.queryDataSet((String)"wf.engine.findHasProcessesCategory", (DBRoute)DBRoute.workflow, (String)sql);
        row22 = null;
        try {
            for (Row row3 : ds) {
                ids.add(row3.getLong("FID"));
            }
        }
        catch (Throwable iter) {
            row22 = iter;
            throw iter;
        }
        finally {
            if (ds != null) {
                if (row22 != null) {
                    try {
                        ds.close();
                    }
                    catch (Throwable iter) {
                        ((Throwable)row22).addSuppressed(iter);
                    }
                } else {
                    ds.close();
                }
            }
        }
        if (this.parentId == 10000L) {
            String fields;
            QFilter[] filters = new QFilter[]{new QFilter("parentid", "in", map.keySet())};
            List categories = categoryManager.findByQueryFilters(filters, fields = String.format("%s, %s", "id", "parentid"), null);
            if (!categories.isEmpty()) {
                for (ProcessCategoryEntity processCategoryEntity : categories) {
                    List children = (List)map.get(processCategoryEntity.getParentId());
                    if (children == null || !ids.contains(processCategoryEntity.getId())) continue;
                    children.add(processCategoryEntity.getId());
                }
                for (Map.Entry entry : map.entrySet()) {
                    Long key = (Long)entry.getKey();
                    if (!ids.contains(key) && ((List)entry.getValue()).isEmpty()) continue;
                    categoryIds.add(key);
                }
            } else {
                categoryIds = this.filterFromMap(map, ids);
            }
        } else {
            categoryIds = this.filterFromMap(map, ids);
        }
        if (!categoryIds.isEmpty()) {
            return categoryManager.findByQueryFilters(new QFilter[]{new QFilter("id", "in", categoryIds)});
        }
        return result;
    }

    private Set<Long> filterFromMap(Map<Long, List<Long>> map, Set<Long> ids) {
        Set<Long> keys = map.keySet();
        HashSet<Long> categoryIds = new HashSet<Long>(keys.size());
        for (Long key : keys) {
            if (!ids.contains(key)) continue;
            categoryIds.add(key);
        }
        return categoryIds;
    }
}

