/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.workflow.engine.impl.cmd.management;

import java.util.ArrayList;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.stream.Collectors;
import kd.bos.algo.DataSet;
import kd.bos.algo.Row;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.metadata.IDataEntityProperty;
import kd.bos.dataentity.metadata.IDataEntityType;
import kd.bos.db.DB;
import kd.bos.db.DBRoute;
import kd.bos.entity.BillEntityType;
import kd.bos.entity.property.MainOrgProp;
import kd.bos.servicehelper.org.OrgUnitServiceHelper;
import kd.bos.workflow.api.EnabledProcessInfo;
import kd.bos.workflow.engine.WfConfigurationUtil;
import kd.bos.workflow.engine.WfUtils;
import kd.bos.workflow.engine.delegate.VariableScope;
import kd.bos.workflow.engine.impl.cmd.startup.BusinessModelVariableScope;
import kd.bos.workflow.engine.impl.interceptor.Command;
import kd.bos.workflow.engine.impl.interceptor.CommandContext;
import kd.bos.workflow.engine.impl.util.condition.ConditionUtil;

public class GetEnabledProcessesCmd
implements Command<List<EnabledProcessInfo>> {
    private DynamicObject dataEntity;
    private String operation;
    private BusinessModelVariableScope bizScope;
    private static final String ID = "id";
    private static final String NUMBER = "number";
    private static final String NAME = "name";
    private static final String PROCESSTYPE = "processtype";
    private static final String ORGID = "orgId";
    private static final String ALGOKEY = "wf.engine.FindEnabledProcess.execute";

    public GetEnabledProcessesCmd(DynamicObject dataEntity, String operation) {
        this.dataEntity = dataEntity;
        this.operation = operation;
        this.bizScope = new BusinessModelVariableScope(dataEntity);
    }

    @Override
    public List<EnabledProcessInfo> execute(CommandContext commandContext) {
        if (WfConfigurationUtil.isProcessAddressByOrg()) {
            return this.findEnabledProcessByOrg();
        }
        return this.findEnabledProcessByEntityNumber();
    }

    private List<EnabledProcessInfo> findEnabledProcessByOrg() {
        String mainOrgFieldNumber;
        List<EnabledProcessInfo> enabledProcesses = this.findEnabledProcessByEntityNumber();
        if (this.dataEntity == null || WfUtils.isEmptyForCollection(enabledProcesses)) {
            return enabledProcesses;
        }
        IDataEntityType dt = this.dataEntity.getDataEntityType();
        if (dt instanceof BillEntityType && WfUtils.isNotEmpty(mainOrgFieldNumber = ((BillEntityType)dt).getMainOrg())) {
            DynamicObject billMainOrg;
            MainOrgProp orgProp = (MainOrgProp)((BillEntityType)dt).getProperty(mainOrgFieldNumber);
            String orgFunc = orgProp.getOrgFunc();
            if (WfUtils.isEmpty(orgFunc)) {
                orgFunc = "15";
            }
            if ((billMainOrg = this.dataEntity.getDynamicObject((IDataEntityProperty)orgProp)) == null) {
                return enabledProcesses;
            }
            Long billMainOrgId = (Long)billMainOrg.getPkValue();
            List parentIds = OrgUnitServiceHelper.getAllSuperiorOrgs((String)orgFunc, (long)billMainOrgId);
            parentIds.add(billMainOrgId);
            HashSet<Long> processOrgIds = new HashSet<Long>(enabledProcesses.size());
            for (EnabledProcessInfo enabledProcess2 : enabledProcesses) {
                processOrgIds.add(enabledProcess2.getOrgId());
            }
            for (int i = parentIds.size() - 1; i >= 0; --i) {
                if (!processOrgIds.contains(parentIds.get(i))) continue;
                long orgId = (Long)parentIds.get(i);
                return enabledProcesses.stream().filter(enabledProcess -> enabledProcess.getOrgId() == orgId).collect(Collectors.toList());
            }
            return new ArrayList<EnabledProcessInfo>();
        }
        return enabledProcesses;
    }

    private List<EnabledProcessInfo> findEnabledProcessByEntityNumber() {
        ArrayList<EnabledProcessInfo> enabledProcesses = new ArrayList<EnabledProcessInfo>();
        if (this.dataEntity == null || this.dataEntity.getDataEntityType() == null || WfUtils.isEmpty(this.dataEntity.getDataEntityType().getName())) {
            return enabledProcesses;
        }
        String sql = this.getFindProcessSql();
        Object[] params = new Object[]{this.dataEntity.getDataEntityType().getName()};
        try (DataSet ds = DB.queryDataSet((String)ALGOKEY, (DBRoute)DBRoute.workflow, (String)sql, (Object[])params);){
            Iterator iter = ds.iterator();
            HashSet<String> processNumbers = new HashSet<String>();
            while (iter.hasNext()) {
                Row row = (Row)iter.next();
                String operations = row.getString("operation");
                String number = row.getString(NUMBER);
                if (!this.isEnableProcess(row.getString("startcondition")) || !this.hasOperation(operations, this.operation) || processNumbers.contains(number)) continue;
                processNumbers.add(number);
                Long id = row.getLong(ID);
                String name = row.getString(NAME);
                String processType = row.getString(PROCESSTYPE);
                Long orgId = row.getLong(ORGID);
                EnabledProcessInfo enabledProcess = new EnabledProcessInfo(id, number, name, processType, orgId);
                enabledProcesses.add(enabledProcess);
            }
        }
        return enabledProcesses;
    }

    private String getFindProcessSql() {
        String procDefTableAlias = "a ";
        String processConfigTableAlias = "b ";
        StringBuilder sql = new StringBuilder("SELECT ");
        sql.append("a.fid id, a.fkey number, a.fname name,");
        sql.append("b.foperation operation, a.forgunitid orgId, b.fprocesstype processtype, ");
        sql.append("b.fstartcondition startcondition ");
        sql.append("FROM t_wf_processconfig ");
        sql.append(processConfigTableAlias);
        sql.append("LEFT JOIN t_wf_procdef ");
        sql.append(procDefTableAlias);
        sql.append("ON a.fid = b.fprocdefid ");
        sql.append("WHERE b.fentitynumber = ? ");
        sql.append("and a.fenable = 'enable' ");
        sql.append("and b.fallowstart = '1' ");
        sql.append("and a.ftype = 'AuditFlow' ");
        sql.append("ORDER BY a.fcreatedate desc,a.fversion desc");
        return sql.toString();
    }

    private boolean hasOperation(String operations, String operation) {
        if (WfUtils.isEmpty(operation)) {
            return true;
        }
        if (WfUtils.isNotEmpty(operations)) {
            String[] arr;
            for (String str : arr = operations.split(",")) {
                if (!str.equals(operation)) continue;
                return true;
            }
        }
        return false;
    }

    private boolean isEnableProcess(String condition) {
        if (WfUtils.isEmpty(condition)) {
            return true;
        }
        String key = String.format("BizFlow: %s , operation: %s", "addressProcess", this.operation);
        return ConditionUtil.hasTrueCondition(condition, (VariableScope)this.bizScope, key);
    }
}

