/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.workflow.engine.impl.cmd.management;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import kd.bos.data.BusinessDataReader;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.metadata.dynamicobject.DynamicObjectType;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.serialization.SerializationUtils;
import kd.bos.entity.EntityMetadataCache;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.metadata.deploy.DeployFile;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.workflow.bpmn.model.deploy.ExportScheme;
import kd.bos.workflow.domain.model.NodeLifecycleUtil;
import kd.bos.workflow.engine.WfUtils;
import kd.bos.workflow.engine.impl.cmd.job.EventTriggerCmd;
import kd.bos.workflow.engine.impl.interceptor.Command;
import kd.bos.workflow.engine.impl.interceptor.CommandContext;
import kd.bos.workflow.engine.impl.interceptor.DefaultCommandContextCloseListener;
import kd.bos.workflow.engine.impl.util.ImportExportProcessUtil;
import kd.bos.workflow.exception.WFIllegalArgumentException;

public class GetExportSchemeFileCmd
implements Serializable,
Command<DeployFile> {
    private static final long serialVersionUID = 8850274338038367017L;
    protected static Log logger = LogFactory.getLog(GetExportSchemeFileCmd.class);
    private long processDefinitionId;
    private static final String FILE_SUFFIX = ".scheme";

    public GetExportSchemeFileCmd(long processDefinitionId) {
        this.processDefinitionId = processDefinitionId;
    }

    @Override
    public DeployFile execute(CommandContext commandContext) {
        if (WfUtils.isEmpty(this.processDefinitionId)) {
            throw new WFIllegalArgumentException(ResManager.loadKDString((String)"\u6d41\u7a0b\u5b9a\u4e49processDefinitionID\u4e0d\u80fd\u4e3a\u7a7a\u3002", (String)"GetExportSchemeFileCmd_1", (String)"bos-wf-engine", (Object[])new Object[0]));
        }
        return this.getExportScheme(this.processDefinitionId, commandContext);
    }

    private DeployFile getExportScheme(final Long processDefinitionId, CommandContext commandContext) {
        ExportScheme deploy = new ExportScheme();
        Long modelId = this.loadProcessDefinitions(processDefinitionId, deploy);
        this.loadProcessModel(modelId, deploy);
        DynamicObject processDefinition = this.loadDeployments(processDefinitionId, deploy);
        this.loadCategory(deploy, processDefinition);
        this.loadParticipantModelCfgs(commandContext, deploy);
        this.loadBillSubject(deploy, processDefinition);
        Map<String, List<Long>> resourceAndConditionRuleIds = this.loadSchemes(commandContext, deploy);
        if (resourceAndConditionRuleIds != null && resourceAndConditionRuleIds.size() > 0) {
            List<Long> resourceIds = resourceAndConditionRuleIds.get("resourceIds");
            List<Long> conditionalRuleIds = resourceAndConditionRuleIds.get("conditionalRuleIds");
            this.loadResources(deploy, resourceIds);
            this.loadProcessConfigs(processDefinitionId, commandContext, deploy, conditionalRuleIds);
            DynamicObject[] conditionalRules = this.loadConditionalRules(deploy, conditionalRuleIds);
            List<Long> jsonResourceId = resourceAndConditionRuleIds.get("jsonResourceId");
            DynamicObject[] jsonResources = BusinessDataReader.load((Object[])jsonResourceId.toArray(), (DynamicObjectType)EntityMetadataCache.getDataEntityType((String)"wf_resource"), (Boolean)Boolean.FALSE);
            this.loadBaseDatasForScheme(deploy, jsonResources, conditionalRules);
        }
        String key = processDefinition.getString("key");
        String version = processDefinition.getString("version");
        if (commandContext.getProcessEngineConfiguration().isEnableBecEventDispatcher()) {
            HashMap<String, Long> params = new HashMap<String, Long>();
            params.put("processDefinitionId", processDefinitionId);
            new EventTriggerCmd("wf.AfterExportSchemeEvent", SerializationUtils.toJsonString(params)).execute(commandContext);
        }
        commandContext.addCloseListener(new DefaultCommandContextCloseListener("lifecycleListener"){

            @Override
            public void closed(CommandContext commandContext) {
                try {
                    NodeLifecycleUtil.executeLifecycleExportSchemeListener(processDefinitionId);
                }
                catch (Exception e) {
                    this.log.error(WfUtils.getExceptionStacktrace(e));
                }
            }
        });
        return deploy.toDeployFile(String.format("%s_%s%s", key, version, FILE_SUFFIX));
    }

    private Map<String, List<Long>> loadSchemes(CommandContext commandContext, ExportScheme deploy) {
        QFilter filters;
        String fields = commandContext.getDynamicConfigSchemeEntityManager().getSelectFields();
        DynamicObject[] schemes = BusinessDataServiceHelper.load((String)"wf_processdynamicconfig", (String)fields, (QFilter[])new QFilter[]{filters = new QFilter("processdefinitionid", "=", (Object)this.processDefinitionId)}, null);
        if (schemes == null || schemes.length == 0) {
            logger.warn("\u8bfb\u53d6\u52a8\u6001\u914d\u7f6e\u65b9\u6848\u4fe1\u606f\u5f02\u5e38");
            return null;
        }
        HashMap<String, List<Long>> resourceAndConditionRuleIds = new HashMap<String, List<Long>>();
        int size = schemes.length;
        ArrayList<Long> jsonResourceId = new ArrayList<Long>(1);
        ArrayList<Long> resourceIds = new ArrayList<Long>(size * 2);
        ArrayList<Long> conditionalRuleIds = new ArrayList<Long>(size);
        for (int i = 0; i < size; ++i) {
            DynamicObject scheme = schemes[i];
            deploy.getSchemes().add(scheme);
            resourceIds.add(scheme.getLong("jsonpatchid"));
            resourceIds.add(scheme.getLong("jsonresourceid"));
            jsonResourceId.add(scheme.getLong("jsonresourceid"));
            conditionalRuleIds.add(scheme.getLong("conditionid"));
        }
        resourceAndConditionRuleIds.put("resourceIds", resourceIds);
        resourceAndConditionRuleIds.put("jsonResourceId", jsonResourceId);
        resourceAndConditionRuleIds.put("conditionalRuleIds", conditionalRuleIds);
        return resourceAndConditionRuleIds;
    }

    private DynamicObject[] loadResources(ExportScheme deploy, List<Long> resourceIds) {
        DynamicObject[] resources = BusinessDataReader.load((Object[])resourceIds.toArray(), (DynamicObjectType)EntityMetadataCache.getDataEntityType((String)"wf_resource"), (Boolean)Boolean.FALSE);
        if (resources != null && resources.length > 0) {
            for (int j = 0; j < resources.length; ++j) {
                DynamicObject resource = resources[j];
                deploy.getResources().add(resource);
            }
        } else {
            logger.warn("\u8bfb\u53d6\u6d41\u7a0b\u8d44\u6e90\u4fe1\u606f\u5f02\u5e38");
        }
        return resources;
    }

    private Long loadProcessDefinitions(Long processDefinitionId, ExportScheme deploy) {
        Long modelId = 0L;
        DynamicObject[] processDefs = BusinessDataReader.load((Object[])new Long[]{processDefinitionId}, (DynamicObjectType)EntityMetadataCache.getDataEntityType((String)"wf_processdefinition"), (Boolean)Boolean.FALSE);
        if (processDefs != null && processDefs.length > 0) {
            modelId = processDefs[0].getLong("modelid");
            for (int j = 0; j < processDefs.length; ++j) {
                DynamicObject processDef = processDefs[j];
                deploy.getProcessDefinitions().add(processDef);
            }
        } else {
            logger.warn(String.format("\u8bfb\u53d6\u6d41\u7a0b\u6a21\u578b\u4fe1\u606f\u5f02\u5e38\uff0c\u6839\u636e\u6d41\u7a0b\u5b9a\u4e49id[%s]\u627e\u4e0d\u5230\u76f8\u5bf9\u5e94\u7684\u6d41\u7a0b\u5b9a\u4e49\uff01", processDefinitionId));
        }
        return modelId;
    }

    private void loadProcessModel(Long modelId, ExportScheme deploy) {
        DynamicObject[] models = BusinessDataReader.load((Object[])new Long[]{modelId}, (DynamicObjectType)EntityMetadataCache.getDataEntityType((String)"wf_model"), (Boolean)Boolean.FALSE);
        if (models != null && models.length > 0) {
            for (int i = 0; i < models.length; ++i) {
                DynamicObject model = models[i];
                deploy.getProcessModel().add(model);
            }
        } else {
            logger.warn(String.format("\u8bfb\u53d6\u6d41\u7a0b\u6a21\u578b\u4fe1\u606f\u5f02\u5e38\uff0c\u6839\u636e\u6d41\u7a0b\u6a21\u578bid[%s]\u627e\u4e0d\u5230\u76f8\u5bf9\u5e94\u7684\u6d41\u7a0b\u6a21\u578b\uff01", modelId));
        }
    }

    private void loadProcessConfigs(Long processDefinitionId, CommandContext commandContext, ExportScheme deploy, List<Long> conditionalRuleIds) {
        QFilter processConfigFilters;
        String processConfigFields = commandContext.getProcessConfigEntityManager().getSelectFields();
        DynamicObject[] processConfigs = BusinessDataServiceHelper.load((String)"wf_processconfig", (String)processConfigFields, (QFilter[])new QFilter[]{processConfigFilters = new QFilter("procdefid", "=", (Object)processDefinitionId)}, null);
        if (processConfigs != null && processConfigs.length > 0) {
            for (int j = 0; j < processConfigs.length; ++j) {
                DynamicObject processConfig = processConfigs[j];
                conditionalRuleIds.add(processConfig.getLong("condruleid"));
                deploy.getProcessConfigs().add(processConfig);
            }
        } else {
            logger.warn("\u8bfb\u53d6\u6d41\u7a0b\u914d\u7f6e\u4fe1\u606f\u4e3a\u7a7a");
        }
    }

    private DynamicObject[] loadConditionalRules(ExportScheme deploy, List<Long> conditionalRuleIds) {
        DynamicObject[] conditionalRules = BusinessDataReader.load((Object[])conditionalRuleIds.toArray(), (DynamicObjectType)EntityMetadataCache.getDataEntityType((String)"wf_conditionalrule"), (Boolean)Boolean.FALSE);
        if (conditionalRules != null && conditionalRules.length > 0) {
            for (int j = 0; j < conditionalRules.length; ++j) {
                DynamicObject conditionalrule = conditionalRules[j];
                deploy.getConditionalrules().add(conditionalrule);
            }
        } else {
            logger.warn("\u8bfb\u53d6\u6d41\u7a0b\u6761\u4ef6\u89c4\u5219\u4fe1\u606f\u5f02\u5e38");
        }
        return conditionalRules;
    }

    private DynamicObject loadDeployments(Long processDefinitionId, ExportScheme deploy) {
        DynamicObject[] processDefinitions = BusinessDataReader.load((Object[])new Long[]{processDefinitionId}, (DynamicObjectType)EntityMetadataCache.getDataEntityType((String)"wf_processdefinition"), (Boolean)Boolean.TRUE);
        DynamicObject processDefinition = processDefinitions[0];
        long deploymentId = processDefinition.getLong("deploymentid");
        DynamicObject[] deployments = BusinessDataReader.load((Object[])new Long[]{deploymentId}, (DynamicObjectType)EntityMetadataCache.getDataEntityType((String)"wf_deployment"), (Boolean)Boolean.FALSE);
        if (deployments != null && deployments.length > 0) {
            for (int j = 0; j < deployments.length; ++j) {
                DynamicObject deployment = deployments[j];
                deploy.getDeployments().add(deployment);
            }
        } else {
            logger.warn("\u8bfb\u53d6\u6d41\u7a0b\u53d1\u5e03\u4fe1\u606f\u5f02\u5e38");
        }
        return processDefinition;
    }

    private void loadCategory(ExportScheme deploy, DynamicObject processDefinition) {
        Long categoryid = 0L;
        if (processDefinition != null) {
            categoryid = (Long)processDefinition.get("categoryid");
        }
        Long parentCategoryid = 0L;
        DynamicObject[] categories = BusinessDataReader.load((Object[])new Long[]{categoryid}, (DynamicObjectType)EntityMetadataCache.getDataEntityType((String)"wf_processcagetory"), (Boolean)Boolean.FALSE);
        if (categories != null && categories.length == 1) {
            deploy.getCategories().add(categories[0]);
            if (categories[0].getBoolean("isleaf")) {
                parentCategoryid = categories[0].getLong("parentid");
            }
        } else {
            logger.warn("\u8bfb\u53d6\u6d41\u7a0b\u5b50\u7c7b\u522b\u4fe1\u606f\u5f02\u5e38");
        }
        if (WfUtils.isNotEmpty(parentCategoryid)) {
            categories = BusinessDataReader.load((Object[])new Long[]{parentCategoryid}, (DynamicObjectType)EntityMetadataCache.getDataEntityType((String)"wf_processcagetory"), (Boolean)Boolean.FALSE);
            if (categories != null && categories.length == 1) {
                deploy.getCategories().add(categories[0]);
            } else {
                logger.warn("\u8bfb\u53d6\u6d41\u7a0b\u7236\u7c7b\u522b\u4fe1\u606f\u5f02\u5e38");
            }
        }
    }

    private void loadParticipantModelCfgs(CommandContext commandContext, ExportScheme deploy) {
        QFilter[] participantFilters;
        String participantModelConfigFields = commandContext.getParticipantModelCfgEntityManager().getSelectFields();
        DynamicObject[] participantModelConfigs = BusinessDataServiceHelper.load((String)"wf_participantmodelconfig", (String)participantModelConfigFields, (QFilter[])(participantFilters = new QFilter[]{null}));
        if (participantModelConfigs != null && participantModelConfigs.length > 0) {
            for (int i = 0; i < participantModelConfigs.length; ++i) {
                DynamicObject participantModelConfig = participantModelConfigs[i];
                deploy.getParticipantmodelcfgs().add(participantModelConfig);
            }
        }
    }

    private void loadBillSubject(ExportScheme deploy, DynamicObject processDefinition) {
        DynamicObject billSubject = BusinessDataServiceHelper.loadSingle((String)"wf_billsubjectmodel", (String)"id,billId,billName,billSubject,entityNumber,formKey,formKeyName,businessFieldMappingInfo", (QFilter[])new QFilter[]{new QFilter("entityNumber", "=", (Object)processDefinition.getString("entrabill"))});
        if (billSubject != null) {
            deploy.getBillSubject().add(billSubject);
        }
    }

    private void loadBaseDatasForScheme(ExportScheme deploy, DynamicObject[] resources, DynamicObject[] conditionalRules) {
        ImportExportProcessUtil.loadBaseDataForScheme("wf_role", resources, conditionalRules, true, null, deploy.getRoles());
        ImportExportProcessUtil.loadBaseDataForScheme("wf_orgtype", resources, conditionalRules, true, null, deploy.getOrgType());
        ImportExportProcessUtil.loadBaseDataForScheme("wf_keyauditor", resources, conditionalRules, true, null, deploy.getKeyAuditor());
        ImportExportProcessUtil.loadMobileBillSummaryForScheme("bos_mobileformconfig", resources, deploy.getMobileFormConfig());
        ImportExportProcessUtil.loadMobileBillSummaryForScheme("wf_mbillsummary_cfg", resources, deploy.getMobileBillSummaryCfg());
        Set<Long> commonAuditCommentIds = ImportExportProcessUtil.loadCommonAuditCommentForScheme("wf_commonauditcommenttree", resources, deploy.getCommonAuditComment());
        ImportExportProcessUtil.loadAuditCommentGroupForSchemeOrModel("wf_auditcommentgroup", commonAuditCommentIds, deploy.getAuditCommentGroup());
        ImportExportProcessUtil.loadBaseDataForScheme("wf_expressionext", resources, conditionalRules, false, "mc_", deploy.getExpressionExtension());
    }
}

