/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.workflow.engine.impl.cmd.management;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import kd.bos.dataentity.entity.LocaleString;
import kd.bos.workflow.bpmn.model.BoundaryEvent;
import kd.bos.workflow.bpmn.model.BpmnModel;
import kd.bos.workflow.bpmn.model.FlowElement;
import kd.bos.workflow.bpmn.model.FlowNode;
import kd.bos.workflow.bpmn.model.Gateway;
import kd.bos.workflow.domain.model.NodeForkJoinModel;
import kd.bos.workflow.engine.WfUtils;
import kd.bos.workflow.engine.impl.interceptor.Command;
import kd.bos.workflow.engine.impl.interceptor.CommandContext;
import kd.bos.workflow.engine.impl.persistence.entity.job.DeadLetterJobEntity;
import kd.bos.workflow.engine.impl.persistence.entity.runtime.ExecutionEntity;
import kd.bos.workflow.engine.impl.util.ProcessDefinitionUtil;
import kd.bos.workflow.engine.impl.util.RuntimeUtil;

public class GetJumpNodesCmd
implements Command<List<Map<String, Object>>> {
    private Long executionId;

    public GetJumpNodesCmd(Long executionId) {
        this.executionId = executionId;
    }

    @Override
    public List<Map<String, Object>> execute(CommandContext commandContext) {
        ExecutionEntity execution = (ExecutionEntity)commandContext.getExecutionEntityManager().findById(this.executionId);
        Long procinstId = execution.getProcessInstanceId();
        List<DeadLetterJobEntity> deadJobs = commandContext.getDeadLetterJobEntityManager().findJobsByProcessInstanceId(procinstId);
        HashSet<String> deadNodes = new HashSet<String>(deadJobs.size());
        for (DeadLetterJobEntity d : deadJobs) {
            if (!RuntimeUtil.isRunningJob(d.getJobHandlerType())) continue;
            deadNodes.add(d.getElementId());
        }
        boolean fromExecution = deadNodes.isEmpty();
        List<ExecutionEntity> allExecutions = commandContext.getExecutionEntityManager().findChildExecutionsByProcessInstanceId(procinstId);
        HashSet<String> currentNodeIds = new HashSet<String>();
        ArrayList<Map<String, Object>> comboItems = new ArrayList<Map<String, Object>>();
        BpmnModel bpmnModel = null;
        Map<String, NodeForkJoinModel> models = null;
        HashSet<String> forkPaths = new HashSet<String>(16);
        HashMap joinItems = new HashMap(16);
        for (ExecutionEntity executionEntity : allExecutions) {
            NodeForkJoinModel model;
            FlowElement ele;
            String actId = executionEntity.getActivityId();
            if (!executionEntity.isActive() || executionEntity.isScope() || currentNodeIds.contains(executionEntity.getActivityId()) || !fromExecution && !deadNodes.contains(actId)) continue;
            if (bpmnModel == null) {
                bpmnModel = ProcessDefinitionUtil.getBpmnModel(execution.getProcessDefinitionId(), procinstId);
                models = bpmnModel.getMainProcess().getForkJoinModels();
            }
            if ((ele = bpmnModel.getFlowElement(actId)) instanceof Gateway || ele instanceof BoundaryEvent || !(ele instanceof FlowNode)) continue;
            currentNodeIds.add(actId);
            HashMap<String, Object> comboItem = new HashMap<String, Object>();
            if (WfUtils.isEmpty(executionEntity.getActivityName().getLocaleValue())) {
                comboItem.put("caption", new LocaleString(bpmnModel.getFlowElement(actId).getName()));
            } else {
                comboItem.put("caption", new LocaleString(executionEntity.getActivityName().getLocaleValue()));
            }
            comboItem.put("value", actId);
            if (WfUtils.isNotEmpty(bpmnModel.getMainProcess().getBoundaryEventId(executionEntity.getActivityId()))) {
                comboItems = new ArrayList();
                comboItems.add(comboItem);
                break;
            }
            if (models != null && (model = models.get(actId)) != null) {
                String cpath = model.getForkStructure();
                if (model.isJoinNode()) {
                    String path;
                    String markKey = String.format("%s$", cpath);
                    boolean flag = false;
                    Iterator iterator = forkPaths.iterator();
                    while (iterator.hasNext() && !(flag = (path = (String)iterator.next()).contains(markKey))) {
                    }
                    if (flag) continue;
                    joinItems.put(markKey, comboItem);
                    continue;
                }
                forkPaths.add(cpath);
            }
            comboItems.add(comboItem);
        }
        for (Map.Entry entry : joinItems.entrySet()) {
            String fp;
            boolean contains = false;
            Iterator iterator = forkPaths.iterator();
            while (iterator.hasNext() && !(contains = (fp = (String)iterator.next()).contains((CharSequence)entry.getKey()))) {
            }
            if (contains) continue;
            comboItems.add((Map<String, Object>)entry.getValue());
        }
        return comboItems;
    }
}

