/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.workflow.engine.impl.cmd.management;

import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONObject;
import com.google.common.collect.Sets;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import kd.bos.context.RequestContext;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.entity.ILocaleString;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.serialization.SerializationUtils;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.db.tx.TX;
import kd.bos.db.tx.TXHandle;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.ORM;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.bos.workflow.bizflow.util.BizFlowUtil;
import kd.bos.workflow.bpmn.graph.codec.GraphCodecUtils;
import kd.bos.workflow.bpmn.model.BaseElement;
import kd.bos.workflow.bpmn.model.BpmnModel;
import kd.bos.workflow.bpmn.model.EventDefinition;
import kd.bos.workflow.bpmn.model.FlowElement;
import kd.bos.workflow.bpmn.model.Signal;
import kd.bos.workflow.bpmn.model.SignalEventDefinition;
import kd.bos.workflow.bpmn.model.StartEvent;
import kd.bos.workflow.bpmn.model.deploy.ExportScheme;
import kd.bos.workflow.engine.WfUtils;
import kd.bos.workflow.engine.enumeration.ConditionalRuleType;
import kd.bos.workflow.engine.impl.bpmn.deployer.BpmnDeploymentHelper;
import kd.bos.workflow.engine.impl.bpmn.deployer.ProcessOperation;
import kd.bos.workflow.engine.impl.bpmn.deployer.VersionUtils;
import kd.bos.workflow.engine.impl.cache.WfCacheHelper;
import kd.bos.workflow.engine.impl.cmd.entity.GetSingleEntityCmd;
import kd.bos.workflow.engine.impl.cmd.management.InitProcessInfoEntityCmd;
import kd.bos.workflow.engine.impl.cmd.management.scheme.GetConfigSchemeBpmnJsonStringCmd;
import kd.bos.workflow.engine.impl.cmd.management.scheme.GetConfigSchemeBpmnModelCmd;
import kd.bos.workflow.engine.impl.context.Context;
import kd.bos.workflow.engine.impl.db.EntityQueryBuilder;
import kd.bos.workflow.engine.impl.interceptor.Command;
import kd.bos.workflow.engine.impl.interceptor.CommandContext;
import kd.bos.workflow.engine.impl.persistence.entity.config.ParticipantModelCfgEntity;
import kd.bos.workflow.engine.impl.persistence.entity.design.ModelEntity;
import kd.bos.workflow.engine.impl.persistence.entity.design.ModelType;
import kd.bos.workflow.engine.impl.persistence.entity.design.ProcessCategoryEntity;
import kd.bos.workflow.engine.impl.persistence.entity.design.ResourceEntity;
import kd.bos.workflow.engine.impl.persistence.entity.design.ResourceEntityManager;
import kd.bos.workflow.engine.impl.persistence.entity.management.BillSubjectModelEntity;
import kd.bos.workflow.engine.impl.persistence.entity.management.ConditionalEntity;
import kd.bos.workflow.engine.impl.persistence.entity.management.ConditionalEntityImpl;
import kd.bos.workflow.engine.impl.persistence.entity.management.ConditionalRuleEntity;
import kd.bos.workflow.engine.impl.persistence.entity.management.ConditionalRuleEntityManager;
import kd.bos.workflow.engine.impl.persistence.entity.management.DeploymentEntityManager;
import kd.bos.workflow.engine.impl.persistence.entity.management.DynamicConfigSchemeEntity;
import kd.bos.workflow.engine.impl.persistence.entity.management.DynamicConfigSchemeEntityImpl;
import kd.bos.workflow.engine.impl.persistence.entity.management.ProcessConfigEntity;
import kd.bos.workflow.engine.impl.persistence.entity.management.ProcessConfigEntityManager;
import kd.bos.workflow.engine.impl.persistence.entity.management.ProcessDefinitionEntity;
import kd.bos.workflow.engine.impl.persistence.entity.management.ProcessDefinitionEntityManager;
import kd.bos.workflow.engine.impl.persistence.entity.management.ProcessDefinitionInfoEntity;
import kd.bos.workflow.engine.impl.persistence.entity.management.ProcessDefinitionInfoEntityImpl;
import kd.bos.workflow.engine.impl.persistence.entity.operationlog.ModelModifyLogEntity;
import kd.bos.workflow.engine.impl.persistence.entity.operationlog.ModelModifyLogEntityManager;
import kd.bos.workflow.engine.impl.persistence.entity.runtime.SignalEventSubscriptionEntity;
import kd.bos.workflow.engine.impl.scheme.enumeration.ImportType;
import kd.bos.workflow.engine.impl.scheme.model.ImportSchemeParameter;
import kd.bos.workflow.engine.impl.util.BpmnModelUtil;
import kd.bos.workflow.engine.impl.util.CollectionUtil;
import kd.bos.workflow.engine.impl.util.DynamicSchemeUtil;
import kd.bos.workflow.engine.impl.util.ExtractMultiLanguageWordsUtil;
import kd.bos.workflow.engine.impl.util.ImportExportProcessUtil;
import kd.bos.workflow.engine.impl.util.ProcessDefinitionUtil;
import kd.bos.workflow.exception.WFIllegalArgumentException;
import kd.bos.workflow.validation.ValidationError;

public class ImportSchemeCmd
implements Command<Map<String, Object>>,
Serializable {
    private static final long serialVersionUID = -7429042691138757215L;
    private Log logger = LogFactory.getLog(ImportSchemeCmd.class);
    private static final String ENTRYENTITY = "entryentity";
    private static final String DATA = "data";
    private static final String CONTENT = "content";
    private static final String CURRENTLANGUAGE = "currentlanguage";
    private static final String JSONRESOURCE = "jsonResource";
    private static final String JSONPATCH = "jsonPatch";
    private ExportScheme exportScheme;
    private boolean isCover;
    private ImportSchemeParameter parameter;

    public ImportSchemeCmd(ExportScheme exportScheme, boolean isCover) {
        this.exportScheme = exportScheme;
        this.isCover = isCover;
    }

    public ImportSchemeCmd(ExportScheme exportScheme, ImportSchemeParameter parameter) {
        this.exportScheme = exportScheme;
        this.isCover = ImportType.COVER == parameter.getImportType();
        this.parameter = parameter;
    }

    @Override
    public Map<String, Object> execute(CommandContext commandContext) {
        if (this.exportScheme == null) {
            throw new WFIllegalArgumentException(ResManager.loadKDString((String)"\u6d41\u7a0b\u52a8\u6001\u65b9\u6848\u5bf9\u8c61exportScheme\u4e0d\u80fd\u4e3a\u7a7a\u3002", (String)"ImportSchemeCmd_1", (String)"bos-wf-engine", (Object[])new Object[0]));
        }
        if (this.isCover) {
            return this.coverImportScheme(commandContext);
        }
        return this.importScheme(this.exportScheme, commandContext);
    }

    private Map<String, Object> coverImportScheme(CommandContext commandContext) {
        List<DynamicObject> processDefinitions = this.exportScheme.getProcessDefinitions();
        DynamicObject processDefinition = processDefinitions.get(0);
        String key = (String)processDefinition.get("key");
        ProcessDefinitionEntity latestProcDef = commandContext.getProcessDefinitionEntityManager().findLatestProcessDefinitionByKey(key);
        try (TXHandle tx = TX.requiresNew();){
            this.insertOrUpdateSchemes(commandContext, latestProcDef);
            ProcessCategoryEntity category = ImportExportProcessUtil.insertProcessCategoryIfNeed(commandContext, this.exportScheme.getCategories());
            this.insertOrUpdateModel(commandContext, null, category);
            this.updateProcessDefinitions(commandContext, this.exportScheme);
            this.insertOrUpdateProcessConfigs(commandContext, latestProcDef);
            this.insertParticipantModelCfgs(commandContext, this.exportScheme.getParticipantmodelcfgs());
            this.insertBillSubject(commandContext, this.exportScheme.getBillSubject());
            this.insertCommonBaseDatas(commandContext, this.exportScheme);
            this.synchronizeResourceWords(commandContext, this.parameter, latestProcDef.getId());
            Map<String, Object> ret = this.getProcessValidationResults(latestProcDef);
            ret.put("modelId", latestProcDef.getModelId());
            Map<String, Object> map = ret;
            return map;
        }
    }

    private void updateProcessDefinitions(CommandContext commandContext, ExportScheme exportScheme) {
        String businessId;
        List<DynamicObject> processDefinitions = exportScheme.getProcessDefinitions();
        DynamicObject processDefinition = processDefinitions.get(0);
        String key = processDefinition.getString("key");
        ProcessDefinitionEntity definitionEntity = Context.getProcessEngineConfiguration().getRepositoryService().getLatestProcessDefinitionByKey(key);
        if (definitionEntity == null) {
            return;
        }
        Long orgUnitId = processDefinition.getLong("orgunitid");
        if (orgUnitId == 0L) {
            List<DynamicObject> resources = exportScheme.getResources();
            Long resourceId = processDefinition.getLong("resourceid");
            for (DynamicObject resource : resources) {
                if (!WfUtils.isNotEmpty(resourceId) || !resourceId.equals(resource.get("id"))) continue;
                String data = resource.getString(DATA);
                JSONObject json = JSON.parseObject((String)data);
                if (json == null) break;
                JSONObject properties = json.getJSONObject("properties");
                orgUnitId = properties.getLong("orgUnitId");
                break;
            }
        }
        businessId = StringUtils.isBlank((CharSequence)(businessId = processDefinition.getString("businessid"))) ? key : businessId;
        definitionEntity.setBusinessId(businessId);
        definitionEntity.setOrgUnitId(orgUnitId);
        definitionEntity.setDescription(processDefinition.getLocaleString("description"));
        if (processDefinition.get("primarysubprocess") != null) {
            definitionEntity.setPrimarySubprocess(processDefinition.getString("primarysubprocess"));
        }
        commandContext.getProcessDefinitionEntityManager().update(definitionEntity);
    }

    private void insertOrUpdateProcessConfigs(CommandContext commandContext, ProcessDefinitionEntity latestProcDef) {
        List<DynamicObject> configs = this.exportScheme.getProcessConfigs();
        DynamicObject newConfig = null;
        if (configs == null || configs.isEmpty()) {
            this.deleteProcessConditionalRule(commandContext, latestProcDef);
            commandContext.getProcessConfigEntityManager().getOrCreateProcessConfig(latestProcDef.getId());
        } else {
            ResourceEntity resource = (ResourceEntity)commandContext.getResourceEntityManager().findById(latestProcDef.getResourceId());
            BpmnModel bpmnModel = ProcessDefinitionUtil.getBpmnModel(resource.getData());
            boolean isBizFlow = ModelType.BizFlow.name().equals(bpmnModel.getMainProcess().getProcessType());
            if (isBizFlow) {
                QFilter[] filters = new QFilter[]{new QFilter("procdefid", "=", (Object)latestProcDef.getId())};
                ProcessConfigEntityManager processConfigManager = commandContext.getProcessConfigEntityManager();
                ConditionalRuleEntityManager conditionRuleManager = commandContext.getConditionRuleEntityManager();
                List dbProcessConfigs = processConfigManager.findByQueryFilters(filters);
                for (ProcessConfigEntity dbProcessConfig : dbProcessConfigs) {
                    processConfigManager.delete(dbProcessConfig);
                    if (!WfUtils.isNotEmpty(dbProcessConfig.getCondRuleId())) continue;
                    conditionRuleManager.deleteByFilters(new QFilter[]{new QFilter("id", "=", (Object)dbProcessConfig.getCondRuleId())});
                }
                List<DynamicObject> processConfigs = this.exportScheme.getProcessConfigs();
                for (DynamicObject processConfig : processConfigs) {
                    ProcessConfigEntity config = processConfigManager.create(bpmnModel, latestProcDef.getDynamicObject(), processConfig);
                    this.updateProcessconfigCondition(this.exportScheme, commandContext, latestProcDef.getId(), config, processConfig);
                }
            } else {
                newConfig = configs.get(0);
                if (WfUtils.isEmpty(newConfig.getLong("condruleid"))) {
                    this.deleteProcessConditionalRule(commandContext, latestProcDef);
                }
                ProcessConfigEntity processConfig = commandContext.getProcessConfigEntityManager().getOrCreateProcessConfig(latestProcDef.getId());
                this.updateProcessConfig(commandContext, processConfig, newConfig);
            }
        }
    }

    private void deleteProcessConditionalRule(CommandContext commandContext, ProcessDefinitionEntity latestProcDef) {
        ConditionalRuleEntityManager condRuleManager = commandContext.getConditionRuleEntityManager();
        EntityQueryBuilder queryBuilder = condRuleManager.createQueryBuilder().setSelectFields("id");
        queryBuilder.addFilter("procdefid", latestProcDef.getId()).addFilter("type", ConditionalRuleType.processStartUp.toString());
        List conditionalRules = condRuleManager.findByQueryBuilder(queryBuilder);
        if (conditionalRules == null || conditionalRules.isEmpty()) {
            return;
        }
        commandContext.getConditionRuleEntityManager().delete(((ConditionalRuleEntity)conditionalRules.get(0)).getId());
    }

    private void updateProcessConfig(CommandContext commandContext, ProcessConfigEntity processConfig, DynamicObject newConfig) {
        block2: {
            ConditionalRuleEntity startCondition;
            block1: {
                processConfig.setAllowStart(newConfig.getBoolean("allowstart"));
                processConfig.setProcessType(newConfig.getString("processtype"));
                processConfig.setBatchNumber(newConfig.getString("batchnumber"));
                processConfig.setBatchNumName(newConfig.getString("batchnumname"));
                processConfig.setEventNumber(newConfig.getString("eventnumber"));
                processConfig.setStartType(newConfig.getString("starttype"));
                processConfig.setExceptionConfig(newConfig.getString("exceptionconfig"));
                processConfig.setStartCondition(newConfig.getString("startcondition"));
                startCondition = (ConditionalRuleEntity)commandContext.getConditionRuleEntityManager().findById(processConfig.getCondRuleId());
                if (startCondition != null) break block1;
                DynamicObject dynamicObject = this.createCondition(commandContext, newConfig.getLong("condruleid"), this.exportScheme.getConditionalrules(), processConfig.getProcDefId());
                if (dynamicObject == null) break block2;
                processConfig.setCondRuleId(dynamicObject.getLong("id"));
                break block2;
            }
            for (DynamicObject condition : this.exportScheme.getConditionalrules()) {
                if (!condition.getPkValue().equals(newConfig.get("condruleid"))) continue;
                startCondition.setShowtext(condition.getLocaleString("showtext"));
                startCondition.setDescription(condition.getLocaleString("description"));
                startCondition.setPlugin(condition.getString("plugin"));
                startCondition.setExpression(condition.getString("expression"));
                this.updateConditionals(startCondition, condition);
                commandContext.getConditionRuleEntityManager().update(startCondition);
                break;
            }
        }
        commandContext.getProcessConfigEntityManager().update(processConfig);
    }

    private void insertOrUpdateSchemes(CommandContext commandContext, ProcessDefinitionEntity latestProcDef) {
        HashMap<String, DynamicConfigSchemeEntity> oriSchemeMap = new HashMap<String, DynamicConfigSchemeEntity>();
        DynamicConfigSchemeEntity defScheme = this.findDefaultScheme(commandContext, latestProcDef, oriSchemeMap);
        Map<String, DynamicObject> newSchemeMap = this.getNewSchemeMap(defScheme);
        Set<String> oriSchemeKeys = oriSchemeMap.keySet();
        HashSet<String> coverSchemeKeys = new HashSet<String>();
        Sets.intersection(oriSchemeKeys, newSchemeMap.keySet()).copyInto(coverSchemeKeys);
        HashSet<String> insertSchemeKeys = new HashSet<String>();
        Sets.difference(newSchemeMap.keySet(), oriSchemeKeys).copyInto(insertSchemeKeys);
        this.addCoverRemoveInsertSchemeKeys(oriSchemeMap, newSchemeMap, oriSchemeKeys, coverSchemeKeys, insertSchemeKeys);
        if (!coverSchemeKeys.isEmpty()) {
            this.coverSchemes(commandContext, oriSchemeMap, newSchemeMap, coverSchemeKeys);
        }
        if (!insertSchemeKeys.isEmpty()) {
            this.insertSchemes(commandContext, newSchemeMap, insertSchemeKeys, defScheme);
        }
    }

    private DynamicConfigSchemeEntity findDefaultScheme(CommandContext commandContext, ProcessDefinitionEntity latestProcDef, Map<String, DynamicConfigSchemeEntity> oriSchemeMap) {
        DynamicConfigSchemeEntity defScheme = null;
        QFilter[] filters = new QFilter[]{new QFilter("processdefinitionid", "=", (Object)latestProcDef.getId())};
        List oriSchemes = commandContext.getDynamicConfigSchemeEntityManager().findByQueryFilters(filters);
        for (DynamicConfigSchemeEntity scheme : oriSchemes) {
            oriSchemeMap.put(scheme.getNumber(), scheme);
            if (!scheme.isAcquiescence()) continue;
            defScheme = scheme;
        }
        return defScheme;
    }

    private Map<String, DynamicObject> getNewSchemeMap(DynamicConfigSchemeEntity defScheme) {
        List<DynamicObject> newSchemes = this.exportScheme.getSchemes();
        HashMap<String, DynamicObject> newSchemeMap = new HashMap<String, DynamicObject>();
        for (DynamicObject scheme : newSchemes) {
            if (Boolean.TRUE.equals(scheme.getBoolean("isdefault"))) {
                if (defScheme == null) continue;
                newSchemeMap.put(defScheme.getNumber(), scheme);
                continue;
            }
            newSchemeMap.put(scheme.getString("number"), scheme);
        }
        return newSchemeMap;
    }

    private void addCoverRemoveInsertSchemeKeys(Map<String, DynamicConfigSchemeEntity> oriSchemeMap, Map<String, DynamicObject> newSchemeMap, Set<String> oriSchemeKeys, Set<String> coverSchemeKeys, Set<String> insertSchemeKeys) {
        if (oriSchemeKeys == null || oriSchemeKeys.isEmpty() || insertSchemeKeys.isEmpty()) {
            return;
        }
        Iterator<String> iterator = insertSchemeKeys.iterator();
        DynamicObject schemeObject = null;
        String sourceKey = null;
        DynamicConfigSchemeEntity schemeEntity = null;
        while (iterator.hasNext()) {
            String key = iterator.next();
            schemeObject = newSchemeMap.get(key);
            sourceKey = schemeObject.getString("sourcekey");
            if (WfUtils.isEmpty(sourceKey)) {
                sourceKey = key;
            }
            for (String oriKey : oriSchemeKeys) {
                schemeEntity = oriSchemeMap.get(oriKey);
                if (!sourceKey.equals(schemeEntity.getSourceKey())) continue;
                coverSchemeKeys.add(oriKey);
                newSchemeMap.put(oriKey, newSchemeMap.remove(key));
                iterator.remove();
            }
        }
    }

    private void coverSchemes(CommandContext commandContext, Map<String, DynamicConfigSchemeEntity> oriSchemeMap, Map<String, DynamicObject> newSchemeMap, Set<String> coverSchemeKeys) {
        DynamicConfigSchemeEntity oriScheme = null;
        DynamicObject scheme = null;
        for (String key : coverSchemeKeys) {
            oriScheme = oriSchemeMap.get(key);
            scheme = newSchemeMap.get(key);
            if (!Boolean.valueOf(oriScheme.isAcquiescence()).equals(scheme.getBoolean("isdefault"))) {
                this.logger.debug(String.format("\u539f\u65b9\u6848 %s \u4e0e\u5bfc\u5165\u65b9\u6848 %s \u7f16\u7801[%s]\u76f8\u540c\u4f46'\u662f\u5426\u9ed8\u8ba4'\u72b6\u6001\u4e0d\u540c\uff0c\u8986\u76d6\u5931\u8d25\uff01", oriScheme.getId(), scheme.get("id"), oriScheme.getNumber()));
                continue;
            }
            this.updateResource(commandContext, oriScheme, JSONRESOURCE, scheme.getLong("jsonresourceid"));
            this.updateResource(commandContext, oriScheme, JSONPATCH, scheme.getLong("jsonpatchid"));
            if (!oriScheme.isAcquiescence()) {
                this.updateCondition(commandContext, oriScheme, scheme.getLong("conditionid"));
                oriScheme.setState(scheme.getString("state"));
                oriScheme.setName(scheme.getLocaleString("name"));
            }
            oriScheme.setDescription(scheme.getLocaleString("description"));
            commandContext.getDynamicConfigSchemeEntityManager().update(oriScheme);
            this.disposeSchemeDynamicPartial(commandContext, oriScheme);
            this.recordBaseDataRef(commandContext, oriScheme);
            this.logger.debug(String.format("\u8986\u76d6\u5bfc\u5165\u65b9\u6848 -- \u6e05\u9664\u6d41\u7a0b\u5b9e\u4f8b\u7f13\u5b58\u548c\u64cd\u4f5c\u7f13\u5b58\uff01%s ", oriScheme.getId()));
            DynamicSchemeUtil.disposeCache(commandContext, oriScheme);
            DynamicSchemeUtil.disposeOperationCache(commandContext, oriScheme, new GetConfigSchemeBpmnModelCmd(oriScheme.getId()).execute(commandContext));
            this.saveModelModifyLog(oriScheme, commandContext);
        }
    }

    private void updateResource(CommandContext commandContext, DynamicConfigSchemeEntity oriScheme, String resourceType, Long newResourceId) {
        ModelEntity model;
        ProcessDefinitionEntity procDefEntity;
        Long oriResourceId = 0L;
        if (JSONRESOURCE.equals(resourceType)) {
            oriResourceId = oriScheme.getJsonResourceId();
        } else if (JSONPATCH.equals(resourceType)) {
            oriResourceId = oriScheme.getJsonPatchId();
        }
        ResourceEntityManager resManager = commandContext.getResourceEntityManager();
        ResourceEntity resource = (ResourceEntity)resManager.findById(oriResourceId);
        DynamicObject newResource = this.getResourceDataById(this.exportScheme.getResources(), newResourceId);
        ILocaleString content = null;
        if (newResource != null) {
            String data = newResource.getString(DATA);
            if (WfUtils.isEmpty(data)) {
                data = newResource.getString(CONTENT);
            }
            resource.setData(data);
            content = newResource.getLocaleString(CONTENT);
            resource.setContent(content);
        } else {
            this.logger.debug(String.format("\u8d44\u6e90\u6587\u4ef6\u4e3a\u7a7a\uff01OriResourceId: %s, NewResourceId: %s", oriResourceId, newResourceId));
        }
        resManager.update(resource);
        if (content != null && !WfUtils.isEmpty(content.toString()) && !JSONPATCH.equals(resourceType) && (procDefEntity = (ProcessDefinitionEntity)commandContext.getProcessDefinitionEntityManager().findById(oriScheme.getProcDefId())) != null && (model = (ModelEntity)commandContext.getModelEntityManager().findById(procDefEntity.getModelId())) != null) {
            ExtractMultiLanguageWordsUtil.repairMultiLangResWords(oriResourceId, model.getName().getLocaleValue_zh_CN(), model.getId(), model.getVersion());
            this.recordResourceRelation(newResourceId, model, oriScheme.getProcDefId(), oriResourceId);
        }
    }

    private void updateCondition(CommandContext commandContext, DynamicConfigSchemeEntity oriScheme, Long conditionId) {
        ConditionalRuleEntity oriCondition = (ConditionalRuleEntity)commandContext.getConditionRuleEntityManager().findById(oriScheme.getConditionId());
        for (DynamicObject condrule : this.exportScheme.getConditionalrules()) {
            if (!conditionId.equals(condrule.get("id"))) continue;
            oriCondition.setShowtext(condrule.getLocaleString("showtext"));
            oriCondition.setPlugin(condrule.getString("plugin"));
            oriCondition.setExpression(condrule.getString("expression"));
            oriCondition.setDescription(condrule.getLocaleString("description"));
            oriScheme.setConditionText(oriCondition.getShowtext());
            oriScheme.setConditionExpression(oriCondition.getExpression());
            this.updateConditionals(oriCondition, condrule);
            commandContext.getConditionRuleEntityManager().update(oriCondition);
            break;
        }
    }

    private void updateConditionals(ConditionalRuleEntity oriCondition, DynamicObject condrule) {
        DynamicObjectCollection items = condrule.getDynamicObjectCollection(ENTRYENTITY);
        ArrayList<ConditionalEntity> conditionals = new ArrayList<ConditionalEntity>();
        for (DynamicObject item : items) {
            conditionals.add(new ConditionalEntityImpl(null, oriCondition.getId(), item.getString("leftbracket"), item.getString("paramnumber"), item.getString("operation"), item.getString("value"), item.getString("rightbracket"), item.getString("logic"), item.getString("valuetype"), item.getString("entityNumber"), item.getInt("seq")));
        }
        oriCondition.setEntryentity(conditionals);
    }

    private DynamicObject getResourceDataById(List<DynamicObject> resources, Long id) {
        for (DynamicObject resource : resources) {
            if (!id.equals(resource.get("id"))) continue;
            return resource;
        }
        return null;
    }

    private void insertSchemes(CommandContext commandContext, Map<String, DynamicObject> schemeMap, Set<String> insertSchemeKeys, DynamicConfigSchemeEntity defScheme) {
        for (String key : insertSchemeKeys) {
            DynamicObject scheme = schemeMap.get(key);
            if (scheme.getBoolean("isdefault")) continue;
            DynamicConfigSchemeEntity newScheme = new DynamicConfigSchemeEntityImpl(scheme).clone();
            newScheme.setId(null);
            newScheme.setNumber(this.generateNumber(commandContext, newScheme.getNumber()));
            Long procDefId = null;
            if (defScheme != null) {
                procDefId = defScheme.getProcDefId();
                newScheme.setParentSchemeId(defScheme.getId());
                newScheme.setProcDefId(procDefId);
            }
            DynamicObject jsonResource = this.createSchemeResource(commandContext, scheme, JSONRESOURCE, this.exportScheme.getResources(), null, false);
            DynamicObject patchResource = this.createSchemeResource(commandContext, scheme, JSONPATCH, this.exportScheme.getResources(), null, false);
            if (jsonResource != null) {
                newScheme.setJsonResourceId(jsonResource.getLong("id"));
            } else {
                this.logger.debug("JsonResource \u8d44\u6e90\u6587\u4ef6\u4e3a\u7a7a\uff01" + key);
            }
            if (patchResource != null) {
                newScheme.setJsonPatchId(patchResource.getLong("id"));
            } else {
                this.logger.debug("patchResource \u8d44\u6e90\u6587\u4ef6\u4e3a\u7a7a\uff01" + key);
            }
            DynamicObject conditionalRule = this.createCondition(commandContext, scheme.getLong("conditionid"), this.exportScheme.getConditionalrules(), procDefId);
            if (conditionalRule != null) {
                newScheme.setConditionId(conditionalRule.getLong("id"));
            } else {
                this.logger.debug("\u65b9\u6848\u5e94\u7528\u6761\u4ef6\u4e3a\u7a7a\uff01" + key);
            }
            commandContext.getDynamicConfigSchemeEntityManager().insert(newScheme);
            this.disposeSchemeDynamicPartial(commandContext, newScheme);
            this.recordBaseDataRef(commandContext, newScheme);
        }
    }

    private void disposeSchemeDynamicPartial(CommandContext commandContext, DynamicConfigSchemeEntity scheme) {
        String modelJson = new GetConfigSchemeBpmnJsonStringCmd(scheme.getId(), null).execute(commandContext);
        BpmnModelUtil.disposeDynamicPartial(modelJson, scheme);
    }

    private void recordBaseDataRef(CommandContext commandContext, DynamicConfigSchemeEntity scheme) {
        String modelJson = new GetConfigSchemeBpmnJsonStringCmd(scheme.getId(), null).execute(commandContext);
        BpmnModelUtil.recordBaseDataRef(modelJson, scheme.getProcDefId(), scheme.getId());
    }

    /*
     * Exception decompiling
     */
    private Map<String, Object> importScheme(ExportScheme exportScheme, CommandContext commandContext) {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Started 2 blocks at once
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.getStartingBlocks(Op04StructuredStatement.java:412)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:487)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    private void createProcessInfos(CommandContext commandContext, Long procDefId) {
        try {
            new InitProcessInfoEntityCmd(procDefId).execute(commandContext);
        }
        catch (Exception e) {
            this.logger.error(String.format("initProcessInfoEntity failed! %s %s", procDefId, WfUtils.getExceptionStacktrace(e)));
        }
    }

    private void insertCommonBaseDatas(CommandContext commandContext, ExportScheme exportScheme) {
        ImportExportProcessUtil.insertRoles(commandContext, exportScheme.getRoles());
        ImportExportProcessUtil.insertCommonBaseData(exportScheme.getOrgType(), "wf_orgtype", true, true, false, ENTRYENTITY);
        ImportExportProcessUtil.insertKeyAuditors(commandContext, exportScheme.getKeyAuditor());
        try (TXHandle tx = TX.requiresNew();){
            ImportExportProcessUtil.insertCommonBaseData(exportScheme.getMobileFormConfig(), "bos_mobileformconfig", true, true, false, ENTRYENTITY);
        }
        ImportExportProcessUtil.insertMobileBillSummaryCfg(this.parameter.isCoverSummaryCfg(), exportScheme.getMobileBillSummaryCfg());
        ImportExportProcessUtil.insertCommonAuditComment(exportScheme.getCommonAuditComment(), "wf_commonauditcommenttree", true, false, false, null);
        ImportExportProcessUtil.insertCommonBaseData(exportScheme.getAuditCommentGroup(), "wf_auditcommentgroup", true, false, false, null);
        ImportExportProcessUtil.insertCommonBaseData(exportScheme.getExpressionExtension(), "wf_expressionext", true, false, false, null);
    }

    private void synchronizeResourceWords(CommandContext commandContext, ImportSchemeParameter parameter, Long targetProcDefId) {
        ProcessDefinitionEntityManager definitionEntityManager;
        ProcessDefinitionEntity srcDefinition;
        if (parameter == null) {
            return;
        }
        String srcProcDefId = parameter.getSyncResWordsId();
        if (!WfUtils.isEmpty(srcProcDefId) && (srcDefinition = (ProcessDefinitionEntity)(definitionEntityManager = commandContext.getProcessDefinitionEntityManager()).findById(Long.valueOf(srcProcDefId), "resourceid")) != null) {
            Long srcResourceId = srcDefinition.getResourceId();
            ProcessDefinitionEntity targetDefinition = (ProcessDefinitionEntity)definitionEntityManager.findById(targetProcDefId, "resourceid");
            if (targetDefinition != null) {
                Long targetResourceId = targetDefinition.getResourceId();
                ExtractMultiLanguageWordsUtil.synchronizeResourceWords(srcResourceId, targetResourceId);
            }
        }
    }

    private Map<String, Object> getProcessValidationResults(ProcessDefinitionEntity latestProcDef) {
        ArrayList<Long> processDefinitionIds = new ArrayList<Long>();
        processDefinitionIds.add(latestProcDef.getId());
        HashMap<String, Object> validateInformation = new HashMap<String, Object>();
        boolean validate = true;
        if (this.parameter != null && !this.parameter.isValidate()) {
            validate = false;
        }
        if (validate) {
            List<ValidationError> results = Context.getProcessEngineConfiguration().getRepositoryService().validateProcesses(processDefinitionIds);
            if (results != null && !results.isEmpty()) {
                validateInformation.put("validateResults", SerializationUtils.toJsonString(results));
            }
            validateInformation.put("procDefId", latestProcDef.getId());
        }
        return validateInformation;
    }

    private Long insertOrUpdateModel(CommandContext commandContext, Long newDeploymentId, ProcessCategoryEntity category) {
        List<DynamicObject> processDefinitions = this.exportScheme.getProcessDefinitions();
        String key = (String)processDefinitions.get(0).get("key");
        List models = commandContext.getModelEntityManager().findByQueryFilters(new QFilter[]{new QFilter("key", "=", (Object)key)});
        if (models != null && !models.isEmpty()) {
            return this.updateModel(this.exportScheme, commandContext, newDeploymentId, (ModelEntity)models.get(0));
        }
        return this.insertModel(this.exportScheme, commandContext, newDeploymentId, category);
    }

    private void recordResourceRelation(Long originalResourceId, ModelEntity newModel, Long newProcdefId, Long newResourceId) {
        List<DynamicObject> processDefinitions = this.exportScheme.getProcessDefinitions();
        DynamicObject processDefinition = processDefinitions.get(0);
        ImportExportProcessUtil.insertOrUpdateResRelation(processDefinition, originalResourceId, newModel, newProcdefId, newResourceId, this.isCover);
    }

    private Long updateModel(ExportScheme exportScheme, CommandContext commandContext, Long newDeploymentId, ModelEntity model) {
        ProcessDefinitionEntity processDefinitionEntity = Context.getProcessEngineConfiguration().getRepositoryService().getLatestProcessDefinitionByKey(model.getKey());
        if (processDefinitionEntity != null && !this.isCover) {
            model.setVersion(VersionUtils.getNextVersion(VersionUtils.getNextVersion(processDefinitionEntity.getVersion())));
        }
        if (WfUtils.isNotEmpty(newDeploymentId)) {
            model.setDeploymentId(newDeploymentId);
        }
        List<DynamicObject> processDefinitions = exportScheme.getProcessDefinitions();
        String businessId = "";
        if (processDefinitions != null && processDefinitions.get(0) != null && processDefinitions.get(0).getString("businessid") != null) {
            businessId = processDefinitions.get(0).getString("businessid");
        }
        model.setBusinessId(StringUtils.isBlank((CharSequence)businessId) ? String.valueOf(model.getKey()) : businessId);
        if (processDefinitions != null && processDefinitions.get(0).get("primarysubprocess") != null) {
            model.setPrimarySubprocess(processDefinitions.get(0).getString("primarysubprocess"));
        }
        commandContext.getModelEntityManager().update(model);
        Long bpmnJosnId = model.getBPMNXMLID();
        ResourceEntity bpmnJosnResource = (ResourceEntity)new GetSingleEntityCmd(bpmnJosnId, "wf_resource").execute(commandContext);
        Map<String, Object> defaultJSONs = this.getDefualtSchemeResource(exportScheme);
        String data = null;
        ILocaleString content = null;
        String currentLanguage = null;
        if (defaultJSONs != null) {
            JSONObject dataJsonObject = this.setOrgUnitId((String)defaultJSONs.get(DATA));
            data = JSONObject.toJSONString((Object)dataJsonObject);
            content = (ILocaleString)defaultJSONs.get(CONTENT);
            currentLanguage = (String)defaultJSONs.get(CURRENTLANGUAGE);
        }
        String defaultJSON = "";
        defaultJSON = WfUtils.isEmpty(data) && content != null ? content.getLocaleValue() : data;
        BpmnModel newBpmnModel = this.getNewBpmnModel(exportScheme, commandContext, defaultJSON);
        String newBpmnJson = GraphCodecUtils.convertBpmnModelToJSON(newBpmnModel);
        bpmnJosnResource.setData(newBpmnJson);
        bpmnJosnResource.setCurrentLanguage(currentLanguage);
        bpmnJosnResource.setContent(content);
        commandContext.getResourceEntityManager().update(bpmnJosnResource);
        Long modelId = model.getId();
        BpmnModelUtil.disposeDynamicPartial(newBpmnJson, modelId);
        ExtractMultiLanguageWordsUtil.repairMultiLangResWords(bpmnJosnId, model.getName().getLocaleValue_zh_CN(), modelId, model.getVersion());
        Long originalResourceId = 0L;
        List<DynamicObject> processModels = exportScheme.getProcessModel();
        if (processModels != null && !processModels.isEmpty()) {
            originalResourceId = processModels.get(0).getLong("bpmnxmlid");
        }
        this.recordResourceRelation(originalResourceId, model, 0L, bpmnJosnId);
        return modelId;
    }

    private JSONObject setOrgUnitId(String data) {
        JSONObject dataJsonObject = JSONObject.parseObject((String)data);
        try {
            JSONObject properties = (JSONObject)dataJsonObject.get((Object)"properties");
            properties.put("orgUnitId", (Object)RequestContext.get().getOrgId());
            return dataJsonObject;
        }
        catch (Exception e) {
            this.logger.warn(String.format("ImportSchemeCmd,setOrgUnitId:set org error:%s", WfUtils.getExceptionStacktrace(e)));
            return dataJsonObject;
        }
    }

    private BpmnModel getNewBpmnModel(ExportScheme exportScheme, CommandContext commandContext, String defaultJSON) {
        BpmnModel bpmnModel = ProcessDefinitionUtil.getBpmnModel(defaultJSON);
        List<DynamicObject> processConfigs = exportScheme.getProcessConfigs();
        if (processConfigs == null || processConfigs.isEmpty()) {
            return bpmnModel;
        }
        String condruleId = processConfigs.get(0).getString("condruleid");
        List<DynamicObject> conditionalrules = exportScheme.getConditionalrules();
        for (DynamicObject conditionalrule : conditionalrules) {
            if (!condruleId.equals(conditionalrule.getString("id"))) continue;
            ConditionalRuleEntity conditionRuleEntity = (ConditionalRuleEntity)commandContext.getConditionRuleEntityManager().create();
            conditionRuleEntity.setId(null);
            conditionRuleEntity.setShowtext(conditionalrule.getLocaleString("showtext"));
            conditionRuleEntity.setDescription(conditionalrule.getLocaleString("description"));
            conditionRuleEntity.setExpression(conditionalrule.getString("expression"));
            conditionRuleEntity.setPlugin(conditionalrule.getString("plugin"));
            conditionRuleEntity.setType(conditionalrule.getString("type"));
            DynamicObjectCollection entryEntityObjects = conditionalrule.getDynamicObjectCollection(ENTRYENTITY);
            ArrayList<ConditionalEntity> entryentity = new ArrayList<ConditionalEntity>();
            for (DynamicObject entryEntityObject : entryEntityObjects) {
                ConditionalEntityImpl conditionalEntity = new ConditionalEntityImpl();
                conditionalEntity.setId(null);
                conditionalEntity.setLeftbracket(entryEntityObject.getString("leftbracket"));
                conditionalEntity.setParamnumber(entryEntityObject.getString("paramnumber"));
                conditionalEntity.setOperation(entryEntityObject.getString("operation"));
                conditionalEntity.setValue(entryEntityObject.getString("value"));
                conditionalEntity.setRightbracket(entryEntityObject.getString("rightbracket"));
                conditionalEntity.setLogic(entryEntityObject.getString("logic"));
                conditionalEntity.setValuetype(entryEntityObject.getString("valuetype"));
                entryentity.add(conditionalEntity);
            }
            conditionRuleEntity.setEntryentity(entryentity);
            conditionRuleEntity.setElementid(conditionalrule.getString("elementid"));
            conditionRuleEntity.setProperty(conditionalrule.getString("property"));
            bpmnModel.getMainProcess().setStartupcondrule(conditionRuleEntity);
            break;
        }
        return bpmnModel;
    }

    private Long insertModel(ExportScheme exportScheme, CommandContext commandContext, Long newDeploymentId, ProcessCategoryEntity category) {
        Map<String, Object> defaultJSONs = this.getDefualtSchemeResource(exportScheme);
        String data = null;
        ILocaleString content = null;
        String currentLanguage = null;
        if (defaultJSONs != null) {
            data = (String)defaultJSONs.get(DATA);
            content = (ILocaleString)defaultJSONs.get(CONTENT);
            currentLanguage = (String)defaultJSONs.get(CURRENTLANGUAGE);
        }
        String defaultJSON = "";
        defaultJSON = WfUtils.isEmpty(data) && content != null ? content.getLocaleValue() : data;
        BpmnModel bpmnModel = this.getNewBpmnModel(exportScheme, commandContext, defaultJSON);
        ResourceEntity graphJson = (ResourceEntity)commandContext.getResourceEntityManager().create();
        List<DynamicObject> processDefinitions = exportScheme.getProcessDefinitions();
        DynamicObject processDef = processDefinitions.get(0);
        String modelKey = (String)processDef.get("key");
        String businessId = (String)processDef.get("businessid");
        String graphJsonName = String.format("%s.%s", modelKey, "graph_json");
        graphJson.setId(null);
        graphJson.setName(graphJsonName);
        graphJson.setDeploymentId(null);
        String graphJsonString = GraphCodecUtils.convertBpmnModelToJSON(bpmnModel);
        graphJson.setData(graphJsonString);
        graphJson.setGenerated(false);
        graphJson.setCurrentLanguage(currentLanguage);
        graphJson.setContent(content);
        commandContext.getResourceEntityManager().insert(graphJson);
        String graphXmlName = String.format("%s.%s", modelKey, "graph_xml");
        ResourceEntity graphXml = (ResourceEntity)commandContext.getResourceEntityManager().create();
        graphXml.setId(null);
        graphXml.setName(graphXmlName);
        graphXml.setDeploymentId(null);
        graphXml.setData(GraphCodecUtils.convertBpmnModelToXML(bpmnModel));
        graphXml.setGenerated(false);
        commandContext.getResourceEntityManager().insert(graphXml);
        ModelEntity model = (ModelEntity)commandContext.getModelEntityManager().create();
        Long graphJsonId = graphJson.getId();
        model.setBPMNXMLID(graphJsonId);
        model.setGraphId(graphXml.getId());
        model.setVersion("0002");
        model.setDeploymentId(newDeploymentId);
        model.setPublish(true);
        model.setOrgUnitId(RequestContext.get().getOrgId());
        model.setCreatorId(Long.valueOf(RequestContext.get().getUserId()));
        model.setModifierId(Long.valueOf(RequestContext.get().getUserId()));
        model.setCreateDate(Context.getProcessEngineConfiguration().getClock().getCurrentTime());
        model.setModifyDate(Context.getProcessEngineConfiguration().getClock().getCurrentTime());
        model.setKey(modelKey);
        model.setBusinessId(StringUtils.isBlank((CharSequence)businessId) ? modelKey : businessId);
        if (processDef.get("primarysubprocess") != null) {
            model.setPrimarySubprocess(processDef.getString("primarysubprocess"));
        }
        String modelName = processDef.getString("name");
        model.setName(modelName);
        model.setDescription(processDef.getString("description"));
        model.setCategory(category.getId());
        model.setEntraBill(processDef.getString("entrabill"));
        String entraBillId = WfUtils.isEmpty(processDef.getString("entrabillid")) ? processDef.getString("entrabillid_id") : " ";
        model.setEntraBillId(entraBillId);
        String applicationId = processDef.getString("applicationid");
        if (WfUtils.isEmpty(applicationId)) {
            applicationId = WfUtils.getApplicationIdByBillId(entraBillId);
        }
        model.setApplicationId(applicationId);
        model.setOperation(processDef.getString("operation"));
        model.setType(processDef.getString("type"));
        String entityNumber = processDef.getString("key");
        QFilter filters = new QFilter("key", "=", (Object)entityNumber);
        boolean exist = QueryServiceHelper.exists((String)"wf_model", (QFilter[])new QFilter[]{filters});
        if (exist) {
            String fields = commandContext.getModelEntityManager().getSelectFields();
            DynamicObject[] existModels = BusinessDataServiceHelper.load((String)"wf_model", (String)fields, (QFilter[])new QFilter[]{filters}, null);
            for (int i = 0; i < existModels.length; ++i) {
                DynamicObject existModel = existModels[i];
                commandContext.getModelEntityManager().delete((Long)existModel.get("id"));
            }
        }
        commandContext.getModelEntityManager().insert(model);
        Long modelId = model.getId();
        BpmnModelUtil.disposeDynamicPartial(graphJsonString, modelId);
        ExtractMultiLanguageWordsUtil.repairMultiLangResWords(graphJsonId, modelName, modelId, model.getVersion());
        Long originalResourceId = 0L;
        List<DynamicObject> processModels = exportScheme.getProcessModel();
        if (processModels != null && !processModels.isEmpty()) {
            originalResourceId = processModels.get(0).getLong("bpmnxmlid");
        }
        this.recordResourceRelation(originalResourceId, model, 0L, graphJsonId);
        return modelId;
    }

    private Map<String, Object> getDefualtSchemeResource(ExportScheme exportScheme) {
        List<DynamicObject> schemes = exportScheme.getSchemes();
        String jsonresourceid = "";
        HashMap<String, Object> datas = new HashMap<String, Object>();
        for (DynamicObject scheme : schemes) {
            if (!scheme.getBoolean("isdefault")) continue;
            jsonresourceid = String.valueOf(scheme.get("jsonresourceid"));
            break;
        }
        List<DynamicObject> resources = exportScheme.getResources();
        for (DynamicObject resource : resources) {
            if (!jsonresourceid.equals(resource.getPkValue().toString())) continue;
            datas.put(DATA, resource.getString(DATA));
            datas.put(CONTENT, resource.getLocaleString(CONTENT));
            datas.put(CURRENTLANGUAGE, resource.getString(CURRENTLANGUAGE));
            return datas;
        }
        return null;
    }

    private void insertDeployments(CommandContext commandContext, List<DynamicObject> deployments) {
        if (deployments == null || deployments.isEmpty()) {
            return;
        }
        DeploymentEntityManager deployEntityManager = commandContext.getDeploymentEntityManager();
        long[] deploymentIds = ORM.create().genLongIds("wf_deployment", deployments.size());
        int i = 0;
        for (DynamicObject deployment : deployments) {
            deployment.set("id", (Object)deploymentIds[i]);
            String deployName = "publish" + System.currentTimeMillis();
            deployment.set("name", (Object)deployName);
            deployment.set("deploymenttime", (Object)Context.getProcessEngineConfiguration().getClock().getCurrentTime());
            deployEntityManager.insert(deployEntityManager.create(deployment));
            ++i;
        }
    }

    private DynamicObject insertProcessDefinitions(CommandContext commandContext, ExportScheme scheme, Long newDeploymentId, Long modelId, ProcessCategoryEntity category) {
        ModelEntity model;
        List<DynamicObject> processDefinitions = scheme.getProcessDefinitions();
        DynamicObject processDefinition = processDefinitions.get(0);
        String key = processDefinition.getString("key");
        ProcessDefinitionEntity processDefinitionEntity = Context.getProcessEngineConfiguration().getRepositoryService().getLatestProcessDefinitionByKey(key);
        String procdefVersion = "";
        if (processDefinitionEntity != null) {
            procdefVersion = VersionUtils.getNextVersion(processDefinitionEntity.getVersion());
            processDefinitionEntity.setVersionState("historical");
            commandContext.getProcessDefinitionEntityManager().update(processDefinitionEntity);
        } else {
            procdefVersion = "0001";
        }
        Long originalResourceId = processDefinition.getLong("resourceid");
        DynamicObject resourceObject = this.createSchemeResource(commandContext, originalResourceId, scheme.getResources(), newDeploymentId, true);
        Long resourcePK = null;
        String data = null;
        String content = null;
        if (resourceObject != null) {
            resourcePK = (Long)resourceObject.getPkValue();
            JSONObject dataJsonObject = this.setOrgUnitId(resourceObject.getString(DATA));
            data = JSONObject.toJSONString((Object)dataJsonObject);
            resourceObject.set(DATA, (Object)data);
            content = resourceObject.getLocaleString(CONTENT).getLocaleValue();
        }
        if ((model = (ModelEntity)commandContext.getModelEntityManager().findById(modelId)) != null) {
            ExtractMultiLanguageWordsUtil.repairMultiLangResWords(resourcePK, model.getName().getLocaleValue_zh_CN(), modelId, model.getVersion());
        }
        ProcessDefinitionEntity definitionEntity = (ProcessDefinitionEntity)commandContext.getProcessDefinitionEntityManager().create();
        definitionEntity.setResourceId(resourcePK);
        definitionEntity.setVersionState("newest");
        definitionEntity.setDeploymentId(newDeploymentId);
        definitionEntity.setModelId(modelId);
        String businessId = processDefinition.getString("businessid");
        businessId = StringUtils.isEmpty((CharSequence)businessId) ? key : businessId;
        definitionEntity.setBusinessId(businessId);
        definitionEntity.setOrgUnitId(RequestContext.get().getOrgId());
        definitionEntity.setCreatorId(Long.valueOf(RequestContext.get().getUserId()));
        definitionEntity.setModifierId(Long.valueOf(RequestContext.get().getUserId()));
        definitionEntity.setCreateDate(Context.getProcessEngineConfiguration().getClock().getCurrentTime());
        definitionEntity.setModifyDate(Context.getProcessEngineConfiguration().getClock().getCurrentTime());
        definitionEntity.setKey(processDefinition.getString("key"));
        definitionEntity.setCategory(processDefinition.getString("category"));
        definitionEntity.setCategoryName(category.getName());
        definitionEntity.setVersion(procdefVersion);
        definitionEntity.setGraphicalDefined(true);
        definitionEntity.setEnable("disable");
        definitionEntity.setEntraBill(processDefinition.getString("entrabill"));
        String entraBillId = WfUtils.isEmpty(processDefinition.getString("entrabillid")) ? processDefinition.getString("entrabillid_id") : processDefinition.getString("entrabillid");
        definitionEntity.setEntraBillId(entraBillId);
        String applicationId = processDefinition.getString("applicationid");
        if (WfUtils.isEmpty(applicationId)) {
            applicationId = WfUtils.getApplicationIdByBillId(entraBillId);
        }
        definitionEntity.setApplicationId(applicationId);
        definitionEntity.setOperation(processDefinition.getString("operation"));
        definitionEntity.setParentProcId(processDefinition.getLong("parentprocid"));
        definitionEntity.setType(processDefinition.getString("type"));
        definitionEntity.setCategoryId(category.getId());
        definitionEntity.setName(processDefinition.getLocaleString("name"));
        definitionEntity.setDescription(processDefinition.getLocaleString("description"));
        definitionEntity.setVersionDesc(processDefinition.getString("versiondesc"));
        definitionEntity.setPublishName(WfUtils.findUserName(Long.valueOf(RequestContext.get().getUserId())));
        if (processDefinition.get("primarysubprocess") != null) {
            definitionEntity.setPrimarySubprocess(processDefinition.getString("primarysubprocess"));
        }
        commandContext.getProcessDefinitionEntityManager().insert(definitionEntity);
        this.recordResourceRelation(originalResourceId, model, definitionEntity.getId(), resourcePK);
        BpmnModel bpmnModel = this.disposeEventSubscription(commandContext, procdefVersion, data, content, definitionEntity);
        List<ProcessOperation> operations = this.insertProcessDefinitionInfoEntity(commandContext, definitionEntity, bpmnModel);
        WfCacheHelper.updateProcessDefWhenStateChange(commandContext, definitionEntity.getEntraBill(), operations);
        return definitionEntity.getDynamicObject();
    }

    private BpmnModel disposeEventSubscription(CommandContext commandContext, String procdefVersion, String data, String content, ProcessDefinitionEntity definitionEntity) {
        BpmnModel bpmnModel = ProcessDefinitionUtil.getBpmnModel(WfUtils.isNotEmpty(data) ? data : content);
        if (BizFlowUtil.isBizFlow(bpmnModel)) {
            BizFlowUtil.addBizFlowSignalEventSubscriptions(commandContext, definitionEntity, bpmnModel.getMainProcess(), bpmnModel);
        } else {
            for (FlowElement element : bpmnModel.getMainProcess().getFlowElements()) {
                if (!(element instanceof StartEvent)) continue;
                StartEvent startEvent = (StartEvent)element;
                if (!CollectionUtil.isNotEmpty(startEvent.getEventDefinitions())) break;
                EventDefinition eventDefinition = startEvent.getEventDefinitions().get(0);
                this.insertEventSubscription(commandContext, procdefVersion, definitionEntity, bpmnModel, startEvent, eventDefinition);
                break;
            }
        }
        return bpmnModel;
    }

    private void insertEventSubscription(CommandContext commandContext, String procdefVersion, ProcessDefinitionEntity definitionEntity, BpmnModel bpmnModel, StartEvent startEvent, EventDefinition eventDefinition) {
        if (eventDefinition instanceof SignalEventDefinition) {
            SignalEventDefinition signalEventDefinition = (SignalEventDefinition)eventDefinition;
            SignalEventSubscriptionEntity subscriptionEntity = commandContext.getEventSubscriptionEntityManager().createSignalEventSubscription();
            Signal signal = bpmnModel.getSignal(signalEventDefinition.getSignalRef());
            if (signal != null) {
                subscriptionEntity.setEventName(signal.getName());
            } else {
                subscriptionEntity.setEventName(signalEventDefinition.getSignalRef());
            }
            subscriptionEntity.setActivityId(startEvent.getId());
            subscriptionEntity.setProcessDefinitionId(definitionEntity.getId());
            subscriptionEntity.setVersion(procdefVersion);
            commandContext.getEventSubscriptionEntityManager().insert(subscriptionEntity);
        }
    }

    private List<ProcessOperation> insertProcessDefinitionInfoEntity(CommandContext commandContext, ProcessDefinitionEntity definitionEntity, BpmnModel bpmnModel) {
        BpmnDeploymentHelper bpmnDeploymentHelper = new BpmnDeploymentHelper();
        List<ProcessOperation> operations = bpmnDeploymentHelper.getAllProcessOperations(bpmnModel);
        if (operations != null && !operations.isEmpty()) {
            for (ProcessOperation po : operations) {
                ProcessDefinitionInfoEntity entity = this.getProcessDefinitionInfoEntity(po.getElement(), definitionEntity, po.getOp(), po.getEntityNumber());
                commandContext.getProcessDefinitionInfoEntityManager().insert(entity);
            }
        }
        return operations;
    }

    private ProcessDefinitionInfoEntity getProcessDefinitionInfoEntity(BaseElement element, ProcessDefinitionEntity processDefinition, String operation, String entityNumber) {
        ProcessDefinitionInfoEntityImpl infoEntityImpl = new ProcessDefinitionInfoEntityImpl();
        infoEntityImpl.setActId(element == null ? null : element.getId());
        infoEntityImpl.setEntityNumber(entityNumber);
        infoEntityImpl.setOperation(operation);
        infoEntityImpl.setProcessDefinitionId(processDefinition.getId());
        return infoEntityImpl;
    }

    private List<DynamicConfigSchemeEntity> insertSchemes(ExportScheme exportScheme, CommandContext commandContext, DynamicObject processDefinition, Long newDeploymentId) {
        Object scheme;
        int i;
        List<DynamicObject> schemes = exportScheme.getSchemes();
        if (schemes == null || schemes.isEmpty()) {
            return null;
        }
        Long parentSchemeId = null;
        ArrayList<DynamicConfigSchemeEntity> rets = new ArrayList<DynamicConfigSchemeEntity>();
        for (i = 0; i < schemes.size(); ++i) {
            scheme = schemes.get(i);
            if (!scheme.getBoolean("isdefault")) continue;
            boolean isdefault = scheme.getBoolean("isdefault");
            DynamicConfigSchemeEntity parentScheme = this.insertScheme(commandContext, exportScheme, processDefinition, (DynamicObject)scheme, parentSchemeId, newDeploymentId, isdefault);
            parentSchemeId = parentScheme.getId();
            rets.add(parentScheme);
            break;
        }
        for (i = 0; i < schemes.size(); ++i) {
            scheme = schemes.get(i);
            if (scheme.getBoolean("isdefault")) continue;
            rets.add(this.insertScheme(commandContext, exportScheme, processDefinition, (DynamicObject)scheme, parentSchemeId, newDeploymentId, false));
        }
        for (int j = 0; j < rets.size(); ++j) {
            scheme = (DynamicConfigSchemeEntity)rets.get(j);
            Long schemeId = scheme.getId();
            String modelJson = new GetConfigSchemeBpmnJsonStringCmd(schemeId, null).execute(commandContext);
            BpmnModelUtil.disposeDynamicPartial(modelJson, (DynamicConfigSchemeEntity)scheme);
            BpmnModelUtil.recordBaseDataRef(modelJson, scheme.getProcDefId(), scheme.getId());
        }
        return rets;
    }

    private DynamicConfigSchemeEntity insertScheme(CommandContext commandContext, ExportScheme exportScheme, DynamicObject processDefinition, DynamicObject scheme, Long parentSchemeId, Long newDeploymentId, boolean isdefault) {
        Long proDefId = processDefinition.getLong("id");
        DynamicConfigSchemeEntity schemeEntity = (DynamicConfigSchemeEntity)commandContext.getDynamicConfigSchemeEntityManager().create();
        DynamicObject rule = this.createCondition(commandContext, scheme.getLong("conditionid"), exportScheme.getConditionalrules(), proDefId);
        if (rule != null) {
            schemeEntity.setConditionId((Long)rule.getPkValue());
            schemeEntity.setConditionExpression(rule.getString("expression"));
        }
        schemeEntity.setParentSchemeId(parentSchemeId);
        schemeEntity.setProcDefId(proDefId);
        schemeEntity.setCreatorId(Long.valueOf(RequestContext.get().getUserId()));
        schemeEntity.setModifierId(Long.valueOf(RequestContext.get().getUserId()));
        schemeEntity.setCreateDate(Context.getProcessEngineConfiguration().getClock().getCurrentTime());
        schemeEntity.setModifyDate(Context.getProcessEngineConfiguration().getClock().getCurrentTime());
        DynamicObject pathRes = this.createSchemeResource(commandContext, scheme, JSONPATCH, exportScheme.getResources(), newDeploymentId, false);
        schemeEntity.setJsonPatchId(pathRes == null ? null : (Long)pathRes.getPkValue());
        schemeEntity.setAcquiescence(isdefault);
        if (isdefault) {
            schemeEntity.setState("enable");
            schemeEntity.setJsonResourceId(processDefinition.getLong("resourceid"));
            schemeEntity.setNumber(DynamicSchemeUtil.getDefaultSchemeNumber(processDefinition.getString("key"), processDefinition.getString("version")));
            schemeEntity.setSourceKey(schemeEntity.getNumber());
        } else {
            schemeEntity.setState("");
            DynamicObject jsonRes = this.createSchemeResource(commandContext, scheme, JSONRESOURCE, exportScheme.getResources(), newDeploymentId, false);
            schemeEntity.setJsonResourceId(jsonRes == null ? null : (Long)jsonRes.getPkValue());
            String schemeNumber = scheme.getString("number");
            schemeEntity.setNumber(this.generateNumber(commandContext, schemeNumber));
            String sourceKey = scheme.getString("sourcekey");
            if (WfUtils.isEmpty(sourceKey)) {
                sourceKey = scheme.getString("number");
            }
            schemeEntity.setSourceKey(sourceKey);
        }
        schemeEntity.setName(scheme.getLocaleString("name"));
        schemeEntity.setDescription(scheme.getLocaleString("description"));
        schemeEntity.setConditionText(scheme.getLocaleString("conditiontext"));
        schemeEntity.setOldSchemeId(scheme.getLong("id"));
        commandContext.getDynamicConfigSchemeEntityManager().insert(schemeEntity);
        return schemeEntity;
    }

    private String generateNumber(CommandContext commandContext, String schemeNumber) {
        if (schemeNumber.matches("((^[\\w]+)_sync)\\d*$")) {
            return DynamicSchemeUtil.getSynchronizeSchemeNumber(commandContext, schemeNumber);
        }
        return DynamicSchemeUtil.getImportedSchemeNumber(commandContext, schemeNumber);
    }

    private DynamicObject createSchemeResource(CommandContext commandContext, Long schemeResId, List<DynamicObject> resources, Long newDeploymentId, boolean isdefault) {
        if (resources == null || resources.isEmpty() || WfUtils.isEmpty(schemeResId)) {
            return null;
        }
        DynamicObject resourceObject = this.findDefaultSchemeResource(resources, newDeploymentId, isdefault, schemeResId);
        if (resourceObject != null) {
            ResourceEntity resourceEntity = this.createResourceEntity(commandContext, resourceObject);
            return resourceEntity.getDynamicObject();
        }
        return null;
    }

    private DynamicObject createSchemeResource(CommandContext commandContext, DynamicObject scheme, String resourceType, List<DynamicObject> resources, Long newDeploymentId, boolean isdefault) {
        Long schemeResId = 0L;
        if (JSONRESOURCE.equals(resourceType)) {
            schemeResId = scheme.getLong("jsonresourceid");
        } else if (JSONPATCH.equals(resourceType)) {
            schemeResId = scheme.getLong("jsonpatchid");
        }
        if (resources == null || resources.isEmpty() || WfUtils.isEmpty(schemeResId)) {
            return null;
        }
        DynamicObject resourceObject = this.findDefaultSchemeResource(resources, newDeploymentId, isdefault, schemeResId);
        if (resourceObject == null) {
            return null;
        }
        ResourceEntity resourceEntity = this.createResourceEntity(commandContext, resourceObject);
        ILocaleString content = resourceEntity.getContent();
        if (content != null && !WfUtils.isEmpty(content.toString()) && !JSONPATCH.equals(resourceType)) {
            Long procDefId = scheme.getLong("processdefinitionid");
            ProcessDefinitionEntity procDefEntity = (ProcessDefinitionEntity)commandContext.getProcessDefinitionEntityManager().findById(procDefId);
            if (procDefEntity == null) {
                return resourceEntity.getDynamicObject();
            }
            ModelEntity model = (ModelEntity)commandContext.getModelEntityManager().findById(procDefEntity.getModelId());
            if (model != null) {
                ExtractMultiLanguageWordsUtil.repairMultiLangResWords(resourceEntity.getId(), model.getName().getLocaleValue_zh_CN(), model.getId(), model.getVersion());
                this.recordResourceRelation(resourceObject.getLong("id"), model, procDefId, resourceEntity.getId());
            }
        }
        return resourceEntity.getDynamicObject();
    }

    private DynamicObject findDefaultSchemeResource(List<DynamicObject> resources, Long newDeploymentId, boolean isdefault, Long schemeResId) {
        DynamicObject resourceObject = null;
        for (DynamicObject resource : resources) {
            if (!schemeResId.equals(resource.getPkValue())) continue;
            resourceObject = resource;
            if (!isdefault) break;
            resourceObject.set("deploymentid", (Object)newDeploymentId);
            break;
        }
        return resourceObject;
    }

    private ResourceEntity createResourceEntity(CommandContext commandContext, DynamicObject resourceObject) {
        ResourceEntity resourceEntity = (ResourceEntity)commandContext.getResourceEntityManager().create();
        resourceEntity.setId(null);
        resourceEntity.setName(resourceObject.getString("name"));
        resourceEntity.setDeploymentId(resourceObject.getLong("deploymentid"));
        String data = resourceObject.getString(DATA);
        if (WfUtils.isEmpty(data)) {
            data = resourceObject.getString(CONTENT);
        }
        resourceEntity.setData(data);
        resourceEntity.setGenerated(resourceObject.getBoolean("generated"));
        resourceEntity.setCurrentLanguage(resourceObject.getString(CURRENTLANGUAGE));
        resourceEntity.setContent(resourceObject.getLocaleString(CONTENT));
        commandContext.getResourceEntityManager().insert(resourceEntity);
        return resourceEntity;
    }

    private DynamicObject createCondition(CommandContext commandContext, Long conditionId, List<DynamicObject> conditionalrules, Long processDefinitionId) {
        if (conditionalrules == null || conditionalrules.isEmpty() || WfUtils.isEmpty(conditionId)) {
            return null;
        }
        DynamicObject conditionalruleObject = null;
        for (DynamicObject conditionalrule : conditionalrules) {
            if (!conditionId.equals(conditionalrule.getPkValue())) continue;
            conditionalruleObject = conditionalrule;
            break;
        }
        if (conditionalruleObject != null) {
            DynamicObjectCollection conditions = conditionalruleObject.getDynamicObjectCollection(ENTRYENTITY);
            ConditionalRuleEntity conditionalRuleEntity = (ConditionalRuleEntity)commandContext.getConditionRuleEntityManager().create();
            ArrayList<ConditionalEntity> detail = new ArrayList<ConditionalEntity>();
            for (DynamicObject condition : conditions) {
                ConditionalEntityImpl conditionalEntity = new ConditionalEntityImpl();
                conditionalEntity.setLeftbracket(condition.getString("leftbracket"));
                conditionalEntity.setParamnumber(condition.getString("paramnumber"));
                conditionalEntity.setOperation(condition.getString("operation"));
                conditionalEntity.setValue(condition.getString("value"));
                conditionalEntity.setRightbracket(condition.getString("rightbracket"));
                conditionalEntity.setLogic(condition.getString("logic"));
                conditionalEntity.setValuetype(condition.getString("valuetype"));
                detail.add(conditionalEntity);
            }
            conditionalRuleEntity.setEntryentity(detail);
            conditionalRuleEntity.setId(null);
            conditionalRuleEntity.setProcdefid(processDefinitionId);
            conditionalRuleEntity.setType(conditionalruleObject.getString("type"));
            conditionalRuleEntity.setElementid(conditionalruleObject.getString("elementid"));
            conditionalRuleEntity.setValidtime(conditionalruleObject.getDate("validtime"));
            conditionalRuleEntity.setExpression(conditionalruleObject.getString("expression"));
            conditionalRuleEntity.setPlugin(conditionalruleObject.getString("plugin"));
            conditionalRuleEntity.setVersion(conditionalruleObject.getString("version"));
            conditionalRuleEntity.setProperty(conditionalruleObject.getString("property"));
            conditionalRuleEntity.setShowtext(conditionalruleObject.getLocaleString("showtext"));
            conditionalRuleEntity.setDescription(conditionalruleObject.getLocaleString("description"));
            commandContext.getConditionRuleEntityManager().insert(conditionalRuleEntity);
            return conditionalRuleEntity.getDynamicObject();
        }
        return null;
    }

    private void insertProcessConfigs(ExportScheme exportScheme, List<DynamicObject> processConfigs, DynamicObject processDefinition, CommandContext commandContext) {
        Long processDefinitionId = processDefinition.getLong("id");
        if (processConfigs == null || processConfigs.isEmpty()) {
            return;
        }
        ResourceEntity resource = (ResourceEntity)commandContext.getResourceEntityManager().findById(processDefinition.getLong("resourceid"));
        BpmnModel bpmnModel = ProcessDefinitionUtil.getBpmnModel(resource.getData());
        boolean isBizFlow = ModelType.BizFlow.name().equals(bpmnModel.getMainProcess().getProcessType());
        for (int i = 0; i < processConfigs.size(); ++i) {
            ProcessConfigEntity config = null;
            DynamicObject processConfig = processConfigs.get(i);
            config = isBizFlow ? commandContext.getProcessConfigEntityManager().create(bpmnModel, processDefinition, processConfig) : commandContext.getProcessConfigEntityManager().getOrCreateProcessConfig(processDefinitionId);
            this.updateProcessconfigCondition(exportScheme, commandContext, processDefinitionId, config, processConfig);
        }
    }

    private void updateProcessconfigCondition(ExportScheme exportScheme, CommandContext commandContext, Long processDefinitionId, ProcessConfigEntity config, DynamicObject processConfig) {
        DynamicObject rule = this.createCondition(commandContext, processConfig.getLong("condruleid"), exportScheme.getConditionalrules(), processDefinitionId);
        if (rule != null) {
            config.setCondRuleId((Long)rule.getPkValue());
            String expression = rule.getString("expression");
            config.setStartCondition(WfUtils.isNotEmpty(expression) ? expression : rule.getString("plugin"));
        }
        commandContext.getProcessConfigEntityManager().update(config);
    }

    private void insertParticipantModelCfgs(CommandContext commandContext, List<DynamicObject> participantModelCfgs) {
        if (participantModelCfgs == null || participantModelCfgs.isEmpty()) {
            return;
        }
        for (int i = 0; i < participantModelCfgs.size(); ++i) {
            DynamicObject participantModelCfg = participantModelCfgs.get(i);
            ParticipantModelCfgEntity participantModelCfgEntity = Context.getProcessEngineConfiguration().getRepositoryService().getParticipantModelCfgEntityByCfgNumber((String)participantModelCfg.get("number"));
            if (participantModelCfgEntity != null) continue;
            ParticipantModelCfgEntity entity = (ParticipantModelCfgEntity)commandContext.getParticipantModelCfgEntityManager().create();
            entity.setId(null);
            entity.setName(participantModelCfg.getString("name"));
            entity.setNumber(participantModelCfg.getString("number"));
            entity.setType(participantModelCfg.getString("type"));
            entity.setFormid(participantModelCfg.getString("formid"));
            entity.setParser(participantModelCfg.getString("parser"));
            entity.setApplicationid(participantModelCfg.getString("applicationid"));
            entity.setApplicationName(participantModelCfg.getString("applicationname"));
            commandContext.getParticipantModelCfgEntityManager().insert(entity);
        }
    }

    private void insertBillSubject(CommandContext commandContext, List<DynamicObject> billSubject) {
        if (billSubject == null || billSubject.isEmpty()) {
            return;
        }
        BillSubjectModelEntity billEntity = (BillSubjectModelEntity)commandContext.getBillSubjectModelEntityManager().create();
        DynamicObject resource = billSubject.get(0);
        String entityNumber = resource.getString("entityNumber");
        boolean exist = QueryServiceHelper.exists((String)"wf_billsubjectmodel", (QFilter[])new QFilter[]{new QFilter("entityNumber", "=", (Object)entityNumber)});
        if (!exist) {
            billEntity.setId(null);
            billEntity.setBillId(resource.getString("billId"));
            billEntity.setEntityNumber(resource.getString("entityNumber"));
            billEntity.setFormKey(resource.getString("formKey"));
            billEntity.setCreatorId(resource.getLong("creatorId"));
            billEntity.setCreateDate(Context.getProcessEngineConfiguration().getClock().getCurrentTime());
            billEntity.setModifierId(resource.getLong("modifierId"));
            billEntity.setModifyDate(Context.getProcessEngineConfiguration().getClock().getCurrentTime());
            billEntity.setBillName(resource.getLocaleString("billName"));
            ILocaleString billSubjectName = resource.getLocaleString("subjectShowname");
            if (WfUtils.isEmpty(billSubjectName)) {
                billSubjectName = resource.getLocaleString("billSubjectName");
            }
            if (WfUtils.isEmpty(billSubjectName)) {
                billSubjectName = resource.getLocaleString("billSubject");
            }
            billEntity.setBillSubjectName(billSubjectName);
            billEntity.setBillSubject(resource.getLocaleString("billSubject"));
            billEntity.setBillSubjectMob(resource.getLocaleString("billSubjectMob"));
            billEntity.setBillSubjectMobName(resource.getLocaleString("billSubjectMobName"));
            billEntity.setFormKeyName(resource.getLocaleString("formKeyName"));
            billEntity.setSample(resource.getString("sample"));
            billEntity.setBusinessFieldMappingInfo(resource.getString("businessFieldMappingInfo"));
            commandContext.getBillSubjectModelEntityManager().insert(billEntity);
        }
    }

    private void saveModelModifyLog(DynamicConfigSchemeEntity dcsEntity, CommandContext commandContext) {
        Long schemeId = dcsEntity.getId();
        ModelModifyLogEntityManager mmlEntityManager = commandContext.getModifyLogEntityManager();
        ModelModifyLogEntity mmlEntity = (ModelModifyLogEntity)mmlEntityManager.create();
        mmlEntity.setComment(ResManager.loadKDString((String)"\u8986\u76d6\u5bfc\u5165", (String)"ImportSchemeCmd_3", (String)"bos-wf-engine", (Object[])new Object[0]));
        mmlEntity.setSchemeId(schemeId);
        Long procdefId = dcsEntity.getProcDefId();
        mmlEntity.setProcdefId(procdefId);
        ProcessDefinitionEntity pdEntity = (ProcessDefinitionEntity)commandContext.getProcessDefinitionEntityManager().findById(procdefId, "key");
        mmlEntity.setProcnum(pdEntity.getKey());
        mmlEntity.setType("dynconfscheme");
        Integer revision = mmlEntityManager.generateLatestVersion(schemeId);
        mmlEntity.setRevision(revision);
        mmlEntityManager.insert(mmlEntity);
    }
}

