/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.workflow.engine.impl.cmd.management;

import java.util.List;
import kd.bos.dataentity.entity.ILocaleString;
import kd.bos.dataentity.entity.LocaleString;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.workflow.engine.WfUtils;
import kd.bos.workflow.engine.impl.cmd.management.CreateProcessInfoEntityCmd;
import kd.bos.workflow.engine.impl.cmd.management.scheme.GetConfigSchemeBpmnJsonStringCmd;
import kd.bos.workflow.engine.impl.interceptor.CommandContext;
import kd.bos.workflow.engine.impl.persistence.entity.design.ResourceEntity;
import kd.bos.workflow.engine.impl.persistence.entity.design.ResourceEntityImpl;
import kd.bos.workflow.engine.impl.persistence.entity.design.ResourceEntityManager;
import kd.bos.workflow.engine.impl.persistence.entity.management.DynamicConfigSchemeEntity;
import kd.bos.workflow.engine.impl.persistence.entity.management.ProcessDefinitionEntity;
import kd.bos.workflow.engine.impl.persistence.entity.management.ProcessInfoEntity;
import kd.bos.workflow.engine.impl.persistence.entity.management.ProcessInfoEntityManager;
import kd.bos.workflow.exception.WFException;

public class InitProcessInfoEntityCmd
extends CreateProcessInfoEntityCmd {
    private Long procDefId;
    private String language;
    private Long defaultSchemeId;
    private ProcessDefinitionEntity processDefinition;

    public InitProcessInfoEntityCmd(Long procDefId) {
        this.procDefId = procDefId;
    }

    public InitProcessInfoEntityCmd(Long procDefId, String language) {
        this.procDefId = procDefId;
        this.language = language;
    }

    public InitProcessInfoEntityCmd(ProcessDefinitionEntity processDefinition, Long schemeId) {
        this.defaultSchemeId = schemeId;
        this.processDefinition = processDefinition;
    }

    @Override
    public Void execute(CommandContext commandContext) {
        ResourceEntity resource = null;
        ProcessInfoEntity processInfo = null;
        ResourceEntityManager resourceManager = commandContext.getResourceEntityManager();
        ProcessInfoEntityManager processInfoManager = commandContext.getProcessInfoEntityManager();
        if (this.processDefinition != null) {
            resource = (ResourceEntity)resourceManager.findById(this.processDefinition.getResourceId());
            processInfo = (ProcessInfoEntity)processInfoManager.create();
            processInfo.setProcdefId(this.processDefinition.getId());
            processInfo.setSchemeId(this.defaultSchemeId);
            processInfo.setIsDefaultScheme(true);
            processInfo.setResourceId(this.processDefinition.getResourceId());
            this.createProcessInfo(commandContext, processInfo, resource);
        } else {
            String fields = String.format("%s,%s,%s", "id", "jsonresourceid", "isdefault");
            List<DynamicConfigSchemeEntity> schemes = commandContext.getDynamicConfigSchemeEntityManager().getSchemesByProcDefId(this.procDefId, fields, true);
            if (schemes.isEmpty()) {
                String tip = null;
                if (WfUtils.isNotEmpty(this.language)) {
                    LocaleString msgMap = ResManager.getLocaleString((String)"\u6d41\u7a0b\u201c%s\u201d\u6ca1\u6709\u914d\u7f6e\u65b9\u6848\u3002", (String)"InitProcessInfoEntityCmd_1", (String)"bos-wf-engine");
                    tip = (String)msgMap.getOrDefault((Object)this.language, (Object)msgMap.getLocaleValue());
                } else {
                    tip = String.format(ResManager.loadKDString((String)"\u6d41\u7a0b\u201c%s\u201d\u6ca1\u6709\u914d\u7f6e\u65b9\u6848\u3002", (String)"InitProcessInfoEntityCmd_1", (String)"bos-wf-engine", (Object[])new Object[0]), this.procDefId);
                }
                throw new WFException(tip);
            }
            processInfoManager.deleteProcessInfoByProcDefId(this.procDefId);
            Long schemeId = null;
            for (DynamicConfigSchemeEntity scheme : schemes) {
                schemeId = scheme.getId();
                processInfo = (ProcessInfoEntity)processInfoManager.create();
                processInfo.setProcdefId(this.procDefId);
                processInfo.setSchemeId(schemeId);
                processInfo.setIsDefaultScheme(scheme.isAcquiescence());
                processInfo.setResourceId(scheme.getJsonResourceId());
                resource = (ResourceEntity)resourceManager.findById(scheme.getJsonResourceId());
                if (!scheme.isAcquiescence()) {
                    String data = new GetConfigSchemeBpmnJsonStringCmd(schemeId, null).execute(commandContext);
                    ILocaleString content = resource.getContent();
                    resource = new ResourceEntityImpl();
                    resource.setContent(content);
                    resource.setData(data);
                }
                this.createProcessInfo(commandContext, processInfo, resource);
            }
        }
        return null;
    }
}

