/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.workflow.engine.impl.cmd.management;

import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import kd.bos.context.RequestContext;
import kd.bos.dataentity.entity.ILocaleString;
import kd.bos.dataentity.entity.LocaleString;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dlock.DLock;
import kd.bos.exception.KDBizException;
import kd.bos.workflow.bpmn.model.CallActivity;
import kd.bos.workflow.bpmn.model.FlowElement;
import kd.bos.workflow.bpmn.model.FlowNode;
import kd.bos.workflow.bpmn.model.Process;
import kd.bos.workflow.domain.model.NodeForkJoinModel;
import kd.bos.workflow.engine.TaskService;
import kd.bos.workflow.engine.WfUtils;
import kd.bos.workflow.engine.delegate.DelegateExecution;
import kd.bos.workflow.engine.impl.cmd.job.EventTriggerCmd;
import kd.bos.workflow.engine.impl.interceptor.Command;
import kd.bos.workflow.engine.impl.interceptor.CommandContext;
import kd.bos.workflow.engine.impl.persistence.entity.management.ManagementConstants;
import kd.bos.workflow.engine.impl.persistence.entity.operationlog.OperationLogEntityImpl;
import kd.bos.workflow.engine.impl.persistence.entity.runtime.ExecutionEntity;
import kd.bos.workflow.engine.impl.util.ProcessDefinitionUtil;
import kd.bos.workflow.engine.impl.util.RuntimeUtil;
import kd.bos.workflow.engine.impl.util.WfOperationLogUtil;
import kd.bos.workflow.engine.task.center.ForkNodeRejectListener;
import kd.bos.workflow.exception.WFEngineException;
import kd.bos.workflow.exception.WFErrorCode;
import kd.bos.workflow.exception.WFIllegalArgumentException;

public class JumpToNodeCmd
implements Command<Void> {
    protected Long proinstanceId = null;
    protected String srcNodeId = null;
    protected String destNodeId = null;
    protected boolean isSuspend = false;
    private String reason = null;
    private ILocaleString reasonMulLang;

    public JumpToNodeCmd(Long proinstanceId, String srcNodeId, String destNodeId, boolean isSuspend, String reason) {
        this.srcNodeId = srcNodeId;
        this.destNodeId = destNodeId;
        this.proinstanceId = proinstanceId;
        this.isSuspend = isSuspend;
        this.reason = reason;
    }

    public JumpToNodeCmd(Long proinstanceId, String srcNodeId, String destNodeId, boolean isSuspend) {
        this.srcNodeId = srcNodeId;
        this.destNodeId = destNodeId;
        this.proinstanceId = proinstanceId;
        this.isSuspend = isSuspend;
    }

    public JumpToNodeCmd(Long proinstanceId, String srcNodeId, String destNodeId, boolean isSuspend, ILocaleString reasonMulLang) {
        this.srcNodeId = srcNodeId;
        this.destNodeId = destNodeId;
        this.proinstanceId = proinstanceId;
        this.isSuspend = isSuspend;
        this.reasonMulLang = reasonMulLang;
    }

    @Override
    public Void execute(CommandContext commandContext) {
        block31: {
            if (WfUtils.isEmpty(this.proinstanceId) || WfUtils.isEmpty(this.destNodeId)) {
                throw new WFIllegalArgumentException(ResManager.loadKDString((String)"\u6d41\u7a0b\u5b9e\u4f8b\u6216\u8005\u76ee\u6807\u8282\u70b9\u4e3a\u7a7a\uff0c\u65e0\u6cd5\u8df3\u8f6c\u3002", (String)"JumpToNodeCmd_1", (String)"bos-wf-engine", (Object[])new Object[0]));
            }
            try (DLock lock = DLock.create((String)String.format("wf/nodejump/%s/%s", String.valueOf(this.proinstanceId), String.valueOf(this.destNodeId)), (String)String.format("process [%S] jump to %s", String.valueOf(this.proinstanceId), String.valueOf(this.destNodeId)));){
                boolean lockSuccess = lock.tryLock(3000L);
                if (!lockSuccess) break block31;
                List<ExecutionEntity> executionList = commandContext.getExecutionEntityManager().findChildExecutionsByProcessInstanceId(this.proinstanceId);
                DelegateExecution destExecution = null;
                if (executionList != null) {
                    for (ExecutionEntity executionEntity : executionList) {
                        if (!executionEntity.isActive() && executionEntity.getCurrentFlowElement() instanceof CallActivity) continue;
                        if (this.srcNodeId == null) {
                            if (destExecution == null && executionEntity.getParent() != null && executionEntity.isActive()) {
                                destExecution = executionEntity;
                            }
                            if (!executionEntity.isMultiInstanceRoot() || executionEntity.equals(destExecution)) continue;
                            destExecution = executionEntity;
                            continue;
                        }
                        if (!this.srcNodeId.equalsIgnoreCase(executionEntity.getActivityId())) continue;
                        if (destExecution == null && executionEntity.getParent() != null && executionEntity.isActive()) {
                            destExecution = executionEntity;
                        }
                        if (!executionEntity.isMultiInstanceRoot() || executionEntity.equals(destExecution)) continue;
                        destExecution = executionEntity;
                    }
                }
                if (destExecution == null) {
                    throw new WFEngineException(ResManager.loadKDString((String)"\u65e0\u6cd5\u627e\u5230\u53ef\u8df3\u8f6c\u7684\u6267\u884c\u5b9e\u4f8b\u3002", (String)"JumpToNodeCmd_2", (String)"bos-wf-engine", (Object[])new Object[0]));
                }
                if (!RuntimeUtil.isRunning(commandContext, destExecution.getBusinessKey())) {
                    if (!RuntimeUtil.isRetring(commandContext, destExecution.getBusinessKey())) {
                        String lastUserNode;
                        Map<String, NodeForkJoinModel> models;
                        if (WfUtils.isEmpty(this.srcNodeId)) {
                            this.srcNodeId = destExecution.getActivityId();
                        }
                        FlowElement elem = destExecution.getCurrentFlowElement();
                        Process process = ProcessDefinitionUtil.getProcess(destExecution.getProcessDefinitionId(), destExecution.getProcessInstanceId());
                        FlowNode flowNode = (FlowNode)process.getFlowElement(this.srcNodeId);
                        if (flowNode != null && flowNode.getJoin() != null && flowNode.getJoin().booleanValue() && "enterwhenallarrive".equals(flowNode.getInSet()) && WfUtils.isEmpty(destExecution.getCurrentTaskId())) {
                            throw new WFIllegalArgumentException(ResManager.loadKDString((String)"\u6ca1\u6709\u751f\u6210\u4efb\u52a1\u7684\u6c47\u805a\u8282\u70b9\u65e0\u6cd5\u8df3\u8f6c", (String)"JumpToNodeCmd_3", (String)"bos-wf-engine", (Object[])new Object[0]));
                        }
                        TaskService taskService = commandContext.getProcessEngineConfiguration().getTaskService();
                        boolean hasRejectKey = taskService.judgeForkTaskCanReject(destExecution.getProcessInstanceId(), this.srcNodeId);
                        if (!(!hasRejectKey || (models = process.getForkJoinModels()).get(this.srcNodeId) != null && WfUtils.isNotEmpty(this.destNodeId) && models.get(this.destNodeId) != null && models.get(this.srcNodeId).getForkStructure().equals(models.get(this.destNodeId).getForkStructure()))) {
                            throw new WFIllegalArgumentException(ResManager.loadKDString((String)"\u5f53\u524d\u5206\u652f\u8282\u70b9\u65e0\u6cd5\u8df3\u5230\u4e3b\u5e72\u8282\u70b9\uff0c\u5df2\u6709\u5176\u4ed6\u5206\u652f\u5df2\u7ecf\u9a73\u56de\uff0c\u5176\u4ed6\u8282\u70b9\u56de\u5230\u5206\u652f\u540e\u624d\u80fd\u8df3\u8f6c\u5230\u4e3b\u5e72\u3002", (String)"JumpToNodeCmd_9", (String)"bos-wf-engine", (Object[])new Object[0]));
                        }
                        ForkNodeRejectListener.markOtherBranchsEnd(commandContext, (ExecutionEntity)destExecution, this.proinstanceId, this.srcNodeId, this.destNodeId, "", "jump");
                        DelegateExecution lastUserNodeExe = destExecution;
                        if ("CallActivity".equals(elem.getType()) && lastUserNodeExe.getParent().isMultiInstanceRoot()) {
                            lastUserNodeExe = lastUserNodeExe.getParent();
                        }
                        if (WfUtils.isNotEmpty(lastUserNode = (String)lastUserNodeExe.getVariableLocal("lastUserDealNode")) && "start".equals(lastUserNode)) {
                            lastUserNodeExe.setVariableLocal("lastUserDealNode", "jump");
                        }
                        if (this.isSuspend || destExecution.getProcessInstance().getSuspensionState().equals(ManagementConstants.ACTIVE.getStateCode())) {
                            HashMap<String, Object> variables = new HashMap<String, Object>();
                            if (WfUtils.isNotEmpty(this.reason)) {
                                variables.put("skipReason", this.reason);
                            }
                            variables.put("dynType", "dynJump");
                            variables.put("nextNodeId", this.destNodeId);
                            variables.put("dynparticipantdynjump", this.destNodeId);
                            this.saveOperationLog(commandContext, (ExecutionEntity)destExecution);
                            taskService.skipTaskAndContinue((ExecutionEntity)destExecution, Long.valueOf(RequestContext.get().getUserId()), variables, this.isSuspend);
                            if (commandContext.getProcessEngineConfiguration().isEnableBecEventDispatcher()) {
                                HashMap<String, Object> jsonMap = new HashMap<String, Object>();
                                jsonMap.put("destNodeId", this.destNodeId);
                                jsonMap.put("srcNodeId", this.srcNodeId);
                                if (this.reasonMulLang != null) {
                                    jsonMap.put("reason", this.reasonMulLang);
                                } else {
                                    jsonMap.put("reason", this.reason);
                                }
                                new EventTriggerCmd("wf.AfterProcessJumpEvent", (ExecutionEntity)destExecution, jsonMap).execute(commandContext);
                            }
                            break block31;
                        }
                        throw new KDBizException(WFErrorCode.processSuspend(), new Object[]{ResManager.loadKDString((String)"\u786e\u8ba4\u8df3\u8f6c\u5417\uff1f", (String)"JumpToNodeCmd_6", (String)"bos-wf-engine", (Object[])new Object[0])});
                    }
                    throw new WFEngineException(ResManager.loadKDString((String)"\u5f53\u524d\u6267\u884c\u5b9e\u4f8b\u6b63\u5728\u7b49\u5f85\u91cd\u8bd5\u5931\u8d25\u7684\u6d88\u606f\uff0c\u8bf7\u7a0d\u540e\u518d\u8df3\u8f6c\u3002", (String)"JumpToNodeCmd_7", (String)"bos-wf-engine", (Object[])new Object[0]));
                }
                throw new WFEngineException(ResManager.loadKDString((String)"\u5f53\u524d\u6267\u884c\u5b9e\u4f8b\u6b63\u5728\u6d41\u8f6c\uff0c\u8bf7\u7a0d\u540e\u518d\u8df3\u8f6c\u3002", (String)"JumpToNodeCmd_8", (String)"bos-wf-engine", (Object[])new Object[0]));
            }
        }
        return null;
    }

    protected void saveOperationLog(CommandContext commandContext, ExecutionEntity execution) {
        OperationLogEntityImpl operationLog = new OperationLogEntityImpl();
        Date date = commandContext.getProcessEngineConfiguration().getClock().getCurrentTime();
        operationLog.setCreateDate(date);
        Long taskId = execution.getCurrentTaskId();
        if (WfUtils.isNotEmpty(taskId)) {
            operationLog.setTaskId(taskId);
        } else {
            operationLog.setActivityId(execution.getActivityId());
            operationLog.setActivityName(execution.getActivityName());
        }
        operationLog.setProcInstId(this.proinstanceId);
        operationLog.setType("jump");
        Long userId = Long.parseLong(RequestContext.get().getUserId());
        operationLog.setOwnerId(userId);
        operationLog.setOwner(WfUtils.findUserName(userId));
        if (this.reasonMulLang != null) {
            operationLog.setNOpinion(this.reasonMulLang);
        } else {
            operationLog.setNOpinion((ILocaleString)new LocaleString(this.reason));
        }
        WfOperationLogUtil.recordOperationLog(commandContext, operationLog);
    }
}

