/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.workflow.engine.impl.cmd.management;

import java.io.Serializable;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.workflow.engine.impl.context.Context;
import kd.bos.workflow.engine.impl.interceptor.Command;
import kd.bos.workflow.engine.impl.interceptor.CommandContext;
import kd.bos.workflow.engine.impl.persistence.deploy.DeploymentCache;
import kd.bos.workflow.engine.impl.persistence.deploy.ProcessDefinitionCacheEntry;
import kd.bos.workflow.engine.impl.util.ProcessDefinitionUtil;
import kd.bos.workflow.exception.WFIllegalArgumentException;

public class RemoveProcessDefinitionCacheByIdCmd
implements Command<Void>,
Serializable {
    private static final long serialVersionUID = -2813361606673015975L;
    private Log log = LogFactory.getLog(this.getClass());
    private Long processDefinitionId;
    private Long processInstanceId;

    public RemoveProcessDefinitionCacheByIdCmd(Long processDefinitionId) {
        this.processDefinitionId = processDefinitionId;
    }

    public RemoveProcessDefinitionCacheByIdCmd(Long processDefinitionId, Long processInstanceId) {
        this(processDefinitionId);
        this.processInstanceId = processInstanceId;
    }

    @Override
    public Void execute(CommandContext commandContext) {
        if (this.processDefinitionId == null) {
            throw new WFIllegalArgumentException("processDefinitionId is null");
        }
        this.log.debug("remove processDefinitionCache " + this.processDefinitionId);
        DeploymentCache<ProcessDefinitionCacheEntry> processDefinitionCache = Context.getCommandContext().getProcessEngineConfiguration().getDeploymentManager().getProcessDefinitionCache();
        processDefinitionCache.remove(this.processDefinitionId);
        if (this.processInstanceId != null) {
            processDefinitionCache.remove(this.processInstanceId);
        }
        ProcessDefinitionUtil.getProcess(this.processDefinitionId, this.processInstanceId);
        return null;
    }
}

