/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.workflow.engine.impl.cmd.management;

import java.util.HashMap;
import java.util.Map;
import kd.bos.dataentity.serialization.SerializationUtils;
import kd.bos.workflow.engine.WFMultiLangConstants;
import kd.bos.workflow.engine.WfUtils;
import kd.bos.workflow.engine.impl.cmd.management.AbandonProcessCmd;
import kd.bos.workflow.engine.impl.interceptor.CommandContext;
import kd.bos.workflow.engine.impl.persistence.entity.history.HistoricProcessInstanceEntity;
import kd.bos.workflow.engine.impl.persistence.entity.runtime.ExecutionEntity;

public class TerminateProcessWhenExceptionOccursCmd
extends AbandonProcessCmd {
    private Map<String, Object> payload;

    public TerminateProcessWhenExceptionOccursCmd(Long proInstanceId, Map<String, Object> payload) {
        super(proInstanceId);
        this.payload = payload != null ? payload : new HashMap();
    }

    @Override
    public Void execute(CommandContext commandContext) {
        if (WfUtils.isEmpty(this.proInstanceId)) {
            logger.warn("ProcessInstanceId is empty.");
            return null;
        }
        HistoricProcessInstanceEntity procInst = (HistoricProcessInstanceEntity)commandContext.getHistoricProcessInstanceEntityManager().findById(this.proInstanceId, "endTime");
        if (procInst == null || procInst.getEndTime() != null) {
            logger.warn(String.format("The process instance %s does not exist or has already ended.", this.proInstanceId));
            return null;
        }
        ExecutionEntity destExecution = this.getDestExecution(commandContext);
        if (destExecution == null) {
            logger.warn(String.format("Execution can not found, may be it is finished. ProcessInstanceId: %s ", this.proInstanceId));
            return null;
        }
        String activityId = (String)this.payload.get("elementId");
        String exceptionMsg = (String)this.payload.get("exceptionMessage");
        destExecution.setVariable("deleteReason", this.payload.get("errorCode"));
        HashMap<String, Object> variables = new HashMap<String, Object>();
        variables.put("dynType", "terminateProcWhenExceptionOccurs");
        variables.put("dynName", SerializationUtils.toJsonString((Object)WFMultiLangConstants.getAbendText()));
        this.skipTaskAndContinue(commandContext, destExecution, variables);
        if (WfUtils.isNotEmpty(exceptionMsg)) {
            exceptionMsg = String.format("errorCode=%s;errorMsg=%s", this.payload.get("errorCode"), exceptionMsg);
        }
        commandContext.getDetailLogEntityManager().updateErrorMessage(commandContext, this.proInstanceId, activityId, exceptionMsg);
        return null;
    }
}

