/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.workflow.engine.impl.cmd.management;

import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONArray;
import com.alibaba.fastjson.JSONObject;
import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.node.ArrayNode;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import kd.bos.context.RequestContext;
import kd.bos.dataentity.entity.ILocaleString;
import kd.bos.dataentity.entity.LocaleString;
import kd.bos.workflow.engine.WfUtils;
import kd.bos.workflow.engine.impl.interceptor.Command;
import kd.bos.workflow.engine.impl.interceptor.CommandContext;
import kd.bos.workflow.engine.impl.persistence.entity.design.ResourceEntity;
import kd.bos.workflow.engine.impl.persistence.entity.management.DynamicConfigSchemeEntity;
import kd.bos.workflow.engine.impl.persistence.entity.management.ProcessInfoDetailEntity;
import kd.bos.workflow.engine.impl.persistence.entity.management.ProcessInfoEntity;
import kd.bos.workflow.engine.impl.persistence.entity.management.ProcessInfoEntityManager;

public class UpdateProcessInfoDetailEntityCmd
implements Command<Void> {
    private DynamicConfigSchemeEntity scheme;
    private JsonNode patchJsonNode;

    public UpdateProcessInfoDetailEntityCmd(DynamicConfigSchemeEntity scheme, JsonNode patchJsonNode) {
        this.scheme = scheme;
        this.patchJsonNode = patchJsonNode;
    }

    @Override
    public Void execute(CommandContext commandContext) {
        JsonNode properties;
        HashMap<String, String> actMap = new HashMap<String, String>(16);
        this.checkNameHasBeenModified(actMap, this.patchJsonNode);
        if (!this.scheme.isAcquiescence() && Boolean.TRUE.equals(commandContext.getAttribute("updated_by_parent"))) {
            JSONArray parentPatch = this.getParentSchemePatch(commandContext);
            this.checkNameHasBeenModified(actMap, parentPatch);
        }
        if (!actMap.isEmpty()) {
            this.updateProcessInfoDetails(commandContext, actMap);
        }
        if ((properties = this.patchJsonNode.get("properties")) != null) {
            this.updateProcessInfoOrgId(commandContext, properties);
        }
        return null;
    }

    private void updateProcessInfoOrgId(CommandContext commandContext, JsonNode properties) {
        JsonNode orgUnitId = properties.get("orgUnitId");
        if (orgUnitId != null) {
            ProcessInfoEntityManager entityManager = commandContext.getProcessInfoEntityManager();
            ProcessInfoEntity processInfo = entityManager.findProcessInfoWithDetailsBySchemeId(this.scheme.getId());
            long orgId = orgUnitId.longValue();
            if (!processInfo.getOrgId().equals(orgId)) {
                processInfo.setOrgId(orgId);
                entityManager.update(processInfo);
            }
        }
    }

    private JSONArray getParentSchemePatch(CommandContext commandContext) {
        DynamicConfigSchemeEntity parentScheme = (DynamicConfigSchemeEntity)commandContext.getDynamicConfigSchemeEntityManager().findById(this.scheme.getParentSchemeId());
        ResourceEntity resouce = (ResourceEntity)commandContext.getResourceEntityManager().findById(parentScheme.getJsonPatchId());
        if (resouce == null) {
            return null;
        }
        String data = resouce.getData();
        if (WfUtils.isEmpty(data)) {
            return null;
        }
        return JSON.parseArray((String)data);
    }

    private void checkNameHasBeenModified(Map<String, String> actMap, JsonNode jsonNode) {
        if (jsonNode == null) {
            return;
        }
        JsonNode children = jsonNode.get("childShapes");
        if (children instanceof ArrayNode) {
            ArrayNode shapes = (ArrayNode)children;
            for (JsonNode shape : shapes) {
                JsonNode resourceId = shape.get("resourceId");
                JsonNode properties = shape.get("properties");
                JsonNode nameNode = properties.get("name");
                String name = null;
                if (nameNode == null || !WfUtils.isNotEmpty(name = nameNode.textValue())) continue;
                actMap.put(resourceId.textValue(), name);
            }
        }
    }

    private void checkNameHasBeenModified(Map<String, String> actMap, JSONArray patch) {
        if (patch == null || patch.isEmpty()) {
            return;
        }
        JSONObject item = null;
        String regex = "/childShapes/\\[resourceId:(.+?)\\]/properties/name";
        for (int i = 0; i < patch.size(); ++i) {
            item = patch.getJSONObject(i);
            String path = item.getString("path");
            if (!path.matches(regex)) continue;
            actMap.put(path.replaceFirst(regex, "$1"), item.getString("value"));
        }
    }

    private void updateProcessInfoDetails(CommandContext commandContext, Map<String, String> actMap) {
        ProcessInfoEntityManager entityManager = commandContext.getProcessInfoEntityManager();
        ProcessInfoEntity processInfo = entityManager.findProcessInfoWithDetailsBySchemeId(this.scheme.getId());
        if (processInfo == null) {
            return;
        }
        ProcessInfoDetailEntity detail = null;
        List<ProcessInfoDetailEntity> details = processInfo.getDetails();
        String lang = RequestContext.get().getLang().toString();
        for (Map.Entry<String, String> entry : actMap.entrySet()) {
            String resourceId = entry.getKey();
            detail = this.getProcessInfoDetail(details, resourceId);
            if (detail == null) continue;
            String name = entry.getValue();
            ILocaleString activityName = detail.getActivityName();
            if (activityName == null) {
                activityName = new LocaleString();
            }
            activityName.put((Object)lang, (Object)name);
            detail.setActivityName(activityName);
        }
        processInfo.setDetails(details);
        entityManager.update(processInfo);
    }

    private ProcessInfoDetailEntity getProcessInfoDetail(List<ProcessInfoDetailEntity> entities, String activityId) {
        for (ProcessInfoDetailEntity entity : entities) {
            if (!activityId.equals(entity.getActivityId())) continue;
            return entity;
        }
        return null;
    }
}

