/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.workflow.engine.impl.cmd.management;

import java.io.Serializable;
import java.util.List;
import kd.bos.context.RequestContext;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.entity.ILocaleString;
import kd.bos.dataentity.entity.LocaleString;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.lang.Lang;
import kd.bos.orm.query.QFilter;
import kd.bos.workflow.engine.WfMultiLangUtils;
import kd.bos.workflow.engine.WfUtils;
import kd.bos.workflow.engine.impl.cmd.system.InsertBaseChangeLogsCmd;
import kd.bos.workflow.engine.impl.interceptor.Command;
import kd.bos.workflow.engine.impl.interceptor.CommandContext;
import kd.bos.workflow.engine.impl.persistence.entity.management.RoleEntity;
import kd.bos.workflow.engine.impl.persistence.entity.management.RoleEntityManager;

public class WorkflowRoleResetApproverCmd
implements Command<String>,
Serializable {
    private static final long serialVersionUID = 7881045554385891883L;
    private DynamicObject originalApprover;
    private DynamicObject approver;
    private List<Long> rowIds;
    private Boolean isSelectedRows;

    public WorkflowRoleResetApproverCmd(DynamicObject originalApprover, DynamicObject approver, List<Long> rowIds, Boolean isSelectedRows) {
        this.originalApprover = originalApprover;
        this.approver = approver;
        this.rowIds = rowIds;
        this.isSelectedRows = isSelectedRows;
    }

    @Override
    public String execute(CommandContext commandContext) {
        RoleEntityManager roleEntityManager = commandContext.getRoleEntityManager();
        String fields = roleEntityManager.getSelectFields();
        List roleEntities = null;
        if (this.isSelectedRows.booleanValue()) {
            QFilter[] qFilters = new QFilter[]{new QFilter("id", "in", this.rowIds)};
            roleEntities = roleEntityManager.findByQueryFilters(qFilters, fields, null);
        } else {
            roleEntities = roleEntityManager.findByQueryFilters(null, fields, null);
        }
        for (RoleEntity roleEntity : roleEntities) {
            if (!"user".equals(roleEntity.getRoleType())) continue;
            DynamicObjectCollection entryEntities = roleEntity.getRoleEntry();
            for (DynamicObject entryEntity : entryEntities) {
                Long userId;
                DynamicObject roleEntryUser = (DynamicObject)entryEntity.get("user");
                if (roleEntryUser == null || !(userId = (Long)roleEntryUser.getPkValue()).equals((Long)this.originalApprover.getPkValue())) continue;
                entryEntity.set("user", (Object)this.approver);
                entryEntity.set("userposition", null);
                entryEntity.getDataEntityState().setDirty(true);
                Long baseFormId = roleEntity.getId();
                ILocaleString title = WfUtils.getPromptWordLocaleString("\u4fee\u6539\u5de5\u4f5c\u6d41\u89d2\u8272\uff1a", "WorkflowRoleResetApproverCmd_0", "bos-wf-engine");
                title = this.mulitLangAppendString(title, String.format("%s(%s)", roleEntity.getName(), roleEntity.getNumber()));
                LocaleString detail = ResManager.getLocaleString((String)"\u91cd\u65b0\u8bbe\u7f6e\u5ba1\u6279\u4eba\u201c%1$s\u201d\u4e3a\u201c%2$s\u201d\u3002", (String)"WorkflowRoleResetApproverCmd_1", (String)"bos-wf-engine");
                detail = WfMultiLangUtils.replaceILocaleString((ILocaleString)detail, roleEntryUser.getLocaleString("name"), this.approver.getLocaleString("name"));
                new InsertBaseChangeLogsCmd(baseFormId, "role", "modify", title, (ILocaleString)detail, RequestContext.get().getUserId()).execute(commandContext);
            }
            roleEntity.setRoleEntry(entryEntities);
            commandContext.getRoleEntityManager().update(roleEntity);
        }
        return "OK";
    }

    private ILocaleString mulitLangAppendString(ILocaleString lString, String string) {
        for (Lang lang : WfUtils.getSupportLangs()) {
            lString.setItem(lang.toString(), (Object)((String)lString.getItem(lang.toString()) + string));
        }
        return lString;
    }

    private ILocaleString mulitLangAppend(ILocaleString lString1, ILocaleString lString2) {
        for (Lang lang : WfUtils.getSupportLangs()) {
            if (WfUtils.isEmpty((String)lString1.getItem(lang.toString()))) {
                return lString2;
            }
            lString1.setItem(lang.toString(), (Object)((String)lString1.getItem(lang.toString()) + (String)lString2.getItem(lang.toString())));
        }
        return lString1;
    }
}

