/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.workflow.engine.impl.cmd.management.delegatesetting;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import kd.bos.dataentity.entity.ILocaleString;
import kd.bos.dataentity.resource.promptenum.MultiLangEnumBridge;
import kd.bos.dataentity.serialization.SerializationUtils;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.query.QFilter;
import kd.bos.workflow.engine.WfMultiLangUtils;
import kd.bos.workflow.engine.WfUtils;
import kd.bos.workflow.engine.impl.dynprocess.DynProcessProcessorHelper;
import kd.bos.workflow.engine.impl.interceptor.Command;
import kd.bos.workflow.engine.impl.interceptor.CommandContext;
import kd.bos.workflow.engine.impl.persistence.entity.history.HistoricIdentityLinkEntity;
import kd.bos.workflow.engine.impl.persistence.entity.history.HistoricIdentityLinkEntityManager;
import kd.bos.workflow.engine.impl.persistence.entity.runtime.IdentityLinkEntity;
import kd.bos.workflow.engine.impl.persistence.entity.runtime.IdentityLinkEntityManager;
import kd.bos.workflow.engine.impl.persistence.entity.task.TaskEntity;
import kd.bos.workflow.engine.task.TaskDelegateUtil;
import kd.bos.workflow.engine.task.TaskUtils;

public class ResumeDelegateTasksCmd
implements Command<Void>,
Serializable {
    private static final long serialVersionUID = 2773244749404519177L;
    private static Log logger = LogFactory.getLog(ResumeDelegateTasksCmd.class);
    private Long taskId;
    private String scene = null;
    private Long currentUserId = WfUtils.getCurrentUser();
    private Map<String, Object> params = new HashMap<String, Object>();

    public ResumeDelegateTasksCmd(Long taskId) {
        this.taskId = taskId;
    }

    public ResumeDelegateTasksCmd(Long taskId, String scene) {
        this.taskId = taskId;
        this.scene = scene;
    }

    public ResumeDelegateTasksCmd(Long taskId, String scene, Map<String, Object> params) {
        this.taskId = taskId;
        this.scene = scene;
        this.params = params;
    }

    public ResumeDelegateTasksCmd(Long taskId, String scene, Long userId) {
        this.taskId = taskId;
        this.scene = scene;
        this.currentUserId = userId;
    }

    @Override
    public Void execute(CommandContext commandContext) {
        this.resumeDelegateTasks(commandContext, this.taskId, this.scene);
        return null;
    }

    private void resumeDelegateTasks(CommandContext commandContext, Long taskId, String scene) {
        logger.info("start resumeDelegateTasks");
        HistoricIdentityLinkEntityManager hiIdentityLinkManager = commandContext.getHistoricIdentityLinkEntityManager();
        List<HistoricIdentityLinkEntity> hiIdentitys = hiIdentityLinkManager.findParticipantsByTaskId(taskId, hiIdentityLinkManager.getSelectFields(), null);
        HashSet<Long> hiIdentityIds = new HashSet<Long>();
        for (HistoricIdentityLinkEntity hiIdentity : hiIdentitys) {
            if (!WfUtils.isNotEmpty(hiIdentity.getDelegateId())) continue;
            hiIdentityIds.add(hiIdentity.getUserId());
        }
        if (hiIdentityIds.isEmpty()) {
            logger.info("hiIdentityIds value is null");
            return;
        }
        Long ownerId = TaskDelegateUtil.getDelegateTaskOwnerId(taskId, this.currentUserId);
        logger.info(String.format("ownerId value is %s", ownerId));
        QFilter isExistParticipantForDelegate1 = new QFilter("taskid", "=", (Object)taskId);
        QFilter isExistParticipantForDelegate2 = new QFilter("ownerid", "=", (Object)this.currentUserId);
        QFilter isExistParticipantForDelegate3 = new QFilter("delegateid", "is not null", null);
        QFilter[] isExistParticipantForDelegates = new QFilter[]{isExistParticipantForDelegate1, isExistParticipantForDelegate2, isExistParticipantForDelegate3};
        List delegatesParticipants = commandContext.getIdentityLinkEntityManager().findByQueryFilters(isExistParticipantForDelegates);
        if (!this.currentUserId.equals(ownerId) || delegatesParticipants.isEmpty()) {
            return;
        }
        logger.info("Real recovery");
        IdentityLinkEntityManager identityLinkManager = commandContext.getIdentityLinkEntityManager();
        List<IdentityLinkEntity> participants = identityLinkManager.findIdentityLinksByTaskId(taskId, identityLinkManager.getSelectFields());
        ArrayList<Long> delegateUserIds = new ArrayList<Long>(participants.size());
        ArrayList<IdentityLinkEntity> trustees = new ArrayList<IdentityLinkEntity>(participants.size());
        ArrayList<Long> trusteeIds = new ArrayList<Long>(participants.size());
        for (IdentityLinkEntity participant : participants) {
            if (!ownerId.equals(participant.getOwnerId()) || !"participant".equals(participant.getType()) || participant.getDelegateId() <= 0L) continue;
            trustees.add(participant);
            trusteeIds.add(participant.getUserId());
            delegateUserIds.add(participant.getUserId());
        }
        ArrayList<IdentityLinkEntity> coordinates = new ArrayList<IdentityLinkEntity>(participants.size());
        ArrayList<Long> coordinateIds = new ArrayList<Long>(participants.size());
        ArrayList<String> coordinateIdStrList = new ArrayList<String>(participants.size());
        for (IdentityLinkEntity identityLinkEntity : participants) {
            if (!"coordinate".equals(identityLinkEntity.getType())) continue;
            coordinates.add(identityLinkEntity);
            coordinateIds.add(identityLinkEntity.getUserId());
            delegateUserIds.add(identityLinkEntity.getUserId());
            coordinateIdStrList.add(String.valueOf(identityLinkEntity.getUserId()));
        }
        ArrayList<Long> processedCoordinateIds = new ArrayList<Long>(hiIdentitys.size());
        for (HistoricIdentityLinkEntity hiIdentity : hiIdentitys) {
            if (!"coordinate".equals(hiIdentity.getType()) || coordinateIds.contains(hiIdentity.getUserId())) continue;
            delegateUserIds.add(hiIdentity.getUserId());
            coordinateIdStrList.add(String.valueOf(hiIdentity.getUserId()));
            processedCoordinateIds.add(hiIdentity.getUserId());
        }
        QFilter qFilter = new QFilter("taskid", "=", (Object)taskId);
        QFilter commentQFilter2 = new QFilter("userid", "in", processedCoordinateIds);
        QFilter commentQFilter3 = new QFilter("type", "=", (Object)"coordinate");
        QFilter[] commentQFilters = new QFilter[]{qFilter, commentQFilter2, commentQFilter3};
        commandContext.getCommentEntityManager().deleteByFilters(commentQFilters);
        TaskEntity task = (TaskEntity)commandContext.getTaskEntityManager().findById(taskId);
        ArrayList<IdentityLinkEntity> delegateIdentitys = new ArrayList<IdentityLinkEntity>(trustees.size() + coordinates.size());
        delegateIdentitys.addAll(trustees);
        delegateIdentitys.addAll(coordinates);
        for (IdentityLinkEntity identityLinkEntity : delegateIdentitys) {
            identityLinkManager.deleteIdentityLink(identityLinkEntity, true);
            task.getIdentityLinks().remove(identityLinkEntity);
            logger.info(String.format("taskId is %s;userid is %s;", taskId, identityLinkEntity.getUserId()));
            TaskUtils.deleteRuleTaskRelationByTaskIdAndType(commandContext, taskId, identityLinkEntity.getUserId(), "delegate");
        }
        if (!"autoTransfer".equals(scene)) {
            this.updateYzjTaskMemberInfoVariables(task, task.getIdentityLinks(), trusteeIds, commandContext);
        }
        logger.info("delete delegate flag over ");
        if (coordinateIdStrList != null && !coordinateIdStrList.isEmpty()) {
            WfUtils.addOpLog("wf_participant", "taskCoordinateRequestWithdraw", new MultiLangEnumBridge("\u64a4\u56de\u534f\u529e\u8bf7\u6c42", "TaskCoordinateRequestWithdrawCmd_0", "bos-wf-engine"), new MultiLangEnumBridge("\u6536\u56detaskId\u4e3a%1$s\u59d4\u6258\u4efb\u52a1\u65f6\uff0c\u6e05\u9664\u534f\u529e\u4ebaid\u4e3a %2$s\u7684\u534f\u529e", "ResumeDelegateTasksCmd_0", "bos-wf-engine"), taskId, String.join((CharSequence)",", coordinateIdStrList));
        }
        if (!task.isBizTask()) {
            DynProcessProcessorHelper.clearAddsignAfterByTaskIdAndOwerId(task.getProcessInstanceId(), taskId, trusteeIds, commandContext);
            WfUtils.addOpLog("wf_dynamicresource", "clearAddSignAfter", new MultiLangEnumBridge("\u6e05\u9664\u540e\u52a0\u7b7e", "ResumeDelegateTasksCmd_1", "bos-wf-engine"), new MultiLangEnumBridge("\u6e05\u9664taskId\u4e3a%1$s\u7684\u540e\u52a0\u7b7e", "ResumeDelegateTasksCmd_2", "bos-wf-engine"), taskId);
        }
        ArrayList<Long> delegatesParticipantIds = new ArrayList<Long>(10);
        for (IdentityLinkEntity delegatesParticipant : delegatesParticipants) {
            delegatesParticipantIds.add(delegatesParticipant.getUserId());
        }
        QFilter qFilter2 = new QFilter("taskId", "=", (Object)taskId);
        QFilter taskHandleLogQFilter2 = new QFilter("ownerId", "!=", (Object)ownerId);
        QFilter taskHandleLogQFilter4 = new QFilter("assigneeid", "in", delegatesParticipantIds);
        QFilter taskHandleLogQFilter3 = new QFilter("type", "=", (Object)"transfer");
        QFilter[] taskHandleLogQFilters = new QFilter[]{qFilter2, taskHandleLogQFilter2, taskHandleLogQFilter4, taskHandleLogQFilter3};
        commandContext.getTaskHandleLogEntityManager().deleteByFilters(taskHandleLogQFilters);
        QFilter ruleTaskQFilter1 = new QFilter("taskid", "=", (Object)taskId);
        QFilter ruleTaskQFilter2 = new QFilter("ruletype", "=", (Object)"delegate");
        QFilter ruleTaskQFilter3 = new QFilter("userid", "not in", trusteeIds);
        QFilter[] ruleTaskQFilters = new QFilter[]{ruleTaskQFilter1, ruleTaskQFilter2, ruleTaskQFilter3};
        commandContext.getRuleTaskRelationEntityManager().deleteByFilters(ruleTaskQFilters);
        for (IdentityLinkEntity participant : participants) {
            HistoricIdentityLinkEntity hiIdentity;
            if (!ownerId.equals(participant.getUserId()) || !"participant".equals(participant.getType()) || participant.getDelegateId() != 0L) continue;
            participant.setTrustName(null);
            participant.setTrustNameFormat(null);
            participant.setDisplay(Boolean.TRUE);
            boolean deleted = participant.isDeleted();
            if ("task complete".equals(scene) || deleted) {
                identityLinkManager.update(participant, false);
            } else {
                identityLinkManager.update(participant);
            }
            if ((hiIdentity = (HistoricIdentityLinkEntity)hiIdentityLinkManager.findById(participant.getId())) == null) continue;
            hiIdentity.setTrustName(null);
            hiIdentity.setTrustNameFormat(null);
            hiIdentityLinkManager.update(hiIdentity);
        }
        TaskDelegateUtil.dispatchTaskDelegateResumeListener(task, delegateIdentitys, scene, this.params);
        if (!delegateUserIds.isEmpty()) {
            commandContext.getMessageService().deleteToDo(taskId, delegateUserIds, false, true);
        }
    }

    private void updateYzjTaskMemberInfoVariables(TaskEntity task, List<IdentityLinkEntity> participants, List<Long> trusteeIds, CommandContext commandContext) {
        if (WfUtils.isEmpty(task.getParentTaskId())) {
            return;
        }
        TaskEntity parentTask = task.getParentTaskInstance();
        List<IdentityLinkEntity> identityLinkEntitysForParent = commandContext.getIdentityLinkEntityManager().findIdentityLinksByParentTaskId(task.getParentTaskId());
        List remainingIdentityLinkEntitys = identityLinkEntitysForParent.stream().filter(s -> !trusteeIds.contains(s.getUserId())).collect(Collectors.toList());
        ArrayList<ILocaleString> names = new ArrayList<ILocaleString>(remainingIdentityLinkEntitys.size());
        ArrayList<ILocaleString> nameFormates = new ArrayList<ILocaleString>(remainingIdentityLinkEntitys.size());
        for (IdentityLinkEntity remainingIdentityLinkEntity : remainingIdentityLinkEntitys) {
            names.add(remainingIdentityLinkEntity.getUserName());
            nameFormates.add(remainingIdentityLinkEntity.getUserNameFormatter());
        }
        ILocaleString teamMerberNames = WfMultiLangUtils.getFormatMergeValue(names);
        ILocaleString teamMemberNamesFormat = WfMultiLangUtils.getFormatMergeValue(nameFormates);
        parentTask.setVariableLocal("teamMemberNames", SerializationUtils.toJsonString((Object)teamMerberNames));
        parentTask.setVariableLocal("teamMemberNamesFormat", SerializationUtils.toJsonString((Object)teamMemberNamesFormat));
    }
}

