/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.workflow.engine.impl.cmd.management.delegatesetting;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import kd.bos.exception.KDBizException;
import kd.bos.orm.query.QFilter;
import kd.bos.workflow.engine.WfUtils;
import kd.bos.workflow.engine.impl.cmd.management.delegatesetting.DelegationPath;
import kd.bos.workflow.engine.impl.interceptor.Command;
import kd.bos.workflow.engine.impl.interceptor.CommandContext;
import kd.bos.workflow.engine.impl.persistence.entity.management.delegatesetting.DelegateSettingEntity;
import kd.bos.workflow.engine.impl.persistence.entity.management.delegatesetting.DelegateSettingEntityManager;
import kd.bos.workflow.exception.WFErrorCode;

public class ValidateDelegateSettingCmd
implements Command<Void>,
Serializable {
    private static final long serialVersionUID = -4292608078750456392L;
    private Long curDelegateId;
    private Long assignorId;
    private Long trusteeId;
    private static final String ASSIGNORNAME = "assignorName";
    private static final String TRUSTEENAME = "trusteeName";

    public ValidateDelegateSettingCmd(Long curDelegateId, Long assignorId, Long trusteeId) {
        this.assignorId = assignorId;
        this.trusteeId = trusteeId;
        this.curDelegateId = curDelegateId;
    }

    @Override
    public Void execute(CommandContext commandContext) {
        DelegateSettingEntity delegateSetting;
        DelegateSettingEntity delegateSetting2;
        if ((WfUtils.isEmpty(this.assignorId) || WfUtils.isEmpty(this.trusteeId)) && (delegateSetting2 = (DelegateSettingEntity)commandContext.getDelegateSettingEntityManager().findById(this.curDelegateId)) != null) {
            this.assignorId = delegateSetting2.getAssignorId();
            this.trusteeId = delegateSetting2.getTrusteeId();
        }
        Map<String, String> assignorAndTrusteeName = ValidateDelegateSettingCmd.getAssignorAndTrusteeName(this.assignorId, this.trusteeId);
        String assignorName = assignorAndTrusteeName.get(ASSIGNORNAME);
        String trusteeName = assignorAndTrusteeName.get(TRUSTEENAME);
        DelegateSettingEntityManager delegateSettingEntityManager = commandContext.getDelegateSettingEntityManager();
        if (this.isMutualDelegateCmd(delegateSettingEntityManager, this.curDelegateId, this.assignorId, this.trusteeId, delegateSetting = (DelegateSettingEntity)delegateSettingEntityManager.findById(this.curDelegateId))) {
            throw new KDBizException(WFErrorCode.existsMutualDelegateError(assignorName, trusteeName), new Object[0]);
        }
        if (this.isPrincipalRing(delegateSettingEntityManager, this.assignorId, this.trusteeId, delegateSetting).booleanValue()) {
            throw new KDBizException(WFErrorCode.existsDelegateRingError(assignorName, trusteeName), new Object[0]);
        }
        return null;
    }

    private boolean isMutualDelegateCmd(DelegateSettingEntityManager delegateSettingEntityManager, Long curDelegateId, Long assignorId, Long trusteeId, DelegateSettingEntity delegateSetting) {
        QFilter filter5;
        QFilter filter4;
        QFilter filter3;
        Date currentDate;
        long currentDateTimestamp;
        if (delegateSetting == null) {
            return false;
        }
        Date startTime = delegateSetting.getStartTime();
        long startTimeTimestamp = startTime.getTime();
        Date endTime = delegateSetting.getEndTime();
        long endTimeTimestamp = endTime.getTime();
        if (endTimeTimestamp < (currentDateTimestamp = (currentDate = WfUtils.now()).getTime())) {
            return false;
        }
        QFilter filter1 = new QFilter("id", "!=", (Object)curDelegateId);
        QFilter filter2 = new QFilter("status", "=", (Object)Character.valueOf('1'));
        QFilter[] filters = new QFilter[]{filter1, filter2, filter3 = new QFilter("assignorid", "=", (Object)trusteeId), filter4 = new QFilter("trusteeid", "=", (Object)assignorId), filter5 = new QFilter("endtime", ">", (Object)currentDate)};
        List targetDelegateSettings = delegateSettingEntityManager.findByQueryFilters(filters, "starttime,endtime", null);
        if (targetDelegateSettings == null || targetDelegateSettings.isEmpty()) {
            return false;
        }
        ArrayList<DelegateSettingEntity> resultList = new ArrayList<DelegateSettingEntity>(targetDelegateSettings.size());
        for (DelegateSettingEntity targetDelegateSetting : targetDelegateSettings) {
            long targetStarttime = targetDelegateSetting.getStartTime().getTime();
            long targetEndtime = targetDelegateSetting.getEndTime().getTime();
            if (targetEndtime < startTimeTimestamp || endTimeTimestamp < targetStarttime) continue;
            if (targetStarttime <= startTimeTimestamp && startTimeTimestamp < targetEndtime) {
                resultList.add(targetDelegateSetting);
                break;
            }
            if (startTimeTimestamp < targetStarttime && targetStarttime < targetEndtime && targetEndtime <= endTimeTimestamp) {
                resultList.add(targetDelegateSetting);
                break;
            }
            if (targetStarttime < endTimeTimestamp && endTimeTimestamp < targetEndtime) {
                resultList.add(targetDelegateSetting);
                break;
            }
            if (targetStarttime >= startTimeTimestamp || startTimeTimestamp >= endTimeTimestamp || endTimeTimestamp >= targetEndtime) continue;
            resultList.add(targetDelegateSetting);
            break;
        }
        return !resultList.isEmpty();
    }

    private static Map<String, String> getAssignorAndTrusteeName(Long assignorId, Long trusteeId) {
        HashMap<String, String> assignorAndTrustee = new HashMap<String, String>(2);
        ArrayList<Long> userIds = new ArrayList<Long>(2);
        userIds.add(assignorId);
        userIds.add(trusteeId);
        String usersName = WfUtils.getUsersName(userIds);
        if (!WfUtils.isEmpty(usersName)) {
            String[] names = usersName.split(",");
            String assignor = "";
            String trustee = "";
            if (names.length > 0) {
                assignor = names[0];
            }
            if (names.length > 1) {
                trustee = names[1];
            }
            assignorAndTrustee.put(ASSIGNORNAME, assignor);
            assignorAndTrustee.put(TRUSTEENAME, trustee);
        }
        return assignorAndTrustee;
    }

    private Boolean isPrincipalRing(DelegateSettingEntityManager deleSetEntiManager, Long origAssignorId, Long origTrusteeId, DelegateSettingEntity delegateSetting) {
        Boolean isDelegateRing = Boolean.FALSE;
        List<DelegateSettingEntity> delegateEntities = this.getDelegateSettingEntitysByAssignorId(deleSetEntiManager, origAssignorId);
        ArrayList<DelegationPath> delegationPaths = new ArrayList<DelegationPath>();
        for (DelegateSettingEntity delegateEntity : delegateEntities) {
            DelegationPath delegationPath = new DelegationPath(origAssignorId, delegateSetting.getStartTime(), delegateSetting.getEndTime());
            delegationPath.addPreAssignorIdsForOne(delegateEntity.getAssignorId());
            delegationPath.setMaxStartTime(delegateEntity.getStartTime());
            delegationPath.setMinEndTime(delegateEntity.getEndTime());
            this.findAllCircularDelegationPaths(delegationPaths, delegationPath, deleSetEntiManager, delegateEntity.getAssignorId(), origTrusteeId);
        }
        Date currentDate = WfUtils.now();
        for (DelegationPath delegationPath : delegationPaths) {
            Date minEndTime;
            Date maxStartTime = delegationPath.getMaxStartTime();
            if (!maxStartTime.before(minEndTime = delegationPath.getMinEndTime()) || currentDate.after(minEndTime)) continue;
            isDelegateRing = Boolean.TRUE;
            break;
        }
        return isDelegateRing;
    }

    private List<DelegateSettingEntity> getDelegateSettingEntitysByAssignorId(DelegateSettingEntityManager deleSetEntiManager, Long userId) {
        Date currentDate = WfUtils.now();
        QFilter filter1 = new QFilter("status", "=", (Object)Character.valueOf('1'));
        QFilter filter2 = new QFilter("trusteeid", "=", (Object)userId);
        QFilter filter3 = new QFilter("endtime", ">", (Object)currentDate);
        QFilter[] filters = new QFilter[]{filter1, filter2, filter3};
        String selectFileds = "assignorid,starttime,endtime";
        return deleSetEntiManager.findByQueryFilters(filters, selectFileds, null);
    }

    private void findAllCircularDelegationPaths(List<DelegationPath> delegationPaths, DelegationPath delegationPath, DelegateSettingEntityManager deleSetEntiManager, Long assignorId, Long origTrusteeId) {
        List<DelegateSettingEntity> delegateEntities = this.getDelegateSettingEntitysByAssignorId(deleSetEntiManager, assignorId);
        for (DelegateSettingEntity delegateEntity : delegateEntities) {
            DelegationPath delegationPathNew = new DelegationPath(delegationPath.getPreAssignorIds(), delegationPath.getMaxStartTime(), delegationPath.getMinEndTime());
            delegationPathNew.addPreAssignorIdsForOne(delegateEntity.getAssignorId());
            delegationPathNew.setMaxStartTime(delegateEntity.getStartTime());
            delegationPathNew.setMinEndTime(delegateEntity.getEndTime());
            if (delegationPathNew.getPreAssignorIds().contains(origTrusteeId)) {
                delegationPaths.add(delegationPathNew);
                continue;
            }
            this.findAllCircularDelegationPaths(delegationPaths, delegationPathNew, deleSetEntiManager, delegateEntity.getAssignorId(), origTrusteeId);
        }
    }
}

