/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.workflow.engine.impl.cmd.management.scheme;

import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONArray;
import com.alibaba.fastjson.JSONObject;
import com.fasterxml.jackson.databind.JsonNode;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import kd.bos.dataentity.entity.ILocaleString;
import kd.bos.dataentity.entity.LocaleString;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.serialization.SerializationUtils;
import kd.bos.workflow.api.NodeTemplate;
import kd.bos.workflow.bpmn.diff.patch.JsonPatch;
import kd.bos.workflow.bpmn.diff.util.BpmnDiffUtil;
import kd.bos.workflow.bpmn.model.BpmnModel;
import kd.bos.workflow.bpmn.model.FlowElement;
import kd.bos.workflow.bpmn.model.Process;
import kd.bos.workflow.engine.WfMultiLangUtils;
import kd.bos.workflow.engine.WfUtils;
import kd.bos.workflow.engine.impl.bpmn.helper.nodetemplate.NodeTemplateUtil;
import kd.bos.workflow.engine.impl.interceptor.Command;
import kd.bos.workflow.engine.impl.interceptor.CommandContext;
import kd.bos.workflow.engine.impl.persistence.entity.design.ResourceEntity;
import kd.bos.workflow.engine.impl.persistence.entity.management.DynamicConfigSchemeEntity;
import kd.bos.workflow.engine.impl.persistence.entity.operationlog.IModelModifyLog;
import kd.bos.workflow.engine.impl.persistence.entity.operationlog.ModelModifyLogEntity;
import kd.bos.workflow.engine.impl.persistence.entity.operationlog.ModelModifyLogEntityManager;
import kd.bos.workflow.engine.impl.util.BpmnModelUtil;
import kd.bos.workflow.engine.impl.util.ModelModifyLogUtils;
import kd.bos.workflow.engine.impl.util.ProcessDefinitionUtil;
import kd.bos.workflow.service.WorkflowService;
import kd.bos.workflow.service.impl.ServiceFactory;

public class CompareVersionDifferenceCmd
implements Command<List<ModelModifyLogEntity>>,
Serializable {
    private static final long serialVersionUID = -5585516877563715506L;
    private static final String GROUPENABLE = "groupEnable";
    private static final String EXTATTRVALUE = "extAttrValue";
    private static final String ATTRIBUTES = "attributes";
    private static final String ATTRIBUTENUMBER = "attributeNumber";
    private static final String ATTRIBUTENAME = "attributeName";
    private String modelJson;
    private String origModelJson;
    private IModelModifyLog entity;
    private Set<String> ignoredProps;

    public CompareVersionDifferenceCmd(String modelJson, String origModelJson, IModelModifyLog entity, Set<String> ignoredProps) {
        this.modelJson = modelJson;
        this.origModelJson = origModelJson;
        this.entity = entity;
        this.ignoredProps = ignoredProps;
    }

    @Override
    public List<ModelModifyLogEntity> execute(CommandContext commandContext) {
        JsonNode patchJson = this.getBpmnPatch();
        return this.getEntities(patchJson, commandContext);
    }

    private JsonNode getBpmnPatch() {
        JsonPatch patch = BpmnDiffUtil.getJsonDiffPatch(this.origModelJson, this.modelJson);
        return BpmnDiffUtil.getBpmnPatch(patch);
    }

    private List<ModelModifyLogEntity> getEntities(JsonNode bpmnPatch, CommandContext commandContext) {
        BpmnModel bpmnModel = ProcessDefinitionUtil.getBpmnModel(this.modelJson);
        ModelModifyLogEntityManager manager = commandContext.getModifyLogEntityManager();
        List<Map<String, String>> elementPaths = ModelModifyLogUtils.getElementPathsByBpmnPatch(bpmnPatch, bpmnModel);
        List<String> processPaths = ModelModifyLogUtils.getProcessPathsByBpmnPatch(bpmnPatch, bpmnModel);
        ArrayList<ModelModifyLogEntity> entities = new ArrayList<ModelModifyLogEntity>();
        Integer revision = null;
        if (this.entity instanceof DynamicConfigSchemeEntity) {
            revision = manager.generateLatestVersion(((DynamicConfigSchemeEntity)this.entity).getId());
        }
        this.putElementModifyEntities(entities, elementPaths, bpmnModel, manager, revision, commandContext);
        this.putProcessModifyEntities(entities, processPaths, bpmnModel, manager, revision);
        return entities;
    }

    private void putElementModifyEntities(List<ModelModifyLogEntity> result, List<Map<String, String>> elementPaths, BpmnModel bpmnModel, ModelModifyLogEntityManager manager, Integer revision, CommandContext commandContext) {
        Process process = bpmnModel.getMainProcess();
        List<Map<String, Object>> params = this.getElementParams(elementPaths, bpmnModel, manager, revision, commandContext);
        ResourceEntity resource = this.getResourceEntity();
        HashMap<String, Set<Map<String, Object>>> bizGroups = new HashMap<String, Set<Map<String, Object>>>();
        for (Map<String, Object> param : params) {
            ModelModifyLogEntity modelModifyLogEntity;
            if (this.recordBizGroup(param, bizGroups) || !WfUtils.isNotEmpty((modelModifyLogEntity = manager.generateEntity(resource, this.entity, process, param)).getContent()) && !WfUtils.isNotEmpty(modelModifyLogEntity.getOldval())) continue;
            result.add(modelModifyLogEntity);
        }
        this.putMeragedEntity(bizGroups, resource, process, result, manager);
    }

    private List<Map<String, Object>> getElementParams(List<Map<String, String>> elementPaths, BpmnModel bpmnModel, ModelModifyLogEntityManager manager, Integer revision, CommandContext commandContext) {
        JSONObject origModel = JSON.parseObject((String)this.origModelJson);
        JSONObject model = JSON.parseObject((String)this.modelJson);
        ArrayList<Map<String, Object>> params = new ArrayList<Map<String, Object>>(16);
        HashSet<String> addElements = new HashSet<String>();
        for (Map<String, String> map : elementPaths) {
            HashMap<String, String> param;
            String path = map.get("path");
            if (this.isPathsIgnored(path)) continue;
            String resourceId = map.get("resourceId");
            JSONObject origJsonObject = BpmnModelUtil.getNodeJSON(this.origModelJson, resourceId);
            JSONObject modelJsonObject = BpmnModelUtil.getNodeJSON(this.modelJson, resourceId);
            String action = map.get("_action_");
            if (WfUtils.isNotEmpty(action)) {
                param = new HashMap<String, String>();
                param.put("flowElementId", String.format(ResManager.loadKDString((String)"%1$s\uff08\u5220\u9664\uff09", (String)"CompareVersionDifferenceCmd_0", (String)"bos-wf-engine", (Object[])new Object[0]), resourceId));
                String origElementJson = origJsonObject.toJSONString();
                param.put("oldValue", origElementJson);
                params.add(param);
                continue;
            }
            if (origJsonObject == null && modelJsonObject != null) {
                param = new HashMap();
                if (!addElements.contains(resourceId)) {
                    param.put("flowElementId", String.format(ResManager.loadKDString((String)"%1$s\uff08\u589e\u52a0\uff09", (String)"CompareVersionDifferenceCmd_1", (String)"bos-wf-engine", (Object[])new Object[0]), resourceId));
                    param.put("newValue", modelJsonObject.toJSONString());
                    params.add(param);
                }
                addElements.add(resourceId);
                continue;
            }
            Object oldVal = BpmnModelUtil.getProcessNodeProperty(origModel, resourceId, path);
            Object newVal = BpmnModelUtil.getProcessNodeProperty(model, resourceId, path);
            String oldValStr = null;
            String newValStr = null;
            if (oldVal != null) {
                oldValStr = oldVal.toString();
            }
            if (newVal != null) {
                newValStr = newVal.toString();
            }
            if ("properties.extAttrGroup".equals(path)) {
                List<Map<String, Object>> expendParams = this.getExpendParamByVal(resourceId, oldValStr, newValStr, path, bpmnModel, commandContext);
                for (Map<String, Object> expendParam : expendParams) {
                    if (revision == null) continue;
                    expendParam.put("revision", revision);
                    Integer n = revision;
                    Integer n2 = revision = Integer.valueOf(revision + 1);
                }
                params.addAll(expendParams);
                continue;
            }
            Map<String, Object> param2 = ModelModifyLogUtils.getParamsByPatch(resourceId, oldValStr, newValStr, path, this.entity, bpmnModel, manager);
            if (revision != null) {
                param2.put("revision", revision);
            }
            params.add(param2);
        }
        return params;
    }

    private List<Map<String, Object>> getExpendParamByVal(String flowElementId, String oldVal, String newVal, String path, BpmnModel bpmnModel, CommandContext commandContext) {
        ArrayList<Map<String, Object>> paramsList = new ArrayList<Map<String, Object>>(10);
        Process process = bpmnModel.getMainProcess();
        String flowElementName = null;
        String elementType = null;
        FlowElement element = process.getFlowElement(flowElementId);
        elementType = element.getType();
        flowElementName = element.getName();
        String operation = this.getOperation(oldVal, newVal);
        JSONObject oldJson = WfUtils.isEmpty(oldVal) ? new JSONObject() : JSONObject.parseObject((String)oldVal);
        JSONObject newJson = WfUtils.isEmpty(newVal) ? new JSONObject() : JSONObject.parseObject((String)newVal);
        List<NodeTemplate> nodeTemplateExpendDatas = NodeTemplateUtil.getExtendNodeTemplateBystencilType(elementType, commandContext);
        HashMap<String, String> oldMap = new HashMap<String, String>(nodeTemplateExpendDatas.size());
        HashMap<String, String> newMap = new HashMap<String, String>(nodeTemplateExpendDatas.size());
        ArrayList<NodeTemplate> expendNumberList = new ArrayList<NodeTemplate>(nodeTemplateExpendDatas.size());
        for (NodeTemplate nodeTemplate : nodeTemplateExpendDatas) {
            String groupNumber = nodeTemplate.getNumber();
            String presentOldVal = oldJson.getString(groupNumber);
            String presentNewVal = newJson.getString(groupNumber);
            if ((presentOldVal != null || presentNewVal == null) && (presentOldVal == null || presentOldVal.equals(presentNewVal))) continue;
            oldMap.put(groupNumber, presentOldVal);
            newMap.put(groupNumber, presentNewVal);
            expendNumberList.add(nodeTemplate);
        }
        for (NodeTemplate nodeTemplate : expendNumberList) {
            boolean newEnable;
            String number = nodeTemplate.getNumber();
            JSONObject expendOldValue = WfUtils.isEmpty((String)oldMap.get(number)) ? new JSONObject() : JSONObject.parseObject((String)((String)oldMap.get(number)));
            JSONObject expendNewValue = WfUtils.isEmpty((String)newMap.get(number)) ? new JSONObject() : JSONObject.parseObject((String)((String)newMap.get(number)));
            boolean oldEnable = expendOldValue.getBooleanValue(GROUPENABLE);
            if (oldEnable != (newEnable = expendNewValue.getBooleanValue(GROUPENABLE))) {
                HashMap<String, Object> params = new HashMap<String, Object>(15);
                String tagepath = path + "." + number;
                String name = nodeTemplate.getName();
                this.getParams((ILocaleString)new LocaleString(name), flowElementId, flowElementName, elementType, operation, nodeTemplate, number, String.valueOf(oldEnable), String.valueOf(newEnable), params, tagepath);
                paramsList.add(params);
            }
            JSONObject oldExtendedAttribute = expendOldValue.getJSONObject(EXTATTRVALUE) == null ? new JSONObject() : expendOldValue.getJSONObject(EXTATTRVALUE);
            JSONObject newExtendedAttribute = expendNewValue.getJSONObject(EXTATTRVALUE) == null ? new JSONObject() : expendNewValue.getJSONObject(EXTATTRVALUE);
            JSONObject propsDefinition = WfUtils.isEmpty(nodeTemplate.getPropsDefinition()) ? new JSONObject() : JSONObject.parseObject((String)nodeTemplate.getPropsDefinition());
            JSONArray attributes = propsDefinition.getJSONArray(ATTRIBUTES);
            if (attributes == null) continue;
            for (Object attribute : attributes) {
                JSONObject attributeJSONObject = (JSONObject)attribute;
                String attributeNumber = attributeJSONObject.getString(ATTRIBUTENUMBER);
                Object oldAttributeValue = oldExtendedAttribute.get((Object)attributeNumber);
                Object newAttributeValue = newExtendedAttribute.get((Object)attributeNumber);
                if ((oldAttributeValue != null || newAttributeValue == null) && (oldAttributeValue == null || oldAttributeValue.equals(newAttributeValue))) continue;
                HashMap<String, Object> params = new HashMap<String, Object>(15);
                String tagepath = path + "." + number + "." + attributeNumber;
                ILocaleString name = WfMultiLangUtils.getMultiLangValue((Map)SerializationUtils.fromJsonString((String)attributeJSONObject.getString(ATTRIBUTENAME), Map.class));
                this.getParams(name, flowElementId, flowElementName, elementType, operation, nodeTemplate, attributeNumber, SerializationUtils.toJsonString((Object)oldAttributeValue), SerializationUtils.toJsonString((Object)newAttributeValue), params, tagepath);
                paramsList.add(params);
            }
        }
        return paramsList;
    }

    private String getOperation(String oldVal, String newVal) {
        String operation = null;
        operation = this.isEmptyForBatch(oldVal) && !this.isEmptyForBatch(newVal) ? "add" : (this.isEmptyForBatch(newVal) && !this.isEmptyForBatch(oldVal) ? "delete" : "replace");
        return operation;
    }

    private void getParams(ILocaleString name, String flowElementId, String flowElementName, String elementType, String operation, NodeTemplate nodeTemplate, String number, String oldValue, String newValue, Map<String, Object> params, String tagepath) {
        params.put("property", number);
        params.put("propertyName", name);
        params.put("group", nodeTemplate.getNumber());
        params.put("groupName", new LocaleString(nodeTemplate.getName()));
        params.put("elementType", elementType);
        params.put("elementTypeName", new LocaleString(flowElementName));
        params.put("operation", operation);
        params.put("flowElementId", flowElementId);
        params.put("flowElementName", new LocaleString(flowElementName));
        params.put("path", tagepath);
        params.put("oldValue", oldValue);
        params.put("newValue", newValue);
    }

    private boolean isEmptyForBatch(String value) {
        return WfUtils.isEmpty(value) || "[]".equals(value);
    }

    private void putProcessModifyEntities(List<ModelModifyLogEntity> result, List<String> processPaths, BpmnModel bpmnModel, ModelModifyLogEntityManager manager, Integer revision) {
        Process process = bpmnModel.getMainProcess();
        List<Map<String, Object>> params = this.getProcessParams(processPaths, bpmnModel, manager, revision);
        ResourceEntity resource = this.getResourceEntity();
        HashMap<String, Set<Map<String, Object>>> bizGroups = new HashMap<String, Set<Map<String, Object>>>();
        for (Map<String, Object> param : params) {
            ModelModifyLogEntity modelModifyLogEntity;
            if (this.recordBizGroup(param, bizGroups) || !WfUtils.isNotEmpty((modelModifyLogEntity = manager.generateEntity(resource, this.entity, process, param)).getContent()) && !WfUtils.isNotEmpty(modelModifyLogEntity.getOldval())) continue;
            result.add(modelModifyLogEntity);
        }
        this.putMeragedEntity(bizGroups, resource, process, result, manager);
    }

    private List<Map<String, Object>> getProcessParams(List<String> processPaths, BpmnModel bpmnModel, ModelModifyLogEntityManager manager, Integer revision) {
        ArrayList<Map<String, Object>> params = new ArrayList<Map<String, Object>>(16);
        for (String path : processPaths) {
            if (this.isPathsIgnored(path)) continue;
            Object oldVal = BpmnModelUtil.getProcessProperty(this.origModelJson, path);
            Object newVal = BpmnModelUtil.getProcessProperty(this.modelJson, path);
            String oldValStr = null;
            String newValStr = null;
            if (oldVal != null) {
                oldValStr = oldVal.toString();
            }
            if (newVal != null) {
                newValStr = newVal.toString();
            }
            Map<String, Object> param = ModelModifyLogUtils.getParamsByPatch("node_1", oldValStr, newValStr, path, this.entity, bpmnModel, manager);
            if (revision != null) {
                param.put("revision", revision);
            }
            params.add(param);
        }
        return params;
    }

    private ResourceEntity getResourceEntity() {
        Long id = this.entity.getResourceId();
        WorkflowService service = (WorkflowService)ServiceFactory.getService(WorkflowService.class);
        return (ResourceEntity)service.getRepositoryService().findEntityById(id, "wf_resource");
    }

    private boolean isPathsIgnored(String path) {
        if (WfUtils.isEmpty(path)) {
            return false;
        }
        path = path.replace("properties.", "");
        return this.ignoredProps.contains(path);
    }

    private boolean recordBizGroup(Map<String, Object> param, Map<String, Set<Map<String, Object>>> bizGroups) {
        Object bizGroupObj = param.get("bizGroup");
        if (bizGroupObj != null) {
            String bizGroup = (String)bizGroupObj;
            String elementId = param.get("flowElementId") == null ? null : (String)param.get("flowElementId");
            StringBuilder keyBuilder = new StringBuilder();
            keyBuilder.append(elementId).append(":").append(bizGroup);
            String key = keyBuilder.toString();
            Set groupSet = bizGroups.computeIfAbsent(key, k -> new HashSet());
            groupSet.add(new HashMap<String, Object>(param));
            bizGroups.put(key, groupSet);
            return true;
        }
        return false;
    }

    private void putMeragedEntity(Map<String, Set<Map<String, Object>>> bizGroups, ResourceEntity resource, Process process, List<ModelModifyLogEntity> result, ModelModifyLogEntityManager manager) {
        List<Map<String, Object>> mergedParams = ModelModifyLogUtils.mergeBizGroupParams(bizGroups);
        for (Map<String, Object> param : mergedParams) {
            ModelModifyLogEntity modelModifyLogEntity = manager.generateEntity(resource, this.entity, process, param);
            result.add(modelModifyLogEntity);
        }
    }
}

