/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.workflow.engine.impl.cmd.management.scheme;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import kd.bos.context.RequestContext;
import kd.bos.dataentity.entity.ILocaleString;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.query.QFilter;
import kd.bos.workflow.bpmn.converter.BpmnJsonConverter;
import kd.bos.workflow.bpmn.diff.util.BpmnDiffUtil;
import kd.bos.workflow.bpmn.model.AuditTask;
import kd.bos.workflow.bpmn.model.BpmnModel;
import kd.bos.workflow.bpmn.model.CallActivity;
import kd.bos.workflow.bpmn.model.SequenceFlow;
import kd.bos.workflow.bpmn.model.basedata.BaseDataHelper;
import kd.bos.workflow.engine.WfUtils;
import kd.bos.workflow.engine.impl.cmd.management.RemoveProcessDefinitionCacheByIdCmd;
import kd.bos.workflow.engine.impl.cmd.management.scheme.GetConfigSchemeByFiltersCmd;
import kd.bos.workflow.engine.impl.cmd.management.scheme.UpdateProcessInstanceSchemeId;
import kd.bos.workflow.engine.impl.db.BatchSQLInfo;
import kd.bos.workflow.engine.impl.interceptor.Command;
import kd.bos.workflow.engine.impl.interceptor.CommandContext;
import kd.bos.workflow.engine.impl.persistence.entity.design.ResourceEntity;
import kd.bos.workflow.engine.impl.persistence.entity.management.ConditionalEntity;
import kd.bos.workflow.engine.impl.persistence.entity.management.ConditionalRuleEntity;
import kd.bos.workflow.engine.impl.persistence.entity.management.DynamicConfigSchemeEntity;
import kd.bos.workflow.engine.impl.persistence.entity.management.ParticipantModelEntity;
import kd.bos.workflow.engine.impl.persistence.entity.management.ProcessDefinitionEntity;
import kd.bos.workflow.engine.impl.util.BpmnModelUtil;
import kd.bos.workflow.engine.impl.util.CollectionUtil;
import kd.bos.workflow.engine.impl.util.DynamicSchemeUtil;
import kd.bos.workflow.engine.impl.util.ProcessDefinitionUtil;
import kd.bos.workflow.engine.impl.util.condition.ConditionalRuleHelper;
import kd.bos.workflow.engine.management.batchsetting.BatchSettingUtil;
import kd.bos.workflow.engine.management.util.ConditionalRuleConvertUtil;

public class CreateDynamicConfigSchemeCmd
implements Command<DynamicConfigSchemeEntity>,
Serializable {
    protected static Log logger = LogFactory.getLog(CreateDynamicConfigSchemeCmd.class);
    private static final long serialVersionUID = 1L;
    private static final String SCHEMECHAR = "%s_scheme.%s";
    private Long procDefId;
    private String number;
    private String condition;
    private ILocaleString name;
    private ILocaleString description;
    private boolean defaultScheme;
    private boolean compatible;

    public CreateDynamicConfigSchemeCmd(Long procDefId, String number, String condition, ILocaleString name, ILocaleString description) {
        this.procDefId = procDefId;
        this.number = number;
        this.condition = condition;
        this.name = name;
        this.description = description;
    }

    public CreateDynamicConfigSchemeCmd(Long procDefId, boolean isDefault) {
        this.procDefId = procDefId;
        this.defaultScheme = isDefault;
    }

    public CreateDynamicConfigSchemeCmd(Long procDefId, boolean isDefault, boolean compatible) {
        this.procDefId = procDefId;
        this.defaultScheme = isDefault;
        this.compatible = compatible;
    }

    @Override
    public DynamicConfigSchemeEntity execute(CommandContext commandContext) {
        DynamicConfigSchemeEntity entity = (DynamicConfigSchemeEntity)commandContext.getDynamicConfigSchemeEntityManager().create();
        ResourceEntity schemeResource = null;
        String resourceName = null;
        String content = null;
        Long defaultSchemeId = 0L;
        if (this.defaultScheme) {
            ProcessDefinitionEntity procDef = (ProcessDefinitionEntity)commandContext.getProcessDefinitionEntityManager().findById(this.procDefId);
            String defSchemeNumber = DynamicSchemeUtil.getDefaultSchemeNumber(procDef.getKey(), procDef.getVersion());
            ResourceEntity resource = (ResourceEntity)commandContext.getResourceEntityManager().findById(procDef.getResourceId());
            if (this.compatible) {
                BpmnModel bpmnModel = ProcessDefinitionUtil.getBpmnModel(this.procDefId, null);
                this.filterBpmnModel(bpmnModel);
                content = new BpmnJsonConverter().convertToJson(bpmnModel).toString();
            } else {
                content = resource.getData();
            }
            content = BpmnDiffUtil.fixArrayElementId(content);
            resource.setData(content);
            commandContext.getResourceEntityManager().update(resource);
            if (this.compatible) {
                commandContext.getProcessDefinitionEntityManager().update(procDef);
                new RemoveProcessDefinitionCacheByIdCmd(this.procDefId).execute(commandContext);
            }
            resourceName = String.format(SCHEMECHAR, procDef.getKey(), "diff_json");
            ResourceEntity patchResource = this.createJsonResource(commandContext, resourceName);
            entity.setJsonPatchId(patchResource.getId());
            entity.setJsonResourceId(procDef.getResourceId());
            this.setDefaultSchemeInfo(entity, defSchemeNumber);
        } else {
            QFilter[] filters = new QFilter[]{new QFilter("processdefinitionid", "=", (Object)this.procDefId), new QFilter("isdefault", "=", (Object)Boolean.TRUE)};
            Object schemes = new GetConfigSchemeByFiltersCmd(filters).execute(commandContext);
            DynamicConfigSchemeEntity defScheme = (DynamicConfigSchemeEntity)schemes.get(0);
            defaultSchemeId = defScheme.getId();
            resourceName = String.format(SCHEMECHAR, this.number, "patch_json");
            schemeResource = this.createJsonResource(commandContext, resourceName);
            entity.setJsonResourceId(schemeResource.getId());
            resourceName = String.format(SCHEMECHAR, this.number, "diff_json");
            ResourceEntity patchResource = this.createJsonResource(commandContext, resourceName);
            entity.setJsonPatchId(patchResource.getId());
            this.setSchemeInfo(commandContext, entity, defScheme.getId());
            entity.setState("disable");
            ResourceEntity resource = (ResourceEntity)commandContext.getResourceEntityManager().findById(defScheme.getJsonResourceId());
            content = resource.getData();
        }
        Date date = WfUtils.now();
        entity.setSourceKey(entity.getNumber());
        entity.setAcquiescence(this.defaultScheme);
        entity.setProcDefId(this.procDefId);
        entity.setCreateDate(date);
        entity.setCreatorId(Long.valueOf(RequestContext.get().getUserId()));
        commandContext.getDynamicConfigSchemeEntityManager().insert(entity);
        if (this.defaultScheme && this.compatible) {
            new UpdateProcessInstanceSchemeId(this.procDefId, entity.getId()).execute(commandContext);
        }
        if (!this.defaultScheme) {
            BatchSettingUtil.createProcessInfo(commandContext, entity, content);
        }
        BpmnModelUtil.disposeDynamicPartial(content, entity);
        if (!this.defaultScheme) {
            this.updateParticipantModelForDefaultScheme(commandContext, defaultSchemeId, entity.getId());
        }
        BpmnModelUtil.recordBaseDataRef(content, entity.getProcDefId(), entity.getSchemeId());
        if (WfUtils.isNotEmpty(this.condition)) {
            BaseDataHelper.recordBaseDataRefForStartUpCond(ConditionalRuleConvertUtil.jsonToConditionalRuleModel(this.condition), this.procDefId, entity.getSchemeId());
        }
        return entity;
    }

    private void updateParticipantModelForDefaultScheme(CommandContext commandContext, Long defaultSchemeId, Long newSchemedId) {
        QFilter filter1 = new QFilter("type", "=", (Object)"person");
        QFilter filter2 = new QFilter("schemeId", "=", (Object)defaultSchemeId);
        List defaultParticipantModels = commandContext.getParticipantModelEntityManager().findByQueryFilters(new QFilter[]{filter1, filter2});
        if (CollectionUtil.isEmpty(defaultParticipantModels)) {
            return;
        }
        ArrayList<Object[]> batchParams = new ArrayList<Object[]>(defaultParticipantModels.size());
        for (ParticipantModelEntity participantModelEntity : defaultParticipantModels) {
            batchParams.add(new Object[]{participantModelEntity.getValue(), newSchemedId, participantModelEntity.getModelJsonPartId(), participantModelEntity.getTaskActivityId()});
        }
        String batchSql = "update t_wf_participantmodel set fvalue = ? where fschemeId = ? and fmodjsonpartid = ? and ftaskactivityId = ?";
        BatchSQLInfo info = new BatchSQLInfo(batchSql, batchParams, 500);
        commandContext.getDbSqlSession().addBatchSQLInfo(info);
    }

    private void filterBpmnModel(BpmnModel bpmnModel) {
        try {
            List<CallActivity> callActivities;
            List<AuditTask> auditTasks = bpmnModel.getMainProcess().findFlowElementsOfType(AuditTask.class);
            if (auditTasks != null) {
                for (AuditTask elem : auditTasks) {
                    if (!elem.isDynamicReject()) continue;
                    elem.removeAttribute("dynamicReject");
                    List<SequenceFlow> flows = elem.getOutgoingFlows();
                    for (SequenceFlow flow : flows) {
                        this.setConditionRuleAndExpression(flow);
                    }
                }
            }
            if ((callActivities = bpmnModel.getMainProcess().findFlowElementsOfType(CallActivity.class)) != null) {
                for (CallActivity callActivity : callActivities) {
                    if (!callActivity.isDynamicReject()) continue;
                    callActivity.removeAttribute("dynamicReject");
                    List<SequenceFlow> flows = callActivity.getOutgoingFlows();
                    for (SequenceFlow flow : flows) {
                        this.setConditionRuleAndExpression(flow);
                    }
                }
            }
        }
        catch (Exception e) {
            logger.error(WfUtils.getExceptionStacktrace(e));
        }
    }

    private void setConditionRuleAndExpression(SequenceFlow flow) {
        List<ConditionalEntity> conditionalEntrys;
        ConditionalRuleEntity conditionalRule = flow.getConditionalRule();
        if (conditionalRule != null && (conditionalEntrys = conditionalRule.getEntryentity()) != null && !conditionalEntrys.isEmpty()) {
            if (conditionalEntrys.size() == 1) {
                flow.setConditionalRule(null);
                flow.setConditionExpression(null);
            } else {
                ArrayList<ConditionalEntity> addEntitys = new ArrayList<ConditionalEntity>();
                List<Map<String, Object>> items = this.getConditionalRuleItems(flow, addEntitys);
                flow.getConditionalRule().setEntryentity(addEntitys);
                String expression = ConditionalRuleHelper.getConditionExpression(ConditionalRuleHelper.getConditionItems(items));
                flow.setConditionExpression(expression);
            }
        }
    }

    private List<Map<String, Object>> getConditionalRuleItems(SequenceFlow flow, List<ConditionalEntity> addEntitys) {
        Iterator<ConditionalEntity> iter = flow.getConditionalRule().getEntryentity().iterator();
        ArrayList<Map<String, Object>> items = new ArrayList<Map<String, Object>>();
        while (iter.hasNext()) {
            ConditionalEntity entity = iter.next();
            if ("auditNumber".equalsIgnoreCase(entity.getParamnumber())) continue;
            addEntitys.add(entity);
            HashMap<String, String> map = new HashMap<String, String>(7);
            map.put("value", entity.getValue());
            map.put("leftbracket", entity.getLeftbracket());
            map.put("operation", entity.getOperation());
            map.put("rightbracket", entity.getRightbracket());
            map.put("logic", entity.getLogic());
            map.put("valuetype", entity.getValuetype());
            map.put("paramnumber", entity.getParamnumber());
            items.add(map);
        }
        return items;
    }

    private ResourceEntity createJsonResource(CommandContext commandContext, String resourceName) {
        ResourceEntity schemeResource = (ResourceEntity)commandContext.getResourceEntityManager().create();
        schemeResource.setName(resourceName);
        commandContext.getResourceEntityManager().insert(schemeResource);
        return schemeResource;
    }

    private void setDefaultSchemeInfo(DynamicConfigSchemeEntity entity, String number) {
        entity.setState("enable");
        ILocaleString name = WfUtils.getPromptWordLocaleString("\u9ed8\u8ba4\u65b9\u6848", "CreateDynamicConfigSchemeCmd_0", "bos-wf-engine");
        entity.setName(name);
        entity.setNumber(number);
        ILocaleString desc = WfUtils.getPromptWordLocaleString("\u9ed8\u8ba4\u65b9\u6848\uff0c\u7cfb\u7edf\u81ea\u5e26", "CreateDynamicConfigSchemeCmd_1", "bos-wf-engine");
        entity.setDescription(desc);
    }

    private void setSchemeInfo(CommandContext commandContext, DynamicConfigSchemeEntity entity, Long parentSchemeId) {
        entity.setName(this.name);
        entity.setNumber(this.number);
        entity.setDescription(this.description);
        ConditionalRuleEntity condition = this.saveCondition(commandContext);
        entity.setConditionId(condition.getId());
        entity.setConditionText(condition.getShowtext());
        entity.setConditionExpression(condition.getExpression());
        entity.setParentSchemeId(parentSchemeId);
    }

    private ConditionalRuleEntity saveCondition(CommandContext commandContext) {
        ConditionalRuleEntity entity = ConditionalRuleConvertUtil.jsonToConditionalRuleModel(this.condition);
        commandContext.getConditionRuleEntityManager().insert(entity);
        return entity;
    }

    public Long getProcDefId() {
        return this.procDefId;
    }

    public void setProcDefId(Long procDefId) {
        this.procDefId = procDefId;
    }

    public String getNumber() {
        return this.number;
    }

    public void setNumber(String number) {
        this.number = number;
    }

    public String getCondition() {
        return this.condition;
    }

    public void setCondition(String condition) {
        this.condition = condition;
    }

    public ILocaleString getName() {
        return this.name;
    }

    public void setName(ILocaleString name) {
        this.name = name;
    }

    public ILocaleString getDescription() {
        return this.description;
    }

    public void setDescription(ILocaleString description) {
        this.description = description;
    }

    public boolean isDefault() {
        return this.defaultScheme;
    }

    public void setDefault(boolean isDefault) {
        this.defaultScheme = isDefault;
    }
}

