/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.workflow.engine.impl.cmd.management.scheme;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.List;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.resource.promptenum.MultiLangEnumBridge;
import kd.bos.orm.query.QFilter;
import kd.bos.workflow.engine.WfUtils;
import kd.bos.workflow.engine.impl.interceptor.Command;
import kd.bos.workflow.engine.impl.interceptor.CommandContext;
import kd.bos.workflow.engine.impl.persistence.entity.management.DynamicConfigSchemeEntity;
import kd.bos.workflow.engine.impl.persistence.entity.management.DynamicConfigSchemeEntityManager;
import kd.bos.workflow.engine.impl.persistence.entity.management.ParticipantModelEntity;
import kd.bos.workflow.engine.impl.persistence.entity.management.ParticipantModelEntityManager;
import kd.bos.workflow.engine.impl.persistence.entity.operationlog.ModelModifyLogEntityManager;
import kd.bos.workflow.exception.WFException;

public class DeleteDynamicConfigSchemeCmd
implements Command<Void>,
Serializable {
    private static final long serialVersionUID = 1L;
    private Long schemeId;

    public DeleteDynamicConfigSchemeCmd(Long schemeId) {
        this.schemeId = schemeId;
    }

    @Override
    public Void execute(CommandContext commandContext) {
        QFilter[] filters = new QFilter[]{new QFilter("schemeId", "=", (Object)this.schemeId)};
        List procInsts = commandContext.getHistoricProcessInstanceEntityManager().findByQueryFilters(filters, true);
        if (procInsts != null && !procInsts.isEmpty()) {
            String message = ResManager.loadKDString((String)"\u914d\u7f6e\u65b9\u6848\u5df2\u88ab\u4f7f\u7528\uff0c\u4e0d\u80fd\u5220\u9664\u3002", (String)"DeleteDynamicConfigSchemeCmd_1", (String)"bos-wf-engine", (Object[])new Object[0]);
            throw new WFException(message, new Exception(message));
        }
        DynamicConfigSchemeEntityManager manager = commandContext.getDynamicConfigSchemeEntityManager();
        DynamicConfigSchemeEntity scheme = (DynamicConfigSchemeEntity)manager.findById(this.schemeId);
        if (scheme.isAcquiescence()) {
            String message = ResManager.loadKDString((String)"\u9ed8\u8ba4\u65b9\u6848\u4e0d\u80fd\u5220\u9664\u3002", (String)"DeleteDynamicConfigSchemeCmd_2", (String)"bos-wf-engine", (Object[])new Object[0]);
            throw new WFException(message, new Exception(message));
        }
        commandContext.getConditionRuleEntityManager().delete(scheme.getConditionId());
        commandContext.getResourceEntityManager().delete(scheme.getJsonResourceId());
        commandContext.getResourceEntityManager().delete(scheme.getJsonPatchId());
        this.deleteParticipantModel(commandContext);
        commandContext.getDynamicConfigSchemeEntityManager().delete(scheme.getId());
        this.deleteModelModifyLogs(commandContext);
        commandContext.getProcessInfoEntityManager().deleteProcessInfoBySchemeId(scheme.getId());
        commandContext.getModelDataChangeLogEntityManager().deleteChangeLogsBySchemeId(scheme.getId());
        commandContext.getBaseDataRefRecordManager().deleteBaseDataRefRecordBySchemeId(this.schemeId);
        WfUtils.addOpLog("wf_processdynamicconfig", "delete", new MultiLangEnumBridge("\u5220\u9664\u6d41\u7a0b\u65b9\u6848", "DeleteDynamicConfigSchemeCmd_3", "bos-wf-engine"), new MultiLangEnumBridge("ID: [%1$s] \u540d\u79f0: %2$s \u7f16\u7801: %3$s", "DeleteDynamicConfigSchemeCmd_4", "bos-wf-engine"), scheme.getId(), scheme.getName().getLocaleValue(), scheme.getNumber());
        return null;
    }

    private void deleteModelModifyLogs(CommandContext commandContext) {
        QFilter schemeIdFilter = new QFilter("schemeid", "=", (Object)this.schemeId);
        ModelModifyLogEntityManager manager = commandContext.getModifyLogEntityManager();
        manager.deleteByFilters(new QFilter[]{schemeIdFilter});
    }

    private void deleteParticipantModel(CommandContext commandContext) {
        QFilter[] filters = new QFilter[]{new QFilter("schemeId", "=", (Object)this.schemeId)};
        ParticipantModelEntityManager participantEntityManager = commandContext.getParticipantModelEntityManager();
        List participants = participantEntityManager.findByQueryFilters(filters);
        if (!participants.isEmpty()) {
            ArrayList<Long> conditionIds = new ArrayList<Long>();
            ArrayList<Long> participantIds = new ArrayList<Long>(participants.size());
            for (ParticipantModelEntity participant : participants) {
                participantIds.add(participant.getId());
                if (!WfUtils.isNotEmpty(participant.getCondRuleId())) continue;
                conditionIds.add(participant.getCondRuleId());
            }
            filters = new QFilter[]{new QFilter("id", "in", participantIds)};
            participantEntityManager.deleteByFilters(filters);
            if (!conditionIds.isEmpty()) {
                filters = new QFilter[]{new QFilter("id", "in", conditionIds)};
                commandContext.getConditionRuleEntityManager().deleteByFilters(filters);
            }
        }
    }
}

