/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.workflow.engine.impl.cmd.management.scheme;

import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONArray;
import com.alibaba.fastjson.JSONObject;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import kd.bos.orm.query.QFilter;
import kd.bos.workflow.engine.WfUtils;
import kd.bos.workflow.engine.impl.interceptor.Command;
import kd.bos.workflow.engine.impl.interceptor.CommandContext;
import kd.bos.workflow.engine.impl.persistence.entity.design.ResourceEntity;
import kd.bos.workflow.engine.impl.persistence.entity.design.ResourceEntityManager;
import kd.bos.workflow.engine.impl.persistence.entity.management.DynamicConfigSchemeEntity;
import kd.bos.workflow.engine.impl.util.BpmnModelUtil;

public class GetChildrenSchemesDecisionsCmd
implements Command<Map<String, List<String>>>,
Serializable {
    private static final long serialVersionUID = 1L;
    private Long schemeId;
    private String itemId;

    public GetChildrenSchemesDecisionsCmd(Long schemeId, String itemId) {
        this.schemeId = schemeId;
        this.itemId = itemId;
    }

    @Override
    public Map<String, List<String>> execute(CommandContext commandContext) {
        HashMap<String, List<String>> result = null;
        ResourceEntityManager resourceManager = commandContext.getResourceEntityManager();
        QFilter[] filters = new QFilter[]{new QFilter("parentschemeid", "=", (Object)this.schemeId)};
        List childrenSchemes = commandContext.getDynamicConfigSchemeEntityManager().findByQueryFilters(filters);
        if (childrenSchemes == null || childrenSchemes.isEmpty()) {
            return new HashMap<String, List<String>>();
        }
        ResourceEntity resource = null;
        result = new HashMap<String, List<String>>(childrenSchemes.size());
        for (DynamicConfigSchemeEntity entity : childrenSchemes) {
            JSONObject node;
            List<String> numberList;
            resource = (ResourceEntity)resourceManager.findById(entity.getJsonResourceId());
            String data = resource.getData();
            if (WfUtils.isEmpty(data) || (numberList = this.getConditionPatchNode(node = JSON.parseObject((String)data), this.itemId)) == null) continue;
            result.put(String.format("%s[%s]", entity.getName(), entity.getNumber()), numberList);
        }
        return result;
    }

    private List<String> getConditionPatchNode(JSONObject node, String itemId) {
        JSONArray childShapes = node.getJSONArray("childShapes");
        if (childShapes == null || childShapes.isEmpty()) {
            return null;
        }
        ArrayList<String> resultList = new ArrayList<String>();
        for (int i = 0; i < childShapes.size(); ++i) {
            JSONObject child = childShapes.getJSONObject(i);
            if (!itemId.equals(child.getString("resourceId"))) continue;
            JSONArray decisionOptions = (JSONArray)BpmnModelUtil.getProperty((Map<String, Object>)child, "properties.decisionOptions");
            this.getDecisionOptionNumbers(resultList, decisionOptions);
            break;
        }
        return resultList;
    }

    private void getDecisionOptionNumbers(List<String> resultList, JSONArray decisionOptions) {
        if (decisionOptions != null && !decisionOptions.isEmpty()) {
            for (int j = 0; j < decisionOptions.size(); ++j) {
                JSONObject decisionOption = decisionOptions.getJSONObject(j);
                String number = decisionOption.getString("number");
                if (decisionOption.getBooleanValue("_independent_") || !WfUtils.isNotEmpty(number)) continue;
                resultList.add(number.toLowerCase());
            }
        }
    }
}

