/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.workflow.engine.impl.cmd.management.scheme;

import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.ObjectMapper;
import java.io.IOException;
import java.io.Serializable;
import kd.bos.context.RequestContext;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.exception.KDBizException;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.workflow.bpmn.diff.util.BpmnDiffUtil;
import kd.bos.workflow.engine.impl.interceptor.Command;
import kd.bos.workflow.engine.impl.interceptor.CommandContext;
import kd.bos.workflow.engine.impl.persistence.entity.design.ResourceEntity;
import kd.bos.workflow.engine.impl.persistence.entity.design.ResourceEntityManager;
import kd.bos.workflow.engine.impl.persistence.entity.management.DynamicConfigSchemeEntity;
import kd.bos.workflow.engine.impl.util.BpmnModelUtil;
import kd.bos.workflow.engine.impl.util.ExtractMultiLanguageWordsUtil;

public class GetConfigSchemeBpmnJsonStringCmd
implements Command<String>,
Serializable {
    private static final long serialVersionUID = 1L;
    private Log log = LogFactory.getLog(this.getClass());
    private Long schemeId;
    private String state;

    public GetConfigSchemeBpmnJsonStringCmd(Long schemeId, String state) {
        this.schemeId = schemeId;
        this.state = state;
    }

    @Override
    public String execute(CommandContext commandContext) {
        DynamicConfigSchemeEntity scheme = (DynamicConfigSchemeEntity)commandContext.getDynamicConfigSchemeEntityManager().findById(this.schemeId);
        if (this.state != null && !this.state.equals(scheme.getState())) {
            return null;
        }
        this.log.debug(String.format("\u83b7\u53d6\u65b9\u6848%s[%s]\u7684\u8d44\u6e90\uff01", scheme.getNumber(), scheme.getId()));
        if (scheme.isAcquiescence()) {
            ResourceEntity resource = (ResourceEntity)commandContext.getResourceEntityManager().findById(scheme.getJsonResourceId());
            String lang = RequestContext.get().getLang().toString();
            return ExtractMultiLanguageWordsUtil.getMultiLanguageResourceData(resource, lang);
        }
        return this.getSchemeBpmnJsonString(commandContext, scheme);
    }

    private String getSchemeBpmnJsonString(CommandContext commandContext, DynamicConfigSchemeEntity scheme) {
        ResourceEntityManager resourceManager = commandContext.getResourceEntityManager();
        ResourceEntity patchResource = (ResourceEntity)resourceManager.findById(scheme.getJsonResourceId());
        DynamicConfigSchemeEntity parentScheme = (DynamicConfigSchemeEntity)commandContext.getDynamicConfigSchemeEntityManager().findById(scheme.getParentSchemeId());
        ResourceEntity resource = (ResourceEntity)resourceManager.findById(parentScheme.getJsonResourceId());
        try {
            String lang = RequestContext.get().getLang().toString();
            String sourceJson = ExtractMultiLanguageWordsUtil.getMultiLanguageResourceData(resource, lang);
            if (!BpmnModelUtil.isEmptyResource(patchResource.getData())) {
                String content = ExtractMultiLanguageWordsUtil.getMultiLanguagePatchResourceData(patchResource, lang);
                JsonNode source = new ObjectMapper().readTree(sourceJson);
                this.log.debug(String.format("\u65b9\u6848%s[%s]\u5408\u5e76\u5dee\u91cf: %s", scheme.getNumber(), scheme.getId(), content));
                JsonNode target = BpmnDiffUtil.applyPatch(source, content);
                this.log.debug(String.format("\u65b9\u6848[%s]\u5408\u5e76\u540e\u7684JSON: %s", scheme.getId(), target));
                return target.toString();
            }
            this.log.debug(String.format("\u65b9\u6848%s[%s]\u6ca1\u6709\u5dee\u91cf!", scheme.getNumber(), scheme.getId()));
            return sourceJson;
        }
        catch (IOException e) {
            throw new KDBizException(String.format(ResManager.loadKDString((String)"\u83b7\u53d6\u65b9\u6848%1$s\u201c%2$s\u201d\u7684\u8d44\u6e90\u51fa\u9519\uff0c\u539f\u56e0\uff1a%3$s\u3002", (String)"GetConfigSchemeBpmnJsonStringCmd_1", (String)"bos-wf-engine", (Object[])new Object[0]), scheme.getNumber(), scheme.getId(), e.getMessage()));
        }
    }
}

