/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.workflow.engine.impl.cmd.management.scheme;

import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.ObjectMapper;
import java.io.Serializable;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.workflow.bpmn.converter.BpmnJsonConverter;
import kd.bos.workflow.bpmn.diff.util.BpmnDiffUtil;
import kd.bos.workflow.bpmn.model.BpmnModel;
import kd.bos.workflow.engine.WfUtils;
import kd.bos.workflow.engine.impl.interceptor.Command;
import kd.bos.workflow.engine.impl.interceptor.CommandContext;
import kd.bos.workflow.engine.impl.persistence.entity.design.ResourceEntity;
import kd.bos.workflow.engine.impl.persistence.entity.design.ResourceEntityManager;
import kd.bos.workflow.engine.impl.persistence.entity.management.DynamicConfigSchemeEntity;
import kd.bos.workflow.engine.impl.util.ProcessDefinitionUtil;
import kd.bos.workflow.exception.WFException;

public class GetConfigSchemeBpmnModelCmd
implements Command<BpmnModel>,
Serializable {
    private static final long serialVersionUID = 1L;
    private Log log = LogFactory.getLog(this.getClass());
    private Long schemeId;

    public GetConfigSchemeBpmnModelCmd(Long schemeId) {
        this.schemeId = schemeId;
    }

    @Override
    public BpmnModel execute(CommandContext commandContext) {
        BpmnModel bpmnModel = null;
        DynamicConfigSchemeEntity scheme = (DynamicConfigSchemeEntity)commandContext.getDynamicConfigSchemeEntityManager().findById(this.schemeId);
        if (scheme.isAcquiescence()) {
            ResourceEntity resource = (ResourceEntity)commandContext.getResourceEntityManager().findById(scheme.getJsonResourceId());
            return ProcessDefinitionUtil.getBpmnModel(resource.getData());
        }
        bpmnModel = this.getSchemeBpmnModel(commandContext, scheme);
        return bpmnModel;
    }

    private BpmnModel getSchemeBpmnModel(CommandContext commandContext, DynamicConfigSchemeEntity scheme) {
        ResourceEntityManager resourceManager = commandContext.getResourceEntityManager();
        ResourceEntity patchResource = (ResourceEntity)resourceManager.findById(scheme.getJsonResourceId());
        DynamicConfigSchemeEntity parentScheme = (DynamicConfigSchemeEntity)commandContext.getDynamicConfigSchemeEntityManager().findById(scheme.getParentSchemeId());
        ResourceEntity resource = (ResourceEntity)resourceManager.findById(parentScheme.getJsonResourceId());
        try {
            JsonNode source = new ObjectMapper().readTree(resource.getData());
            String content = patchResource.getData();
            if (WfUtils.isNotEmpty(content)) {
                JsonNode target = BpmnDiffUtil.applyPatch(source, content);
                this.log.debug(String.format("\u65b9\u6848[%s]\u5408\u5e76\u540e\u7684JSON: %s", scheme.getId(), target));
                return new BpmnJsonConverter().convertToBpmnModel(target);
            }
            return new BpmnJsonConverter().convertToBpmnModel(source);
        }
        catch (Exception e) {
            this.log.error(String.format("Json Resource\u8f6cBpmnModel\u5931\u8d25\uff01\u539f\u56e0\uff1a%s", e.getMessage()), (Throwable)e);
            throw new WFException(e.getMessage());
        }
    }
}

