/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.workflow.engine.impl.cmd.management.scheme;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.resource.promptenum.MultiLangEnumBridge;
import kd.bos.dataentity.serialization.DcxmlSerializer;
import kd.bos.dataentity.serialization.SerializationUtils;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.workflow.bpmn.model.deploy.ExportScheme;
import kd.bos.workflow.domain.model.NodeLifecycleUtil;
import kd.bos.workflow.engine.WfUtils;
import kd.bos.workflow.engine.impl.cmd.job.EventTriggerCmd;
import kd.bos.workflow.engine.impl.cmd.management.ImportSchemeCmd;
import kd.bos.workflow.engine.impl.interceptor.Command;
import kd.bos.workflow.engine.impl.interceptor.CommandContext;
import kd.bos.workflow.engine.impl.interceptor.DefaultCommandContextCloseListener;
import kd.bos.workflow.engine.impl.scheme.enumeration.ImportType;
import kd.bos.workflow.engine.impl.scheme.model.ImportSchemeParameter;
import kd.bos.workflow.exception.WFIllegalArgumentException;
import kd.bos.workflow.validation.ValidationError;

public class ImportSchemesCmd
implements Command<List<ValidationError>> {
    private Log log = LogFactory.getLog(this.getClass());
    private List<ImportSchemeParameter> parameters;
    private String appId;

    public ImportSchemesCmd(List<ImportSchemeParameter> parameters) {
        this.parameters = parameters;
    }

    public ImportSchemesCmd(List<ImportSchemeParameter> parameters, String appId) {
        this.parameters = parameters;
        this.appId = appId;
    }

    @Override
    public List<ValidationError> execute(CommandContext commandContext) {
        if (this.parameters == null || this.parameters.isEmpty()) {
            throw new WFIllegalArgumentException(ResManager.loadKDString((String)"\u5bfc\u5165\u65b9\u6848\u6240\u9700\u53c2\u6570\u201cparameters\u201d\u4e3a\u7a7a\u3002", (String)"ImportSchemesCmd_1", (String)"bos-wf-engine", (Object[])new Object[0]));
        }
        StringBuilder sb = new StringBuilder();
        ExportScheme exportScheme = null;
        DcxmlSerializer serializer = new DcxmlSerializer(ExportScheme.getDCBinder());
        serializer.setColloctionIgnorePKValue(true);
        int count = 0;
        ArrayList<ValidationError> processValidateResults = new ArrayList<ValidationError>();
        for (ImportSchemeParameter parameter : this.parameters) {
            if (ImportType.DONOTHING == parameter.getImportType()) {
                this.log.debug(String.format("%s \u65b9\u6848\u6587\u4ef6\u4e0d\u5bfc\u5165", parameter.getFilename()));
                continue;
            }
            boolean isCover = ImportType.COVER == parameter.getImportType();
            exportScheme = (ExportScheme)serializer.deserializeFromString(parameter.getSchemeContent(), null);
            Object validateInformation = new ImportSchemeCmd(exportScheme, parameter).execute(commandContext);
            Long processDefinitionId = null;
            if (validateInformation != null && !validateInformation.isEmpty()) {
                Object validateObject;
                processDefinitionId = (Long)validateInformation.get("procDefId");
                parameter.setProcessDefinitionId(processDefinitionId);
                if (isCover && (validateObject = validateInformation.get("validateResults")) != null) {
                    List validateResults = SerializationUtils.fromJsonStringToList((String)validateObject.toString(), ValidationError.class);
                    processValidateResults.addAll(validateResults);
                }
            }
            sb.append(parameter.getName()).append('[').append(parameter.getNumber()).append("] ");
            ++count;
            if (commandContext.getProcessEngineConfiguration().isEnableBecEventDispatcher()) {
                HashMap<String, Long> params = new HashMap<String, Long>();
                params.put("processDefinitionId", processDefinitionId);
                new EventTriggerCmd("wf.AfterImportSchemeEvent", SerializationUtils.toJsonString(params)).execute(commandContext);
            }
            final Long procDefId = processDefinitionId;
            commandContext.addCloseListener(new DefaultCommandContextCloseListener("lifecycleListener"){

                @Override
                public void closed(CommandContext commandContext) {
                    try {
                        NodeLifecycleUtil.executeLifecycleImportSchemesListener(procDefId);
                    }
                    catch (Exception e) {
                        this.log.error(WfUtils.getExceptionStacktrace(e));
                    }
                }
            });
        }
        WfUtils.addOpLogByAppId(this.appId, "wf_processdefinition", "barimport", new MultiLangEnumBridge("\u5bfc\u5165\u6d41\u7a0b\u53ca\u65b9\u6848", "ImportSchemesCmd_2", "bos-wf-engine"), new MultiLangEnumBridge("\u5171\u5bfc\u5165%1$s\u4e2a\u6d41\u7a0b(\u53ca\u65b9\u6848)\uff0c\u8be6\u60c5\uff1a%2$s\u3002", "ImportSchemesCmd_3", "bos-wf-engine"), count, sb.toString());
        return processValidateResults;
    }
}

