/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.workflow.engine.impl.cmd.management.scheme;

import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONObject;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;
import kd.bos.algo.DataSet;
import kd.bos.algo.Row;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.ILocaleString;
import kd.bos.db.DB;
import kd.bos.db.DBRoute;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.workflow.engine.TableNameConstant;
import kd.bos.workflow.engine.WfUtils;
import kd.bos.workflow.engine.impl.cache.WfCacheHelper;
import kd.bos.workflow.engine.impl.persistence.entity.design.ResourceEntity;

public class ProcessMultiLangDataHelper {
    private String DATA = "data";
    private String LANG = "lang";
    private Log log = LogFactory.getLog(this.getClass());

    public JSONObject getConfigSchemeMultiLangData(Long processInstanceId) {
        try {
            String cache;
            Long schemeId = WfCacheHelper.getCachedSchemeId(processInstanceId);
            if (WfUtils.isNotEmpty(schemeId) && WfUtils.isNotEmpty(cache = WfCacheHelper.getSchemeMultiLangDatas(schemeId))) {
                return JSON.parseObject((String)cache);
            }
            return this.getMultiLangData(processInstanceId);
        }
        catch (Exception e) {
            this.log.error(String.format("\u83b7\u53d6\u6d41\u7a0b %s \u7684\u591a\u8bed\u8a00\u6570\u636e\u51fa\u9519\uff0c\u539f\u56e0\uff1a%s", processInstanceId, WfUtils.getExceptionStacktrace(e)));
            return new JSONObject();
        }
    }

    private JSONObject getMultiLangData(Long processInstanceId) {
        String sql = String.format("SELECT FID, FPARENTSCHEME, FBPMNJSON FROM T_WF_DYNCONFSCHEME WHERE FID = (SELECT FSCHEMEID FROM %s WHERE FID = ?);", TableNameConstant.getHiProcInstTableName());
        Long schemeId = null;
        Long parentSchemeId = null;
        Long bpmnJsonId = null;
        try (DataSet ds = DB.queryDataSet((String)"wf.engine.querySchemeInfoByProcInstId", (DBRoute)DBRoute.workflow, (String)sql, (Object[])new Object[]{processInstanceId});){
            Iterator iter = ds.iterator();
            if (iter.hasNext()) {
                Row row = (Row)iter.next();
                schemeId = row.getLong("FID");
                bpmnJsonId = row.getLong("FBPMNJSON");
                parentSchemeId = row.getLong("FPARENTSCHEME");
            }
        }
        if (WfUtils.isEmpty(schemeId)) {
            return new JSONObject();
        }
        String cache = WfCacheHelper.getSchemeMultiLangDatas(schemeId);
        if (WfUtils.isNotEmpty(cache)) {
            return JSON.parseObject((String)cache);
        }
        ArrayList<Long> ids = new ArrayList<Long>();
        ids.add(bpmnJsonId);
        Long parentBpmnJsonId = null;
        if (WfUtils.isNotEmpty(parentSchemeId)) {
            sql = "SELECT FBPMNJSON FROM T_WF_DYNCONFSCHEME WHERE FID = ?;";
            try (DataSet ds = DB.queryDataSet((String)"wf.engine.querySchemeJsonIdBySchemeId", (DBRoute)DBRoute.workflow, (String)sql, (Object[])new Object[]{parentSchemeId});){
                Iterator iter = ds.iterator();
                if (iter.hasNext()) {
                    Row row = (Row)iter.next();
                    parentBpmnJsonId = row.getLong("FBPMNJSON");
                }
            }
            ids.add(parentBpmnJsonId);
        }
        QFilter[] filters = new QFilter[]{new QFilter("id", "in", ids)};
        DynamicObject[] resources = BusinessDataServiceHelper.load((String)"wf_resource", (String)String.format("%s,%s", "id", "content"), (QFilter[])filters);
        if (resources == null || resources.length == 0) {
            return new JSONObject();
        }
        ILocaleString multiData = null;
        ILocaleString parentMultiData = null;
        for (DynamicObject resource : resources) {
            Long resourceId = resource.getLong("id");
            if (resourceId.equals(bpmnJsonId)) {
                multiData = resource.getLocaleString("content");
                continue;
            }
            if (!resourceId.equals(parentBpmnJsonId)) continue;
            parentMultiData = resource.getLocaleString("content");
        }
        if (multiData == null) {
            return new JSONObject();
        }
        JSONObject result = null;
        result = parentMultiData == null ? this.getMultiDataJSON(multiData) : this.getMultiDataJSON(multiData, parentMultiData);
        WfCacheHelper.putSchemeMultiLangDatas(schemeId, JSON.toJSONString((Object)result));
        return result;
    }

    public JSONObject getResourceMultiLangData(ResourceEntity resource) {
        if (resource == null || WfUtils.isEmpty(resource.getData())) {
            this.log.debug("resource is null or resource's data is empty!");
            return new JSONObject();
        }
        ILocaleString multiData = resource.getContent();
        if (WfUtils.isEmpty(multiData)) {
            this.log.debug("resource's content is null!");
            return new JSONObject();
        }
        return this.getMultiDataJSON(multiData);
    }

    private JSONObject getMultiDataJSON(ILocaleString data) {
        JSONObject ret = new JSONObject();
        JSONObject value = null;
        JSONObject jsonData = null;
        for (String key : data.keySet()) {
            value = this.getValidatedMultiJSON((String)data.get((Object)key));
            if (value == null || (jsonData = value.getJSONObject(this.DATA)) == null) continue;
            ret.put(key, (Object)jsonData);
        }
        return ret;
    }

    private JSONObject getMultiDataJSON(ILocaleString data, ILocaleString parentData) {
        JSONObject ret = new JSONObject();
        Set keys = data.keySet();
        JSONObject value = null;
        JSONObject parentValue = null;
        JSONObject jsonData = null;
        JSONObject parentJsonData = null;
        if (keys.isEmpty()) {
            for (String multiKey : parentData.keySet()) {
                parentValue = this.getValidatedMultiJSON((String)parentData.get((Object)multiKey));
                if (parentValue != null) {
                    parentJsonData = parentValue.getJSONObject(this.DATA);
                }
                if (parentJsonData == null) continue;
                ret.put(multiKey, (Object)parentJsonData);
            }
        } else {
            for (String key : keys) {
                value = this.getValidatedMultiJSON((String)data.get((Object)key));
                if (value != null) {
                    jsonData = value.getJSONObject(this.DATA);
                }
                if ((parentValue = this.getValidatedMultiJSON((String)parentData.get((Object)key))) != null) {
                    parentJsonData = parentValue.getJSONObject(this.DATA);
                }
                if (jsonData == null) {
                    ret.put(key, (Object)parentJsonData);
                    continue;
                }
                if (parentJsonData == null) continue;
                ret.put(key, (Object)this.getMergedJSONData(parentJsonData, jsonData));
            }
        }
        return ret;
    }

    private JSONObject getMergedJSONData(JSONObject parentJsonData, JSONObject jsonData) {
        JSONObject ret = new JSONObject((Map)parentJsonData);
        Set keys = jsonData.keySet();
        String value = null;
        for (String key : keys) {
            value = jsonData.getString(key);
            if (value == null) continue;
            ret.put(key, (Object)value);
        }
        return ret;
    }

    private JSONObject getValidatedMultiJSON(String json) {
        JSONObject datas;
        if (WfUtils.isNotEmpty(json) && (datas = JSON.parseObject((String)json)).containsKey((Object)this.DATA) && datas.containsKey((Object)this.LANG)) {
            return datas;
        }
        return null;
    }
}

