/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.workflow.engine.impl.cmd.management.scheme;

import java.io.Serializable;
import java.util.List;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.query.QFilter;
import kd.bos.workflow.engine.impl.interceptor.Command;
import kd.bos.workflow.engine.impl.interceptor.CommandContext;
import kd.bos.workflow.engine.impl.persistence.deploy.DeploymentCache;
import kd.bos.workflow.engine.impl.persistence.deploy.ProcessDefinitionCacheEntry;
import kd.bos.workflow.engine.impl.persistence.entity.runtime.ExecutionEntity;
import kd.bos.workflow.engine.impl.util.ProcessDefinitionUtil;

public class RemoveBpmnModelCacheCmd
implements Command<Void>,
Serializable {
    private static final long serialVersionUID = 5063144178789910350L;
    private Log log = LogFactory.getLog(this.getClass());
    private Long processInstanceId;
    private Long schemeId;

    public RemoveBpmnModelCacheCmd(Long processInstanceId, Long schemeId) {
        this.processInstanceId = processInstanceId;
        this.schemeId = schemeId;
    }

    @Override
    public Void execute(CommandContext commandContext) {
        if (this.processInstanceId != null) {
            ProcessDefinitionUtil.removeBPMNModel(this.processInstanceId);
        } else if (this.schemeId != null) {
            this.removeSchemeCache(commandContext);
        }
        return null;
    }

    private void removeSchemeCache(CommandContext commandContext) {
        ProcessDefinitionUtil.removeBPMNModel(this.schemeId);
        QFilter[] filters = new QFilter[]{new QFilter("schemeId", "=", (Object)this.schemeId), new QFilter("scope", "=", (Object)Boolean.TRUE)};
        List executions = commandContext.getExecutionEntityManager().findByQueryFilters(filters, true);
        this.log.debug(String.format("\u6e05\u9664\u5f15\u7528\u65b9\u6848%s\u7684\u6d41\u7a0b\u5b9e\u4f8b\u7f13\u5b58\uff01", this.schemeId));
        if (executions != null && !executions.isEmpty()) {
            DeploymentCache<ProcessDefinitionCacheEntry> processDefinitionCache = commandContext.getProcessEngineConfiguration().getDeploymentManager().getProcessDefinitionCache();
            for (ExecutionEntity execution : executions) {
                commandContext.getExecutionEntityManager().update(execution, false);
                this.log.debug(String.format("--\u79fb\u9664\u6d41\u7a0b\u5b9e\u4f8b %s \u7684\u7f13\u5b58\uff1a", execution.getProcessInstanceId()));
                processDefinitionCache.remove(execution.getProcessInstanceId());
            }
        }
    }
}

