/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.workflow.engine.impl.cmd.management.scheme;

import java.io.Serializable;
import java.util.List;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.query.QFilter;
import kd.bos.workflow.engine.WfUtils;
import kd.bos.workflow.engine.impl.cmd.management.scheme.GetConfigSchemeBpmnJsonStringCmd;
import kd.bos.workflow.engine.impl.interceptor.Command;
import kd.bos.workflow.engine.impl.interceptor.CommandContext;
import kd.bos.workflow.engine.impl.persistence.entity.design.ResourceEntity;
import kd.bos.workflow.engine.impl.persistence.entity.design.ResourceEntityManager;
import kd.bos.workflow.engine.impl.persistence.entity.management.ConditionalRuleEntity;
import kd.bos.workflow.engine.impl.persistence.entity.management.DynamicConfigSchemeEntity;
import kd.bos.workflow.engine.impl.persistence.entity.management.ProcessDefinitionEntity;
import kd.bos.workflow.engine.impl.util.BpmnModelUtil;
import kd.bos.workflow.engine.impl.util.DynamicSchemeUtil;
import kd.bos.workflow.engine.management.batchsetting.BatchSettingUtil;

public class SynchronizeSchemeCmd
implements Command<Void>,
Serializable {
    private static final long serialVersionUID = -5547923154869906278L;
    private Log log = LogFactory.getLog(this.getClass());
    private Long procDefId;
    private Long defSchemeId;
    private ProcessDefinitionEntity processDefinition;

    public SynchronizeSchemeCmd(ProcessDefinitionEntity processDefinition, Long procDefId, Long defSchemeId) {
        this.procDefId = procDefId;
        this.defSchemeId = defSchemeId;
        this.processDefinition = processDefinition;
    }

    @Override
    public Void execute(CommandContext commandContext) {
        QFilter[] filters = new QFilter[]{new QFilter("processdefinitionid", "=", (Object)this.procDefId), new QFilter("isdefault", "=", (Object)Boolean.FALSE)};
        List customSchemes = commandContext.getDynamicConfigSchemeEntityManager().findByQueryFilters(filters);
        if (customSchemes != null && !customSchemes.isEmpty()) {
            for (DynamicConfigSchemeEntity scheme : customSchemes) {
                this.syncCustomScheme(commandContext, scheme);
            }
        } else {
            this.log.debug(String.format("\u540c\u6b65\u6d41\u7a0b\u5b9a\u4e49 %s \u7684\u81ea\u5b9a\u4e49\u65b9\u6848\u5931\u8d25\uff0c\u539f\u56e0\uff1a\u8be5\u6d41\u7a0b\u5b9a\u4e49\u6ca1\u6709\u81ea\u5b9a\u4e49\u65b9\u6848\uff01", this.procDefId));
        }
        return null;
    }

    private void syncCustomScheme(CommandContext commandContext, DynamicConfigSchemeEntity scheme) {
        DynamicConfigSchemeEntity newScheme = (DynamicConfigSchemeEntity)commandContext.getDynamicConfigSchemeEntityManager().create();
        String number = scheme.getNumber();
        newScheme.setNumber(DynamicSchemeUtil.getSynchronizeSchemeNumber(commandContext, number));
        newScheme.setName(scheme.getName());
        newScheme.setDescription(scheme.getDescription());
        newScheme.setProcDefId(this.processDefinition.getId());
        newScheme.setParentSchemeId(this.defSchemeId);
        newScheme.setState(scheme.getState());
        newScheme.setAcquiescence(scheme.isAcquiescence());
        newScheme.setSourceKey(scheme.getSourceKey());
        String sourceKey = scheme.getSourceKey();
        if (WfUtils.isEmpty(sourceKey)) {
            sourceKey = scheme.getNumber();
        }
        newScheme.setSourceKey(sourceKey);
        this.copySchemeResource(commandContext, newScheme, scheme);
        this.copySchemeCondition(commandContext, newScheme, scheme);
        commandContext.getDynamicConfigSchemeEntityManager().insert(newScheme);
        String content = new GetConfigSchemeBpmnJsonStringCmd(newScheme.getId(), null).execute(commandContext);
        BpmnModelUtil.disposeDynamicPartial(content, newScheme);
        BpmnModelUtil.recordBaseDataRef(content, newScheme.getProcDefId(), newScheme.getId());
        BatchSettingUtil.createProcessInfo(commandContext, newScheme, content);
    }

    private void copySchemeCondition(CommandContext commandContext, DynamicConfigSchemeEntity newScheme, DynamicConfigSchemeEntity scheme) {
        ConditionalRuleEntity condition = (ConditionalRuleEntity)commandContext.getConditionRuleEntityManager().findById(scheme.getConditionId());
        ConditionalRuleEntity newCondition = (ConditionalRuleEntity)condition.clone();
        newCondition.setId(null);
        commandContext.getConditionRuleEntityManager().insert(newCondition);
        newScheme.setConditionId(newCondition.getId());
        newScheme.setConditionText(scheme.getConditionText());
        newScheme.setConditionExpression(scheme.getConditionExpression());
    }

    private void copySchemeResource(CommandContext commandContext, DynamicConfigSchemeEntity newScheme, DynamicConfigSchemeEntity scheme) {
        ResourceEntityManager resourceManager = commandContext.getResourceEntityManager();
        ResourceEntity resource = (ResourceEntity)resourceManager.findById(scheme.getJsonResourceId());
        ResourceEntity newResource = (ResourceEntity)resourceManager.create();
        this.copyResource(newResource, resource);
        resourceManager.insert(newResource);
        newScheme.setJsonResourceId(newResource.getId());
        ResourceEntity patch = (ResourceEntity)resourceManager.findById(scheme.getJsonPatchId());
        ResourceEntity newPatch = (ResourceEntity)resourceManager.create();
        this.copyResource(newPatch, patch);
        resourceManager.insert(newPatch);
        newScheme.setJsonPatchId(newPatch.getId());
    }

    private void copyResource(ResourceEntity newResource, ResourceEntity resource) {
        newResource.setName(resource.getName());
        newResource.setData(resource.getData());
        newResource.setContent(resource.getContent());
        newResource.setCurrentLanguage(resource.getCurrentLanguage());
    }
}

