/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.workflow.engine.impl.cmd.management.scheme;

import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONObject;
import com.fasterxml.jackson.databind.JsonNode;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import kd.bos.context.RequestContext;
import kd.bos.dataentity.entity.ILocaleString;
import kd.bos.dataentity.entity.LocaleString;
import kd.bos.dataentity.resource.promptenum.MultiLangEnumBridge;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.query.QFilter;
import kd.bos.workflow.bizflow.util.BizFlowUtil;
import kd.bos.workflow.bpmn.diff.patch.JsonPatch;
import kd.bos.workflow.bpmn.diff.util.BpmnDiffUtil;
import kd.bos.workflow.bpmn.model.AllowNextPersonSettingModel;
import kd.bos.workflow.bpmn.model.BpmnModel;
import kd.bos.workflow.bpmn.model.Process;
import kd.bos.workflow.bpmn.model.basedata.BaseDataHelper;
import kd.bos.workflow.engine.WfUtils;
import kd.bos.workflow.engine.impl.cmd.management.UpdateProcessInfoDetailEntityCmd;
import kd.bos.workflow.engine.impl.cmd.management.scheme.GetConfigSchemeBpmnJsonStringCmd;
import kd.bos.workflow.engine.impl.cmd.management.scheme.GetConfigSchemeBpmnModelCmd;
import kd.bos.workflow.engine.impl.interceptor.Command;
import kd.bos.workflow.engine.impl.interceptor.CommandContext;
import kd.bos.workflow.engine.impl.persistence.entity.design.ModelEntity;
import kd.bos.workflow.engine.impl.persistence.entity.design.ResourceEntity;
import kd.bos.workflow.engine.impl.persistence.entity.design.ResourceEntityManager;
import kd.bos.workflow.engine.impl.persistence.entity.management.ConditionalRuleEntity;
import kd.bos.workflow.engine.impl.persistence.entity.management.ConditionalRuleEntityManager;
import kd.bos.workflow.engine.impl.persistence.entity.management.DynamicConfigSchemeEntity;
import kd.bos.workflow.engine.impl.persistence.entity.management.ProcessConfigEntity;
import kd.bos.workflow.engine.impl.persistence.entity.management.ProcessDefinitionEntity;
import kd.bos.workflow.engine.impl.persistence.entity.management.ProcessDefinitionEntityManager;
import kd.bos.workflow.engine.impl.persistence.entity.runtime.EventSubscriptionEntity;
import kd.bos.workflow.engine.impl.persistence.entity.runtime.EventSubscriptionEntityManager;
import kd.bos.workflow.engine.impl.persistence.entity.runtime.SignalEventSubscriptionEntity;
import kd.bos.workflow.engine.impl.util.BpmnModelUtil;
import kd.bos.workflow.engine.impl.util.DynamicSchemeUtil;
import kd.bos.workflow.engine.impl.util.ExtractMultiLanguageWordsUtil;
import kd.bos.workflow.engine.impl.util.ProcessDefinitionUtil;
import kd.bos.workflow.engine.management.util.ConditionalRuleConvertUtil;

public class UpdateDynamicConfigSchemeCmd
implements Command<Void>,
Serializable {
    private Log log = LogFactory.getLog(this.getClass());
    private static final long serialVersionUID = 1L;
    private DynamicConfigSchemeEntity scheme;
    private String modelJson;
    private String condition;
    private BpmnModel bpmnModel;

    public UpdateDynamicConfigSchemeCmd(DynamicConfigSchemeEntity scheme) {
        this.scheme = scheme;
    }

    public UpdateDynamicConfigSchemeCmd(DynamicConfigSchemeEntity scheme, String modelJson, String condition) {
        this.scheme = scheme;
        this.modelJson = modelJson;
        this.condition = condition;
    }

    @Override
    public Void execute(CommandContext commandContext) {
        if (WfUtils.isNotEmpty(this.modelJson)) {
            BpmnModel model = this.getBpmnModel();
            this.updateResource(commandContext);
            this.log.debug(String.format("\u5904\u7406\u65b9\u6848%s[%s]\u7684\u591a\u8bed\u8a00\uff1a", this.scheme.getNumber(), this.scheme.getId()));
            this.log.debug(String.format("\u5904\u7406\u65b9\u6848%s[%s]\u7684\u53c2\u4e0e\u4eba\uff1a", this.scheme.getNumber(), this.scheme.getId()));
            BpmnModelUtil.disposeDynamicPartial(this.bpmnModel, this.scheme);
            BpmnModelUtil.recordBaseDataRef(this.bpmnModel, this.scheme.getProcDefId(), this.scheme.getId());
            this.updateProcessConfig(commandContext, model);
        }
        if (WfUtils.isNotEmpty(this.condition)) {
            ConditionalRuleEntity conditionalRule = this.updateConditionalRule(commandContext);
            this.scheme.setConditionText(conditionalRule.getShowtext());
            String expression = WfUtils.isNotEmpty(conditionalRule.getExpression()) ? conditionalRule.getExpression() : conditionalRule.getPlugin();
            this.scheme.setConditionExpression(expression);
            BaseDataHelper.recordBaseDataRefForStartUpCond(conditionalRule, this.scheme.getProcDefId(), this.scheme.getId());
            this.log.debug(String.format("\u4fee\u6539\u65b9\u6848%s[%s]\u7684\u5e94\u7528\u6761\u4ef6\u4e3a\uff1a%s", this.scheme.getNumber(), this.scheme.getId(), expression));
            WfUtils.addOpLog("wf_processdynamicconfig", "modify", new MultiLangEnumBridge("\u4fee\u6539\u65b9\u6848\u5e94\u7528\u6761\u4ef6", "UpdateDynamicConfigSchemeCmd_1", "bos-wf-engine"), new MultiLangEnumBridge("\u6761\u4ef6\u89c4\u5219Id:[%1$s] \u5c06\u65b9\u6848%2$s[%3$s]\u5e94\u7528\u6761\u4ef6\u6539\u4e3a\uff1a%4$s", "UpdateDynamicConfigSchemeCmd_2", "bos-wf-engine"), conditionalRule.getId(), this.scheme.getName(), this.scheme.getId(), expression);
        }
        commandContext.getDynamicConfigSchemeEntityManager().update(this.scheme);
        this.disposeOperationCache(commandContext);
        this.disposeCache(commandContext);
        return null;
    }

    private void updateProcessConfig(CommandContext commandContext, BpmnModel model) {
        if (!this.scheme.isAcquiescence()) {
            return;
        }
        Process process = model.getMainProcess();
        ProcessConfigEntity processConfigEntity = commandContext.getProcessConfigEntityManager().getOrCreateProcessConfig(this.scheme.getProcDefId());
        if (process != null && processConfigEntity != null) {
            boolean allowNextPersonWhenMatch = false;
            AllowNextPersonSettingModel allowNextPersonSettingModel = process.getAllowNextPersonSettingModel();
            if (null != allowNextPersonSettingModel) {
                allowNextPersonWhenMatch = allowNextPersonSettingModel.isAllowNextPersonWhenMatch();
            }
            if (allowNextPersonWhenMatch != processConfigEntity.isAllowNextPerson()) {
                processConfigEntity.setAllowNextPerson(allowNextPersonWhenMatch);
                commandContext.getProcessConfigEntityManager().update(processConfigEntity);
            }
        }
    }

    private void disposeOperationCache(CommandContext commandContext) {
        BpmnModel model = null;
        model = WfUtils.isNotEmpty(this.modelJson) ? this.getBpmnModel() : new GetConfigSchemeBpmnModelCmd(this.scheme.getId()).execute(commandContext);
        DynamicSchemeUtil.disposeOperationCache(commandContext, this.scheme, model);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void disposeCache(CommandContext commandContext) {
        this.log.debug(String.format("\u5904\u7406\u65b9\u6848%s[%s]\u7684\u7f13\u5b58\uff01", this.scheme.getNumber(), this.scheme.getId()));
        if (WfUtils.isEmpty(this.scheme.getParentSchemeId())) {
            QFilter[] filters = new QFilter[]{new QFilter("parentschemeid", "=", (Object)this.scheme.getId())};
            List children = commandContext.getDynamicConfigSchemeEntityManager().findByQueryFilters(filters, true);
            if (!children.isEmpty()) {
                for (DynamicConfigSchemeEntity entity : children) {
                    String childJson = new GetConfigSchemeBpmnJsonStringCmd(entity.getId(), null).execute(commandContext);
                    this.log.debug(String.format("\u4fdd\u5b58\u65b9\u6848%s[%s]\uff0c\u91cd\u65b0\u4fdd\u5b58\u5b50\u65b9\u6848%s[%s]", this.scheme.getNumber(), this.scheme.getId(), entity.getNumber(), entity.getId()));
                    try {
                        commandContext.addAttribute("updated_by_parent", true);
                        new UpdateDynamicConfigSchemeCmd(entity, childJson, null).execute(commandContext);
                    }
                    finally {
                        commandContext.removeAttribute("updated_by_parent");
                    }
                }
            }
        }
        DynamicSchemeUtil.disposeCache(commandContext, this.scheme);
    }

    private void updateResource(CommandContext commandContext) {
        ResourceEntityManager resourceManager = commandContext.getResourceEntityManager();
        Long jsonResourceId = this.scheme.getJsonResourceId();
        Long procDefId = this.scheme.getProcDefId();
        ResourceEntity resource = (ResourceEntity)resourceManager.findById(jsonResourceId);
        commandContext.getModelDataChangeLogEntityManager().recordChangeLog(this.scheme.getProcDefId(), this.scheme.getId(), jsonResourceId, resource.getData());
        if (this.scheme.isAcquiescence()) {
            String sourceJson = resource.getData();
            JsonPatch jsonPatch = BpmnDiffUtil.getJsonDiffPatch(sourceJson, this.modelJson);
            this.updateJsonPatch(resourceManager, jsonPatch);
            this.updateProcessDefinition(commandContext, procDefId, this.modelJson);
            this.updateProcessInfoDetail(commandContext, jsonPatch);
            this.updateProcessConfigAndEvtSubscr(commandContext, procDefId);
            resource.setData(this.modelJson);
        } else {
            DynamicConfigSchemeEntity parentScheme = (DynamicConfigSchemeEntity)commandContext.getDynamicConfigSchemeEntityManager().findById(this.scheme.getParentSchemeId());
            ResourceEntity parentResource = (ResourceEntity)resourceManager.findById(parentScheme.getJsonResourceId());
            String parentJson = parentResource.getData();
            JsonPatch jsonPatch = BpmnDiffUtil.getJsonDiffPatch(parentJson, this.modelJson);
            this.updateJsonPatch(resourceManager, jsonPatch);
            JsonNode jsonNode = BpmnDiffUtil.getBpmnPatch(jsonPatch);
            resource.setData(jsonNode.toString());
            this.updateProcessInfoDetail(commandContext, jsonNode);
        }
        resource.setCurrentLanguage(RequestContext.get().getLang().toString());
        resourceManager.update(resource);
        this.extractMultiLangWords(commandContext, procDefId, jsonResourceId);
        this.correctionMultiLangTerm(commandContext, jsonResourceId);
        this.log.debug(String.format("\u66f4\u65b0\u65b9\u6848 %s[%s] \u7684\u8d44\u6e90: %s", this.scheme.getNumber(), this.scheme.getId(), resource.getData()));
    }

    private void updateProcessConfigAndEvtSubscr(CommandContext commandContext, Long procDefId) {
        BpmnModel model = this.getBpmnModel();
        if (BizFlowUtil.isBizFlow(model)) {
            QFilter[] filters = new QFilter[]{new QFilter("procdefid", "=", (Object)procDefId)};
            List configs = commandContext.getProcessConfigEntityManager().findByQueryFilters(filters);
            if (!configs.isEmpty()) {
                ArrayList<Long> condRuleIds = new ArrayList<Long>(configs.size());
                for (Object config : configs) {
                    if (WfUtils.isNotEmpty(config.getCondRuleId())) {
                        condRuleIds.add(config.getCondRuleId());
                    }
                    commandContext.getProcessConfigEntityManager().delete(config);
                }
                if (!condRuleIds.isEmpty()) {
                    filters = new QFilter[]{new QFilter("id", "in", condRuleIds)};
                    List condRules = commandContext.getConditionRuleEntityManager().findByQueryFilters(filters);
                    for (ConditionalRuleEntity rule : condRules) {
                        commandContext.getConditionRuleEntityManager().delete(rule);
                    }
                }
            }
            EventSubscriptionEntityManager subscriptionManager = commandContext.getEventSubscriptionEntityManager();
            filters = new QFilter[]{new QFilter("processDefinitionId", "=", (Object)procDefId), new QFilter("eventType", "=", (Object)"signal")};
            ProcessDefinitionEntity processDefinition = (ProcessDefinitionEntity)commandContext.getProcessDefinitionEntityManager().findById(procDefId);
            List<SignalEventSubscriptionEntity> signalEvents = BizFlowUtil.addBizFlowSignalEventSubscriptions(commandContext, processDefinition, model.getMainProcess(), model, false);
            HashSet<String> nodeIds = new HashSet<String>(signalEvents.size());
            for (SignalEventSubscriptionEntity entity : signalEvents) {
                nodeIds.add(entity.getActivityId());
            }
            List entities = subscriptionManager.findByQueryFilters(filters);
            if (!entities.isEmpty()) {
                for (EventSubscriptionEntity eventSubscriptionEntity : entities) {
                    if (!nodeIds.contains(eventSubscriptionEntity.getActivityId())) continue;
                    subscriptionManager.delete(eventSubscriptionEntity);
                }
            }
            for (SignalEventSubscriptionEntity signalEventSubscriptionEntity : signalEvents) {
                subscriptionManager.insert(signalEventSubscriptionEntity);
            }
            BizFlowUtil.addBizFlowProcessConfigs(commandContext, processDefinition, model.getMainProcess());
        }
    }

    private void updateProcessInfoDetail(CommandContext commandContext, Object patch) {
        try {
            JsonNode patchJsonNode = null;
            if (patch instanceof JsonPatch) {
                patchJsonNode = BpmnDiffUtil.getBpmnPatch((JsonPatch)patch);
            } else if (patch instanceof JsonNode) {
                patchJsonNode = (JsonNode)patch;
            }
            if (patchJsonNode == null || patchJsonNode.size() < 1) {
                return;
            }
            new UpdateProcessInfoDetailEntityCmd(this.scheme, patchJsonNode).execute(commandContext);
        }
        catch (Exception e) {
            this.log.warn(String.format("update processInfoDetail failed! schemeId: %s reason: %s", this.scheme.getId(), WfUtils.getExceptionStacktrace(e)));
        }
    }

    private void updateProcessDefinition(CommandContext commandContext, Long procDefId, String sourceJson) {
        ProcessDefinitionEntityManager entityManager = commandContext.getProcessDefinitionEntityManager();
        ProcessDefinitionEntity procDefEntity = (ProcessDefinitionEntity)entityManager.findById(procDefId);
        JSONObject json = JSON.parseObject((String)sourceJson);
        JSONObject properties = json.getJSONObject("properties");
        this.log.debug(String.format("\u66f4\u65b0\u65b9\u6848 %s[%s] \u7684\u7ec4\u7ec7\u548c\u63cf\u8ff0: %s", this.scheme.getNumber(), this.scheme.getId(), properties));
        procDefEntity.setOrgUnitId(properties.getLong("orgUnitId"));
        procDefEntity.setBusinessId(properties.getString("businessId"));
        String desc = properties.getString("documentation");
        if (WfUtils.isEmpty(desc)) {
            procDefEntity.setDescription(null);
        } else {
            procDefEntity.setDescription((ILocaleString)new LocaleString(desc));
        }
        entityManager.update(procDefEntity);
    }

    private void correctionMultiLangTerm(CommandContext commandContext, Long jsonResourceId) {
        ResourceEntityManager resourceManager = commandContext.getResourceEntityManager();
        ResourceEntity resource = (ResourceEntity)resourceManager.findById(jsonResourceId);
        ILocaleString content = resource.getContent();
        if (WfUtils.isEmpty(content)) {
            this.log.debug("content-is-null!");
            return;
        }
        String currentLang = resource.getCurrentLanguage();
        String criterion = (String)content.get((Object)currentLang);
        if (WfUtils.isEmpty(criterion)) {
            this.log.debug(String.format("%s-data-is-null", currentLang));
            return;
        }
        String data = "data";
        JSONObject datas = JSON.parseObject((String)criterion).getJSONObject(data);
        if (datas == null || datas.isEmpty()) {
            this.log.debug(String.format("%s-no-data-property-or-data-is-null", currentLang));
            return;
        }
        JSONObject multiJson = null;
        JSONObject multiDatas = null;
        Set criterionKeys = datas.keySet();
        Set keys = content.keySet();
        for (String key : keys) {
            if (key.equals(currentLang)) continue;
            String multiStr = (String)content.get((Object)key);
            if (WfUtils.isEmpty(multiStr)) {
                this.log.debug(String.format("%s-data-is-null", key));
                continue;
            }
            multiJson = JSON.parseObject((String)multiStr);
            multiDatas = multiJson.getJSONObject(data);
            if (multiDatas == null || multiDatas.isEmpty()) {
                this.log.debug(String.format("%s-no-data-property-or-data-is-null", key));
                continue;
            }
            boolean ret = this.correctionData(criterionKeys, multiDatas);
            if (!ret) continue;
            content.put((Object)key, (Object)multiJson.toJSONString());
            this.log.debug(String.format("update-%s-%s-multilang-datas", jsonResourceId, key));
        }
        resourceManager.update(resource);
    }

    private boolean correctionData(Set<String> criterionKeys, JSONObject multiDatas) {
        boolean changed = false;
        Set entry = multiDatas.entrySet();
        Iterator iterator = entry.iterator();
        while (iterator.hasNext()) {
            Map.Entry next = (Map.Entry)iterator.next();
            String key = (String)next.getKey();
            if (criterionKeys.contains(key)) continue;
            iterator.remove();
            changed = true;
            this.log.debug(String.format("remove invalid term %s:%s", key, next.getValue()));
        }
        return changed;
    }

    private void updateJsonPatch(ResourceEntityManager resourceManager, JsonPatch jsonPatch) {
        this.log.debug(String.format("\u66f4\u65b0\u65b9\u6848 %s[%s] \u7684JsonPatch: %s", this.scheme.getNumber(), this.scheme.getId(), jsonPatch));
        ResourceEntity jsonPatchResource = (ResourceEntity)resourceManager.findById(this.scheme.getJsonPatchId());
        jsonPatchResource.setData(jsonPatch.toString());
        jsonPatchResource.setCurrentLanguage(RequestContext.get().getLang().toString());
        resourceManager.update(jsonPatchResource);
    }

    private ConditionalRuleEntity updateConditionalRule(CommandContext commandContext) {
        ConditionalRuleEntityManager condRuleManager = commandContext.getConditionRuleEntityManager();
        ConditionalRuleEntity entity = ConditionalRuleConvertUtil.jsonToConditionalRuleModel(this.condition);
        ConditionalRuleEntity condition = (ConditionalRuleEntity)condRuleManager.findById(entity.getId());
        condition.setShowtext(entity.getShowtext());
        condition.setExpression(entity.getExpression());
        condition.setPlugin(entity.getPlugin());
        condition.setDescription(entity.getDescription());
        condition.setEntryentity(entity.getEntryentity());
        condRuleManager.update(condition);
        return condition;
    }

    public BpmnModel getBpmnModel() {
        if (this.bpmnModel == null) {
            this.bpmnModel = ProcessDefinitionUtil.getBpmnModel(this.modelJson);
        }
        return this.bpmnModel;
    }

    private void extractMultiLangWords(CommandContext commandContext, Long procDefId, Long resourceId) {
        ProcessDefinitionEntity processDefinition = (ProcessDefinitionEntity)commandContext.getProcessDefinitionEntityManager().findById(procDefId);
        if (processDefinition != null) {
            Long processId = processDefinition.getModelId();
            ModelEntity model = (ModelEntity)commandContext.getModelEntityManager().findById(processId);
            if (model != null) {
                String name = model.getName().toString();
                String version = model.getVersion();
                ExtractMultiLanguageWordsUtil.extractWordsAndSaveOrUpdate(resourceId, name, processId, version, model.getKey());
            }
        }
    }
}

