/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.workflow.engine.impl.cmd.management.scheme;

import java.io.Serializable;
import java.util.HashSet;
import java.util.List;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.query.QFilter;
import kd.bos.workflow.engine.impl.interceptor.Command;
import kd.bos.workflow.engine.impl.interceptor.CommandContext;
import kd.bos.workflow.engine.impl.persistence.entity.history.HistoricProcessInstanceEntity;
import kd.bos.workflow.engine.impl.persistence.entity.history.HistoricProcessInstanceEntityManager;
import kd.bos.workflow.engine.impl.persistence.entity.runtime.ExecutionEntity;
import kd.bos.workflow.engine.impl.persistence.entity.runtime.ExecutionEntityManager;

public class UpdateProcessInstanceSchemeId
implements Command<Void>,
Serializable {
    private static final long serialVersionUID = 7021378533610589085L;
    private Log log = LogFactory.getLog(this.getClass());
    private Long procDefId;
    private Long schemeId;

    public UpdateProcessInstanceSchemeId(Long procDefId, Long schemeId) {
        this.procDefId = procDefId;
        this.schemeId = schemeId;
    }

    @Override
    public Void execute(CommandContext commandContext) {
        QFilter[] filters = new QFilter[]{new QFilter("processDefinitionId", "=", (Object)this.procDefId)};
        ExecutionEntityManager executionManager = commandContext.getExecutionEntityManager();
        List executions = executionManager.findByQueryFilters(filters, true);
        if (executions == null || executions.isEmpty()) {
            return null;
        }
        HashSet<Long> procInstIds = new HashSet<Long>(executions.size());
        for (ExecutionEntity execution : executions) {
            execution.setSchemeId(this.schemeId);
            executionManager.update(execution);
            procInstIds.add(execution.getProcessInstanceId());
        }
        this.log.info(String.format("\u66f4\u65b0\u6d41\u7a0b\u5b9e\u4f8b %s \u7684\u65b9\u6848ID\u4e3a %s\uff0c\u8981\u66f4\u65b0\u7684\u6d41\u7a0b\u5b9e\u4f8bID\uff1a%s", this.procDefId, this.schemeId, procInstIds));
        filters = new QFilter[]{new QFilter("id", "in", procInstIds)};
        HistoricProcessInstanceEntityManager hisProcInstManager = commandContext.getHistoricProcessInstanceEntityManager();
        List procInsts = hisProcInstManager.findByQueryFilters(filters, true);
        for (HistoricProcessInstanceEntity entity : procInsts) {
            entity.setSchemeId(this.schemeId);
            hisProcInstManager.update(entity);
        }
        return null;
    }
}

