/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.workflow.engine.impl.cmd.management.scheme;

import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONObject;
import java.io.Serializable;
import java.util.Map;
import kd.bos.dataentity.serialization.SerializationUtils;
import kd.bos.workflow.bpmn.model.basedata.BaseDataHelper;
import kd.bos.workflow.engine.RepositoryService;
import kd.bos.workflow.engine.WfUtils;
import kd.bos.workflow.engine.impl.interceptor.Command;
import kd.bos.workflow.engine.impl.interceptor.CommandContext;
import kd.bos.workflow.engine.impl.persistence.entity.design.ResourceEntity;
import kd.bos.workflow.engine.impl.persistence.entity.design.ResourceEntityManager;
import kd.bos.workflow.engine.impl.persistence.entity.management.ConditionalRuleEntity;
import kd.bos.workflow.engine.impl.persistence.entity.management.ProcessDefinitionEntity;
import kd.bos.workflow.engine.impl.persistence.entity.management.ProcessDefinitionEntityManager;
import kd.bos.workflow.engine.impl.util.BpmnModelUtil;
import kd.bos.workflow.service.WorkflowService;
import kd.bos.workflow.service.impl.ServiceFactory;

public class UpdateStartUpConditionalRuleCmd
implements Command<Void>,
Serializable {
    private static final long serialVersionUID = 1L;
    private Long procDefId;
    private ConditionalRuleEntity condRule;
    private boolean deleteFlag;
    private String condRuleId;

    public UpdateStartUpConditionalRuleCmd(Long procDefId, ConditionalRuleEntity condRule, boolean deleteFlag, String condRuleId) {
        this.procDefId = procDefId;
        this.condRule = condRule;
        this.deleteFlag = deleteFlag;
        this.condRuleId = condRuleId;
    }

    @Override
    public Void execute(CommandContext commandContext) {
        ProcessDefinitionEntityManager procDefEntityManager = commandContext.getProcessDefinitionEntityManager();
        ProcessDefinitionEntity procDefEntity = (ProcessDefinitionEntity)procDefEntityManager.findById(this.procDefId);
        ResourceEntityManager resourceEntityManager = commandContext.getResourceEntityManager();
        ResourceEntity resourceEntity = (ResourceEntity)resourceEntityManager.findById(procDefEntity.getResourceId());
        JSONObject model = JSON.parseObject((String)resourceEntity.getData());
        if (this.deleteFlag) {
            this.getRepositoryService().deleteEntity(WfUtils.normalizeId(this.condRuleId), "wf_conditionalrule");
            BpmnModelUtil.deleteProperty((Map<String, Object>)model, "properties.startupcondrule");
            BaseDataHelper.deleteBaseDataRefForStartUpCond(this.procDefId, null);
        } else {
            this.getRepositoryService().saveOrUpdateEntity(this.condRule);
            String condRuleStr = SerializationUtils.toJsonString((Object)this.condRule, (boolean)true);
            Object value = JSON.parse((String)condRuleStr);
            BpmnModelUtil.setProperty((Map<String, Object>)model, "properties.startupcondrule", value);
            BaseDataHelper.recordBaseDataRefForStartUpCond(this.condRule, this.procDefId, null);
        }
        resourceEntity.setData(model.toString());
        resourceEntityManager.update(resourceEntity);
        return null;
    }

    private RepositoryService getRepositoryService() {
        return ((WorkflowService)ServiceFactory.getService(WorkflowService.class)).getRepositoryService();
    }
}

