/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.workflow.engine.impl.cmd.management.scheme;

import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONArray;
import com.alibaba.fastjson.JSONObject;
import com.fasterxml.jackson.databind.JsonNode;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import kd.bos.dataentity.serialization.SerializationUtils;
import kd.bos.orm.query.QFilter;
import kd.bos.workflow.bpmn.diff.util.BpmnDiffUtil;
import kd.bos.workflow.engine.WfUtils;
import kd.bos.workflow.engine.impl.interceptor.Command;
import kd.bos.workflow.engine.impl.interceptor.CommandContext;
import kd.bos.workflow.engine.impl.persistence.entity.design.ResourceEntity;
import kd.bos.workflow.engine.impl.persistence.entity.design.ResourceEntityManager;
import kd.bos.workflow.engine.impl.persistence.entity.management.DynamicConfigSchemeEntity;
import kd.bos.workflow.engine.impl.util.condition.ConditionalRuleHelper;

public class ValidateChildrenSchemesConditionsCmd
implements Command<Map<String, String>>,
Serializable {
    private static final long serialVersionUID = -27085378988493322L;
    private Long schemeId;
    private transient Map<String, Object> condRule;

    public ValidateChildrenSchemesConditionsCmd(Long schemeId, Map<String, Object> condRule) {
        this.schemeId = schemeId;
        this.condRule = condRule;
    }

    @Override
    public Map<String, String> execute(CommandContext commandContext) {
        HashMap<String, String> result = new HashMap<String, String>();
        String elementId = (String)this.condRule.get("elementid");
        String type = (String)this.condRule.get("type");
        String condRuleStr = JSON.toJSONString(this.condRule);
        ResourceEntityManager resourceManager = commandContext.getResourceEntityManager();
        QFilter[] filters = new QFilter[]{new QFilter("parentschemeid", "=", (Object)this.schemeId)};
        List childrenSchemes = commandContext.getDynamicConfigSchemeEntityManager().findByQueryFilters(filters);
        if (childrenSchemes == null || childrenSchemes.isEmpty()) {
            return result;
        }
        ResourceEntity resource = null;
        for (DynamicConfigSchemeEntity entity : childrenSchemes) {
            JSONObject node;
            JSONObject condPatch;
            resource = (ResourceEntity)resourceManager.findById(entity.getJsonResourceId());
            String data = resource.getData();
            if (WfUtils.isEmpty(data) || (condPatch = this.getConditionPatchNode(node = JSON.parseObject((String)data), elementId, type)) == null) continue;
            JsonNode ret = BpmnDiffUtil.applyPatch(condRuleStr, JSON.toJSONString((Object)condPatch));
            List items = JSON.parseArray((String)SerializationUtils.toJsonString((Object)ret.get("entryentity")), Map.class);
            ArrayList<Map<String, Object>> conditions = new ArrayList<Map<String, Object>>(items.size());
            for (Map item : items) {
                conditions.add(item);
            }
            List<Map<String, Object>> conditionItems = ConditionalRuleHelper.getConditionItems(conditions);
            String tip = ConditionalRuleHelper.validateConditionItems(conditionItems);
            if (tip == null) continue;
            result.put(entity.getName().getLocaleValue(), tip);
        }
        return result;
    }

    private JSONObject getConditionPatchNode(JSONObject node, String elementId, String type) {
        JSONArray childShapes = node.getJSONArray("childShapes");
        if (childShapes == null || childShapes.isEmpty()) {
            return null;
        }
        int size = childShapes.size();
        for (int i = 0; i < size; ++i) {
            JSONObject child = childShapes.getJSONObject(i);
            if (!elementId.equals(child.getString("resourceId"))) continue;
            JSONObject properties = child.getJSONObject("properties");
            Set keys = properties.keySet();
            for (String key : keys) {
                JSONObject obj;
                Object value = properties.get((Object)key);
                if (!(value instanceof JSONObject) || !(obj = (JSONObject)value).containsKey((Object)"expression") || !obj.containsKey((Object)"entryentity") || !obj.containsKey((Object)"type") || !type.equals(obj.getString("type"))) continue;
                return obj;
            }
        }
        return null;
    }
}

