/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.workflow.engine.impl.cmd.model;

import java.beans.PropertyDescriptor;
import java.util.List;
import kd.bos.exception.KDException;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.workflow.bpmn.graph.codec.GraphCodecUtils;
import kd.bos.workflow.bpmn.model.BaseElement;
import kd.bos.workflow.engine.WfUtils;
import kd.bos.workflow.engine.impl.cmd.model.IModelProcessor;
import kd.bos.workflow.exception.WFErrorCode;
import org.apache.commons.beanutils.PropertyUtils;

public abstract class AbstractProcessor
implements IModelProcessor {
    protected Log logger = LogFactory.getLog(this.getClass());

    protected String getInCondition(List<String> datas) {
        StringBuilder ret = new StringBuilder("(");
        int length = datas.size();
        for (int i = 0; i < length; ++i) {
            ret.append('\'').append(datas.get(i)).append('\'');
            if (i >= length - 1) continue;
            ret.append(',');
        }
        return ret.append(')').toString();
    }

    protected void updateBpmnModelProperty(BaseElement element, String property, Object value) {
        try {
            if (WfUtils.isNotEmpty(property) && value != null) {
                if (value instanceof String && "".equals(value.toString().trim())) {
                    return;
                }
                this.logger.debug("updateBpmnModelProperty set property value: " + property + "  " + value);
                GraphCodecUtils.safeSetPropertyValue(element, property, value);
            }
        }
        catch (Exception e) {
            throw new KDException(WFErrorCode.updateBpmnModelDynamicPartialError(), new Object[]{e.getMessage()});
        }
    }

    protected String getPropertyName(Object obj, Class<?> clazz) {
        if (obj == null) {
            return null;
        }
        PropertyDescriptor[] descriptors = PropertyUtils.getPropertyDescriptors((Object)obj);
        if (descriptors != null) {
            for (PropertyDescriptor descriptor : descriptors) {
                if (!clazz.equals(descriptor.getClass())) continue;
                return descriptor.getName();
            }
        }
        return null;
    }

    @Override
    public String getProcessDefinitionField() {
        return "procdefid";
    }
}

