/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.workflow.engine.impl.cmd.model;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.LocaleString;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.devportal.BizAppServiceHelp;
import kd.bos.workflow.api.model.ProcessModel;
import kd.bos.workflow.engine.WfUtils;
import kd.bos.workflow.engine.impl.interceptor.Command;
import kd.bos.workflow.engine.impl.interceptor.CommandContext;
import kd.bos.workflow.engine.impl.persistence.entity.design.ModelEntity;
import kd.bos.workflow.engine.impl.persistence.entity.design.ProcessCategoryEntity;

public abstract class AbstractQueryProcessModelsCmd
implements Command<List<ProcessModel>> {
    protected Log log = LogFactory.getLog(this.getClass());

    @Override
    public List<ProcessModel> execute(CommandContext commandContext) {
        QFilter[] filters = this.getQueryFilters(commandContext);
        if (filters == null) {
            return new ArrayList<ProcessModel>();
        }
        List entities = commandContext.getModelEntityManager().findByQueryFilters(filters);
        int size = entities.size();
        ArrayList<ProcessModel> models = new ArrayList<ProcessModel>(size);
        HashMap<Long, ProcessModel> modelMap = new HashMap<Long, ProcessModel>(size);
        HashMap<Long, Long> modelCategoryMap = new HashMap<Long, Long>(size);
        ProcessModel processModel = null;
        for (ModelEntity entity : entities) {
            processModel = new ProcessModel();
            Long modelId = entity.getId();
            processModel.setId(modelId);
            processModel.setNumber(entity.getNumber());
            processModel.setBusinessId(entity.getBusinessId());
            processModel.setName(LocaleString.fromMap((Map)entity.getName()));
            processModel.setDescription(LocaleString.fromMap((Map)entity.getDescription()));
            processModel.setType(entity.getType());
            processModel.setEntityId(entity.getEntityId());
            processModel.setEntityNumber(entity.getEntityNumber());
            processModel.setOrgId(entity.getOrgId());
            processModel.setOperation(entity.getOperation());
            modelCategoryMap.put(modelId, entity.getCategory());
            modelMap.put(modelId, processModel);
            models.add(processModel);
        }
        QFilter[] categoryFilters = new QFilter[]{new QFilter("id", "in", modelCategoryMap.values())};
        String fields = String.format("%s,%s,%s", "id", "parentid", "applicationid");
        List categories = commandContext.getProcessCategoryEntityManager().findByQueryFilters(categoryFilters, fields, null);
        HashMap<Long, ProcessCategoryEntity> categoryMap = new HashMap<Long, ProcessCategoryEntity>(categories.size());
        for (ProcessCategoryEntity category : categories) {
            categoryMap.put(category.getId(), category);
        }
        Long rootCategoryId = 10000L;
        ProcessModel model = null;
        ProcessCategoryEntity category = null;
        for (Map.Entry entry : modelCategoryMap.entrySet()) {
            Long modelId = (Long)entry.getKey();
            Long categoryId = (Long)entry.getValue();
            category = (ProcessCategoryEntity)categoryMap.get(categoryId);
            if (category == null) continue;
            model = (ProcessModel)modelMap.get(modelId);
            Long parentCategoryId = category.getParentId();
            String applicationId = category.getApplicationId();
            if (rootCategoryId.equals(parentCategoryId)) {
                model.setCloudId(applicationId);
                continue;
            }
            DynamicObject bizApp = null;
            try {
                bizApp = BizAppServiceHelp.getBizAppByID((String)applicationId);
            }
            catch (Exception e) {
                this.log.warn(WfUtils.getExceptionStacktrace(e));
            }
            if (bizApp != null) {
                DynamicObject bizCloud = (DynamicObject)bizApp.get("bizcloud");
                model.setCloudId(bizCloud.getString("id"));
            }
            model.setAppId(applicationId);
        }
        return models;
    }

    protected abstract QFilter[] getQueryFilters(CommandContext var1);
}

