/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.workflow.engine.impl.cmd.model;

import java.util.Date;
import java.util.List;
import java.util.Map;
import kd.bos.context.RequestContext;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.ILocaleString;
import kd.bos.orm.query.QFilter;
import kd.bos.workflow.bpmn.model.deploy.NodeTemplateModel;
import kd.bos.workflow.engine.WfUtils;
import kd.bos.workflow.engine.impl.cmd.model.AddNodeTemplateLogCmd;
import kd.bos.workflow.engine.impl.db.EntityQueryBuilder;
import kd.bos.workflow.engine.impl.interceptor.Command;
import kd.bos.workflow.engine.impl.interceptor.CommandContext;
import kd.bos.workflow.engine.impl.persistence.entity.management.NodeTemplateEntity;
import kd.bos.workflow.engine.impl.persistence.entity.management.NodeTemplateEntityImpl;
import kd.bos.workflow.engine.impl.persistence.entity.management.NodeTemplateEntityManager;
import kd.bos.workflow.engine.impl.persistence.entity.management.NodeTemplateGroupEntity;
import kd.bos.workflow.engine.impl.persistence.entity.management.NodeTemplateGroupEntityManager;

public class AddNodeTemplateByImportCmd
implements Command<Void> {
    private Map<String, String> treatmentStrategyMap;
    private List<NodeTemplateModel> nodeTemplateModels;
    private CommandContext commandContext;

    public AddNodeTemplateByImportCmd(Map<String, String> treatmentStrategyMap, List<NodeTemplateModel> nodeTemplateModels) {
        this.treatmentStrategyMap = treatmentStrategyMap;
        this.nodeTemplateModels = nodeTemplateModels;
    }

    @Override
    public Void execute(CommandContext commandContext) {
        this.commandContext = commandContext;
        NodeTemplateEntityManager nodeTemplateEntityManager = commandContext.getNodeTemplateEntityManager();
        NodeTemplateGroupEntityManager nodeTemplateGroupEntityManager = commandContext.getNodeTemplateGroupEntityManager();
        for (NodeTemplateModel nodeTemplateModel : this.nodeTemplateModels) {
            String templateNumber;
            String treatmentStrategy;
            NodeTemplateGroupEntity nodeTemplateGroupEntity2;
            List<DynamicObject> templates = nodeTemplateModel.getTemplates();
            DynamicObject template = templates.get(0);
            List<DynamicObject> groups = nodeTemplateModel.getGroups();
            DynamicObject group = groups.get(0);
            String groupNumber = group.getString("number");
            ILocaleString groupName = group.getLocaleString("name");
            List nodeTemplateGroupEntityList = nodeTemplateGroupEntityManager.findByQueryFilters(new QFilter[]{new QFilter("number", "=", (Object)groupNumber).or(new QFilter("name", "=", (Object)groupName.getLocaleValue()))});
            Long nodeTemplateGroupIdByNumber = 0L;
            Long nodeTemplateGroupIdByName = 0L;
            for (NodeTemplateGroupEntity nodeTemplateGroupEntity2 : nodeTemplateGroupEntityList) {
                if (groupNumber.equals(nodeTemplateGroupEntity2.getNumber())) {
                    nodeTemplateGroupIdByNumber = nodeTemplateGroupEntity2.getId();
                    break;
                }
                if (!WfUtils.isEmpty(groupName.getLocaleValue()) && !groupName.getLocaleValue().equals(nodeTemplateGroupEntity2.getName().getLocaleValue())) continue;
                nodeTemplateGroupIdByName = nodeTemplateGroupEntity2.getId();
                break;
            }
            Long nodeTemplateGroupId = WfUtils.isEmpty(nodeTemplateGroupIdByNumber) ? nodeTemplateGroupIdByName : nodeTemplateGroupIdByNumber;
            nodeTemplateGroupId = WfUtils.isEmpty(nodeTemplateGroupId) ? Long.valueOf(group.getLong("id")) : nodeTemplateGroupId;
            template.set("groupid", (Object)nodeTemplateGroupId);
            nodeTemplateGroupEntity2 = (NodeTemplateGroupEntity)nodeTemplateGroupEntityManager.findById(nodeTemplateGroupId);
            if (nodeTemplateGroupEntity2 == null) {
                nodeTemplateGroupEntity2 = (NodeTemplateGroupEntity)nodeTemplateGroupEntityManager.create();
                this.setNodeTemplateGroupProperty(nodeTemplateGroupEntity2, group);
                EntityQueryBuilder nodeTemplateGroupQueryBuilder = nodeTemplateGroupEntityManager.createQueryBuilder();
                nodeTemplateGroupQueryBuilder.addFilter("number", "is not null", null);
                nodeTemplateGroupQueryBuilder.setSelectFields("sequence");
                nodeTemplateGroupQueryBuilder.orderBy("sequence desc");
                nodeTemplateGroupQueryBuilder.setLimit(1);
                List nodeTemplateGroups = nodeTemplateGroupEntityManager.findByQueryBuilder(nodeTemplateGroupQueryBuilder);
                NodeTemplateGroupEntity nodeTemplateGroup = (NodeTemplateGroupEntity)nodeTemplateGroups.get(0);
                Integer sequence = Integer.valueOf(nodeTemplateGroup.getSequence()) == null ? 0 : nodeTemplateGroup.getSequence();
                nodeTemplateGroupEntity2.setSequence(sequence + 1);
                nodeTemplateGroupEntityManager.insert(nodeTemplateGroupEntity2);
            }
            if ("cover".equals(treatmentStrategy = this.treatmentStrategyMap.get(templateNumber = template.getString("number")))) {
                this.coverNodeTemplate(template, templateNumber, nodeTemplateEntityManager);
                continue;
            }
            if (!"add".equals(treatmentStrategy)) continue;
            this.addNewNodeTemplate(template, nodeTemplateEntityManager);
        }
        return null;
    }

    private void setNodeTemplateGroupProperty(NodeTemplateGroupEntity nodeTemplateGroupEntity, DynamicObject group) {
        Long id = group.getLong("id");
        String number = group.getString("number");
        ILocaleString name = group.getLocaleString("name");
        Long creatorId = group.getLong("creator_id");
        Long modifier = group.getLong("modifier_id");
        String status = group.getString("status");
        String enable = group.getString("enable");
        String initialization = group.getString("isinitialization");
        Long masterId = group.getLong("masterid");
        Date createTime = group.getDate("createtime");
        Date modifyTime = group.getDate("modifytime");
        nodeTemplateGroupEntity.setId(id);
        nodeTemplateGroupEntity.setNumber(number);
        nodeTemplateGroupEntity.setName(name);
        nodeTemplateGroupEntity.setCreatorId(creatorId);
        nodeTemplateGroupEntity.setModifierId(modifier);
        nodeTemplateGroupEntity.setStatus(status);
        nodeTemplateGroupEntity.setEnable(enable);
        nodeTemplateGroupEntity.setInitialization(initialization);
        nodeTemplateGroupEntity.setMasterId(masterId);
        nodeTemplateGroupEntity.setCreateTime(createTime);
        nodeTemplateGroupEntity.setModifyTime(modifyTime);
    }

    private void addNewNodeTemplate(DynamicObject template, NodeTemplateEntityManager nodeTemplateEntityManager) {
        NodeTemplateEntity nodeTemplate = (NodeTemplateEntity)nodeTemplateEntityManager.create();
        nodeTemplate.setNumber(template.getString("number"));
        this.setNodeTemplateProperty(nodeTemplate, template, Boolean.TRUE);
        nodeTemplateEntityManager.insert(nodeTemplate);
        this.addNodetemplateLog(null, nodeTemplate);
    }

    private void coverNodeTemplate(DynamicObject template, String templateNumber, NodeTemplateEntityManager nodeTemplateEntityManager) {
        QFilter[] filters = new QFilter[]{new QFilter("number", "=", (Object)templateNumber)};
        List nodeTemplates = nodeTemplateEntityManager.findByQueryFilters(filters);
        NodeTemplateEntity nodeTemplate = (NodeTemplateEntity)nodeTemplates.get(0);
        NodeTemplateEntityImpl oldNodeTemplate = ((NodeTemplateEntityImpl)nodeTemplate).clone();
        this.setNodeTemplateProperty(nodeTemplate, template, Boolean.FALSE);
        this.addNodetemplateLog(oldNodeTemplate, nodeTemplate);
        nodeTemplateEntityManager.update(nodeTemplate);
    }

    private void addNodetemplateLog(NodeTemplateEntity oldNodeTemplate, NodeTemplateEntity nodeTemplate) {
        new AddNodeTemplateLogCmd(oldNodeTemplate, nodeTemplate, "import").execute(this.commandContext);
    }

    private void setNodeTemplateProperty(NodeTemplateEntity nodeTemplate, DynamicObject template, Boolean isAddNew) {
        ILocaleString name = template.getLocaleString("name");
        String stencilType = template.getString("stenciltype");
        String appId = template.getString("appid");
        String entityId = template.getString("entityid");
        Boolean initialization = template.getBoolean("isinitialization");
        Boolean isExtend = template.getBoolean("isextend");
        Boolean isSystemNode = template.getBoolean("issystemnode");
        Long creatorId = template.getLong("creator_id");
        String developmentType = template.getString("developmenttype");
        String enable = template.getString("enable");
        String status = template.getString("status");
        Long masterId = template.getLong("masterid");
        String properties = template.getString("properties");
        String bizIdentification = template.getString("bizidentification");
        String cloudId = template.getString("cloudid");
        String processType = template.getString("processtype");
        String version = template.getString("version");
        Date createDate = template.getDate("createtime");
        if (isAddNew.booleanValue()) {
            String groupId = WfUtils.isNotEmpty(template.getString("groupid")) ? template.getString("groupid") : template.getString("groupid_id");
            nodeTemplate.setGroupId(groupId);
        }
        nodeTemplate.setILocaleStringName(name);
        nodeTemplate.setStencilType(stencilType);
        nodeTemplate.setAppId(appId);
        nodeTemplate.setEntityId(entityId);
        nodeTemplate.setInitialization(initialization);
        nodeTemplate.setExtend(isExtend);
        nodeTemplate.setSystemNode(isSystemNode);
        nodeTemplate.setCreatorId(creatorId);
        nodeTemplate.setDevelopmentType(developmentType);
        nodeTemplate.setEnable(enable);
        nodeTemplate.setStatus(status);
        nodeTemplate.setMasterId(masterId);
        nodeTemplate.setProperties(properties);
        nodeTemplate.setBizIdentification(bizIdentification);
        nodeTemplate.setCloudId(cloudId);
        nodeTemplate.setProcessType(processType);
        nodeTemplate.setVersion(version);
        nodeTemplate.setCreateTime(createDate);
        nodeTemplate.setModifyTime(new Date());
        nodeTemplate.setModifierId(Long.valueOf(RequestContext.get().getUserId()));
    }
}

